/*
 * Decompiled with CFR 0.152.
 */
package org.semanticweb.owlapi.oboformat;

import java.io.BufferedReader;
import java.io.IOException;
import java.io.InputStreamReader;
import java.io.Serializable;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import org.obolibrary.obo2owl.OWLAPIObo2Owl;
import org.obolibrary.oboformat.model.OBODoc;
import org.obolibrary.oboformat.parser.OBOFormatParser;
import org.obolibrary.oboformat.parser.OBOFormatParserException;
import org.semanticweb.owlapi.formats.OBODocumentFormat;
import org.semanticweb.owlapi.formats.OBODocumentFormatFactory;
import org.semanticweb.owlapi.io.OWLOntologyDocumentSource;
import org.semanticweb.owlapi.io.OWLParser;
import org.semanticweb.owlapi.io.OWLParserException;
import org.semanticweb.owlapi.model.IRI;
import org.semanticweb.owlapi.model.OWLDocumentFormat;
import org.semanticweb.owlapi.model.OWLDocumentFormatFactory;
import org.semanticweb.owlapi.model.OWLOntology;
import org.semanticweb.owlapi.model.OWLOntologyCreationException;
import org.semanticweb.owlapi.model.OWLOntologyLoaderConfiguration;

public class OBOFormatOWLAPIParser
implements OWLParser,
Serializable {
    private static final long serialVersionUID = 40000L;

    @Nonnull
    public OWLDocumentFormat parse(IRI documentIRI, @Nonnull OWLOntology ontology) throws IOException {
        try {
            OBOFormatOWLAPIParser.parse(documentIRI, null, ontology);
        }
        catch (OBOFormatParserException e) {
            throw new OWLParserException((Throwable)((Object)e));
        }
        catch (OWLOntologyCreationException e) {
            throw new OWLParserException((Throwable)e);
        }
        return new OBODocumentFormat();
    }

    @Nonnull
    public OWLDocumentFormat parse(@Nonnull OWLOntologyDocumentSource documentSource, @Nonnull OWLOntology ontology, OWLOntologyLoaderConfiguration configuration) throws IOException {
        try {
            OBOFormatOWLAPIParser.parse(null, documentSource, ontology);
        }
        catch (OBOFormatParserException e) {
            throw new OWLParserException((Throwable)((Object)e));
        }
        catch (OWLOntologyCreationException e) {
            throw new OWLParserException((Throwable)e);
        }
        return new OBODocumentFormat();
    }

    private static OWLOntology parse(@Nullable IRI iri, @Nullable OWLOntologyDocumentSource source, @Nonnull OWLOntology in) throws IOException, OWLOntologyCreationException {
        if (iri == null && source == null) {
            throw new IllegalArgumentException("iri and source annot both be null");
        }
        OBOFormatParser p = new OBOFormatParser();
        OBODoc obodoc = null;
        if (iri != null) {
            if (iri.toString().startsWith("jar:!")) {
                throw new OWLParserException("Jar IRIs are not supported by the OBO parser");
            }
            obodoc = p.parse(iri.toURI().toURL());
        } else if (source.isReaderAvailable()) {
            obodoc = p.parse(new BufferedReader(source.getReader()));
        } else if (source.isInputStreamAvailable()) {
            obodoc = p.parse(new BufferedReader(new InputStreamReader(source.getInputStream())));
        } else {
            return OBOFormatOWLAPIParser.parse(source.getDocumentIRI(), null, in);
        }
        OWLAPIObo2Owl bridge = new OWLAPIObo2Owl(in.getOWLOntologyManager());
        OWLOntology ontology = bridge.convert(obodoc, in);
        if (ontology == in) {
            return in;
        }
        return ontology;
    }

    @Nonnull
    public String getName() {
        return "OWLoboformatParser";
    }

    @Nonnull
    public OWLDocumentFormatFactory getSupportedFormat() {
        return new OBODocumentFormatFactory();
    }
}

