/*
 * Decompiled with CFR 0.152.
 */
package org.obolibrary.oboformat.writer;

import java.io.BufferedReader;
import java.io.BufferedWriter;
import java.io.File;
import java.io.FileOutputStream;
import java.io.FileReader;
import java.io.IOException;
import java.io.InputStreamReader;
import java.io.OutputStream;
import java.io.OutputStreamWriter;
import java.net.URL;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.Comparator;
import java.util.Date;
import java.util.HashSet;
import java.util.Hashtable;
import java.util.Iterator;
import java.util.List;
import java.util.Set;
import java.util.logging.Level;
import java.util.logging.Logger;
import org.obolibrary.obo2owl.OWLAPIObo2Owl;
import org.obolibrary.oboformat.model.Clause;
import org.obolibrary.oboformat.model.Frame;
import org.obolibrary.oboformat.model.OBODoc;
import org.obolibrary.oboformat.model.QualifierValue;
import org.obolibrary.oboformat.model.Xref;
import org.obolibrary.oboformat.parser.OBOFormatConstants;
import org.obolibrary.oboformat.parser.OBOFormatParser;
import org.obolibrary.oboformat.parser.OBOFormatParserException;
import org.semanticweb.owlapi.model.IRI;
import org.semanticweb.owlapi.model.OWLAnnotationAssertionAxiom;
import org.semanticweb.owlapi.model.OWLAnnotationSubject;
import org.semanticweb.owlapi.model.OWLAnnotationValue;
import org.semanticweb.owlapi.model.OWLLiteral;
import org.semanticweb.owlapi.model.OWLOntology;

public class OBOFormatWriter {
    private static Logger LOG = Logger.getLogger(OBOFormatWriter.class.getName());
    private static HashSet<String> tagsInformative = OBOFormatWriter.buildTagsInformative();
    private boolean isCheckStructure = true;

    public boolean isCheckStructure() {
        return this.isCheckStructure;
    }

    public void setCheckStructure(boolean isCheckStructure) {
        this.isCheckStructure = isCheckStructure;
    }

    private static HashSet<String> buildTagsInformative() {
        HashSet<String> set = new HashSet<String>();
        set.add(OBOFormatConstants.OboFormatTag.TAG_IS_A.getTag());
        set.add(OBOFormatConstants.OboFormatTag.TAG_RELATIONSHIP.getTag());
        set.add(OBOFormatConstants.OboFormatTag.TAG_DISJOINT_FROM.getTag());
        set.add(OBOFormatConstants.OboFormatTag.TAG_INTERSECTION_OF.getTag());
        set.add(OBOFormatConstants.OboFormatTag.TAG_UNION_OF.getTag());
        set.add(OBOFormatConstants.OboFormatTag.TAG_EQUIVALENT_TO.getTag());
        set.add(OBOFormatConstants.OboFormatTag.TAG_PROPERTY_VALUE.getTag());
        set.add(OBOFormatConstants.OboFormatTag.TAG_DOMAIN.getTag());
        set.add(OBOFormatConstants.OboFormatTag.TAG_RANGE.getTag());
        set.add(OBOFormatConstants.OboFormatTag.TAG_INVERSE_OF.getTag());
        set.add(OBOFormatConstants.OboFormatTag.TAG_TRANSITIVE_OVER.getTag());
        set.add(OBOFormatConstants.OboFormatTag.TAG_EQUIVALENT_TO_CHAIN.getTag());
        set.add(OBOFormatConstants.OboFormatTag.TAG_DISJOINT_OVER.getTag());
        return set;
    }

    public void write(String fn, BufferedWriter writer) throws IOException, OBOFormatParserException {
        if (fn.startsWith("http:")) {
            this.write(new URL(fn), writer);
        } else {
            BufferedReader reader = new BufferedReader(new FileReader(new File(fn)));
            this.write(reader, writer);
        }
    }

    public void write(URL url, BufferedWriter writer) throws IOException, OBOFormatParserException {
        BufferedReader reader = new BufferedReader(new InputStreamReader(url.openStream()));
        this.write(reader, writer);
    }

    public void write(BufferedReader reader, BufferedWriter writer) throws IOException, OBOFormatParserException {
        OBOFormatParser parser = new OBOFormatParser();
        OBODoc doc = parser.parse(reader);
        this.write(doc, writer);
    }

    public void write(OBODoc doc, String outFile) throws IOException {
        FileOutputStream os = new FileOutputStream(new File(outFile));
        OutputStreamWriter osw = new OutputStreamWriter((OutputStream)os, "UTF-8");
        BufferedWriter bw = new BufferedWriter(osw);
        this.write(doc, bw);
        bw.close();
    }

    public void write(OBODoc doc, BufferedWriter writer) throws IOException {
        OBODocNameProvider nameProvider = new OBODocNameProvider(doc);
        this.write(doc, writer, (NameProvider)nameProvider);
    }

    public void write(OBODoc doc, BufferedWriter writer, NameProvider nameProvider) throws IOException {
        if (this.isCheckStructure) {
            doc.check();
        }
        Frame headerFrame = doc.getHeaderFrame();
        this.writeHeader(headerFrame, writer, nameProvider);
        ArrayList<Frame> termFrames = new ArrayList<Frame>();
        termFrames.addAll(doc.getTermFrames());
        Collections.sort(termFrames, FramesComparator.instance);
        ArrayList<Frame> typeDefFrames = new ArrayList<Frame>();
        typeDefFrames.addAll(doc.getTypedefFrames());
        Collections.sort(typeDefFrames, FramesComparator.instance);
        ArrayList instanceFrames = new ArrayList();
        typeDefFrames.addAll(doc.getInstanceFrames());
        Collections.sort(instanceFrames, FramesComparator.instance);
        for (Frame f : termFrames) {
            this.write(f, writer, nameProvider);
        }
        for (Frame f : typeDefFrames) {
            this.write(f, writer, nameProvider);
        }
        for (Frame f : instanceFrames) {
            this.write(f, writer, nameProvider);
        }
        writer.flush();
    }

    private void writeLine(StringBuilder ln, BufferedWriter writer) throws IOException {
        ln.append('\n');
        writer.write(ln.toString());
    }

    private void writeLine(String ln, BufferedWriter writer) throws IOException {
        writer.write(ln + "\n");
    }

    private void writeEmptyLine(BufferedWriter writer) throws IOException {
        writer.write("\n");
    }

    private List<String> duplicateTags(Set<String> src) {
        ArrayList<String> tags = new ArrayList<String>(src.size());
        for (String tag : src) {
            tags.add(tag);
        }
        return tags;
    }

    public void writeHeader(Frame frame, BufferedWriter writer, NameProvider nameProvider) throws IOException {
        List<String> tags = this.duplicateTags(frame.getTags());
        Collections.sort(tags, HeaderTagsComparator.instance);
        this.write(new Clause(OBOFormatConstants.OboFormatTag.TAG_FORMAT_VERSION.getTag(), "1.2"), writer, nameProvider);
        for (String tag : tags) {
            if (tag.equals(OBOFormatConstants.OboFormatTag.TAG_FORMAT_VERSION.getTag())) continue;
            ArrayList<Clause> clauses = new ArrayList<Clause>(frame.getClauses(tag));
            Collections.sort(clauses, ClauseComparator.instance);
            for (Clause clause : clauses) {
                if (tag.equals(OBOFormatConstants.OboFormatTag.TAG_SUBSETDEF.getTag())) {
                    this.writeSynonymtypedef(clause, writer);
                    continue;
                }
                if (tag.equals(OBOFormatConstants.OboFormatTag.TAG_SYNONYMTYPEDEF.getTag())) {
                    this.writeSynonymtypedef(clause, writer);
                    continue;
                }
                if (tag.equals(OBOFormatConstants.OboFormatTag.TAG_DATE.getTag())) {
                    this.writeHeaderDate(clause, writer);
                    continue;
                }
                if (tag.equals(OBOFormatConstants.OboFormatTag.TAG_PROPERTY_VALUE.getTag())) {
                    this.writePropertyValue(clause, writer);
                    continue;
                }
                if (tag.equals(OBOFormatConstants.OboFormatTag.TAG_IDSPACE.getTag())) {
                    this.writeIdSpace(clause, writer);
                    continue;
                }
                this.write(clause, writer, nameProvider);
            }
        }
        this.writeEmptyLine(writer);
    }

    public void write(Frame frame, BufferedWriter writer, NameProvider nameProvider) throws IOException {
        Comparator<String> comparator = null;
        if (frame.getType() == Frame.FrameType.TERM) {
            this.writeLine("[Term]", writer);
            comparator = TermsTagsComparator.instance;
        } else if (frame.getType() == Frame.FrameType.TYPEDEF) {
            this.writeLine("[Typedef]", writer);
            comparator = TypeDefTagsComparator.instance;
        } else if (frame.getType() == Frame.FrameType.INSTANCE) {
            this.writeLine("[Instance]", writer);
            comparator = TypeDefTagsComparator.instance;
        }
        if (frame.getId() != null) {
            Object label = frame.getTagValue(OBOFormatConstants.OboFormatTag.TAG_NAME);
            String extra = "";
            if (label == null && nameProvider != null && (label = nameProvider.getName(frame.getId())) != null) {
                extra = " ! " + label;
            }
            this.writeLine(OBOFormatConstants.OboFormatTag.TAG_ID.getTag() + ": " + frame.getId() + extra, writer);
        }
        List<String> tags = this.duplicateTags(frame.getTags());
        Collections.sort(tags, comparator);
        String defaultOboNamespace = null;
        if (nameProvider != null) {
            defaultOboNamespace = nameProvider.getDefaultOboNamespace();
        }
        for (String tag : tags) {
            ArrayList<Clause> clauses = new ArrayList<Clause>(frame.getClauses(tag));
            Collections.sort(clauses, ClauseComparator.instance);
            for (Clause clause : clauses) {
                String clauseTag = clause.getTag();
                if (OBOFormatConstants.OboFormatTag.TAG_ID.getTag().equals(clauseTag)) continue;
                if (OBOFormatConstants.OboFormatTag.TAG_DEF.getTag().equals(clauseTag)) {
                    this.writeDef(clause, writer);
                    continue;
                }
                if (OBOFormatConstants.OboFormatTag.TAG_SYNONYM.getTag().equals(clauseTag)) {
                    this.writeSynonym(clause, writer);
                    continue;
                }
                if (OBOFormatConstants.OboFormatTag.TAG_PROPERTY_VALUE.getTag().equals(clauseTag)) {
                    this.writePropertyValue(clause, writer);
                    continue;
                }
                if (OBOFormatConstants.OboFormatTag.TAG_EXPAND_EXPRESSION_TO.getTag().equals(clauseTag) || OBOFormatConstants.OboFormatTag.TAG_EXPAND_ASSERTION_TO.getTag().equals(clauseTag)) {
                    this.writeClauseWithQuotedString(clause, writer);
                    continue;
                }
                if (OBOFormatConstants.OboFormatTag.TAG_XREF.getTag().equals(clauseTag)) {
                    this.writeXRefClause(clause, writer);
                    continue;
                }
                if (OBOFormatConstants.OboFormatTag.TAG_NAMESPACE.getTag().equals(clauseTag)) {
                    if (defaultOboNamespace != null && clause.getValue().equals(defaultOboNamespace)) continue;
                    this.write(clause, writer, nameProvider);
                    continue;
                }
                this.write(clause, writer, nameProvider);
            }
        }
        this.writeEmptyLine(writer);
    }

    private void writeXRefClause(Clause clause, BufferedWriter writer) throws IOException {
        Xref xref = clause.getValue(Xref.class);
        if (xref != null) {
            StringBuilder sb = new StringBuilder();
            sb.append(clause.getTag());
            sb.append(": ");
            if (xref.getIdref() != null) {
                String idref = xref.getIdref();
                int colonPos = idref.indexOf(58);
                if (colonPos > 0) {
                    sb.append(this.escapeOboString(idref.substring(0, colonPos), EscapeMode.xref));
                    sb.append(':');
                    sb.append(this.escapeOboString(idref.substring(colonPos + 1), EscapeMode.xref));
                } else {
                    sb.append(this.escapeOboString(idref, EscapeMode.xref));
                }
                String annotation = xref.getAnnotation();
                if (annotation != null) {
                    sb.append(" \"");
                    sb.append(this.escapeOboString(annotation, EscapeMode.quotes));
                    sb.append('\"');
                }
            }
            this.appendQualifiers(sb, clause);
            this.writeLine(sb, writer);
        }
    }

    private void writeSynonymtypedef(Clause clause, BufferedWriter writer) throws IOException {
        StringBuilder sb = new StringBuilder();
        sb.append(clause.getTag());
        sb.append(": ");
        Iterator<Object> valuesIterator = clause.getValues().iterator();
        Collection<Object> values = clause.getValues();
        for (int i = 0; i < values.size(); ++i) {
            String value = valuesIterator.next().toString();
            if (i == 1) {
                sb.append('\"');
            }
            sb.append(this.escapeOboString(value, EscapeMode.quotes));
            if (i == 1) {
                sb.append('\"');
            }
            if (!valuesIterator.hasNext()) continue;
            sb.append(' ');
        }
        this.appendQualifiers(sb, clause);
        this.writeLine(sb, writer);
    }

    private void writeHeaderDate(Clause clause, BufferedWriter writer) throws IOException {
        StringBuilder sb = new StringBuilder();
        sb.append(clause.getTag());
        sb.append(": ");
        Object value = clause.getValue();
        if (value instanceof Date) {
            sb.append(OBOFormatConstants.headerDateFormat.get().format((Date)value));
        } else if (value instanceof String) {
            sb.append(value);
        } else if (LOG.isLoggable(Level.WARNING)) {
            LOG.log(Level.WARNING, "Unknown datatype ('" + value.getClass().getName() + "') for value in clause: " + clause);
            sb.append(value.toString());
        }
        this.writeLine(sb, writer);
    }

    private void writeIdSpace(Clause cl, BufferedWriter writer) throws IOException {
        StringBuilder sb = new StringBuilder();
        sb.append(cl.getTag());
        sb.append(": ");
        Collection<Object> values = cl.getValues();
        Iterator<Object> iterator = values.iterator();
        for (int i = 0; iterator.hasNext() && i < 3; ++i) {
            String value = iterator.next().toString();
            if (i == 2) {
                sb.append('\"');
                sb.append(this.escapeOboString(value, EscapeMode.quotes));
                sb.append('\"');
                continue;
            }
            sb.append(this.escapeOboString(value, EscapeMode.simple));
            sb.append(' ');
        }
        this.appendQualifiers(sb, cl);
        this.writeLine(sb, writer);
    }

    private void writeClauseWithQuotedString(Clause clause, BufferedWriter writer) throws IOException {
        StringBuilder sb = new StringBuilder();
        sb.append(clause.getTag());
        sb.append(": ");
        boolean first = true;
        Iterator<Object> valuesIterator = clause.getValues().iterator();
        while (valuesIterator.hasNext()) {
            if (first) {
                sb.append('\"');
            }
            String value = valuesIterator.next().toString();
            sb.append(this.escapeOboString(value, EscapeMode.quotes));
            if (first) {
                sb.append('\"');
            }
            if (valuesIterator.hasNext()) {
                sb.append(' ');
            }
            first = false;
        }
        Collection<Xref> xrefs = clause.getXrefs();
        if (xrefs != null && !xrefs.isEmpty()) {
            this.appendXrefs(sb, xrefs);
        } else if (OBOFormatConstants.OboFormatTag.TAG_DEF.getTag().equals(clause.getTag()) || OBOFormatConstants.OboFormatTag.TAG_SYNONYM.getTag().equals(clause.getTag()) || OBOFormatConstants.OboFormatTag.TAG_EXPAND_EXPRESSION_TO.getTag().equals(clause.getTag()) || OBOFormatConstants.OboFormatTag.TAG_EXPAND_ASSERTION_TO.getTag().equals(clause.getTag())) {
            sb.append(" []");
        }
        this.appendQualifiers(sb, clause);
        this.writeLine(sb, writer);
    }

    private void appendXrefs(StringBuilder sb, Collection<Xref> xrefs) {
        ArrayList<Xref> sortedXrefs = new ArrayList<Xref>(xrefs);
        Collections.sort(sortedXrefs, XrefComparator.instance);
        sb.append(" [");
        Iterator xrefsIterator = sortedXrefs.iterator();
        while (xrefsIterator.hasNext()) {
            Xref current = (Xref)xrefsIterator.next();
            String idref = current.getIdref();
            int colonPos = idref.indexOf(58);
            if (colonPos > 0) {
                sb.append(this.escapeOboString(idref.substring(0, colonPos), EscapeMode.xrefList));
                sb.append(':');
                sb.append(this.escapeOboString(idref.substring(colonPos + 1), EscapeMode.xrefList));
            } else {
                sb.append(this.escapeOboString(idref, EscapeMode.xrefList));
            }
            String annotation = current.getAnnotation();
            if (annotation != null) {
                sb.append(' ');
                sb.append('\"');
                sb.append(this.escapeOboString(annotation, EscapeMode.quotes));
                sb.append('\"');
            }
            if (!xrefsIterator.hasNext()) continue;
            sb.append(", ");
        }
        sb.append("]");
    }

    public void writeDef(Clause clause, BufferedWriter writer) throws IOException {
        this.writeClauseWithQuotedString(clause, writer);
    }

    public void writePropertyValue(Clause clause, BufferedWriter writer) throws IOException {
        Collection<Object> cols = clause.getValues();
        if (cols.size() < 2) {
            if (LOG.isLoggable(Level.WARNING)) {
                LOG.log(Level.WARNING, "The " + OBOFormatConstants.OboFormatTag.TAG_PROPERTY_VALUE.getTag() + " has incorrect number of values: " + clause);
            }
            return;
        }
        StringBuilder sb = new StringBuilder();
        sb.append(clause.getTag());
        sb.append(": ");
        Iterator<Object> it = cols.iterator();
        String property = it.next().toString();
        sb.append(this.escapeOboString(property, EscapeMode.simple));
        while (it.hasNext()) {
            sb.append(' ');
            String val = it.next().toString();
            if (val.contains(" ") || !val.contains(":")) {
                sb.append('\"');
                sb.append(this.escapeOboString(val, EscapeMode.quotes));
                sb.append('\"');
                continue;
            }
            sb.append(this.escapeOboString(val, EscapeMode.simple));
        }
        this.appendQualifiers(sb, clause);
        this.writeLine(sb, writer);
    }

    public void writeSynonym(Clause clause, BufferedWriter writer) throws IOException {
        Collection<Xref> xrefs = clause.getXrefs();
        if (xrefs == null) {
            clause.setXrefs(new ArrayList<Xref>(0));
        }
        this.writeClauseWithQuotedString(clause, writer);
    }

    public void write(Clause clause, BufferedWriter writer, NameProvider nameProvider) throws IOException {
        String trimmed;
        Object value;
        if (OBOFormatConstants.OboFormatTag.TAG_IS_OBSELETE.getTag().equals(clause.getTag()) && ((value = clause.getValue()) instanceof Boolean ? Boolean.FALSE.equals(value) : !Boolean.TRUE.toString().equals(value))) {
            return;
        }
        StringBuilder sb = new StringBuilder();
        sb.append(clause.getTag());
        sb.append(": ");
        Iterator<Object> valuesIterator = clause.getValues().iterator();
        StringBuilder idsLabel = null;
        if (nameProvider != null && tagsInformative.contains(clause.getTag())) {
            idsLabel = new StringBuilder();
        }
        while (valuesIterator.hasNext()) {
            String label;
            String value2 = valuesIterator.next().toString();
            if (idsLabel != null && nameProvider != null && (label = nameProvider.getName(value2)) != null && (this.isOpaqueIdentifier(value2) || !valuesIterator.hasNext())) {
                if (idsLabel.length() > 0) {
                    idsLabel.append(" ");
                }
                idsLabel.append(label);
            }
            EscapeMode mode = EscapeMode.most;
            if (OBOFormatConstants.OboFormatTag.TAG_COMMENT.getTag().equals(clause.getTag())) {
                mode = EscapeMode.parenthesis;
            }
            sb.append(this.escapeOboString(value2, mode));
            if (!valuesIterator.hasNext()) continue;
            sb.append(' ');
        }
        Collection<Xref> xrefs = clause.getXrefs();
        if (xrefs != null && !xrefs.isEmpty()) {
            this.appendXrefs(sb, xrefs);
        }
        this.appendQualifiers(sb, clause);
        if (idsLabel != null && idsLabel.length() > 0 && (trimmed = idsLabel.toString().trim()).length() > 0) {
            sb.append(" ! ");
            sb.append(trimmed);
        }
        this.writeLine(sb, writer);
    }

    private boolean isOpaqueIdentifier(String value) {
        int colonPos;
        boolean result = false;
        if (value != null && value.length() > 0 && (colonPos = value.indexOf(58)) > 0 && value.length() > colonPos + 1) {
            result = true;
            for (int i = colonPos; i < value.length(); ++i) {
                char c = value.charAt(i);
                if (Character.isDigit(c) || c == ':') continue;
                result = false;
                break;
            }
        }
        return result;
    }

    private void appendQualifiers(StringBuilder sb, Clause clause) {
        Collection<QualifierValue> qvs = clause.getQualifierValues();
        if (qvs != null && qvs.size() > 0) {
            Iterator<QualifierValue> qvsIterator;
            if (qvs.size() > 1) {
                ArrayList<QualifierValue> sortQualifiers = new ArrayList<QualifierValue>(qvs);
                Collections.sort(sortQualifiers, QualifierComparator.instance);
                qvsIterator = sortQualifiers.iterator();
            } else {
                qvsIterator = qvs.iterator();
            }
            sb.append(" {");
            while (qvsIterator.hasNext()) {
                QualifierValue qv = qvsIterator.next();
                sb.append(qv.getQualifier());
                sb.append("=\"");
                sb.append(this.escapeOboString(qv.getValue().toString(), EscapeMode.quotes));
                sb.append("\"");
                if (!qvsIterator.hasNext()) continue;
                sb.append(", ");
            }
            sb.append("}");
        }
    }

    private CharSequence escapeOboString(String in, EscapeMode mode) {
        boolean modfied = false;
        StringBuilder sb = new StringBuilder();
        int length = in.length();
        for (int i = 0; i < length; ++i) {
            char c = in.charAt(i);
            if (c == '\n') {
                modfied = true;
                sb.append("\\n");
                continue;
            }
            if (c == '\\') {
                modfied = true;
                sb.append("\\\\");
                continue;
            }
            if (c == '\"' && (mode == EscapeMode.most || mode == EscapeMode.quotes)) {
                modfied = true;
                sb.append("\\\"");
                continue;
            }
            if (c == '{' && (mode == EscapeMode.most || mode == EscapeMode.parenthesis)) {
                modfied = true;
                sb.append("\\{");
                continue;
            }
            if (c == ',' && (mode == EscapeMode.xref || mode == EscapeMode.xrefList)) {
                modfied = true;
                sb.append("\\,");
                continue;
            }
            if (c == ':' && (mode == EscapeMode.xref || mode == EscapeMode.xrefList)) {
                modfied = true;
                sb.append("\\:");
                continue;
            }
            if (c == ']' && mode == EscapeMode.xrefList) {
                modfied = true;
                sb.append("\\]");
                continue;
            }
            sb.append(c);
        }
        if (modfied) {
            return sb;
        }
        return in;
    }

    public static void sortTermClauses(List<Clause> clauses) {
        Collections.sort(clauses, ClauseListComparator.instance);
    }

    public static class OWLOntologyNameProvider
    implements NameProvider {
        private final OWLOntology ont;
        private final String defaultOboNamespace;

        public OWLOntologyNameProvider(OWLOntology ont, String defaultOboNamespace) {
            this.ont = ont;
            this.defaultOboNamespace = defaultOboNamespace;
        }

        @Override
        public String getName(String id) {
            OWLAPIObo2Owl obo2owl = new OWLAPIObo2Owl(this.ont.getOWLOntologyManager());
            IRI iri = obo2owl.oboIdToIRI(id);
            for (OWLOntology o : this.ont.getImportsClosure()) {
                Set axioms = o.getAnnotationAssertionAxioms((OWLAnnotationSubject)iri);
                for (OWLAnnotationAssertionAxiom axiom : axioms) {
                    OWLAnnotationValue value;
                    if (!axiom.getProperty().isLabel() || (value = axiom.getValue()) == null || !(value instanceof OWLLiteral)) continue;
                    return ((OWLLiteral)value).getLiteral();
                }
            }
            return null;
        }

        @Override
        public String getDefaultOboNamespace() {
            return this.defaultOboNamespace;
        }
    }

    public static class OBODocNameProvider
    implements NameProvider {
        private final OBODoc oboDoc;
        private final String defaultOboNamespace;

        public OBODocNameProvider(OBODoc oboDoc) {
            this.oboDoc = oboDoc;
            Frame headerFrame = oboDoc.getHeaderFrame();
            this.defaultOboNamespace = headerFrame != null ? headerFrame.getTagValue(OBOFormatConstants.OboFormatTag.TAG_DEFAULT_NAMESPACE, String.class) : null;
        }

        @Override
        public String getName(String id) {
            Clause cl;
            String name = null;
            Frame frame = this.oboDoc.getTermFrame(id);
            if (frame == null) {
                frame = this.oboDoc.getTypedefFrame(id);
            }
            if (frame != null && (cl = frame.getClause(OBOFormatConstants.OboFormatTag.TAG_NAME)) != null) {
                name = cl.getValue(String.class);
            }
            return name;
        }

        @Override
        public String getDefaultOboNamespace() {
            return this.defaultOboNamespace;
        }
    }

    public static interface NameProvider {
        public String getName(String var1);

        public String getDefaultOboNamespace();
    }

    private static class QualifierComparator
    implements Comparator<QualifierValue> {
        static final QualifierComparator instance = new QualifierComparator();

        private QualifierComparator() {
        }

        @Override
        public int compare(QualifierValue qv1, QualifierValue qv2) {
            if (qv1 == null && qv2 == null) {
                return 0;
            }
            if (qv1 == null) {
                return -1;
            }
            if (qv2 == null) {
                return 1;
            }
            return qv1.compareTo(qv2);
        }
    }

    private static class XrefComparator
    implements Comparator<Xref> {
        static final XrefComparator instance = new XrefComparator();

        private XrefComparator() {
        }

        @Override
        public int compare(Xref x1, Xref x2) {
            String idref1 = x1.getIdref();
            String idref2 = x2.getIdref();
            if (idref1 == null && idref2 == null) {
                return 0;
            }
            if (idref1 == null) {
                return -1;
            }
            if (idref2 == null) {
                return 1;
            }
            return idref1.compareToIgnoreCase(idref2);
        }
    }

    private static class ClauseComparator
    implements Comparator<Clause> {
        static final ClauseComparator instance = new ClauseComparator();

        private ClauseComparator() {
        }

        @Override
        public int compare(Clause o1, Clause o2) {
            int comp;
            String tag = o1.getTag();
            if (OBOFormatConstants.OboFormatTag.TAG_INTERSECTION_OF.getTag().equals(tag)) {
                int s2;
                int s1 = o1.getValues().size();
                if (s1 < (s2 = o2.getValues().size())) {
                    return -1;
                }
                if (s1 > s2) {
                    return 1;
                }
            }
            if ((comp = this.compareValues(o1.getValue(), o2.getValue())) != 0) {
                return comp;
            }
            return this.compareValues(o1.getValue2(), o2.getValue2());
        }

        private int compareValues(Object o1, Object o2) {
            String s1 = this.toStringRepresentation(o1);
            String s2 = this.toStringRepresentation(o2);
            if (o1 == null && o2 == null) {
                return 0;
            }
            if (o1 == null) {
                return -1;
            }
            if (o2 == null) {
                return 1;
            }
            int comp = s1.compareToIgnoreCase(s2);
            if (comp == 0) {
                comp = s1.compareTo(s2);
            }
            return comp;
        }

        private String toStringRepresentation(Object obj) {
            String s = null;
            if (obj != null) {
                if (obj instanceof Xref) {
                    Xref xref = (Xref)obj;
                    s = xref.getIdref() + " " + xref.getAnnotation();
                } else {
                    s = obj instanceof String ? (String)obj : obj.toString();
                }
            }
            return s;
        }
    }

    private static class FramesComparator
    implements Comparator<Frame> {
        static final FramesComparator instance = new FramesComparator();

        private FramesComparator() {
        }

        @Override
        public int compare(Frame f1, Frame f2) {
            return f1.getId().compareTo(f2.getId());
        }
    }

    private static class TypeDefTagsComparator
    implements Comparator<String> {
        static final TypeDefTagsComparator instance = new TypeDefTagsComparator();
        private static Hashtable<String, Integer> tagsPriorities = TypeDefTagsComparator.buildTagsPriorities();

        private TypeDefTagsComparator() {
        }

        private static Hashtable<String, Integer> buildTagsPriorities() {
            Hashtable<String, Integer> table = new Hashtable<String, Integer>();
            table.put(OBOFormatConstants.OboFormatTag.TAG_ID.getTag(), 5);
            table.put(OBOFormatConstants.OboFormatTag.TAG_IS_ANONYMOUS.getTag(), 10);
            table.put(OBOFormatConstants.OboFormatTag.TAG_NAME.getTag(), 15);
            table.put(OBOFormatConstants.OboFormatTag.TAG_NAMESPACE.getTag(), 20);
            table.put(OBOFormatConstants.OboFormatTag.TAG_ALT_ID.getTag(), 25);
            table.put(OBOFormatConstants.OboFormatTag.TAG_DEF.getTag(), 30);
            table.put(OBOFormatConstants.OboFormatTag.TAG_COMMENT.getTag(), 35);
            table.put(OBOFormatConstants.OboFormatTag.TAG_SUBSET.getTag(), 40);
            table.put(OBOFormatConstants.OboFormatTag.TAG_SYNONYM.getTag(), 45);
            table.put(OBOFormatConstants.OboFormatTag.TAG_XREF.getTag(), 50);
            table.put(OBOFormatConstants.OboFormatTag.TAG_PROPERTY_VALUE.getTag(), 55);
            table.put(OBOFormatConstants.OboFormatTag.TAG_DOMAIN.getTag(), 60);
            table.put(OBOFormatConstants.OboFormatTag.TAG_RANGE.getTag(), 65);
            table.put(OBOFormatConstants.OboFormatTag.TAG_BUILTIN.getTag(), 70);
            table.put(OBOFormatConstants.OboFormatTag.TAG_HOLDS_OVER_CHAIN.getTag(), 71);
            table.put(OBOFormatConstants.OboFormatTag.TAG_IS_ANTI_SYMMETRIC.getTag(), 75);
            table.put(OBOFormatConstants.OboFormatTag.TAG_IS_CYCLIC.getTag(), 80);
            table.put(OBOFormatConstants.OboFormatTag.TAG_IS_REFLEXIVE.getTag(), 85);
            table.put(OBOFormatConstants.OboFormatTag.TAG_IS_SYMMETRIC.getTag(), 90);
            table.put(OBOFormatConstants.OboFormatTag.TAG_IS_TRANSITIVE.getTag(), 100);
            table.put(OBOFormatConstants.OboFormatTag.TAG_IS_FUNCTIONAL.getTag(), 105);
            table.put(OBOFormatConstants.OboFormatTag.TAG_IS_INVERSE_FUNCTIONAL.getTag(), 110);
            table.put(OBOFormatConstants.OboFormatTag.TAG_IS_A.getTag(), 115);
            table.put(OBOFormatConstants.OboFormatTag.TAG_INTERSECTION_OF.getTag(), 120);
            table.put(OBOFormatConstants.OboFormatTag.TAG_UNION_OF.getTag(), 125);
            table.put(OBOFormatConstants.OboFormatTag.TAG_EQUIVALENT_TO.getTag(), 130);
            table.put(OBOFormatConstants.OboFormatTag.TAG_DISJOINT_FROM.getTag(), 135);
            table.put(OBOFormatConstants.OboFormatTag.TAG_INVERSE_OF.getTag(), 140);
            table.put(OBOFormatConstants.OboFormatTag.TAG_TRANSITIVE_OVER.getTag(), 145);
            table.put(OBOFormatConstants.OboFormatTag.TAG_EQUIVALENT_TO_CHAIN.getTag(), 155);
            table.put(OBOFormatConstants.OboFormatTag.TAG_DISJOINT_OVER.getTag(), 160);
            table.put(OBOFormatConstants.OboFormatTag.TAG_RELATIONSHIP.getTag(), 165);
            table.put(OBOFormatConstants.OboFormatTag.TAG_IS_OBSELETE.getTag(), 169);
            table.put(OBOFormatConstants.OboFormatTag.TAG_REPLACED_BY.getTag(), 185);
            table.put(OBOFormatConstants.OboFormatTag.TAG_CONSIDER.getTag(), 190);
            table.put(OBOFormatConstants.OboFormatTag.TAG_CREATED_BY.getTag(), 191);
            table.put(OBOFormatConstants.OboFormatTag.TAG_CREATION_DATE.getTag(), 192);
            table.put(OBOFormatConstants.OboFormatTag.TAG_EXPAND_ASSERTION_TO.getTag(), 195);
            table.put(OBOFormatConstants.OboFormatTag.TAG_EXPAND_EXPRESSION_TO.getTag(), 200);
            table.put(OBOFormatConstants.OboFormatTag.TAG_IS_METADATA_TAG.getTag(), 205);
            table.put(OBOFormatConstants.OboFormatTag.TAG_IS_CLASS_LEVEL_TAG.getTag(), 210);
            return table;
        }

        @Override
        public int compare(String o1, String o2) {
            Integer i1 = tagsPriorities.get(o1);
            Integer i2 = tagsPriorities.get(o2);
            if (i1 == null) {
                i1 = 10000;
            }
            if (i2 == null) {
                i2 = 10000;
            }
            return i1.compareTo(i2);
        }
    }

    private static final class ClauseListComparator
    implements Comparator<Clause> {
        protected static final ClauseListComparator instance = new ClauseListComparator();

        private ClauseListComparator() {
        }

        @Override
        public int compare(Clause c1, Clause c2) {
            String t2;
            String t1 = c1.getTag();
            int compare = TermsTagsComparator.instance.compare(t1, t2 = c2.getTag());
            if (compare == 0) {
                compare = ClauseComparator.instance.compare(c1, c2);
            }
            return compare;
        }
    }

    private static class TermsTagsComparator
    implements Comparator<String> {
        static final TermsTagsComparator instance = new TermsTagsComparator();
        private static Hashtable<String, Integer> tagsPriorities = TermsTagsComparator.buildTagsPriorities();

        private TermsTagsComparator() {
        }

        private static Hashtable<String, Integer> buildTagsPriorities() {
            Hashtable<String, Integer> table = new Hashtable<String, Integer>();
            table.put(OBOFormatConstants.OboFormatTag.TAG_ID.getTag(), 5);
            table.put(OBOFormatConstants.OboFormatTag.TAG_IS_ANONYMOUS.getTag(), 10);
            table.put(OBOFormatConstants.OboFormatTag.TAG_NAME.getTag(), 15);
            table.put(OBOFormatConstants.OboFormatTag.TAG_NAMESPACE.getTag(), 20);
            table.put(OBOFormatConstants.OboFormatTag.TAG_ALT_ID.getTag(), 25);
            table.put(OBOFormatConstants.OboFormatTag.TAG_DEF.getTag(), 30);
            table.put(OBOFormatConstants.OboFormatTag.TAG_COMMENT.getTag(), 35);
            table.put(OBOFormatConstants.OboFormatTag.TAG_SUBSET.getTag(), 40);
            table.put(OBOFormatConstants.OboFormatTag.TAG_SYNONYM.getTag(), 45);
            table.put(OBOFormatConstants.OboFormatTag.TAG_XREF.getTag(), 50);
            table.put(OBOFormatConstants.OboFormatTag.TAG_BUILTIN.getTag(), 55);
            table.put(OBOFormatConstants.OboFormatTag.TAG_HOLDS_OVER_CHAIN.getTag(), 60);
            table.put(OBOFormatConstants.OboFormatTag.TAG_IS_A.getTag(), 65);
            table.put(OBOFormatConstants.OboFormatTag.TAG_INTERSECTION_OF.getTag(), 70);
            table.put(OBOFormatConstants.OboFormatTag.TAG_UNION_OF.getTag(), 80);
            table.put(OBOFormatConstants.OboFormatTag.TAG_EQUIVALENT_TO.getTag(), 85);
            table.put(OBOFormatConstants.OboFormatTag.TAG_DISJOINT_FROM.getTag(), 90);
            table.put(OBOFormatConstants.OboFormatTag.TAG_RELATIONSHIP.getTag(), 95);
            table.put(OBOFormatConstants.OboFormatTag.TAG_PROPERTY_VALUE.getTag(), 98);
            table.put(OBOFormatConstants.OboFormatTag.TAG_IS_OBSELETE.getTag(), 110);
            table.put(OBOFormatConstants.OboFormatTag.TAG_REPLACED_BY.getTag(), 115);
            table.put(OBOFormatConstants.OboFormatTag.TAG_CONSIDER.getTag(), 120);
            table.put(OBOFormatConstants.OboFormatTag.TAG_CREATED_BY.getTag(), 130);
            table.put(OBOFormatConstants.OboFormatTag.TAG_CREATION_DATE.getTag(), 140);
            return table;
        }

        @Override
        public int compare(String o1, String o2) {
            Integer i1 = tagsPriorities.get(o1);
            Integer i2 = tagsPriorities.get(o2);
            if (i1 == null) {
                i1 = 10000;
            }
            if (i2 == null) {
                i2 = 10000;
            }
            return i1.compareTo(i2);
        }
    }

    private static class HeaderTagsComparator
    implements Comparator<String> {
        static final HeaderTagsComparator instance = new HeaderTagsComparator();
        private static Hashtable<String, Integer> tagsPriorities = HeaderTagsComparator.buildTagsPriorities();

        private HeaderTagsComparator() {
        }

        private static Hashtable<String, Integer> buildTagsPriorities() {
            Hashtable<String, Integer> table = new Hashtable<String, Integer>();
            table.put(OBOFormatConstants.OboFormatTag.TAG_FORMAT_VERSION.getTag(), 0);
            table.put(OBOFormatConstants.OboFormatTag.TAG_DATA_VERSION.getTag(), 10);
            table.put(OBOFormatConstants.OboFormatTag.TAG_DATE.getTag(), 15);
            table.put(OBOFormatConstants.OboFormatTag.TAG_SAVED_BY.getTag(), 20);
            table.put(OBOFormatConstants.OboFormatTag.TAG_AUTO_GENERATED_BY.getTag(), 25);
            table.put(OBOFormatConstants.OboFormatTag.TAG_SUBSETDEF.getTag(), 35);
            table.put(OBOFormatConstants.OboFormatTag.TAG_SYNONYMTYPEDEF.getTag(), 40);
            table.put(OBOFormatConstants.OboFormatTag.TAG_DEFAULT_NAMESPACE.getTag(), 45);
            table.put(OBOFormatConstants.OboFormatTag.TAG_NAMESPACE_ID_RULE.getTag(), 46);
            table.put(OBOFormatConstants.OboFormatTag.TAG_IDSPACE.getTag(), 50);
            table.put(OBOFormatConstants.OboFormatTag.TAG_TREAT_XREFS_AS_EQUIVALENT.getTag(), 55);
            table.put(OBOFormatConstants.OboFormatTag.TAG_TREAT_XREFS_AS_GENUS_DIFFERENTIA.getTag(), 60);
            table.put(OBOFormatConstants.OboFormatTag.TAG_TREAT_XREFS_AS_RELATIONSHIP.getTag(), 65);
            table.put(OBOFormatConstants.OboFormatTag.TAG_TREAT_XREFS_AS_IS_A.getTag(), 70);
            table.put(OBOFormatConstants.OboFormatTag.TAG_REMARK.getTag(), 75);
            table.put(OBOFormatConstants.OboFormatTag.TAG_IMPORT.getTag(), 80);
            table.put(OBOFormatConstants.OboFormatTag.TAG_ONTOLOGY.getTag(), 85);
            table.put(OBOFormatConstants.OboFormatTag.TAG_PROPERTY_VALUE.getTag(), 100);
            table.put(OBOFormatConstants.OboFormatTag.TAG_OWL_AXIOMS.getTag(), 110);
            return table;
        }

        @Override
        public int compare(String o1, String o2) {
            Integer i1 = tagsPriorities.get(o1);
            Integer i2 = tagsPriorities.get(o2);
            if (i1 == null) {
                i1 = 10000;
            }
            if (i2 == null) {
                i2 = 10000;
            }
            return i1.compareTo(i2);
        }
    }

    private static enum EscapeMode {
        most,
        parenthesis,
        quotes,
        xref,
        xrefList,
        simple;

    }
}

