/*
 * Decompiled with CFR 0.152.
 */
package org.coode.owlapi.oboformat;

import java.io.BufferedWriter;
import java.io.IOException;
import java.io.OutputStream;
import java.io.OutputStreamWriter;
import java.io.Writer;
import org.obolibrary.obo2owl.OWLAPIOwl2Obo;
import org.obolibrary.oboformat.model.OBODoc;
import org.obolibrary.oboformat.writer.OBOFormatWriter;
import org.semanticweb.owlapi.io.OWLRenderer;
import org.semanticweb.owlapi.model.OWLException;
import org.semanticweb.owlapi.model.OWLOntology;
import org.semanticweb.owlapi.model.OWLOntologyManager;
import org.semanticweb.owlapi.model.OWLOntologyStorageException;

public class OBOFormatRenderer
implements OWLRenderer {
    public void setOWLOntologyManager(OWLOntologyManager owlOntologyManager) throws OWLException {
    }

    public void render(OWLOntology ontology, OutputStream os) throws OWLOntologyStorageException {
        this.render(ontology, new OutputStreamWriter(os));
    }

    public void render(OWLOntology ontology, Writer writer) throws OWLOntologyStorageException {
        try {
            OBOFormatWriter.NameProvider nameProvider;
            boolean hasImports;
            OWLAPIOwl2Obo translator = new OWLAPIOwl2Obo(ontology.getOWLOntologyManager());
            OBODoc result = translator.convert(ontology);
            boolean bl = hasImports = !ontology.getImports().isEmpty();
            if (hasImports) {
                final OBOFormatWriter.OBODocNameProvider primary = new OBOFormatWriter.OBODocNameProvider(result);
                final OBOFormatWriter.OWLOntologyNameProvider secondary = new OBOFormatWriter.OWLOntologyNameProvider(ontology, primary.getDefaultOboNamespace());
                nameProvider = new OBOFormatWriter.NameProvider(){

                    @Override
                    public String getName(String id) {
                        String name = primary.getName(id);
                        if (name != null) {
                            return name;
                        }
                        return secondary.getName(id);
                    }

                    @Override
                    public String getDefaultOboNamespace() {
                        return primary.getDefaultOboNamespace();
                    }
                };
            } else {
                nameProvider = new OBOFormatWriter.OBODocNameProvider(result);
            }
            new OBOFormatWriter().write(result, new BufferedWriter(writer), nameProvider);
        }
        catch (IOException e) {
            throw new OWLOntologyStorageException((Throwable)e);
        }
    }
}

