/*
 * Decompiled with CFR 0.152.
 */
package uk.ac.manchester.cs.owl.owlapi;

import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.Set;
import java.util.stream.Stream;
import org.semanticweb.owlapi.model.OWLAnnotation;
import org.semanticweb.owlapi.model.OWLNaryPropertyAxiom;
import org.semanticweb.owlapi.model.OWLPropertyExpression;
import org.semanticweb.owlapi.util.OWLAPIPreconditions;
import org.semanticweb.owlapi.util.OWLAPIStreamUtils;
import uk.ac.manchester.cs.owl.owlapi.OWLPropertyAxiomImpl;

public abstract class OWLNaryPropertyAxiomImpl<P extends OWLPropertyExpression>
extends OWLPropertyAxiomImpl
implements OWLNaryPropertyAxiom<P> {
    protected final List<P> properties;

    public OWLNaryPropertyAxiomImpl(List<P> properties, Collection<OWLAnnotation> annotations) {
        super(annotations);
        this.properties = Collections.unmodifiableList((List)OWLAPIPreconditions.checkValidForNAryExpressions(properties, (String)"properties cannot be null or empty"));
    }

    public Stream<P> properties() {
        return OWLAPIStreamUtils.streamFromSorted(this.properties);
    }

    public List<P> getOperandsAsList() {
        return this.properties;
    }

    public Set<P> getPropertiesMinus(P property) {
        return OWLAPIStreamUtils.asUnorderedSet(this.properties.stream().filter(x -> !x.equals(property)));
    }
}

