/*
 * Decompiled with CFR 0.152.
 */
package uk.ac.manchester.cs.owl.owlapi;

import java.util.stream.Stream;
import javax.annotation.Nullable;
import org.semanticweb.owlapi.model.DataRangeType;
import org.semanticweb.owlapi.model.IRI;
import org.semanticweb.owlapi.model.OWLDatatype;
import org.semanticweb.owlapi.model.OWLEntity;
import org.semanticweb.owlapi.model.OWLObject;
import org.semanticweb.owlapi.util.OWLAPIPreconditions;
import org.semanticweb.owlapi.vocab.OWL2Datatype;

public class OWL2DatatypeImpl
implements OWLDatatype {
    private final OWL2Datatype owl2Datatype;
    private final int hashCode;

    public OWL2DatatypeImpl(OWL2Datatype owl2Datatype) {
        this.owl2Datatype = (OWL2Datatype)OWLAPIPreconditions.checkNotNull((Object)owl2Datatype, (String)"owl2Datatype must not be null");
        this.hashCode = this.initHashCode();
    }

    public OWL2Datatype getBuiltInDatatype() {
        return this.owl2Datatype;
    }

    public boolean isString() {
        return this.owl2Datatype == OWL2Datatype.XSD_STRING;
    }

    public boolean isInteger() {
        return this.owl2Datatype == OWL2Datatype.XSD_INTEGER;
    }

    public boolean isFloat() {
        return this.owl2Datatype == OWL2Datatype.XSD_FLOAT;
    }

    public boolean isDouble() {
        return this.owl2Datatype == OWL2Datatype.XSD_DOUBLE;
    }

    public boolean isBoolean() {
        return this.owl2Datatype == OWL2Datatype.XSD_BOOLEAN;
    }

    public boolean isRDFPlainLiteral() {
        return this.owl2Datatype == OWL2Datatype.RDF_PLAIN_LITERAL;
    }

    public boolean isTopDatatype() {
        return this.owl2Datatype == OWL2Datatype.RDFS_LITERAL;
    }

    public DataRangeType getDataRangeType() {
        return DataRangeType.DATATYPE;
    }

    public boolean isBuiltIn() {
        return true;
    }

    public boolean isOWLDatatype() {
        return true;
    }

    public String toStringID() {
        return this.owl2Datatype.getIRI().toString();
    }

    public String toString() {
        return this.toStringID();
    }

    public IRI getIRI() {
        return this.owl2Datatype.getIRI();
    }

    public boolean equals(@Nullable Object obj) {
        if (obj == this) {
            return true;
        }
        if (!(obj instanceof OWLDatatype)) {
            return false;
        }
        OWLDatatype other = (OWLDatatype)obj;
        return this.owl2Datatype.getIRI().equals((Object)other.getIRI());
    }

    public Stream<OWLEntity> signature() {
        return Stream.of(this);
    }

    public boolean containsEntityInSignature(OWLEntity owlEntity) {
        return this.equals(owlEntity);
    }

    public Stream<OWLDatatype> datatypesInSignature() {
        return Stream.of(this);
    }

    public boolean isTopEntity() {
        return this.owl2Datatype == OWL2Datatype.RDFS_LITERAL;
    }

    public int compareTo(@Nullable OWLObject o) {
        if (o == null) {
            throw new NullPointerException("o cannot be null in a compareTo call.");
        }
        int diff = Integer.compare(this.typeIndex(), o.typeIndex());
        if (diff != 0) {
            return diff;
        }
        if (o instanceof OWLDatatype) {
            diff = this.getIRI().compareTo((OWLObject)((OWLDatatype)o).getIRI());
        }
        return diff;
    }

    public int hashCode() {
        return this.hashCode;
    }
}

