/*
 * Decompiled with CFR 0.152.
 */
package uk.ac.manchester.cs.owl.owlapi.concurrent;

import java.io.OutputStream;
import java.util.Collection;
import java.util.List;
import java.util.Set;
import java.util.concurrent.locks.Lock;
import java.util.concurrent.locks.ReadWriteLock;
import java.util.function.Predicate;
import java.util.stream.Stream;
import javax.annotation.Nullable;
import javax.inject.Inject;
import org.semanticweb.owlapi.io.OWLOntologyDocumentTarget;
import org.semanticweb.owlapi.model.AxiomType;
import org.semanticweb.owlapi.model.IRI;
import org.semanticweb.owlapi.model.OWLAnnotation;
import org.semanticweb.owlapi.model.OWLAnnotationAssertionAxiom;
import org.semanticweb.owlapi.model.OWLAnnotationAxiom;
import org.semanticweb.owlapi.model.OWLAnnotationProperty;
import org.semanticweb.owlapi.model.OWLAnnotationPropertyDomainAxiom;
import org.semanticweb.owlapi.model.OWLAnnotationPropertyRangeAxiom;
import org.semanticweb.owlapi.model.OWLAnnotationSubject;
import org.semanticweb.owlapi.model.OWLAnonymousIndividual;
import org.semanticweb.owlapi.model.OWLAsymmetricObjectPropertyAxiom;
import org.semanticweb.owlapi.model.OWLAxiom;
import org.semanticweb.owlapi.model.OWLClass;
import org.semanticweb.owlapi.model.OWLClassAssertionAxiom;
import org.semanticweb.owlapi.model.OWLClassAxiom;
import org.semanticweb.owlapi.model.OWLClassExpression;
import org.semanticweb.owlapi.model.OWLDataProperty;
import org.semanticweb.owlapi.model.OWLDataPropertyAssertionAxiom;
import org.semanticweb.owlapi.model.OWLDataPropertyAxiom;
import org.semanticweb.owlapi.model.OWLDataPropertyDomainAxiom;
import org.semanticweb.owlapi.model.OWLDataPropertyExpression;
import org.semanticweb.owlapi.model.OWLDataPropertyRangeAxiom;
import org.semanticweb.owlapi.model.OWLDatatype;
import org.semanticweb.owlapi.model.OWLDatatypeDefinitionAxiom;
import org.semanticweb.owlapi.model.OWLDeclarationAxiom;
import org.semanticweb.owlapi.model.OWLDifferentIndividualsAxiom;
import org.semanticweb.owlapi.model.OWLDisjointClassesAxiom;
import org.semanticweb.owlapi.model.OWLDisjointDataPropertiesAxiom;
import org.semanticweb.owlapi.model.OWLDisjointObjectPropertiesAxiom;
import org.semanticweb.owlapi.model.OWLDisjointUnionAxiom;
import org.semanticweb.owlapi.model.OWLDocumentFormat;
import org.semanticweb.owlapi.model.OWLEntity;
import org.semanticweb.owlapi.model.OWLEquivalentClassesAxiom;
import org.semanticweb.owlapi.model.OWLEquivalentDataPropertiesAxiom;
import org.semanticweb.owlapi.model.OWLEquivalentObjectPropertiesAxiom;
import org.semanticweb.owlapi.model.OWLFunctionalDataPropertyAxiom;
import org.semanticweb.owlapi.model.OWLFunctionalObjectPropertyAxiom;
import org.semanticweb.owlapi.model.OWLHasKeyAxiom;
import org.semanticweb.owlapi.model.OWLImportsDeclaration;
import org.semanticweb.owlapi.model.OWLIndividual;
import org.semanticweb.owlapi.model.OWLIndividualAxiom;
import org.semanticweb.owlapi.model.OWLInverseFunctionalObjectPropertyAxiom;
import org.semanticweb.owlapi.model.OWLInverseObjectPropertiesAxiom;
import org.semanticweb.owlapi.model.OWLIrreflexiveObjectPropertyAxiom;
import org.semanticweb.owlapi.model.OWLLogicalAxiom;
import org.semanticweb.owlapi.model.OWLMutableOntology;
import org.semanticweb.owlapi.model.OWLNamedIndividual;
import org.semanticweb.owlapi.model.OWLNamedObjectVisitor;
import org.semanticweb.owlapi.model.OWLNamedObjectVisitorEx;
import org.semanticweb.owlapi.model.OWLNegativeDataPropertyAssertionAxiom;
import org.semanticweb.owlapi.model.OWLNegativeObjectPropertyAssertionAxiom;
import org.semanticweb.owlapi.model.OWLObject;
import org.semanticweb.owlapi.model.OWLObjectProperty;
import org.semanticweb.owlapi.model.OWLObjectPropertyAssertionAxiom;
import org.semanticweb.owlapi.model.OWLObjectPropertyAxiom;
import org.semanticweb.owlapi.model.OWLObjectPropertyDomainAxiom;
import org.semanticweb.owlapi.model.OWLObjectPropertyExpression;
import org.semanticweb.owlapi.model.OWLObjectPropertyRangeAxiom;
import org.semanticweb.owlapi.model.OWLObjectVisitor;
import org.semanticweb.owlapi.model.OWLObjectVisitorEx;
import org.semanticweb.owlapi.model.OWLOntology;
import org.semanticweb.owlapi.model.OWLOntologyChange;
import org.semanticweb.owlapi.model.OWLOntologyID;
import org.semanticweb.owlapi.model.OWLOntologyManager;
import org.semanticweb.owlapi.model.OWLOntologyStorageException;
import org.semanticweb.owlapi.model.OWLPrimitive;
import org.semanticweb.owlapi.model.OWLReflexiveObjectPropertyAxiom;
import org.semanticweb.owlapi.model.OWLSameIndividualAxiom;
import org.semanticweb.owlapi.model.OWLSubAnnotationPropertyOfAxiom;
import org.semanticweb.owlapi.model.OWLSubClassOfAxiom;
import org.semanticweb.owlapi.model.OWLSubDataPropertyOfAxiom;
import org.semanticweb.owlapi.model.OWLSubObjectPropertyOfAxiom;
import org.semanticweb.owlapi.model.OWLSymmetricObjectPropertyAxiom;
import org.semanticweb.owlapi.model.OWLTransitiveObjectPropertyAxiom;
import org.semanticweb.owlapi.model.parameters.AxiomAnnotations;
import org.semanticweb.owlapi.model.parameters.ChangeApplied;
import org.semanticweb.owlapi.model.parameters.Imports;
import org.semanticweb.owlapi.model.parameters.Navigation;
import org.semanticweb.owlapi.util.OWLAPIPreconditions;
import org.semanticweb.owlapi.util.OWLAxiomSearchFilter;
import uk.ac.manchester.cs.owl.owlapi.HasTrimToSize;

public class ConcurrentOWLOntologyImpl
implements OWLMutableOntology,
HasTrimToSize {
    private final OWLOntology delegate;
    private final Lock readLock;
    private final Lock writeLock;

    @Inject
    public ConcurrentOWLOntologyImpl(OWLOntology delegate, ReadWriteLock readWriteLock) {
        this.delegate = (OWLOntology)OWLAPIPreconditions.verifyNotNull((Object)delegate);
        OWLAPIPreconditions.verifyNotNull((Object)readWriteLock);
        this.readLock = readWriteLock.readLock();
        this.writeLock = readWriteLock.writeLock();
    }

    public int typeIndex() {
        return this.delegate.typeIndex();
    }

    @Override
    public void trimToSize() {
        this.writeLock.lock();
        try {
            if (this.delegate instanceof HasTrimToSize) {
                ((HasTrimToSize)this.delegate).trimToSize();
            }
        }
        finally {
            this.writeLock.unlock();
        }
    }

    public void accept(OWLNamedObjectVisitor owlNamedObjectVisitor) {
        this.delegate.accept(owlNamedObjectVisitor);
    }

    public <O> O accept(OWLNamedObjectVisitorEx<O> owlNamedObjectVisitorEx) {
        return (O)this.delegate.accept(owlNamedObjectVisitorEx);
    }

    public int hashCode() {
        this.readLock.lock();
        try {
            int n = this.delegate.hashCode();
            return n;
        }
        finally {
            this.readLock.unlock();
        }
    }

    public boolean equals(@Nullable Object obj) {
        this.readLock.lock();
        try {
            boolean bl = this.delegate.equals(obj);
            return bl;
        }
        finally {
            this.readLock.unlock();
        }
    }

    public OWLOntologyManager getOWLOntologyManager() {
        this.readLock.lock();
        try {
            OWLOntologyManager oWLOntologyManager = this.delegate.getOWLOntologyManager();
            return oWLOntologyManager;
        }
        finally {
            this.readLock.unlock();
        }
    }

    public void setOWLOntologyManager(@Nullable OWLOntologyManager owlOntologyManager) {
        this.writeLock.lock();
        try {
            this.delegate.setOWLOntologyManager(owlOntologyManager);
        }
        finally {
            this.writeLock.unlock();
        }
    }

    public OWLOntologyID getOntologyID() {
        this.readLock.lock();
        try {
            OWLOntologyID oWLOntologyID = this.delegate.getOntologyID();
            return oWLOntologyID;
        }
        finally {
            this.readLock.unlock();
        }
    }

    public boolean isAnonymous() {
        this.readLock.lock();
        try {
            boolean bl = this.delegate.isAnonymous();
            return bl;
        }
        finally {
            this.readLock.unlock();
        }
    }

    public Set<OWLAnnotation> getAnnotations() {
        this.readLock.lock();
        try {
            Set set = this.delegate.getAnnotations();
            return set;
        }
        finally {
            this.readLock.unlock();
        }
    }

    public Set<IRI> getDirectImportsDocuments() {
        this.readLock.lock();
        try {
            Set set = this.delegate.getDirectImportsDocuments();
            return set;
        }
        finally {
            this.readLock.unlock();
        }
    }

    public Stream<IRI> directImportsDocuments() {
        this.readLock.lock();
        try {
            Stream stream = this.delegate.directImportsDocuments();
            return stream;
        }
        finally {
            this.readLock.unlock();
        }
    }

    public Set<OWLOntology> getDirectImports() {
        this.readLock.lock();
        try {
            Set set = this.delegate.getDirectImports();
            return set;
        }
        finally {
            this.readLock.unlock();
        }
    }

    public Stream<OWLOntology> directImports() {
        this.readLock.lock();
        try {
            Stream stream = this.delegate.directImports();
            return stream;
        }
        finally {
            this.readLock.unlock();
        }
    }

    public Set<OWLOntology> getImports() {
        this.readLock.lock();
        try {
            Set set = this.delegate.getImports();
            return set;
        }
        finally {
            this.readLock.unlock();
        }
    }

    public Stream<OWLOntology> imports() {
        this.readLock.lock();
        try {
            Stream stream = this.delegate.imports();
            return stream;
        }
        finally {
            this.readLock.unlock();
        }
    }

    public Set<OWLOntology> getImportsClosure() {
        this.readLock.lock();
        try {
            Set set = this.delegate.getImportsClosure();
            return set;
        }
        finally {
            this.readLock.unlock();
        }
    }

    public Stream<OWLOntology> importsClosure() {
        this.readLock.lock();
        try {
            Stream stream = this.delegate.importsClosure();
            return stream;
        }
        finally {
            this.readLock.unlock();
        }
    }

    public Set<OWLImportsDeclaration> getImportsDeclarations() {
        this.readLock.lock();
        try {
            Set set = this.delegate.getImportsDeclarations();
            return set;
        }
        finally {
            this.readLock.unlock();
        }
    }

    public boolean isEmpty() {
        this.readLock.lock();
        try {
            boolean bl = this.delegate.isEmpty();
            return bl;
        }
        finally {
            this.readLock.unlock();
        }
    }

    public Set<OWLAxiom> getTBoxAxioms(Imports imports) {
        this.readLock.lock();
        try {
            Set set = this.delegate.getTBoxAxioms(imports);
            return set;
        }
        finally {
            this.readLock.unlock();
        }
    }

    public Set<OWLAxiom> getABoxAxioms(Imports imports) {
        this.readLock.lock();
        try {
            Set set = this.delegate.getABoxAxioms(imports);
            return set;
        }
        finally {
            this.readLock.unlock();
        }
    }

    public Set<OWLAxiom> getRBoxAxioms(Imports imports) {
        this.readLock.lock();
        try {
            Set set = this.delegate.getRBoxAxioms(imports);
            return set;
        }
        finally {
            this.readLock.unlock();
        }
    }

    public Stream<OWLAxiom> tboxAxioms(Imports imports) {
        this.readLock.lock();
        try {
            Stream stream = this.delegate.tboxAxioms(imports);
            return stream;
        }
        finally {
            this.readLock.unlock();
        }
    }

    public Stream<OWLAxiom> aboxAxioms(Imports imports) {
        this.readLock.lock();
        try {
            Stream stream = this.delegate.aboxAxioms(imports);
            return stream;
        }
        finally {
            this.readLock.unlock();
        }
    }

    public Stream<OWLAxiom> rboxAxioms(Imports imports) {
        this.readLock.lock();
        try {
            Stream stream = this.delegate.rboxAxioms(imports);
            return stream;
        }
        finally {
            this.readLock.unlock();
        }
    }

    public Set<OWLClassAxiom> getGeneralClassAxioms() {
        this.readLock.lock();
        try {
            Set set = this.delegate.getGeneralClassAxioms();
            return set;
        }
        finally {
            this.readLock.unlock();
        }
    }

    public Set<OWLEntity> getSignature() {
        this.readLock.lock();
        try {
            Set set = this.delegate.getSignature();
            return set;
        }
        finally {
            this.readLock.unlock();
        }
    }

    public Set<OWLEntity> getSignature(Imports imports) {
        this.readLock.lock();
        try {
            Set set = this.delegate.getSignature(imports);
            return set;
        }
        finally {
            this.readLock.unlock();
        }
    }

    public Stream<OWLClassAxiom> generalClassAxioms() {
        this.readLock.lock();
        try {
            Stream stream = this.delegate.generalClassAxioms();
            return stream;
        }
        finally {
            this.readLock.unlock();
        }
    }

    public Stream<OWLEntity> signature() {
        this.readLock.lock();
        try {
            Stream stream = this.delegate.signature();
            return stream;
        }
        finally {
            this.readLock.unlock();
        }
    }

    public Stream<OWLEntity> signature(Imports imports) {
        this.readLock.lock();
        try {
            Stream stream = this.delegate.signature(imports);
            return stream;
        }
        finally {
            this.readLock.unlock();
        }
    }

    public boolean isDeclared(OWLEntity owlEntity) {
        this.readLock.lock();
        try {
            boolean bl = this.delegate.isDeclared(owlEntity);
            return bl;
        }
        finally {
            this.readLock.unlock();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean isDeclared(OWLEntity owlEntity, Imports imports) {
        this.readLock.lock();
        try {
            boolean bl = this.delegate.isDeclared(owlEntity, imports);
            return bl;
        }
        finally {
            this.readLock.unlock();
        }
    }

    public void saveOntology() throws OWLOntologyStorageException {
        this.readLock.lock();
        try {
            this.delegate.saveOntology();
        }
        finally {
            this.readLock.unlock();
        }
    }

    public void saveOntology(IRI iri) throws OWLOntologyStorageException {
        this.readLock.lock();
        try {
            this.delegate.saveOntology(iri);
        }
        finally {
            this.readLock.unlock();
        }
    }

    public void saveOntology(OutputStream outputStream) throws OWLOntologyStorageException {
        this.readLock.lock();
        try {
            this.delegate.saveOntology(outputStream);
        }
        finally {
            this.readLock.unlock();
        }
    }

    public void saveOntology(OWLDocumentFormat owlDocumentFormat) throws OWLOntologyStorageException {
        this.readLock.lock();
        try {
            this.delegate.saveOntology(owlDocumentFormat);
        }
        finally {
            this.readLock.unlock();
        }
    }

    public void saveOntology(OWLDocumentFormat owlDocumentFormat, IRI iri) throws OWLOntologyStorageException {
        this.readLock.lock();
        try {
            this.delegate.saveOntology(owlDocumentFormat, iri);
        }
        finally {
            this.readLock.unlock();
        }
    }

    public void saveOntology(OWLDocumentFormat owlDocumentFormat, OutputStream outputStream) throws OWLOntologyStorageException {
        this.readLock.lock();
        try {
            this.delegate.saveOntology(owlDocumentFormat, outputStream);
        }
        finally {
            this.readLock.unlock();
        }
    }

    public void saveOntology(OWLOntologyDocumentTarget owlOntologyDocumentTarget) throws OWLOntologyStorageException {
        this.readLock.lock();
        try {
            this.delegate.saveOntology(owlOntologyDocumentTarget);
        }
        finally {
            this.readLock.unlock();
        }
    }

    public void saveOntology(OWLDocumentFormat owlDocumentFormat, OWLOntologyDocumentTarget owlOntologyDocumentTarget) throws OWLOntologyStorageException {
        this.readLock.lock();
        try {
            this.delegate.saveOntology(owlDocumentFormat, owlOntologyDocumentTarget);
        }
        finally {
            this.readLock.unlock();
        }
    }

    public Set<OWLClassExpression> getNestedClassExpressions() {
        this.readLock.lock();
        try {
            Set set = this.delegate.getNestedClassExpressions();
            return set;
        }
        finally {
            this.readLock.unlock();
        }
    }

    public void accept(OWLObjectVisitor owlObjectVisitor) {
        this.delegate.accept(owlObjectVisitor);
    }

    public <O> O accept(OWLObjectVisitorEx<O> owlObjectVisitorEx) {
        return (O)this.delegate.accept(owlObjectVisitorEx);
    }

    public boolean isTopEntity() {
        this.readLock.lock();
        try {
            boolean bl = this.delegate.isTopEntity();
            return bl;
        }
        finally {
            this.readLock.unlock();
        }
    }

    public boolean isBottomEntity() {
        this.readLock.lock();
        try {
            boolean bl = this.delegate.isBottomEntity();
            return bl;
        }
        finally {
            this.readLock.unlock();
        }
    }

    public String toString() {
        this.readLock.lock();
        try {
            String string = this.delegate.toString();
            return string;
        }
        finally {
            this.readLock.unlock();
        }
    }

    public int compareTo(@Nullable OWLObject o) {
        this.readLock.lock();
        try {
            int n = this.delegate.compareTo((Object)o);
            return n;
        }
        finally {
            this.readLock.unlock();
        }
    }

    public boolean containsEntityInSignature(OWLEntity owlEntity) {
        this.readLock.lock();
        try {
            boolean bl = this.delegate.containsEntityInSignature(owlEntity);
            return bl;
        }
        finally {
            this.readLock.unlock();
        }
    }

    public Set<OWLAnonymousIndividual> getAnonymousIndividuals() {
        this.readLock.lock();
        try {
            Set set = this.delegate.getAnonymousIndividuals();
            return set;
        }
        finally {
            this.readLock.unlock();
        }
    }

    public Set<OWLClass> getClassesInSignature() {
        this.readLock.lock();
        try {
            Set set = this.delegate.getClassesInSignature();
            return set;
        }
        finally {
            this.readLock.unlock();
        }
    }

    public Set<OWLObjectProperty> getObjectPropertiesInSignature() {
        this.readLock.lock();
        try {
            Set set = this.delegate.getObjectPropertiesInSignature();
            return set;
        }
        finally {
            this.readLock.unlock();
        }
    }

    public Set<OWLDataProperty> getDataPropertiesInSignature() {
        this.readLock.lock();
        try {
            Set set = this.delegate.getDataPropertiesInSignature();
            return set;
        }
        finally {
            this.readLock.unlock();
        }
    }

    public Set<OWLNamedIndividual> getIndividualsInSignature() {
        this.readLock.lock();
        try {
            Set set = this.delegate.getIndividualsInSignature();
            return set;
        }
        finally {
            this.readLock.unlock();
        }
    }

    public Set<OWLDatatype> getDatatypesInSignature() {
        this.readLock.lock();
        try {
            Set set = this.delegate.getDatatypesInSignature();
            return set;
        }
        finally {
            this.readLock.unlock();
        }
    }

    public Set<OWLAnnotationProperty> getAnnotationPropertiesInSignature() {
        this.readLock.lock();
        try {
            Set set = this.delegate.getAnnotationPropertiesInSignature();
            return set;
        }
        finally {
            this.readLock.unlock();
        }
    }

    public Set<OWLAxiom> getAxioms(Imports imports) {
        this.readLock.lock();
        try {
            Set set = this.delegate.getAxioms(imports);
            return set;
        }
        finally {
            this.readLock.unlock();
        }
    }

    public int getAxiomCount(Imports imports) {
        this.readLock.lock();
        try {
            int n = this.delegate.getAxiomCount(imports);
            return n;
        }
        finally {
            this.readLock.unlock();
        }
    }

    public Set<OWLLogicalAxiom> getLogicalAxioms(Imports imports) {
        this.readLock.lock();
        try {
            Set set = this.delegate.getLogicalAxioms(imports);
            return set;
        }
        finally {
            this.readLock.unlock();
        }
    }

    public int getLogicalAxiomCount(Imports imports) {
        this.readLock.lock();
        try {
            int n = this.delegate.getLogicalAxiomCount(imports);
            return n;
        }
        finally {
            this.readLock.unlock();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public <T extends OWLAxiom> Set<T> getAxioms(AxiomType<T> axiomType, Imports imports) {
        this.readLock.lock();
        try {
            Set set = this.delegate.getAxioms(axiomType, imports);
            return set;
        }
        finally {
            this.readLock.unlock();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public <T extends OWLAxiom> Stream<T> axioms(AxiomType<T> axiomType, Imports imports) {
        this.readLock.lock();
        try {
            Stream stream = this.delegate.axioms(axiomType, imports);
            return stream;
        }
        finally {
            this.readLock.unlock();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public <T extends OWLAxiom> int getAxiomCount(AxiomType<T> axiomType, Imports imports) {
        this.readLock.lock();
        try {
            int n = this.delegate.getAxiomCount(axiomType, imports);
            return n;
        }
        finally {
            this.readLock.unlock();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean containsAxiom(OWLAxiom owlAxiom, Imports imports, AxiomAnnotations axiomAnnotations) {
        this.readLock.lock();
        try {
            boolean bl = this.delegate.containsAxiom(owlAxiom, imports, axiomAnnotations);
            return bl;
        }
        finally {
            this.readLock.unlock();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Set<OWLAxiom> getAxiomsIgnoreAnnotations(OWLAxiom owlAxiom, Imports imports) {
        this.readLock.lock();
        try {
            Set set = this.delegate.getAxiomsIgnoreAnnotations(owlAxiom, imports);
            return set;
        }
        finally {
            this.readLock.unlock();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Stream<OWLAxiom> axiomsIgnoreAnnotations(OWLAxiom owlAxiom, Imports imports) {
        this.readLock.lock();
        try {
            Stream stream = this.delegate.axiomsIgnoreAnnotations(owlAxiom, imports);
            return stream;
        }
        finally {
            this.readLock.unlock();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Set<OWLAxiom> getReferencingAxioms(OWLPrimitive owlPrimitive, Imports imports) {
        this.readLock.lock();
        try {
            Set set = this.delegate.getReferencingAxioms(owlPrimitive, imports);
            return set;
        }
        finally {
            this.readLock.unlock();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Stream<OWLAxiom> referencingAxioms(OWLPrimitive owlPrimitive, Imports imports) {
        this.readLock.lock();
        try {
            Stream stream = this.delegate.referencingAxioms(owlPrimitive, imports);
            return stream;
        }
        finally {
            this.readLock.unlock();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Set<OWLClassAxiom> getAxioms(OWLClass owlClass, Imports imports) {
        this.readLock.lock();
        try {
            Set set = this.delegate.getAxioms(owlClass, imports);
            return set;
        }
        finally {
            this.readLock.unlock();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Set<OWLObjectPropertyAxiom> getAxioms(OWLObjectPropertyExpression owlObjectPropertyExpression, Imports imports) {
        this.readLock.lock();
        try {
            Set set = this.delegate.getAxioms(owlObjectPropertyExpression, imports);
            return set;
        }
        finally {
            this.readLock.unlock();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Set<OWLDataPropertyAxiom> getAxioms(OWLDataProperty owlDataProperty, Imports imports) {
        this.readLock.lock();
        try {
            Set set = this.delegate.getAxioms(owlDataProperty, imports);
            return set;
        }
        finally {
            this.readLock.unlock();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Set<OWLIndividualAxiom> getAxioms(OWLIndividual owlIndividual, Imports imports) {
        this.readLock.lock();
        try {
            Set set = this.delegate.getAxioms(owlIndividual, imports);
            return set;
        }
        finally {
            this.readLock.unlock();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Set<OWLAnnotationAxiom> getAxioms(OWLAnnotationProperty owlAnnotationProperty, Imports imports) {
        this.readLock.lock();
        try {
            Set set = this.delegate.getAxioms(owlAnnotationProperty, imports);
            return set;
        }
        finally {
            this.readLock.unlock();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Set<OWLDatatypeDefinitionAxiom> getAxioms(OWLDatatype owlDatatype, Imports imports) {
        this.readLock.lock();
        try {
            Set set = this.delegate.getAxioms(owlDatatype, imports);
            return set;
        }
        finally {
            this.readLock.unlock();
        }
    }

    public Set<OWLAxiom> getAxioms() {
        this.readLock.lock();
        try {
            Set set = this.delegate.getAxioms();
            return set;
        }
        finally {
            this.readLock.unlock();
        }
    }

    public Stream<OWLAxiom> axioms() {
        this.readLock.lock();
        try {
            Stream stream = this.delegate.axioms();
            return stream;
        }
        finally {
            this.readLock.unlock();
        }
    }

    public Set<OWLLogicalAxiom> getLogicalAxioms() {
        this.readLock.lock();
        try {
            Set set = this.delegate.getLogicalAxioms();
            return set;
        }
        finally {
            this.readLock.unlock();
        }
    }

    public Stream<OWLLogicalAxiom> logicalAxioms() {
        this.readLock.lock();
        try {
            Stream stream = this.delegate.logicalAxioms();
            return stream;
        }
        finally {
            this.readLock.unlock();
        }
    }

    public <T extends OWLAxiom> Set<T> getAxioms(AxiomType<T> axiomType) {
        this.readLock.lock();
        try {
            Set set = this.delegate.getAxioms(axiomType);
            return set;
        }
        finally {
            this.readLock.unlock();
        }
    }

    public <T extends OWLAxiom> Stream<T> axioms(AxiomType<T> axiomType) {
        this.readLock.lock();
        try {
            Stream stream = this.delegate.axioms(axiomType);
            return stream;
        }
        finally {
            this.readLock.unlock();
        }
    }

    public boolean containsAxiom(OWLAxiom owlAxiom) {
        this.readLock.lock();
        try {
            boolean bl = this.delegate.containsAxiom(owlAxiom);
            return bl;
        }
        finally {
            this.readLock.unlock();
        }
    }

    public Set<OWLAxiom> getAxioms(boolean b) {
        this.readLock.lock();
        try {
            Set set = this.delegate.getAxioms(b);
            return set;
        }
        finally {
            this.readLock.unlock();
        }
    }

    public int getAxiomCount(boolean b) {
        this.readLock.lock();
        try {
            int n = this.delegate.getAxiomCount(b);
            return n;
        }
        finally {
            this.readLock.unlock();
        }
    }

    public Set<OWLLogicalAxiom> getLogicalAxioms(boolean b) {
        this.readLock.lock();
        try {
            Set set = this.delegate.getLogicalAxioms(b);
            return set;
        }
        finally {
            this.readLock.unlock();
        }
    }

    public int getLogicalAxiomCount(boolean b) {
        this.readLock.lock();
        try {
            int n = this.delegate.getLogicalAxiomCount(b);
            return n;
        }
        finally {
            this.readLock.unlock();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public <T extends OWLAxiom> Set<T> getAxioms(AxiomType<T> axiomType, boolean b) {
        this.readLock.lock();
        try {
            Set set = this.delegate.getAxioms(axiomType, b);
            return set;
        }
        finally {
            this.readLock.unlock();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public <T extends OWLAxiom> int getAxiomCount(AxiomType<T> axiomType, boolean b) {
        this.readLock.lock();
        try {
            int n = this.delegate.getAxiomCount(axiomType, b);
            return n;
        }
        finally {
            this.readLock.unlock();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean containsAxiom(OWLAxiom owlAxiom, boolean b) {
        this.readLock.lock();
        try {
            boolean bl = this.delegate.containsAxiom(owlAxiom, b);
            return bl;
        }
        finally {
            this.readLock.unlock();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean containsAxiomIgnoreAnnotations(OWLAxiom owlAxiom, boolean b) {
        this.readLock.lock();
        try {
            boolean bl = this.delegate.containsAxiomIgnoreAnnotations(owlAxiom, b);
            return bl;
        }
        finally {
            this.readLock.unlock();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Set<OWLAxiom> getAxiomsIgnoreAnnotations(OWLAxiom owlAxiom, boolean b) {
        this.readLock.lock();
        try {
            Set set = this.delegate.getAxiomsIgnoreAnnotations(owlAxiom, b);
            return set;
        }
        finally {
            this.readLock.unlock();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Set<OWLAxiom> getReferencingAxioms(OWLPrimitive owlPrimitive, boolean b) {
        this.readLock.lock();
        try {
            Set set = this.delegate.getReferencingAxioms(owlPrimitive, b);
            return set;
        }
        finally {
            this.readLock.unlock();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Set<OWLClassAxiom> getAxioms(OWLClass owlClass, boolean b) {
        this.readLock.lock();
        try {
            Set set = this.delegate.getAxioms(owlClass, b);
            return set;
        }
        finally {
            this.readLock.unlock();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Set<OWLObjectPropertyAxiom> getAxioms(OWLObjectPropertyExpression owlObjectPropertyExpression, boolean b) {
        this.readLock.lock();
        try {
            Set set = this.delegate.getAxioms(owlObjectPropertyExpression, b);
            return set;
        }
        finally {
            this.readLock.unlock();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Set<OWLDataPropertyAxiom> getAxioms(OWLDataProperty owlDataProperty, boolean b) {
        this.readLock.lock();
        try {
            Set set = this.delegate.getAxioms(owlDataProperty, b);
            return set;
        }
        finally {
            this.readLock.unlock();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Set<OWLIndividualAxiom> getAxioms(OWLIndividual owlIndividual, boolean b) {
        this.readLock.lock();
        try {
            Set set = this.delegate.getAxioms(owlIndividual, b);
            return set;
        }
        finally {
            this.readLock.unlock();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Set<OWLAnnotationAxiom> getAxioms(OWLAnnotationProperty owlAnnotationProperty, boolean b) {
        this.readLock.lock();
        try {
            Set set = this.delegate.getAxioms(owlAnnotationProperty, b);
            return set;
        }
        finally {
            this.readLock.unlock();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Set<OWLDatatypeDefinitionAxiom> getAxioms(OWLDatatype owlDatatype, boolean b) {
        this.readLock.lock();
        try {
            Set set = this.delegate.getAxioms(owlDatatype, b);
            return set;
        }
        finally {
            this.readLock.unlock();
        }
    }

    public int getAxiomCount() {
        this.readLock.lock();
        try {
            int n = this.delegate.getAxiomCount();
            return n;
        }
        finally {
            this.readLock.unlock();
        }
    }

    public int getLogicalAxiomCount() {
        this.readLock.lock();
        try {
            int n = this.delegate.getLogicalAxiomCount();
            return n;
        }
        finally {
            this.readLock.unlock();
        }
    }

    public <T extends OWLAxiom> int getAxiomCount(AxiomType<T> axiomType) {
        this.readLock.lock();
        try {
            int n = this.delegate.getAxiomCount(axiomType);
            return n;
        }
        finally {
            this.readLock.unlock();
        }
    }

    public boolean containsAxiomIgnoreAnnotations(OWLAxiom owlAxiom) {
        this.readLock.lock();
        try {
            boolean bl = this.delegate.containsAxiomIgnoreAnnotations(owlAxiom);
            return bl;
        }
        finally {
            this.readLock.unlock();
        }
    }

    public Set<OWLAxiom> getAxiomsIgnoreAnnotations(OWLAxiom owlAxiom) {
        this.readLock.lock();
        try {
            Set set = this.delegate.getAxiomsIgnoreAnnotations(owlAxiom);
            return set;
        }
        finally {
            this.readLock.unlock();
        }
    }

    public Stream<OWLAxiom> axiomsIgnoreAnnotations(OWLAxiom owlAxiom) {
        this.readLock.lock();
        try {
            Stream stream = this.delegate.axiomsIgnoreAnnotations(owlAxiom);
            return stream;
        }
        finally {
            this.readLock.unlock();
        }
    }

    public Set<OWLAxiom> getReferencingAxioms(OWLPrimitive owlPrimitive) {
        this.readLock.lock();
        try {
            Set set = this.delegate.getReferencingAxioms(owlPrimitive);
            return set;
        }
        finally {
            this.readLock.unlock();
        }
    }

    public Stream<OWLAxiom> referencingAxioms(OWLPrimitive owlPrimitive) {
        this.readLock.lock();
        try {
            Stream stream = this.delegate.referencingAxioms(owlPrimitive);
            return stream;
        }
        finally {
            this.readLock.unlock();
        }
    }

    public Set<OWLClassAxiom> getAxioms(OWLClass owlClass) {
        this.readLock.lock();
        try {
            Set set = this.delegate.getAxioms(owlClass);
            return set;
        }
        finally {
            this.readLock.unlock();
        }
    }

    public Set<OWLObjectPropertyAxiom> getAxioms(OWLObjectPropertyExpression owlObjectPropertyExpression) {
        this.readLock.lock();
        try {
            Set set = this.delegate.getAxioms(owlObjectPropertyExpression);
            return set;
        }
        finally {
            this.readLock.unlock();
        }
    }

    public Set<OWLDataPropertyAxiom> getAxioms(OWLDataProperty owlDataProperty) {
        this.readLock.lock();
        try {
            Set set = this.delegate.getAxioms(owlDataProperty);
            return set;
        }
        finally {
            this.readLock.unlock();
        }
    }

    public Set<OWLIndividualAxiom> getAxioms(OWLIndividual owlIndividual) {
        this.readLock.lock();
        try {
            Set set = this.delegate.getAxioms(owlIndividual);
            return set;
        }
        finally {
            this.readLock.unlock();
        }
    }

    public Set<OWLAnnotationAxiom> getAxioms(OWLAnnotationProperty owlAnnotationProperty) {
        this.readLock.lock();
        try {
            Set set = this.delegate.getAxioms(owlAnnotationProperty);
            return set;
        }
        finally {
            this.readLock.unlock();
        }
    }

    public Set<OWLDatatypeDefinitionAxiom> getAxioms(OWLDatatype owlDatatype) {
        this.readLock.lock();
        try {
            Set set = this.delegate.getAxioms(owlDatatype);
            return set;
        }
        finally {
            this.readLock.unlock();
        }
    }

    public Stream<OWLClassAxiom> axioms(OWLClass owlClass) {
        this.readLock.lock();
        try {
            Stream stream = this.delegate.axioms(owlClass);
            return stream;
        }
        finally {
            this.readLock.unlock();
        }
    }

    public Stream<OWLObjectPropertyAxiom> axioms(OWLObjectPropertyExpression owlObjectPropertyExpression) {
        this.readLock.lock();
        try {
            Stream stream = this.delegate.axioms(owlObjectPropertyExpression);
            return stream;
        }
        finally {
            this.readLock.unlock();
        }
    }

    public Stream<OWLDataPropertyAxiom> axioms(OWLDataProperty owlDataProperty) {
        this.readLock.lock();
        try {
            Stream stream = this.delegate.axioms(owlDataProperty);
            return stream;
        }
        finally {
            this.readLock.unlock();
        }
    }

    public Stream<OWLIndividualAxiom> axioms(OWLIndividual owlIndividual) {
        this.readLock.lock();
        try {
            Stream stream = this.delegate.axioms(owlIndividual);
            return stream;
        }
        finally {
            this.readLock.unlock();
        }
    }

    public Stream<OWLAnnotationAxiom> axioms(OWLAnnotationProperty owlAnnotationProperty) {
        this.readLock.lock();
        try {
            Stream stream = this.delegate.axioms(owlAnnotationProperty);
            return stream;
        }
        finally {
            this.readLock.unlock();
        }
    }

    public Stream<OWLDatatypeDefinitionAxiom> axioms(OWLDatatype owlDatatype) {
        this.readLock.lock();
        try {
            Stream stream = this.delegate.axioms(owlDatatype);
            return stream;
        }
        finally {
            this.readLock.unlock();
        }
    }

    public Set<OWLClass> getClassesInSignature(Imports imports) {
        this.readLock.lock();
        try {
            Set set = this.delegate.getClassesInSignature(imports);
            return set;
        }
        finally {
            this.readLock.unlock();
        }
    }

    public Set<OWLObjectProperty> getObjectPropertiesInSignature(Imports imports) {
        this.readLock.lock();
        try {
            Set set = this.delegate.getObjectPropertiesInSignature(imports);
            return set;
        }
        finally {
            this.readLock.unlock();
        }
    }

    public Set<OWLDataProperty> getDataPropertiesInSignature(Imports imports) {
        this.readLock.lock();
        try {
            Set set = this.delegate.getDataPropertiesInSignature(imports);
            return set;
        }
        finally {
            this.readLock.unlock();
        }
    }

    public Set<OWLNamedIndividual> getIndividualsInSignature(Imports imports) {
        this.readLock.lock();
        try {
            Set set = this.delegate.getIndividualsInSignature(imports);
            return set;
        }
        finally {
            this.readLock.unlock();
        }
    }

    public Set<OWLAnonymousIndividual> getReferencedAnonymousIndividuals(Imports imports) {
        this.readLock.lock();
        try {
            Set set = this.delegate.getReferencedAnonymousIndividuals(imports);
            return set;
        }
        finally {
            this.readLock.unlock();
        }
    }

    public Stream<OWLAnonymousIndividual> referencedAnonymousIndividuals(Imports imports) {
        this.readLock.lock();
        try {
            Stream stream = this.delegate.referencedAnonymousIndividuals(imports);
            return stream;
        }
        finally {
            this.readLock.unlock();
        }
    }

    public Stream<OWLAnonymousIndividual> referencedAnonymousIndividuals() {
        this.readLock.lock();
        try {
            Stream stream = this.delegate.referencedAnonymousIndividuals();
            return stream;
        }
        finally {
            this.readLock.unlock();
        }
    }

    public Set<OWLDatatype> getDatatypesInSignature(Imports imports) {
        this.readLock.lock();
        try {
            Set set = this.delegate.getDatatypesInSignature(imports);
            return set;
        }
        finally {
            this.readLock.unlock();
        }
    }

    public Set<OWLAnnotationProperty> getAnnotationPropertiesInSignature(Imports imports) {
        this.readLock.lock();
        try {
            Set set = this.delegate.getAnnotationPropertiesInSignature(imports);
            return set;
        }
        finally {
            this.readLock.unlock();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean containsEntityInSignature(OWLEntity owlEntity, Imports imports) {
        this.readLock.lock();
        try {
            boolean bl = this.delegate.containsEntityInSignature(owlEntity, imports);
            return bl;
        }
        finally {
            this.readLock.unlock();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean containsEntityInSignature(IRI iri, Imports imports) {
        this.readLock.lock();
        try {
            boolean bl = this.delegate.containsEntityInSignature(iri, imports);
            return bl;
        }
        finally {
            this.readLock.unlock();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean containsClassInSignature(IRI iri, Imports imports) {
        this.readLock.lock();
        try {
            boolean bl = this.delegate.containsClassInSignature(iri, imports);
            return bl;
        }
        finally {
            this.readLock.unlock();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean containsObjectPropertyInSignature(IRI iri, Imports imports) {
        this.readLock.lock();
        try {
            boolean bl = this.delegate.containsObjectPropertyInSignature(iri, imports);
            return bl;
        }
        finally {
            this.readLock.unlock();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean containsDataPropertyInSignature(IRI iri, Imports imports) {
        this.readLock.lock();
        try {
            boolean bl = this.delegate.containsDataPropertyInSignature(iri, imports);
            return bl;
        }
        finally {
            this.readLock.unlock();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean containsAnnotationPropertyInSignature(IRI iri, Imports imports) {
        this.readLock.lock();
        try {
            boolean bl = this.delegate.containsAnnotationPropertyInSignature(iri, imports);
            return bl;
        }
        finally {
            this.readLock.unlock();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean containsDatatypeInSignature(IRI iri, Imports imports) {
        this.readLock.lock();
        try {
            boolean bl = this.delegate.containsDatatypeInSignature(iri, imports);
            return bl;
        }
        finally {
            this.readLock.unlock();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean containsIndividualInSignature(IRI iri, Imports imports) {
        this.readLock.lock();
        try {
            boolean bl = this.delegate.containsIndividualInSignature(iri, imports);
            return bl;
        }
        finally {
            this.readLock.unlock();
        }
    }

    public boolean containsDatatypeInSignature(IRI iri) {
        this.readLock.lock();
        try {
            boolean bl = this.delegate.containsDatatypeInSignature(iri);
            return bl;
        }
        finally {
            this.readLock.unlock();
        }
    }

    public boolean containsEntityInSignature(IRI iri) {
        this.readLock.lock();
        try {
            boolean bl = this.delegate.containsEntityInSignature(iri);
            return bl;
        }
        finally {
            this.readLock.unlock();
        }
    }

    public boolean containsClassInSignature(IRI iri) {
        this.readLock.lock();
        try {
            boolean bl = this.delegate.containsClassInSignature(iri);
            return bl;
        }
        finally {
            this.readLock.unlock();
        }
    }

    public boolean containsObjectPropertyInSignature(IRI iri) {
        this.readLock.lock();
        try {
            boolean bl = this.delegate.containsObjectPropertyInSignature(iri);
            return bl;
        }
        finally {
            this.readLock.unlock();
        }
    }

    public boolean containsDataPropertyInSignature(IRI iri) {
        this.readLock.lock();
        try {
            boolean bl = this.delegate.containsDataPropertyInSignature(iri);
            return bl;
        }
        finally {
            this.readLock.unlock();
        }
    }

    public boolean containsAnnotationPropertyInSignature(IRI iri) {
        this.readLock.lock();
        try {
            boolean bl = this.delegate.containsAnnotationPropertyInSignature(iri);
            return bl;
        }
        finally {
            this.readLock.unlock();
        }
    }

    public boolean containsIndividualInSignature(IRI iri) {
        this.readLock.lock();
        try {
            boolean bl = this.delegate.containsIndividualInSignature(iri);
            return bl;
        }
        finally {
            this.readLock.unlock();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Set<OWLEntity> getEntitiesInSignature(IRI iri, Imports imports) {
        this.readLock.lock();
        try {
            Set set = this.delegate.getEntitiesInSignature(iri, imports);
            return set;
        }
        finally {
            this.readLock.unlock();
        }
    }

    public Set<IRI> getPunnedIRIs(Imports imports) {
        this.readLock.lock();
        try {
            Set set = this.delegate.getPunnedIRIs(imports);
            return set;
        }
        finally {
            this.readLock.unlock();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean containsReference(OWLEntity owlEntity, Imports imports) {
        this.readLock.lock();
        try {
            boolean bl = this.delegate.containsReference(owlEntity, imports);
            return bl;
        }
        finally {
            this.readLock.unlock();
        }
    }

    public boolean containsReference(OWLEntity owlEntity) {
        this.readLock.lock();
        try {
            boolean bl = this.delegate.containsReference(owlEntity);
            return bl;
        }
        finally {
            this.readLock.unlock();
        }
    }

    public Set<OWLEntity> getEntitiesInSignature(IRI iri) {
        this.readLock.lock();
        try {
            Set set = this.delegate.getEntitiesInSignature(iri);
            return set;
        }
        finally {
            this.readLock.unlock();
        }
    }

    public Stream<OWLEntity> entitiesInSignature(IRI iri) {
        this.readLock.lock();
        try {
            Stream stream = this.delegate.entitiesInSignature(iri);
            return stream;
        }
        finally {
            this.readLock.unlock();
        }
    }

    public Set<OWLClass> getClassesInSignature(boolean b) {
        this.readLock.lock();
        try {
            Set set = this.delegate.getClassesInSignature(b);
            return set;
        }
        finally {
            this.readLock.unlock();
        }
    }

    public Set<OWLObjectProperty> getObjectPropertiesInSignature(boolean b) {
        this.readLock.lock();
        try {
            Set set = this.delegate.getObjectPropertiesInSignature(b);
            return set;
        }
        finally {
            this.readLock.unlock();
        }
    }

    public Set<OWLDataProperty> getDataPropertiesInSignature(boolean b) {
        this.readLock.lock();
        try {
            Set set = this.delegate.getDataPropertiesInSignature(b);
            return set;
        }
        finally {
            this.readLock.unlock();
        }
    }

    public Set<OWLNamedIndividual> getIndividualsInSignature(boolean b) {
        this.readLock.lock();
        try {
            Set set = this.delegate.getIndividualsInSignature(b);
            return set;
        }
        finally {
            this.readLock.unlock();
        }
    }

    public Set<OWLAnonymousIndividual> getReferencedAnonymousIndividuals(boolean b) {
        this.readLock.lock();
        try {
            Set set = this.delegate.getReferencedAnonymousIndividuals(b);
            return set;
        }
        finally {
            this.readLock.unlock();
        }
    }

    public Set<OWLDatatype> getDatatypesInSignature(boolean b) {
        this.readLock.lock();
        try {
            Set set = this.delegate.getDatatypesInSignature(b);
            return set;
        }
        finally {
            this.readLock.unlock();
        }
    }

    public Set<OWLAnnotationProperty> getAnnotationPropertiesInSignature(boolean b) {
        this.readLock.lock();
        try {
            Set set = this.delegate.getAnnotationPropertiesInSignature(b);
            return set;
        }
        finally {
            this.readLock.unlock();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean containsEntityInSignature(OWLEntity owlEntity, boolean b) {
        this.readLock.lock();
        try {
            boolean bl = this.delegate.containsEntityInSignature(owlEntity, b);
            return bl;
        }
        finally {
            this.readLock.unlock();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean containsEntityInSignature(IRI iri, boolean b) {
        this.readLock.lock();
        try {
            boolean bl = this.delegate.containsEntityInSignature(iri, b);
            return bl;
        }
        finally {
            this.readLock.unlock();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean containsClassInSignature(IRI iri, boolean b) {
        this.readLock.lock();
        try {
            boolean bl = this.delegate.containsClassInSignature(iri, b);
            return bl;
        }
        finally {
            this.readLock.unlock();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean containsObjectPropertyInSignature(IRI iri, boolean b) {
        this.readLock.lock();
        try {
            boolean bl = this.delegate.containsObjectPropertyInSignature(iri, b);
            return bl;
        }
        finally {
            this.readLock.unlock();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean containsDataPropertyInSignature(IRI iri, boolean b) {
        this.readLock.lock();
        try {
            boolean bl = this.delegate.containsDataPropertyInSignature(iri, b);
            return bl;
        }
        finally {
            this.readLock.unlock();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean containsAnnotationPropertyInSignature(IRI iri, boolean b) {
        this.readLock.lock();
        try {
            boolean bl = this.delegate.containsAnnotationPropertyInSignature(iri, b);
            return bl;
        }
        finally {
            this.readLock.unlock();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean containsDatatypeInSignature(IRI iri, boolean b) {
        this.readLock.lock();
        try {
            boolean bl = this.delegate.containsDatatypeInSignature(iri, b);
            return bl;
        }
        finally {
            this.readLock.unlock();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean containsIndividualInSignature(IRI iri, boolean b) {
        this.readLock.lock();
        try {
            boolean bl = this.delegate.containsIndividualInSignature(iri, b);
            return bl;
        }
        finally {
            this.readLock.unlock();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Set<OWLEntity> getEntitiesInSignature(IRI iri, boolean b) {
        this.readLock.lock();
        try {
            Set set = this.delegate.getEntitiesInSignature(iri, b);
            return set;
        }
        finally {
            this.readLock.unlock();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean containsReference(OWLEntity owlEntity, boolean b) {
        this.readLock.lock();
        try {
            boolean bl = this.delegate.containsReference(owlEntity, b);
            return bl;
        }
        finally {
            this.readLock.unlock();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public <T extends OWLAxiom> Set<T> getAxioms(Class<T> aClass, OWLObject owlObject, Imports imports, Navigation navigation) {
        this.readLock.lock();
        try {
            Set set = this.delegate.getAxioms(aClass, owlObject, imports, navigation);
            return set;
        }
        finally {
            this.readLock.unlock();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public <T extends OWLAxiom> Stream<T> axioms(Class<T> aClass, OWLObject owlObject, Imports imports, Navigation navigation) {
        this.readLock.lock();
        try {
            Stream stream = this.delegate.axioms(aClass, owlObject, imports, navigation);
            return stream;
        }
        finally {
            this.readLock.unlock();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public <T extends OWLAxiom> Collection<T> filterAxioms(OWLAxiomSearchFilter owlAxiomSearchFilter, Object o, Imports imports) {
        this.readLock.lock();
        try {
            Collection collection = this.delegate.filterAxioms(owlAxiomSearchFilter, o, imports);
            return collection;
        }
        finally {
            this.readLock.unlock();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean contains(OWLAxiomSearchFilter owlAxiomSearchFilter, Object o, Imports imports) {
        this.readLock.lock();
        try {
            boolean bl = this.delegate.contains(owlAxiomSearchFilter, o, imports);
            return bl;
        }
        finally {
            this.readLock.unlock();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean contains(OWLAxiomSearchFilter owlAxiomSearchFilter, Object o) {
        this.readLock.lock();
        try {
            boolean bl = this.delegate.contains(owlAxiomSearchFilter, o);
            return bl;
        }
        finally {
            this.readLock.unlock();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public <T extends OWLAxiom> Set<T> getAxioms(Class<T> aClass, Class<? extends OWLObject> aClass1, OWLObject owlObject, Imports imports, Navigation navigation) {
        this.readLock.lock();
        try {
            Set set = this.delegate.getAxioms(aClass, aClass1, owlObject, imports, navigation);
            return set;
        }
        finally {
            this.readLock.unlock();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public <T extends OWLAxiom> Stream<T> axioms(Class<T> aClass, Class<? extends OWLObject> aClass1, OWLObject owlObject, Imports imports, Navigation navigation) {
        this.readLock.lock();
        try {
            Stream stream = this.delegate.axioms(aClass, aClass1, owlObject, imports, navigation);
            return stream;
        }
        finally {
            this.readLock.unlock();
        }
    }

    public Set<OWLSubAnnotationPropertyOfAxiom> getSubAnnotationPropertyOfAxioms(OWLAnnotationProperty owlAnnotationProperty) {
        this.readLock.lock();
        try {
            Set set = this.delegate.getSubAnnotationPropertyOfAxioms(owlAnnotationProperty);
            return set;
        }
        finally {
            this.readLock.unlock();
        }
    }

    public Set<OWLAnnotationPropertyDomainAxiom> getAnnotationPropertyDomainAxioms(OWLAnnotationProperty owlAnnotationProperty) {
        this.readLock.lock();
        try {
            Set set = this.delegate.getAnnotationPropertyDomainAxioms(owlAnnotationProperty);
            return set;
        }
        finally {
            this.readLock.unlock();
        }
    }

    public Set<OWLAnnotationPropertyRangeAxiom> getAnnotationPropertyRangeAxioms(OWLAnnotationProperty owlAnnotationProperty) {
        this.readLock.lock();
        try {
            Set set = this.delegate.getAnnotationPropertyRangeAxioms(owlAnnotationProperty);
            return set;
        }
        finally {
            this.readLock.unlock();
        }
    }

    public Stream<OWLAnnotationPropertyDomainAxiom> annotationPropertyDomainAxioms(OWLAnnotationProperty owlAnnotationProperty) {
        this.readLock.lock();
        try {
            Stream stream = this.delegate.annotationPropertyDomainAxioms(owlAnnotationProperty);
            return stream;
        }
        finally {
            this.readLock.unlock();
        }
    }

    public Stream<OWLAnnotationPropertyRangeAxiom> annotationPropertyRangeAxioms(OWLAnnotationProperty owlAnnotationProperty) {
        this.readLock.lock();
        try {
            Stream stream = this.delegate.annotationPropertyRangeAxioms(owlAnnotationProperty);
            return stream;
        }
        finally {
            this.readLock.unlock();
        }
    }

    public Set<OWLDeclarationAxiom> getDeclarationAxioms(OWLEntity owlEntity) {
        this.readLock.lock();
        try {
            Set set = this.delegate.getDeclarationAxioms(owlEntity);
            return set;
        }
        finally {
            this.readLock.unlock();
        }
    }

    public Set<OWLAnnotationAssertionAxiom> getAnnotationAssertionAxioms(OWLAnnotationSubject owlAnnotationSubject) {
        this.readLock.lock();
        try {
            Set set = this.delegate.getAnnotationAssertionAxioms(owlAnnotationSubject);
            return set;
        }
        finally {
            this.readLock.unlock();
        }
    }

    public Set<OWLSubClassOfAxiom> getSubClassAxiomsForSubClass(OWLClass owlClass) {
        this.readLock.lock();
        try {
            Set set = this.delegate.getSubClassAxiomsForSubClass(owlClass);
            return set;
        }
        finally {
            this.readLock.unlock();
        }
    }

    public Set<OWLSubClassOfAxiom> getSubClassAxiomsForSuperClass(OWLClass owlClass) {
        this.readLock.lock();
        try {
            Set set = this.delegate.getSubClassAxiomsForSuperClass(owlClass);
            return set;
        }
        finally {
            this.readLock.unlock();
        }
    }

    public Set<OWLEquivalentClassesAxiom> getEquivalentClassesAxioms(OWLClass owlClass) {
        this.readLock.lock();
        try {
            Set set = this.delegate.getEquivalentClassesAxioms(owlClass);
            return set;
        }
        finally {
            this.readLock.unlock();
        }
    }

    public Set<OWLDisjointClassesAxiom> getDisjointClassesAxioms(OWLClass owlClass) {
        this.readLock.lock();
        try {
            Set set = this.delegate.getDisjointClassesAxioms(owlClass);
            return set;
        }
        finally {
            this.readLock.unlock();
        }
    }

    public Set<OWLDisjointUnionAxiom> getDisjointUnionAxioms(OWLClass owlClass) {
        this.readLock.lock();
        try {
            Set set = this.delegate.getDisjointUnionAxioms(owlClass);
            return set;
        }
        finally {
            this.readLock.unlock();
        }
    }

    public Set<OWLHasKeyAxiom> getHasKeyAxioms(OWLClass owlClass) {
        this.readLock.lock();
        try {
            Set set = this.delegate.getHasKeyAxioms(owlClass);
            return set;
        }
        finally {
            this.readLock.unlock();
        }
    }

    public Set<OWLSubObjectPropertyOfAxiom> getObjectSubPropertyAxiomsForSubProperty(OWLObjectPropertyExpression owlObjectPropertyExpression) {
        this.readLock.lock();
        try {
            Set set = this.delegate.getObjectSubPropertyAxiomsForSubProperty(owlObjectPropertyExpression);
            return set;
        }
        finally {
            this.readLock.unlock();
        }
    }

    public Set<OWLSubObjectPropertyOfAxiom> getObjectSubPropertyAxiomsForSuperProperty(OWLObjectPropertyExpression owlObjectPropertyExpression) {
        this.readLock.lock();
        try {
            Set set = this.delegate.getObjectSubPropertyAxiomsForSuperProperty(owlObjectPropertyExpression);
            return set;
        }
        finally {
            this.readLock.unlock();
        }
    }

    public Set<OWLObjectPropertyDomainAxiom> getObjectPropertyDomainAxioms(OWLObjectPropertyExpression owlObjectPropertyExpression) {
        this.readLock.lock();
        try {
            Set set = this.delegate.getObjectPropertyDomainAxioms(owlObjectPropertyExpression);
            return set;
        }
        finally {
            this.readLock.unlock();
        }
    }

    public Set<OWLObjectPropertyRangeAxiom> getObjectPropertyRangeAxioms(OWLObjectPropertyExpression owlObjectPropertyExpression) {
        this.readLock.lock();
        try {
            Set set = this.delegate.getObjectPropertyRangeAxioms(owlObjectPropertyExpression);
            return set;
        }
        finally {
            this.readLock.unlock();
        }
    }

    public Set<OWLInverseObjectPropertiesAxiom> getInverseObjectPropertyAxioms(OWLObjectPropertyExpression owlObjectPropertyExpression) {
        this.readLock.lock();
        try {
            Set set = this.delegate.getInverseObjectPropertyAxioms(owlObjectPropertyExpression);
            return set;
        }
        finally {
            this.readLock.unlock();
        }
    }

    public Set<OWLEquivalentObjectPropertiesAxiom> getEquivalentObjectPropertiesAxioms(OWLObjectPropertyExpression owlObjectPropertyExpression) {
        this.readLock.lock();
        try {
            Set set = this.delegate.getEquivalentObjectPropertiesAxioms(owlObjectPropertyExpression);
            return set;
        }
        finally {
            this.readLock.unlock();
        }
    }

    public Set<OWLDisjointObjectPropertiesAxiom> getDisjointObjectPropertiesAxioms(OWLObjectPropertyExpression owlObjectPropertyExpression) {
        this.readLock.lock();
        try {
            Set set = this.delegate.getDisjointObjectPropertiesAxioms(owlObjectPropertyExpression);
            return set;
        }
        finally {
            this.readLock.unlock();
        }
    }

    public Set<OWLFunctionalObjectPropertyAxiom> getFunctionalObjectPropertyAxioms(OWLObjectPropertyExpression owlObjectPropertyExpression) {
        this.readLock.lock();
        try {
            Set set = this.delegate.getFunctionalObjectPropertyAxioms(owlObjectPropertyExpression);
            return set;
        }
        finally {
            this.readLock.unlock();
        }
    }

    public Set<OWLInverseFunctionalObjectPropertyAxiom> getInverseFunctionalObjectPropertyAxioms(OWLObjectPropertyExpression owlObjectPropertyExpression) {
        this.readLock.lock();
        try {
            Set set = this.delegate.getInverseFunctionalObjectPropertyAxioms(owlObjectPropertyExpression);
            return set;
        }
        finally {
            this.readLock.unlock();
        }
    }

    public Set<OWLSymmetricObjectPropertyAxiom> getSymmetricObjectPropertyAxioms(OWLObjectPropertyExpression owlObjectPropertyExpression) {
        this.readLock.lock();
        try {
            Set set = this.delegate.getSymmetricObjectPropertyAxioms(owlObjectPropertyExpression);
            return set;
        }
        finally {
            this.readLock.unlock();
        }
    }

    public Set<OWLAsymmetricObjectPropertyAxiom> getAsymmetricObjectPropertyAxioms(OWLObjectPropertyExpression owlObjectPropertyExpression) {
        this.readLock.lock();
        try {
            Set set = this.delegate.getAsymmetricObjectPropertyAxioms(owlObjectPropertyExpression);
            return set;
        }
        finally {
            this.readLock.unlock();
        }
    }

    public Set<OWLReflexiveObjectPropertyAxiom> getReflexiveObjectPropertyAxioms(OWLObjectPropertyExpression owlObjectPropertyExpression) {
        this.readLock.lock();
        try {
            Set set = this.delegate.getReflexiveObjectPropertyAxioms(owlObjectPropertyExpression);
            return set;
        }
        finally {
            this.readLock.unlock();
        }
    }

    public Set<OWLIrreflexiveObjectPropertyAxiom> getIrreflexiveObjectPropertyAxioms(OWLObjectPropertyExpression owlObjectPropertyExpression) {
        this.readLock.lock();
        try {
            Set set = this.delegate.getIrreflexiveObjectPropertyAxioms(owlObjectPropertyExpression);
            return set;
        }
        finally {
            this.readLock.unlock();
        }
    }

    public Set<OWLTransitiveObjectPropertyAxiom> getTransitiveObjectPropertyAxioms(OWLObjectPropertyExpression owlObjectPropertyExpression) {
        this.readLock.lock();
        try {
            Set set = this.delegate.getTransitiveObjectPropertyAxioms(owlObjectPropertyExpression);
            return set;
        }
        finally {
            this.readLock.unlock();
        }
    }

    public Set<OWLSubDataPropertyOfAxiom> getDataSubPropertyAxiomsForSubProperty(OWLDataProperty owlDataProperty) {
        this.readLock.lock();
        try {
            Set set = this.delegate.getDataSubPropertyAxiomsForSubProperty(owlDataProperty);
            return set;
        }
        finally {
            this.readLock.unlock();
        }
    }

    public Set<OWLSubDataPropertyOfAxiom> getDataSubPropertyAxiomsForSuperProperty(OWLDataPropertyExpression owlDataPropertyExpression) {
        this.readLock.lock();
        try {
            Set set = this.delegate.getDataSubPropertyAxiomsForSuperProperty(owlDataPropertyExpression);
            return set;
        }
        finally {
            this.readLock.unlock();
        }
    }

    public Set<OWLDataPropertyDomainAxiom> getDataPropertyDomainAxioms(OWLDataProperty owlDataProperty) {
        this.readLock.lock();
        try {
            Set set = this.delegate.getDataPropertyDomainAxioms(owlDataProperty);
            return set;
        }
        finally {
            this.readLock.unlock();
        }
    }

    public Set<OWLDataPropertyRangeAxiom> getDataPropertyRangeAxioms(OWLDataProperty owlDataProperty) {
        this.readLock.lock();
        try {
            Set set = this.delegate.getDataPropertyRangeAxioms(owlDataProperty);
            return set;
        }
        finally {
            this.readLock.unlock();
        }
    }

    public Set<OWLEquivalentDataPropertiesAxiom> getEquivalentDataPropertiesAxioms(OWLDataProperty owlDataProperty) {
        this.readLock.lock();
        try {
            Set set = this.delegate.getEquivalentDataPropertiesAxioms(owlDataProperty);
            return set;
        }
        finally {
            this.readLock.unlock();
        }
    }

    public Set<OWLDisjointDataPropertiesAxiom> getDisjointDataPropertiesAxioms(OWLDataProperty owlDataProperty) {
        this.readLock.lock();
        try {
            Set set = this.delegate.getDisjointDataPropertiesAxioms(owlDataProperty);
            return set;
        }
        finally {
            this.readLock.unlock();
        }
    }

    public Set<OWLFunctionalDataPropertyAxiom> getFunctionalDataPropertyAxioms(OWLDataPropertyExpression owlDataPropertyExpression) {
        this.readLock.lock();
        try {
            Set set = this.delegate.getFunctionalDataPropertyAxioms(owlDataPropertyExpression);
            return set;
        }
        finally {
            this.readLock.unlock();
        }
    }

    public Set<OWLClassAssertionAxiom> getClassAssertionAxioms(OWLIndividual owlIndividual) {
        this.readLock.lock();
        try {
            Set set = this.delegate.getClassAssertionAxioms(owlIndividual);
            return set;
        }
        finally {
            this.readLock.unlock();
        }
    }

    public Set<OWLClassAssertionAxiom> getClassAssertionAxioms(OWLClassExpression owlClassExpression) {
        this.readLock.lock();
        try {
            Set set = this.delegate.getClassAssertionAxioms(owlClassExpression);
            return set;
        }
        finally {
            this.readLock.unlock();
        }
    }

    public Set<OWLDataPropertyAssertionAxiom> getDataPropertyAssertionAxioms(OWLIndividual owlIndividual) {
        this.readLock.lock();
        try {
            Set set = this.delegate.getDataPropertyAssertionAxioms(owlIndividual);
            return set;
        }
        finally {
            this.readLock.unlock();
        }
    }

    public Set<OWLObjectPropertyAssertionAxiom> getObjectPropertyAssertionAxioms(OWLIndividual owlIndividual) {
        this.readLock.lock();
        try {
            Set set = this.delegate.getObjectPropertyAssertionAxioms(owlIndividual);
            return set;
        }
        finally {
            this.readLock.unlock();
        }
    }

    public Set<OWLNegativeObjectPropertyAssertionAxiom> getNegativeObjectPropertyAssertionAxioms(OWLIndividual owlIndividual) {
        this.readLock.lock();
        try {
            Set set = this.delegate.getNegativeObjectPropertyAssertionAxioms(owlIndividual);
            return set;
        }
        finally {
            this.readLock.unlock();
        }
    }

    public Set<OWLNegativeDataPropertyAssertionAxiom> getNegativeDataPropertyAssertionAxioms(OWLIndividual owlIndividual) {
        this.readLock.lock();
        try {
            Set set = this.delegate.getNegativeDataPropertyAssertionAxioms(owlIndividual);
            return set;
        }
        finally {
            this.readLock.unlock();
        }
    }

    public Set<OWLSameIndividualAxiom> getSameIndividualAxioms(OWLIndividual owlIndividual) {
        this.readLock.lock();
        try {
            Set set = this.delegate.getSameIndividualAxioms(owlIndividual);
            return set;
        }
        finally {
            this.readLock.unlock();
        }
    }

    public Set<OWLDifferentIndividualsAxiom> getDifferentIndividualAxioms(OWLIndividual owlIndividual) {
        this.readLock.lock();
        try {
            Set set = this.delegate.getDifferentIndividualAxioms(owlIndividual);
            return set;
        }
        finally {
            this.readLock.unlock();
        }
    }

    public Set<OWLDatatypeDefinitionAxiom> getDatatypeDefinitions(OWLDatatype owlDatatype) {
        this.readLock.lock();
        try {
            Set set = this.delegate.getDatatypeDefinitions(owlDatatype);
            return set;
        }
        finally {
            this.readLock.unlock();
        }
    }

    public ChangeApplied applyChange(OWLOntologyChange owlOntologyChange) {
        this.writeLock.lock();
        try {
            ChangeApplied changeApplied = this.getMutableOntology().applyChange(owlOntologyChange);
            return changeApplied;
        }
        finally {
            this.writeLock.unlock();
        }
    }

    public ChangeApplied applyChanges(List<? extends OWLOntologyChange> list) {
        this.writeLock.lock();
        try {
            ChangeApplied changeApplied = this.getMutableOntology().applyChanges(list);
            return changeApplied;
        }
        finally {
            this.writeLock.unlock();
        }
    }

    public ChangeApplied addAxiom(OWLAxiom owlAxiom) {
        this.writeLock.lock();
        try {
            ChangeApplied changeApplied = this.getMutableOntology().addAxiom(owlAxiom);
            return changeApplied;
        }
        finally {
            this.writeLock.unlock();
        }
    }

    public ChangeApplied addAxioms(Collection<? extends OWLAxiom> set) {
        this.writeLock.lock();
        try {
            ChangeApplied changeApplied = this.getMutableOntology().addAxioms(set);
            return changeApplied;
        }
        finally {
            this.writeLock.unlock();
        }
    }

    public ChangeApplied addAxioms(OWLAxiom ... set) {
        this.writeLock.lock();
        try {
            ChangeApplied changeApplied = this.getMutableOntology().addAxioms(set);
            return changeApplied;
        }
        finally {
            this.writeLock.unlock();
        }
    }

    public ChangeApplied add(OWLAxiom owlAxiom) {
        this.writeLock.lock();
        try {
            ChangeApplied changeApplied = this.getMutableOntology().add(owlAxiom);
            return changeApplied;
        }
        finally {
            this.writeLock.unlock();
        }
    }

    public ChangeApplied add(Collection<? extends OWLAxiom> set) {
        this.writeLock.lock();
        try {
            ChangeApplied changeApplied = this.getMutableOntology().add(set);
            return changeApplied;
        }
        finally {
            this.writeLock.unlock();
        }
    }

    public ChangeApplied add(OWLAxiom ... set) {
        this.writeLock.lock();
        try {
            ChangeApplied changeApplied = this.getMutableOntology().add(set);
            return changeApplied;
        }
        finally {
            this.writeLock.unlock();
        }
    }

    private OWLMutableOntology getMutableOntology() {
        return (OWLMutableOntology)this.delegate;
    }

    public Stream<OWLImportsDeclaration> importsDeclarations() {
        this.readLock.lock();
        try {
            Stream stream = this.delegate.importsDeclarations();
            return stream;
        }
        finally {
            this.readLock.unlock();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public <T extends OWLAxiom> Stream<T> axioms(OWLAxiomSearchFilter filter, Object key, Imports includeImportsClosure) {
        this.readLock.lock();
        try {
            Stream stream = this.delegate.axioms(filter, key, includeImportsClosure);
            return stream;
        }
        finally {
            this.readLock.unlock();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public <T extends OWLAxiom> Stream<T> axioms(OWLAxiomSearchFilter filter, Object key) {
        this.readLock.lock();
        try {
            Stream stream = this.delegate.axioms(filter, key);
            return stream;
        }
        finally {
            this.readLock.unlock();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public <T extends OWLAxiom> Stream<T> axioms(Class<T> type, Class<? extends OWLObject> explicitClass, OWLObject entity, Navigation forSubPosition) {
        this.readLock.lock();
        try {
            Stream stream = this.delegate.axioms(type, explicitClass, entity, forSubPosition);
            return stream;
        }
        finally {
            this.readLock.unlock();
        }
    }

    public Stream<OWLSubAnnotationPropertyOfAxiom> subAnnotationPropertyOfAxioms(OWLAnnotationProperty subProperty) {
        this.readLock.lock();
        try {
            Stream stream = this.delegate.subAnnotationPropertyOfAxioms(subProperty);
            return stream;
        }
        finally {
            this.readLock.unlock();
        }
    }

    public Stream<OWLDatatypeDefinitionAxiom> datatypeDefinitions(OWLDatatype datatype) {
        this.readLock.lock();
        try {
            Stream stream = this.delegate.datatypeDefinitions(datatype);
            return stream;
        }
        finally {
            this.readLock.unlock();
        }
    }

    public ChangeApplied removeAxiom(OWLAxiom axiom) {
        this.writeLock.lock();
        try {
            ChangeApplied changeApplied = this.delegate.removeAxiom(axiom);
            return changeApplied;
        }
        finally {
            this.writeLock.unlock();
        }
    }

    public ChangeApplied removeAxioms(Collection<? extends OWLAxiom> axioms) {
        this.writeLock.lock();
        try {
            ChangeApplied changeApplied = this.delegate.removeAxioms(axioms);
            return changeApplied;
        }
        finally {
            this.writeLock.unlock();
        }
    }

    public ChangeApplied removeAxioms(OWLAxiom ... axioms) {
        this.writeLock.lock();
        try {
            ChangeApplied changeApplied = this.delegate.removeAxioms(axioms);
            return changeApplied;
        }
        finally {
            this.writeLock.unlock();
        }
    }

    public ChangeApplied remove(OWLAxiom axiom) {
        this.writeLock.lock();
        try {
            ChangeApplied changeApplied = this.delegate.remove(axiom);
            return changeApplied;
        }
        finally {
            this.writeLock.unlock();
        }
    }

    public ChangeApplied remove(Collection<? extends OWLAxiom> axioms) {
        this.writeLock.lock();
        try {
            ChangeApplied changeApplied = this.delegate.remove(axioms);
            return changeApplied;
        }
        finally {
            this.writeLock.unlock();
        }
    }

    public ChangeApplied remove(OWLAxiom ... axioms) {
        this.writeLock.lock();
        try {
            ChangeApplied changeApplied = this.delegate.remove(axioms);
            return changeApplied;
        }
        finally {
            this.writeLock.unlock();
        }
    }

    public ChangeApplied applyDirectChange(OWLOntologyChange change) {
        this.writeLock.lock();
        try {
            ChangeApplied changeApplied = this.delegate.applyDirectChange(change);
            return changeApplied;
        }
        finally {
            this.writeLock.unlock();
        }
    }

    public Stream<OWLDisjointObjectPropertiesAxiom> disjointObjectPropertiesAxioms(OWLObjectPropertyExpression property) {
        this.readLock.lock();
        try {
            Stream stream = this.delegate.disjointObjectPropertiesAxioms(property);
            return stream;
        }
        finally {
            this.readLock.unlock();
        }
    }

    public Stream<OWLObjectProperty> objectPropertiesInSignature() {
        this.readLock.lock();
        try {
            Stream stream = this.delegate.objectPropertiesInSignature();
            return stream;
        }
        finally {
            this.readLock.unlock();
        }
    }

    public Stream<OWLAnnotationAssertionAxiom> annotationAssertionAxioms(OWLAnnotationSubject entity) {
        this.readLock.lock();
        try {
            Stream stream = this.delegate.annotationAssertionAxioms(entity);
            return stream;
        }
        finally {
            this.readLock.unlock();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Stream<OWLAnnotationAssertionAxiom> annotationAssertionAxioms(OWLAnnotationSubject entity, Imports imports) {
        this.readLock.lock();
        try {
            Stream stream = this.delegate.annotationAssertionAxioms(entity, imports);
            return stream;
        }
        finally {
            this.readLock.unlock();
        }
    }

    public Stream<OWLAnnotationProperty> annotationPropertiesInSignature() {
        this.readLock.lock();
        try {
            Stream stream = this.delegate.annotationPropertiesInSignature();
            return stream;
        }
        finally {
            this.readLock.unlock();
        }
    }

    public Stream<OWLAnnotationProperty> annotationPropertiesInSignature(Imports imports) {
        this.readLock.lock();
        try {
            Stream stream = this.delegate.annotationPropertiesInSignature(imports);
            return stream;
        }
        finally {
            this.readLock.unlock();
        }
    }

    public Stream<OWLAnnotation> annotations() {
        this.readLock.lock();
        try {
            Stream stream = this.delegate.annotations();
            return stream;
        }
        finally {
            this.readLock.unlock();
        }
    }

    public Stream<OWLAnnotation> annotations(OWLAnnotationProperty p) {
        this.readLock.lock();
        try {
            Stream stream = this.delegate.annotations(p);
            return stream;
        }
        finally {
            this.readLock.unlock();
        }
    }

    public Stream<OWLAnnotation> annotations(Predicate<OWLAnnotation> p) {
        this.readLock.lock();
        try {
            Stream stream = this.delegate.annotations(p);
            return stream;
        }
        finally {
            this.readLock.unlock();
        }
    }

    public Stream<OWLAnonymousIndividual> anonymousIndividuals() {
        this.readLock.lock();
        try {
            Stream stream = this.delegate.anonymousIndividuals();
            return stream;
        }
        finally {
            this.readLock.unlock();
        }
    }

    public Stream<OWLAsymmetricObjectPropertyAxiom> asymmetricObjectPropertyAxioms(OWLObjectPropertyExpression property) {
        this.readLock.lock();
        try {
            Stream stream = this.delegate.asymmetricObjectPropertyAxioms(property);
            return stream;
        }
        finally {
            this.readLock.unlock();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public <T extends OWLAxiom> Stream<T> axioms(Class<T> type, OWLObject entity, Navigation forSubPosition) {
        this.readLock.lock();
        try {
            Stream stream = this.delegate.axioms(type, entity, forSubPosition);
            return stream;
        }
        finally {
            this.readLock.unlock();
        }
    }

    public Stream<OWLAxiom> axioms(Imports imports) {
        this.readLock.lock();
        try {
            Stream stream = this.delegate.axioms(imports);
            return stream;
        }
        finally {
            this.readLock.unlock();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Stream<OWLAnnotationAxiom> axioms(OWLAnnotationProperty property, Imports imports) {
        this.readLock.lock();
        try {
            Stream stream = this.delegate.axioms(property, imports);
            return stream;
        }
        finally {
            this.readLock.unlock();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Stream<OWLClassAxiom> axioms(OWLClass cls, Imports imports) {
        this.readLock.lock();
        try {
            Stream stream = this.delegate.axioms(cls, imports);
            return stream;
        }
        finally {
            this.readLock.unlock();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Stream<OWLDataPropertyAxiom> axioms(OWLDataProperty property, Imports imports) {
        this.readLock.lock();
        try {
            Stream stream = this.delegate.axioms(property, imports);
            return stream;
        }
        finally {
            this.readLock.unlock();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Stream<OWLDatatypeDefinitionAxiom> axioms(OWLDatatype datatype, Imports imports) {
        this.readLock.lock();
        try {
            Stream stream = this.delegate.axioms(datatype, imports);
            return stream;
        }
        finally {
            this.readLock.unlock();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Stream<OWLIndividualAxiom> axioms(OWLIndividual individual, Imports imports) {
        this.readLock.lock();
        try {
            Stream stream = this.delegate.axioms(individual, imports);
            return stream;
        }
        finally {
            this.readLock.unlock();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Stream<OWLObjectPropertyAxiom> axioms(OWLObjectPropertyExpression property, Imports imports) {
        this.readLock.lock();
        try {
            Stream stream = this.delegate.axioms(property, imports);
            return stream;
        }
        finally {
            this.readLock.unlock();
        }
    }

    public Stream<OWLClassAssertionAxiom> classAssertionAxioms(OWLClassExpression ce) {
        this.readLock.lock();
        try {
            Stream stream = this.delegate.classAssertionAxioms(ce);
            return stream;
        }
        finally {
            this.readLock.unlock();
        }
    }

    public Stream<OWLClassAssertionAxiom> classAssertionAxioms(OWLIndividual individual) {
        this.readLock.lock();
        try {
            Stream stream = this.delegate.classAssertionAxioms(individual);
            return stream;
        }
        finally {
            this.readLock.unlock();
        }
    }

    public Stream<OWLClass> classesInSignature() {
        this.readLock.lock();
        try {
            Stream stream = this.delegate.classesInSignature();
            return stream;
        }
        finally {
            this.readLock.unlock();
        }
    }

    public Stream<OWLClass> classesInSignature(Imports imports) {
        this.readLock.lock();
        try {
            Stream stream = this.delegate.classesInSignature(imports);
            return stream;
        }
        finally {
            this.readLock.unlock();
        }
    }

    public Stream<OWLDataProperty> dataPropertiesInSignature() {
        this.readLock.lock();
        try {
            Stream stream = this.delegate.dataPropertiesInSignature();
            return stream;
        }
        finally {
            this.readLock.unlock();
        }
    }

    public Stream<OWLDataProperty> dataPropertiesInSignature(Imports imports) {
        this.readLock.lock();
        try {
            Stream stream = this.delegate.dataPropertiesInSignature(imports);
            return stream;
        }
        finally {
            this.readLock.unlock();
        }
    }

    public Stream<OWLDataPropertyAssertionAxiom> dataPropertyAssertionAxioms(OWLIndividual individual) {
        this.readLock.lock();
        try {
            Stream stream = this.delegate.dataPropertyAssertionAxioms(individual);
            return stream;
        }
        finally {
            this.readLock.unlock();
        }
    }

    public Stream<OWLDataPropertyDomainAxiom> dataPropertyDomainAxioms(OWLDataProperty property) {
        this.readLock.lock();
        try {
            Stream stream = this.delegate.dataPropertyDomainAxioms(property);
            return stream;
        }
        finally {
            this.readLock.unlock();
        }
    }

    public Stream<OWLDataPropertyRangeAxiom> dataPropertyRangeAxioms(OWLDataProperty property) {
        this.readLock.lock();
        try {
            Stream stream = this.delegate.dataPropertyRangeAxioms(property);
            return stream;
        }
        finally {
            this.readLock.unlock();
        }
    }

    public Stream<OWLSubDataPropertyOfAxiom> dataSubPropertyAxiomsForSubProperty(OWLDataProperty subProperty) {
        this.readLock.lock();
        try {
            Stream stream = this.delegate.dataSubPropertyAxiomsForSubProperty(subProperty);
            return stream;
        }
        finally {
            this.readLock.unlock();
        }
    }

    public Stream<OWLSubDataPropertyOfAxiom> dataSubPropertyAxiomsForSuperProperty(OWLDataPropertyExpression superProperty) {
        this.readLock.lock();
        try {
            Stream stream = this.delegate.dataSubPropertyAxiomsForSuperProperty(superProperty);
            return stream;
        }
        finally {
            this.readLock.unlock();
        }
    }

    public Stream<OWLDatatype> datatypesInSignature() {
        this.readLock.lock();
        try {
            Stream stream = this.delegate.datatypesInSignature();
            return stream;
        }
        finally {
            this.readLock.unlock();
        }
    }

    public Stream<OWLDatatype> datatypesInSignature(Imports imports) {
        this.readLock.lock();
        try {
            Stream stream = this.delegate.datatypesInSignature(imports);
            return stream;
        }
        finally {
            this.readLock.unlock();
        }
    }

    public Stream<OWLDeclarationAxiom> declarationAxioms(OWLEntity subject) {
        this.readLock.lock();
        try {
            Stream stream = this.delegate.declarationAxioms(subject);
            return stream;
        }
        finally {
            this.readLock.unlock();
        }
    }

    public Stream<OWLDifferentIndividualsAxiom> differentIndividualAxioms(OWLIndividual individual) {
        this.readLock.lock();
        try {
            Stream stream = this.delegate.differentIndividualAxioms(individual);
            return stream;
        }
        finally {
            this.readLock.unlock();
        }
    }

    public Stream<OWLDisjointClassesAxiom> disjointClassesAxioms(OWLClass cls) {
        this.readLock.lock();
        try {
            Stream stream = this.delegate.disjointClassesAxioms(cls);
            return stream;
        }
        finally {
            this.readLock.unlock();
        }
    }

    public Stream<OWLDisjointDataPropertiesAxiom> disjointDataPropertiesAxioms(OWLDataProperty property) {
        this.readLock.lock();
        try {
            Stream stream = this.delegate.disjointDataPropertiesAxioms(property);
            return stream;
        }
        finally {
            this.readLock.unlock();
        }
    }

    public Stream<OWLDisjointUnionAxiom> disjointUnionAxioms(OWLClass owlClass) {
        this.readLock.lock();
        try {
            Stream stream = this.delegate.disjointUnionAxioms(owlClass);
            return stream;
        }
        finally {
            this.readLock.unlock();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Stream<OWLEntity> entitiesInSignature(IRI iri, Imports imports) {
        this.readLock.lock();
        try {
            Stream stream = this.delegate.entitiesInSignature(iri, imports);
            return stream;
        }
        finally {
            this.readLock.unlock();
        }
    }

    public Stream<OWLEquivalentClassesAxiom> equivalentClassesAxioms(OWLClass cls) {
        this.readLock.lock();
        try {
            Stream stream = this.delegate.equivalentClassesAxioms(cls);
            return stream;
        }
        finally {
            this.readLock.unlock();
        }
    }

    public Stream<OWLEquivalentDataPropertiesAxiom> equivalentDataPropertiesAxioms(OWLDataProperty property) {
        this.readLock.lock();
        try {
            Stream stream = this.delegate.equivalentDataPropertiesAxioms(property);
            return stream;
        }
        finally {
            this.readLock.unlock();
        }
    }

    public Stream<OWLEquivalentObjectPropertiesAxiom> equivalentObjectPropertiesAxioms(OWLObjectPropertyExpression property) {
        this.readLock.lock();
        try {
            Stream stream = this.delegate.equivalentObjectPropertiesAxioms(property);
            return stream;
        }
        finally {
            this.readLock.unlock();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public <T extends OWLAxiom> Collection<T> filterAxioms(OWLAxiomSearchFilter filter, Object key) {
        this.readLock.lock();
        try {
            Collection collection = this.delegate.filterAxioms(filter, key);
            return collection;
        }
        finally {
            this.readLock.unlock();
        }
    }

    public Stream<OWLFunctionalDataPropertyAxiom> functionalDataPropertyAxioms(OWLDataPropertyExpression property) {
        this.readLock.lock();
        try {
            Stream stream = this.delegate.functionalDataPropertyAxioms(property);
            return stream;
        }
        finally {
            this.readLock.unlock();
        }
    }

    public Stream<OWLFunctionalObjectPropertyAxiom> functionalObjectPropertyAxioms(OWLObjectPropertyExpression property) {
        this.readLock.lock();
        try {
            Stream stream = this.delegate.functionalObjectPropertyAxioms(property);
            return stream;
        }
        finally {
            this.readLock.unlock();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Set<OWLAnnotationAssertionAxiom> getAnnotationAssertionAxioms(OWLAnnotationSubject entity, Imports imports) {
        this.readLock.lock();
        try {
            Set set = this.delegate.getAnnotationAssertionAxioms(entity, imports);
            return set;
        }
        finally {
            this.readLock.unlock();
        }
    }

    public Set<OWLAnnotation> getAnnotations(OWLAnnotationProperty annotationProperty) {
        this.readLock.lock();
        try {
            Set set = this.delegate.getAnnotations(annotationProperty);
            return set;
        }
        finally {
            this.readLock.unlock();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public <T extends OWLAxiom> Set<T> getAxioms(Class<T> type, Class<? extends OWLObject> explicitClass, OWLObject entity, Navigation forSubPosition) {
        this.readLock.lock();
        try {
            Set set = this.delegate.getAxioms(type, explicitClass, entity, forSubPosition);
            return set;
        }
        finally {
            this.readLock.unlock();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public <T extends OWLAxiom> Set<T> getAxioms(Class<T> type, OWLObject entity, Navigation forSubPosition) {
        this.readLock.lock();
        try {
            Set set = this.delegate.getAxioms(type, entity, forSubPosition);
            return set;
        }
        finally {
            this.readLock.unlock();
        }
    }

    @Nullable
    public OWLDocumentFormat getFormat() {
        this.readLock.lock();
        try {
            OWLDocumentFormat oWLDocumentFormat = this.delegate.getFormat();
            return oWLDocumentFormat;
        }
        finally {
            this.readLock.unlock();
        }
    }

    public Set<OWLAnonymousIndividual> getReferencedAnonymousIndividuals() {
        this.readLock.lock();
        try {
            Set set = this.delegate.getReferencedAnonymousIndividuals();
            return set;
        }
        finally {
            this.readLock.unlock();
        }
    }

    public Stream<OWLHasKeyAxiom> hasKeyAxioms(OWLClass cls) {
        this.readLock.lock();
        try {
            Stream stream = this.delegate.hasKeyAxioms(cls);
            return stream;
        }
        finally {
            this.readLock.unlock();
        }
    }

    public Stream<OWLNamedIndividual> individualsInSignature() {
        this.readLock.lock();
        try {
            Stream stream = this.delegate.individualsInSignature();
            return stream;
        }
        finally {
            this.readLock.unlock();
        }
    }

    public Stream<OWLNamedIndividual> individualsInSignature(Imports imports) {
        this.readLock.lock();
        try {
            Stream stream = this.delegate.individualsInSignature(imports);
            return stream;
        }
        finally {
            this.readLock.unlock();
        }
    }

    public Stream<OWLInverseFunctionalObjectPropertyAxiom> inverseFunctionalObjectPropertyAxioms(OWLObjectPropertyExpression property) {
        this.readLock.lock();
        try {
            Stream stream = this.delegate.inverseFunctionalObjectPropertyAxioms(property);
            return stream;
        }
        finally {
            this.readLock.unlock();
        }
    }

    public Stream<OWLInverseObjectPropertiesAxiom> inverseObjectPropertyAxioms(OWLObjectPropertyExpression property) {
        this.readLock.lock();
        try {
            Stream stream = this.delegate.inverseObjectPropertyAxioms(property);
            return stream;
        }
        finally {
            this.readLock.unlock();
        }
    }

    public Stream<OWLIrreflexiveObjectPropertyAxiom> irreflexiveObjectPropertyAxioms(OWLObjectPropertyExpression property) {
        this.readLock.lock();
        try {
            Stream stream = this.delegate.irreflexiveObjectPropertyAxioms(property);
            return stream;
        }
        finally {
            this.readLock.unlock();
        }
    }

    public Stream<OWLLogicalAxiom> logicalAxioms(Imports imports) {
        this.readLock.lock();
        try {
            Stream stream = this.delegate.logicalAxioms(imports);
            return stream;
        }
        finally {
            this.readLock.unlock();
        }
    }

    public Stream<OWLNegativeDataPropertyAssertionAxiom> negativeDataPropertyAssertionAxioms(OWLIndividual individual) {
        this.readLock.lock();
        try {
            Stream stream = this.delegate.negativeDataPropertyAssertionAxioms(individual);
            return stream;
        }
        finally {
            this.readLock.unlock();
        }
    }

    public Stream<OWLNegativeObjectPropertyAssertionAxiom> negativeObjectPropertyAssertionAxioms(OWLIndividual individual) {
        this.readLock.lock();
        try {
            Stream stream = this.delegate.negativeObjectPropertyAssertionAxioms(individual);
            return stream;
        }
        finally {
            this.readLock.unlock();
        }
    }

    public Stream<OWLClassExpression> nestedClassExpressions() {
        this.readLock.lock();
        try {
            Stream stream = this.delegate.nestedClassExpressions();
            return stream;
        }
        finally {
            this.readLock.unlock();
        }
    }

    public Stream<OWLObjectProperty> objectPropertiesInSignature(Imports imports) {
        this.readLock.lock();
        try {
            Stream stream = this.delegate.objectPropertiesInSignature(imports);
            return stream;
        }
        finally {
            this.readLock.unlock();
        }
    }

    public Stream<OWLObjectPropertyAssertionAxiom> objectPropertyAssertionAxioms(OWLIndividual individual) {
        this.readLock.lock();
        try {
            Stream stream = this.delegate.objectPropertyAssertionAxioms(individual);
            return stream;
        }
        finally {
            this.readLock.unlock();
        }
    }

    public Stream<OWLObjectPropertyDomainAxiom> objectPropertyDomainAxioms(OWLObjectPropertyExpression property) {
        this.readLock.lock();
        try {
            Stream stream = this.delegate.objectPropertyDomainAxioms(property);
            return stream;
        }
        finally {
            this.readLock.unlock();
        }
    }

    public Stream<OWLObjectPropertyRangeAxiom> objectPropertyRangeAxioms(OWLObjectPropertyExpression property) {
        this.readLock.lock();
        try {
            Stream stream = this.delegate.objectPropertyRangeAxioms(property);
            return stream;
        }
        finally {
            this.readLock.unlock();
        }
    }

    public Stream<OWLSubObjectPropertyOfAxiom> objectSubPropertyAxiomsForSubProperty(OWLObjectPropertyExpression subProperty) {
        this.readLock.lock();
        try {
            Stream stream = this.delegate.objectSubPropertyAxiomsForSubProperty(subProperty);
            return stream;
        }
        finally {
            this.readLock.unlock();
        }
    }

    public Stream<OWLSubObjectPropertyOfAxiom> objectSubPropertyAxiomsForSuperProperty(OWLObjectPropertyExpression superProperty) {
        this.readLock.lock();
        try {
            Stream stream = this.delegate.objectSubPropertyAxiomsForSuperProperty(superProperty);
            return stream;
        }
        finally {
            this.readLock.unlock();
        }
    }

    public Stream<OWLReflexiveObjectPropertyAxiom> reflexiveObjectPropertyAxioms(OWLObjectPropertyExpression property) {
        this.readLock.lock();
        try {
            Stream stream = this.delegate.reflexiveObjectPropertyAxioms(property);
            return stream;
        }
        finally {
            this.readLock.unlock();
        }
    }

    public Stream<OWLSameIndividualAxiom> sameIndividualAxioms(OWLIndividual individual) {
        this.readLock.lock();
        try {
            Stream stream = this.delegate.sameIndividualAxioms(individual);
            return stream;
        }
        finally {
            this.readLock.unlock();
        }
    }

    public Stream<OWLSubClassOfAxiom> subClassAxiomsForSubClass(OWLClass cls) {
        this.readLock.lock();
        try {
            Stream stream = this.delegate.subClassAxiomsForSubClass(cls);
            return stream;
        }
        finally {
            this.readLock.unlock();
        }
    }

    public Stream<OWLSubClassOfAxiom> subClassAxiomsForSuperClass(OWLClass cls) {
        this.readLock.lock();
        try {
            Stream stream = this.delegate.subClassAxiomsForSuperClass(cls);
            return stream;
        }
        finally {
            this.readLock.unlock();
        }
    }

    public Stream<OWLSymmetricObjectPropertyAxiom> symmetricObjectPropertyAxioms(OWLObjectPropertyExpression property) {
        this.readLock.lock();
        try {
            Stream stream = this.delegate.symmetricObjectPropertyAxioms(property);
            return stream;
        }
        finally {
            this.readLock.unlock();
        }
    }

    public Stream<OWLTransitiveObjectPropertyAxiom> transitiveObjectPropertyAxioms(OWLObjectPropertyExpression property) {
        this.readLock.lock();
        try {
            Stream stream = this.delegate.transitiveObjectPropertyAxioms(property);
            return stream;
        }
        finally {
            this.readLock.unlock();
        }
    }
}

