/*
 * Decompiled with CFR 0.152.
 */
package org.semanticweb.owlapi.reasoner.impl;

import java.util.Collection;
import java.util.HashSet;
import java.util.Iterator;
import java.util.Optional;
import java.util.Set;
import java.util.stream.Stream;
import javax.annotation.Nullable;
import org.semanticweb.owlapi.model.OWLClass;
import org.semanticweb.owlapi.model.OWLDataFactory;
import org.semanticweb.owlapi.model.OWLDataProperty;
import org.semanticweb.owlapi.model.OWLDatatype;
import org.semanticweb.owlapi.model.OWLObject;
import org.semanticweb.owlapi.model.OWLObjectProperty;
import org.semanticweb.owlapi.model.OWLObjectPropertyExpression;
import org.semanticweb.owlapi.reasoner.Node;
import org.semanticweb.owlapi.reasoner.impl.OWLClassNode;
import org.semanticweb.owlapi.reasoner.impl.OWLDataPropertyNode;
import org.semanticweb.owlapi.reasoner.impl.OWLObjectPropertyNode;
import org.semanticweb.owlapi.util.OWLAPIPreconditions;
import org.semanticweb.owlapi.util.OWLAPIStreamUtils;
import uk.ac.manchester.cs.owl.owlapi.OWLDataFactoryImpl;

public abstract class DefaultNode<E extends OWLObject>
implements Node<E> {
    private static final OWLDataFactory DF = new OWLDataFactoryImpl(false);
    protected static final OWLClass TOP_CLASS = DF.getOWLThing();
    protected static final OWLClassNode TOP_NODE = new OWLClassNode(TOP_CLASS);
    protected static final OWLClass BOTTOM_CLASS = DF.getOWLNothing();
    protected static final OWLClassNode BOTTOM_NODE = new OWLClassNode(BOTTOM_CLASS);
    protected static final OWLDataProperty TOP_DATA_PROPERTY = DF.getOWLTopDataProperty();
    protected static final OWLDataPropertyNode TOP_DATA_NODE = new OWLDataPropertyNode(TOP_DATA_PROPERTY);
    protected static final OWLDataProperty BOTTOM_DATA_PROPERTY = DF.getOWLBottomDataProperty();
    protected static final OWLDataPropertyNode BOTTOM_DATA_NODE = new OWLDataPropertyNode(BOTTOM_DATA_PROPERTY);
    protected static final OWLDatatype TOP_DATATYPE = DF.getTopDatatype();
    protected static final OWLObjectProperty TOP_OBJECT_PROPERTY = DF.getOWLTopObjectProperty();
    protected static final OWLObjectPropertyNode TOP_OBJECT_NODE = new OWLObjectPropertyNode((OWLObjectPropertyExpression)TOP_OBJECT_PROPERTY);
    protected static final OWLObjectProperty BOTTOM_OBJECT_PROPERTY = DF.getOWLBottomObjectProperty();
    protected static final OWLObjectPropertyNode BOTTOM_OBJECT_NODE = new OWLObjectPropertyNode((OWLObjectPropertyExpression)BOTTOM_OBJECT_PROPERTY);
    private final Set<E> entities = new HashSet(4);

    public DefaultNode(E entity) {
        this.entities.add(OWLAPIPreconditions.checkNotNull(entity, (String)"entity cannot be null"));
    }

    public DefaultNode(Collection<E> entities) {
        this.entities.addAll((Collection)OWLAPIPreconditions.checkNotNull(entities, (String)"entities cannot be null"));
    }

    public DefaultNode(Stream<E> entities) {
        OWLAPIStreamUtils.add(this.entities, (Stream)((Stream)OWLAPIPreconditions.checkNotNull(entities, (String)"entities cannot be null")));
    }

    protected DefaultNode() {
    }

    protected abstract Optional<E> getTopEntity();

    protected abstract Optional<E> getBottomEntity();

    public void add(E entity) {
        this.entities.add(entity);
    }

    public boolean isTopNode() {
        if (!this.getTopEntity().isPresent()) {
            return false;
        }
        return this.entities.contains(this.getTopEntity().get());
    }

    public boolean isBottomNode() {
        if (!this.getBottomEntity().isPresent()) {
            return false;
        }
        return this.entities.contains(this.getBottomEntity().get());
    }

    public Stream<E> entities() {
        return this.entities.stream();
    }

    public int getSize() {
        return this.entities.size();
    }

    public boolean contains(E entity) {
        return this.entities.contains(entity);
    }

    public Set<E> getEntitiesMinus(E e) {
        return OWLAPIStreamUtils.asUnorderedSet(this.entities.stream().filter(i -> !i.equals(e)));
    }

    public Set<E> getEntitiesMinusTop() {
        Optional<E> topEntity = this.getTopEntity();
        if (topEntity.isPresent()) {
            return this.getEntitiesMinus((OWLObject)topEntity.get());
        }
        return OWLAPIStreamUtils.asUnorderedSet(this.entities.stream());
    }

    public Set<E> getEntitiesMinusBottom() {
        Optional<E> bottomEntity = this.getBottomEntity();
        if (bottomEntity.isPresent()) {
            return this.getEntitiesMinus((OWLObject)bottomEntity.get());
        }
        return OWLAPIStreamUtils.asUnorderedSet(this.entities.stream());
    }

    public boolean isSingleton() {
        return this.entities.size() == 1;
    }

    public E getRepresentativeElement() {
        return (E)((OWLObject)this.entities.iterator().next());
    }

    public Iterator<E> iterator() {
        return this.entities.iterator();
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("Node( ");
        for (OWLObject entity : this.entities) {
            sb.append(entity);
            sb.append(' ');
        }
        sb.append(')');
        return (String)OWLAPIPreconditions.verifyNotNull((Object)sb.toString());
    }

    public boolean equals(@Nullable Object obj) {
        if (obj == null) {
            return false;
        }
        if (obj == this) {
            return true;
        }
        if (!(obj instanceof Node)) {
            return false;
        }
        Node other = (Node)obj;
        return this.entities.equals(OWLAPIStreamUtils.asUnorderedSet((Stream)other.entities()));
    }

    public int hashCode() {
        return this.entities.hashCode();
    }
}

