/*
 * Decompiled with CFR 0.152.
 */
package uk.ac.manchester.cs.owl.owlapi;

import java.util.Collection;
import java.util.Collections;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Set;
import java.util.stream.Stream;
import org.semanticweb.owlapi.model.OWLAnnotation;
import org.semanticweb.owlapi.model.OWLClassExpression;
import org.semanticweb.owlapi.model.OWLNaryClassAxiom;
import org.semanticweb.owlapi.util.OWLAPIPreconditions;
import org.semanticweb.owlapi.util.OWLAPIStreamUtils;
import uk.ac.manchester.cs.owl.owlapi.OWLClassAxiomImpl;

public abstract class OWLNaryClassAxiomImpl
extends OWLClassAxiomImpl
implements OWLNaryClassAxiom {
    protected final List<OWLClassExpression> classExpressions;

    public OWLNaryClassAxiomImpl(List<OWLClassExpression> classExpressions, Collection<OWLAnnotation> annotations) {
        super(annotations);
        this.classExpressions = Collections.unmodifiableList(OWLAPIPreconditions.checkValidForNAryExpressions(classExpressions, "classExpressions cannot be null or empty"));
    }

    @Override
    public Stream<OWLClassExpression> classExpressions() {
        return OWLAPIStreamUtils.streamFromSorted(this.classExpressions);
    }

    @Override
    public List<OWLClassExpression> getOperandsAsList() {
        return this.classExpressions;
    }

    @Override
    public boolean contains(OWLClassExpression ce) {
        return this.classExpressions.contains(ce);
    }

    @Override
    public Set<OWLClassExpression> getClassExpressionsMinus(OWLClassExpression ... desc) {
        LinkedHashSet<OWLClassExpression> result = new LinkedHashSet<OWLClassExpression>(this.classExpressions);
        for (OWLClassExpression d : desc) {
            result.remove(d);
        }
        return result;
    }
}

