/*
 * Decompiled with CFR 0.152.
 */
package org.semanticweb.owlapitools.decomposition;

import java.util.ArrayList;
import java.util.Collection;
import java.util.HashSet;
import java.util.List;
import java.util.Optional;
import java.util.Set;
import java.util.stream.Stream;
import javax.annotation.Nullable;
import org.semanticweb.owlapi.model.OWLAxiom;
import org.semanticweb.owlapi.model.OWLEntity;
import org.semanticweb.owlapi.util.OWLAPIPreconditions;
import org.semanticweb.owlapitools.decomposition.AtomList;
import org.semanticweb.owlapitools.decomposition.AxiomWrapper;
import org.semanticweb.owlapitools.decomposition.LocalityChecker;
import org.semanticweb.owlapitools.decomposition.Modularizer;
import org.semanticweb.owlapitools.decomposition.OntologyAtom;
import org.semanticweb.owlapitools.decomposition.Signature;
import uk.ac.manchester.cs.owlapi.modularity.ModuleType;

public class Decomposer {
    @Nullable
    private AtomList atomList = null;
    private final Modularizer modularizer;
    private final List<AxiomWrapper> tautologies = new ArrayList<AxiomWrapper>();
    @Nullable
    private OntologyAtom rootAtom = null;
    private ModuleType type;
    private final List<AxiomWrapper> axioms;

    public Decomposer(List<AxiomWrapper> axioms, LocalityChecker c) {
        this.axioms = axioms;
        this.modularizer = Decomposer.buildModulariser(axioms, c);
    }

    public static Modularizer buildModulariser(List<AxiomWrapper> axioms, LocalityChecker c) {
        Modularizer m = new Modularizer(c);
        m.preprocessOntology(axioms);
        return m;
    }

    public Modularizer getModularizer() {
        return this.modularizer;
    }

    private void restoreTautologies() {
        for (AxiomWrapper p : this.tautologies) {
            p.setUsed(true);
        }
    }

    private void removeTautologies() {
        this.tautologies.clear();
        for (AxiomWrapper p : this.axioms) {
            if (!p.isUsed()) continue;
            this.modularizer.extract(p, new Signature(p.getAxiom().signature()), this.type);
            if (!this.modularizer.isTautology(p.getAxiom(), this.type)) continue;
            this.tautologies.add(p);
            p.setUsed(false);
        }
    }

    public List<AxiomWrapper> getTautologies() {
        return this.tautologies;
    }

    private Optional<OntologyAtom> buildModule(Signature sig, OntologyAtom parent) {
        this.modularizer.extract(parent.getModule(), sig, this.type);
        Collection<AxiomWrapper> module = this.modularizer.getModule();
        if (module.isEmpty()) {
            return Optional.empty();
        }
        if (parent != this.rootAtom && module.size() == parent.getModule().size()) {
            return Optional.of(parent);
        }
        assert (this.atomList != null);
        OntologyAtom atom = this.atomList.newAtom();
        atom.setModule(module);
        return Optional.of(atom);
    }

    private OntologyAtom createAtom(AxiomWrapper ax, OntologyAtom parent) {
        Optional<OntologyAtom> atom = ax.getAtom();
        if (atom.isPresent()) {
            return atom.get();
        }
        atom = this.buildModule(new Signature(ax.getAxiom().signature()), parent);
        assert (atom.isPresent());
        atom.get().addAxiom(ax);
        if (atom.get() == parent) {
            return parent;
        }
        for (AxiomWrapper q : atom.get().getModule()) {
            if (q.equals(ax)) continue;
            atom.get().addDepAtom(this.createAtom(q, atom.get()));
        }
        return atom.get();
    }

    public AtomList getAOS() {
        return OWLAPIPreconditions.verifyNotNull(this.atomList);
    }

    public AtomList getAOS(ModuleType t) {
        this.type = t;
        this.atomList = new AtomList();
        this.modularizer.preprocessOntology(this.axioms);
        this.removeTautologies();
        this.rootAtom = new OntologyAtom();
        this.rootAtom.setModule(new HashSet<AxiomWrapper>(this.axioms));
        assert (this.rootAtom != null);
        Optional<OntologyAtom> bottomAtom = this.buildModule(new Signature(), this.rootAtom);
        if (bottomAtom.isPresent()) {
            bottomAtom.get().addAxioms(bottomAtom.get().getModule());
        }
        for (AxiomWrapper p : this.axioms) {
            if (!p.isUsed() || p.getAtom().isPresent()) continue;
            assert (this.rootAtom != null);
            this.createAtom(p, this.rootAtom);
        }
        this.restoreTautologies();
        this.rootAtom = null;
        assert (this.atomList != null);
        this.atomList.reduceGraph();
        return OWLAPIPreconditions.verifyNotNull(this.atomList);
    }

    public Set<OWLAxiom> getNonLocal(Stream<OWLEntity> signature, ModuleType moduletype) {
        Signature sig = new Signature(signature);
        sig.setLocality(false);
        this.modularizer.getLocalityChecker().setSignatureValue(sig);
        HashSet<OWLAxiom> result = new HashSet<OWLAxiom>();
        for (AxiomWrapper p : this.axioms) {
            if (this.modularizer.getLocalityChecker().local(p.getAxiom())) continue;
            result.add(p.getAxiom());
        }
        return result;
    }

    public Collection<AxiomWrapper> getModule(Stream<OWLEntity> signature, boolean useSemantics, ModuleType moduletype) {
        Signature sig = new Signature(signature);
        sig.setLocality(false);
        this.modularizer.extract(this.axioms, sig, moduletype);
        return this.modularizer.getModule();
    }
}

