/*
 * Decompiled with CFR 0.152.
 */
package org.semanticweb.owlapi.rdf.model;

import java.io.Serializable;
import java.util.ArrayList;
import java.util.IdentityHashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.Set;
import java.util.concurrent.ConcurrentHashMap;
import java.util.function.Function;
import java.util.function.Predicate;
import java.util.stream.Stream;
import javax.annotation.Nullable;
import org.semanticweb.owlapi.io.RDFResource;
import org.semanticweb.owlapi.model.IRI;
import org.semanticweb.owlapi.model.OWLAnnotation;
import org.semanticweb.owlapi.model.OWLAnnotationAssertionAxiom;
import org.semanticweb.owlapi.model.OWLAnnotationProperty;
import org.semanticweb.owlapi.model.OWLAnnotationPropertyDomainAxiom;
import org.semanticweb.owlapi.model.OWLAnnotationPropertyRangeAxiom;
import org.semanticweb.owlapi.model.OWLAnonymousIndividual;
import org.semanticweb.owlapi.model.OWLAsymmetricObjectPropertyAxiom;
import org.semanticweb.owlapi.model.OWLAxiom;
import org.semanticweb.owlapi.model.OWLCardinalityRestriction;
import org.semanticweb.owlapi.model.OWLClass;
import org.semanticweb.owlapi.model.OWLClassAssertionAxiom;
import org.semanticweb.owlapi.model.OWLClassExpression;
import org.semanticweb.owlapi.model.OWLDataAllValuesFrom;
import org.semanticweb.owlapi.model.OWLDataComplementOf;
import org.semanticweb.owlapi.model.OWLDataExactCardinality;
import org.semanticweb.owlapi.model.OWLDataHasValue;
import org.semanticweb.owlapi.model.OWLDataIntersectionOf;
import org.semanticweb.owlapi.model.OWLDataMaxCardinality;
import org.semanticweb.owlapi.model.OWLDataMinCardinality;
import org.semanticweb.owlapi.model.OWLDataOneOf;
import org.semanticweb.owlapi.model.OWLDataProperty;
import org.semanticweb.owlapi.model.OWLDataPropertyAssertionAxiom;
import org.semanticweb.owlapi.model.OWLDataPropertyDomainAxiom;
import org.semanticweb.owlapi.model.OWLDataPropertyRangeAxiom;
import org.semanticweb.owlapi.model.OWLDataRange;
import org.semanticweb.owlapi.model.OWLDataSomeValuesFrom;
import org.semanticweb.owlapi.model.OWLDataUnionOf;
import org.semanticweb.owlapi.model.OWLDatatype;
import org.semanticweb.owlapi.model.OWLDatatypeDefinitionAxiom;
import org.semanticweb.owlapi.model.OWLDatatypeRestriction;
import org.semanticweb.owlapi.model.OWLDeclarationAxiom;
import org.semanticweb.owlapi.model.OWLDifferentIndividualsAxiom;
import org.semanticweb.owlapi.model.OWLDisjointClassesAxiom;
import org.semanticweb.owlapi.model.OWLDisjointDataPropertiesAxiom;
import org.semanticweb.owlapi.model.OWLDisjointObjectPropertiesAxiom;
import org.semanticweb.owlapi.model.OWLDisjointUnionAxiom;
import org.semanticweb.owlapi.model.OWLDocumentFormat;
import org.semanticweb.owlapi.model.OWLEntity;
import org.semanticweb.owlapi.model.OWLEquivalentClassesAxiom;
import org.semanticweb.owlapi.model.OWLEquivalentDataPropertiesAxiom;
import org.semanticweb.owlapi.model.OWLEquivalentObjectPropertiesAxiom;
import org.semanticweb.owlapi.model.OWLFacetRestriction;
import org.semanticweb.owlapi.model.OWLFunctionalDataPropertyAxiom;
import org.semanticweb.owlapi.model.OWLFunctionalObjectPropertyAxiom;
import org.semanticweb.owlapi.model.OWLHasKeyAxiom;
import org.semanticweb.owlapi.model.OWLIndividual;
import org.semanticweb.owlapi.model.OWLInverseFunctionalObjectPropertyAxiom;
import org.semanticweb.owlapi.model.OWLInverseObjectPropertiesAxiom;
import org.semanticweb.owlapi.model.OWLIrreflexiveObjectPropertyAxiom;
import org.semanticweb.owlapi.model.OWLLiteral;
import org.semanticweb.owlapi.model.OWLNamedIndividual;
import org.semanticweb.owlapi.model.OWLNegativeDataPropertyAssertionAxiom;
import org.semanticweb.owlapi.model.OWLNegativeObjectPropertyAssertionAxiom;
import org.semanticweb.owlapi.model.OWLObject;
import org.semanticweb.owlapi.model.OWLObjectAllValuesFrom;
import org.semanticweb.owlapi.model.OWLObjectComplementOf;
import org.semanticweb.owlapi.model.OWLObjectExactCardinality;
import org.semanticweb.owlapi.model.OWLObjectHasSelf;
import org.semanticweb.owlapi.model.OWLObjectHasValue;
import org.semanticweb.owlapi.model.OWLObjectIntersectionOf;
import org.semanticweb.owlapi.model.OWLObjectInverseOf;
import org.semanticweb.owlapi.model.OWLObjectMaxCardinality;
import org.semanticweb.owlapi.model.OWLObjectMinCardinality;
import org.semanticweb.owlapi.model.OWLObjectOneOf;
import org.semanticweb.owlapi.model.OWLObjectProperty;
import org.semanticweb.owlapi.model.OWLObjectPropertyAssertionAxiom;
import org.semanticweb.owlapi.model.OWLObjectPropertyDomainAxiom;
import org.semanticweb.owlapi.model.OWLObjectPropertyRangeAxiom;
import org.semanticweb.owlapi.model.OWLObjectSomeValuesFrom;
import org.semanticweb.owlapi.model.OWLObjectUnionOf;
import org.semanticweb.owlapi.model.OWLObjectVisitor;
import org.semanticweb.owlapi.model.OWLOntology;
import org.semanticweb.owlapi.model.OWLOntologyID;
import org.semanticweb.owlapi.model.OWLOntologyManager;
import org.semanticweb.owlapi.model.OWLProperty;
import org.semanticweb.owlapi.model.OWLPropertyExpression;
import org.semanticweb.owlapi.model.OWLReflexiveObjectPropertyAxiom;
import org.semanticweb.owlapi.model.OWLRestriction;
import org.semanticweb.owlapi.model.OWLRuntimeException;
import org.semanticweb.owlapi.model.OWLSameIndividualAxiom;
import org.semanticweb.owlapi.model.OWLSubAnnotationPropertyOfAxiom;
import org.semanticweb.owlapi.model.OWLSubClassOfAxiom;
import org.semanticweb.owlapi.model.OWLSubDataPropertyOfAxiom;
import org.semanticweb.owlapi.model.OWLSubObjectPropertyOfAxiom;
import org.semanticweb.owlapi.model.OWLSubPropertyChainOfAxiom;
import org.semanticweb.owlapi.model.OWLSymmetricObjectPropertyAxiom;
import org.semanticweb.owlapi.model.OWLTransitiveObjectPropertyAxiom;
import org.semanticweb.owlapi.model.SWRLArgument;
import org.semanticweb.owlapi.model.SWRLBuiltInAtom;
import org.semanticweb.owlapi.model.SWRLClassAtom;
import org.semanticweb.owlapi.model.SWRLDArgument;
import org.semanticweb.owlapi.model.SWRLDataPropertyAtom;
import org.semanticweb.owlapi.model.SWRLDataRangeAtom;
import org.semanticweb.owlapi.model.SWRLDifferentIndividualsAtom;
import org.semanticweb.owlapi.model.SWRLIArgument;
import org.semanticweb.owlapi.model.SWRLIndividualArgument;
import org.semanticweb.owlapi.model.SWRLLiteralArgument;
import org.semanticweb.owlapi.model.SWRLObjectPropertyAtom;
import org.semanticweb.owlapi.model.SWRLObjectVisitor;
import org.semanticweb.owlapi.model.SWRLRule;
import org.semanticweb.owlapi.model.SWRLSameIndividualAtom;
import org.semanticweb.owlapi.model.SWRLVariable;
import org.semanticweb.owlapi.rdf.model.RDFGraph;
import org.semanticweb.owlapi.util.CollectionFactory;
import org.semanticweb.owlapi.util.IndividualAppearance;
import org.semanticweb.owlapi.util.OWLAPIPreconditions;
import org.semanticweb.owlapi.util.OWLAPIStreamUtils;
import org.semanticweb.owlapi.util.OWLObjectDesharer;
import org.semanticweb.owlapi.vocab.OWLRDFVocabulary;
import org.semanticweb.owlapi.vocab.SWRLVocabulary;
import org.semanticweb.owlapi.vocab.XSDVocabulary;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public abstract class AbstractTranslator<N extends Serializable, R extends N, P extends N, L extends N>
implements OWLObjectVisitor,
SWRLObjectVisitor {
    private static final Logger LOGGER = LoggerFactory.getLogger(AbstractTranslator.class);
    protected final IndividualAppearance multipleOccurrences;
    private final OWLOntologyManager manager;
    protected final OWLOntology ont;
    protected final OWLDocumentFormat format;
    private final boolean useStrongTyping;
    private final Set<OWLIndividual> currentIndividuals = CollectionFactory.createLinkedSet();
    private final Map<OWLObject, N> nodeMap = new ConcurrentHashMap<OWLObject, N>(16, 0.75f, 1);
    private final Map<OWLObject, N> expressionMap = new IdentityHashMap<OWLObject, N>();
    private final Map<OWLObject, OWLObject[]> expressionContext = new ConcurrentHashMap<OWLObject, OWLObject[]>(16, 0.75f, 1);
    protected RDFGraph graph = new RDFGraph();
    private final OWLObjectDesharer desharer;
    private final Set<OWLAxiom> translatedAxioms;

    public AbstractTranslator(OWLOntologyManager manager, OWLOntology ontology, @Nullable OWLDocumentFormat format, boolean useStrongTyping, IndividualAppearance multiple, Set<OWLAxiom> translatedAxioms) {
        this.ont = OWLAPIPreconditions.checkNotNull(ontology, "ontology cannot be null");
        this.manager = OWLAPIPreconditions.checkNotNull(manager, "manager cannot be null");
        this.useStrongTyping = useStrongTyping;
        this.multipleOccurrences = multiple;
        this.format = format;
        this.desharer = new OWLObjectDesharer(manager);
        this.translatedAxioms = translatedAxioms;
    }

    public void translate(OWLObject input) {
        if (input instanceof OWLAxiom) {
            if (this.translatedAxioms.add((OWLAxiom)input)) {
                input.accept(this);
            } else {
                LOGGER.debug("Axiom {} is being rendered twice, second pass skipped.", (Object)input);
            }
        } else {
            input.accept(this);
        }
    }

    @Override
    public void visit(OWLDeclarationAxiom axiom) {
        this.addSingleTripleAxiom((OWLAxiom)axiom, (OWLObject)axiom.getEntity(), OWLRDFVocabulary.RDF_TYPE.getIRI(), axiom.getEntity().getEntityType().getIRI());
    }

    @Override
    public void visit(OWLObjectInverseOf property) {
        this.translateAnonymousNode(property);
        this.addTriple((OWLObject)property, OWLRDFVocabulary.OWL_INVERSE_OF.getIRI(), (OWLObject)property.getInverse());
    }

    @Override
    public void visit(OWLDataIntersectionOf node) {
        this.translateAnonymousNode(node);
        this.addTriple((OWLObject)node, OWLRDFVocabulary.RDF_TYPE.getIRI(), OWLRDFVocabulary.RDFS_DATATYPE.getIRI());
        this.addListTriples(node, OWLRDFVocabulary.OWL_INTERSECTION_OF.getIRI(), node.operands());
    }

    @Override
    public void visit(OWLDataUnionOf node) {
        this.translateAnonymousNode(node);
        this.addTriple((OWLObject)node, OWLRDFVocabulary.RDF_TYPE.getIRI(), OWLRDFVocabulary.RDFS_DATATYPE.getIRI());
        this.addListTriples(node, OWLRDFVocabulary.OWL_UNION_OF.getIRI(), node.operands());
    }

    @Override
    public void visit(OWLDataComplementOf node) {
        this.translateAnonymousNode(node);
        this.addTriple((OWLObject)node, OWLRDFVocabulary.RDF_TYPE.getIRI(), OWLRDFVocabulary.RDFS_DATATYPE.getIRI());
        this.addTriple((OWLObject)node, OWLRDFVocabulary.OWL_DATATYPE_COMPLEMENT_OF.getIRI(), (OWLObject)node.getDataRange());
    }

    @Override
    public void visit(OWLDataOneOf node) {
        this.translateAnonymousNode(node);
        this.addTriple((OWLObject)node, OWLRDFVocabulary.RDF_TYPE.getIRI(), OWLRDFVocabulary.RDFS_DATATYPE.getIRI());
        this.addListTriples(node, OWLRDFVocabulary.OWL_ONE_OF.getIRI(), node.values());
    }

    @Override
    public void visit(OWLDatatypeRestriction node) {
        this.translateAnonymousNode(node);
        this.addTriple((OWLObject)node, OWLRDFVocabulary.RDF_TYPE.getIRI(), OWLRDFVocabulary.RDFS_DATATYPE.getIRI());
        this.addTriple((OWLObject)node, OWLRDFVocabulary.OWL_ON_DATA_TYPE.getIRI(), (OWLObject)node.getDatatype());
        this.addListTriples(node, OWLRDFVocabulary.OWL_WITH_RESTRICTIONS.getIRI(), node.facetRestrictions());
    }

    @Override
    public void visit(OWLObjectIntersectionOf ce) {
        this.translateAnonymousNode(ce);
        this.addListTriples(ce, OWLRDFVocabulary.OWL_INTERSECTION_OF.getIRI(), ce.operands());
        this.addTriple((OWLObject)ce, OWLRDFVocabulary.RDF_TYPE.getIRI(), OWLRDFVocabulary.OWL_CLASS.getIRI());
    }

    @Override
    public void visit(OWLObjectUnionOf ce) {
        this.translateAnonymousNode(ce);
        this.addTriple((OWLObject)ce, OWLRDFVocabulary.RDF_TYPE.getIRI(), OWLRDFVocabulary.OWL_CLASS.getIRI());
        this.addListTriples(ce, OWLRDFVocabulary.OWL_UNION_OF.getIRI(), ce.operands());
    }

    @Override
    public void visit(OWLObjectComplementOf ce) {
        this.translateAnonymousNode(ce);
        this.addTriple((OWLObject)ce, OWLRDFVocabulary.RDF_TYPE.getIRI(), OWLRDFVocabulary.OWL_CLASS.getIRI());
        this.addTriple((OWLObject)ce, OWLRDFVocabulary.OWL_COMPLEMENT_OF.getIRI(), (OWLObject)ce.getOperand());
    }

    @Override
    public void visit(OWLObjectOneOf ce) {
        this.translateAnonymousNode(ce);
        this.addTriple((OWLObject)ce, OWLRDFVocabulary.RDF_TYPE.getIRI(), OWLRDFVocabulary.OWL_CLASS.getIRI());
        this.addListTriples(ce, OWLRDFVocabulary.OWL_ONE_OF.getIRI(), ce.individuals());
        this.processIfAnonymous(ce.individuals(), null);
    }

    private void addRestrictionCommonTriplePropertyRange(OWLRestriction desc, OWLPropertyExpression property) {
        this.translateAnonymousNode(desc);
        this.addTriple((OWLObject)desc, OWLRDFVocabulary.RDF_TYPE.getIRI(), OWLRDFVocabulary.OWL_RESTRICTION.getIRI());
        this.addTriple((OWLObject)desc, OWLRDFVocabulary.OWL_ON_PROPERTY.getIRI(), (OWLObject)property);
    }

    private void addRestrictionCommonTriplePropertyExpression(OWLRestriction desc, OWLPropertyExpression property) {
        this.translateAnonymousNode(desc);
        this.addTriple((OWLObject)desc, OWLRDFVocabulary.RDF_TYPE.getIRI(), OWLRDFVocabulary.OWL_RESTRICTION.getIRI());
        this.addTriple((OWLObject)desc, OWLRDFVocabulary.OWL_ON_PROPERTY.getIRI(), (OWLObject)property);
    }

    private void addObjectCardinalityRestrictionTriples(OWLCardinalityRestriction<OWLClassExpression> ce, OWLPropertyExpression p, OWLRDFVocabulary cardiPredicate) {
        this.addRestrictionCommonTriplePropertyRange(ce, p);
        this.addTriple((OWLObject)ce, cardiPredicate.getIRI(), (OWLObject)this.toTypedConstant(ce.getCardinality()));
        if (ce.isQualified()) {
            if (ce.isObjectRestriction()) {
                this.addTriple((OWLObject)ce, OWLRDFVocabulary.OWL_ON_CLASS.getIRI(), (OWLObject)ce.getFiller());
            } else {
                this.addTriple((OWLObject)ce, OWLRDFVocabulary.OWL_ON_DATA_RANGE.getIRI(), (OWLObject)ce.getFiller());
            }
        }
    }

    private void addDataCardinalityRestrictionTriples(OWLCardinalityRestriction<OWLDataRange> ce, OWLPropertyExpression p, OWLRDFVocabulary cardiPredicate) {
        this.addRestrictionCommonTriplePropertyRange(ce, p);
        this.addTriple((OWLObject)ce, cardiPredicate.getIRI(), (OWLObject)this.toTypedConstant(ce.getCardinality()));
        if (ce.isQualified()) {
            if (ce.isObjectRestriction()) {
                this.addTriple((OWLObject)ce, OWLRDFVocabulary.OWL_ON_CLASS.getIRI(), (OWLObject)ce.getFiller());
            } else {
                this.addTriple((OWLObject)ce, OWLRDFVocabulary.OWL_ON_DATA_RANGE.getIRI(), (OWLObject)ce.getFiller());
            }
        }
    }

    @Override
    public void visit(OWLObjectSomeValuesFrom ce) {
        this.addRestrictionCommonTriplePropertyRange(ce, ce.getProperty());
        this.addTriple((OWLObject)ce, OWLRDFVocabulary.OWL_SOME_VALUES_FROM.getIRI(), (OWLObject)ce.getFiller());
    }

    @Override
    public void visit(OWLObjectAllValuesFrom ce) {
        this.addRestrictionCommonTriplePropertyRange(ce, ce.getProperty());
        this.addTriple((OWLObject)ce, OWLRDFVocabulary.OWL_ALL_VALUES_FROM.getIRI(), (OWLObject)ce.getFiller());
    }

    @Override
    public void visit(OWLObjectHasValue ce) {
        this.addRestrictionCommonTriplePropertyExpression(ce, ce.getProperty());
        this.addTriple((OWLObject)ce, OWLRDFVocabulary.OWL_HAS_VALUE.getIRI(), (OWLObject)ce.getFiller());
        this.processIfAnonymous((OWLIndividual)ce.getFiller());
    }

    @Override
    public void visit(OWLObjectHasSelf ce) {
        this.translateAnonymousNode(ce);
        this.addTriple((OWLObject)ce, OWLRDFVocabulary.RDF_TYPE.getIRI(), OWLRDFVocabulary.OWL_RESTRICTION.getIRI());
        this.addTriple((OWLObject)ce, OWLRDFVocabulary.OWL_ON_PROPERTY.getIRI(), (OWLObject)ce.getProperty());
        this.addTriple((OWLObject)ce, OWLRDFVocabulary.OWL_HAS_SELF.getIRI(), (OWLObject)this.manager.getOWLDataFactory().getOWLLiteral(true));
    }

    @Override
    public void visit(OWLObjectMinCardinality ce) {
        if (ce.isQualified()) {
            this.addObjectCardinalityRestrictionTriples(ce, ce.getProperty(), OWLRDFVocabulary.OWL_MIN_QUALIFIED_CARDINALITY);
        } else {
            this.addObjectCardinalityRestrictionTriples(ce, ce.getProperty(), OWLRDFVocabulary.OWL_MIN_CARDINALITY);
        }
    }

    @Override
    public void visit(OWLObjectMaxCardinality ce) {
        if (ce.isQualified()) {
            this.addObjectCardinalityRestrictionTriples(ce, ce.getProperty(), OWLRDFVocabulary.OWL_MAX_QUALIFIED_CARDINALITY);
        } else {
            this.addObjectCardinalityRestrictionTriples(ce, ce.getProperty(), OWLRDFVocabulary.OWL_MAX_CARDINALITY);
        }
    }

    @Override
    public void visit(OWLObjectExactCardinality ce) {
        if (ce.isQualified()) {
            this.addObjectCardinalityRestrictionTriples(ce, ce.getProperty(), OWLRDFVocabulary.OWL_QUALIFIED_CARDINALITY);
        } else {
            this.addObjectCardinalityRestrictionTriples(ce, ce.getProperty(), OWLRDFVocabulary.OWL_CARDINALITY);
        }
    }

    @Override
    public void visit(OWLDataSomeValuesFrom ce) {
        this.addRestrictionCommonTriplePropertyRange(ce, ce.getProperty());
        this.addTriple((OWLObject)ce, OWLRDFVocabulary.OWL_SOME_VALUES_FROM.getIRI(), (OWLObject)ce.getFiller());
    }

    @Override
    public void visit(OWLDataAllValuesFrom ce) {
        this.addRestrictionCommonTriplePropertyRange(ce, ce.getProperty());
        this.addTriple((OWLObject)ce, OWLRDFVocabulary.OWL_ALL_VALUES_FROM.getIRI(), (OWLObject)ce.getFiller());
    }

    @Override
    public void visit(OWLDataHasValue ce) {
        this.addRestrictionCommonTriplePropertyExpression(ce, ce.getProperty());
        this.addTriple((OWLObject)ce, OWLRDFVocabulary.OWL_HAS_VALUE.getIRI(), (OWLObject)ce.getFiller());
    }

    @Override
    public void visit(OWLDataMinCardinality ce) {
        if (ce.isQualified()) {
            this.addDataCardinalityRestrictionTriples(ce, ce.getProperty(), OWLRDFVocabulary.OWL_MIN_QUALIFIED_CARDINALITY);
        } else {
            this.addDataCardinalityRestrictionTriples(ce, ce.getProperty(), OWLRDFVocabulary.OWL_MIN_CARDINALITY);
        }
    }

    @Override
    public void visit(OWLDataMaxCardinality ce) {
        if (ce.isQualified()) {
            this.addDataCardinalityRestrictionTriples(ce, ce.getProperty(), OWLRDFVocabulary.OWL_MAX_QUALIFIED_CARDINALITY);
        } else {
            this.addDataCardinalityRestrictionTriples(ce, ce.getProperty(), OWLRDFVocabulary.OWL_MAX_CARDINALITY);
        }
    }

    @Override
    public void visit(OWLDataExactCardinality ce) {
        if (ce.isQualified()) {
            this.addDataCardinalityRestrictionTriples(ce, ce.getProperty(), OWLRDFVocabulary.OWL_QUALIFIED_CARDINALITY);
        } else {
            this.addDataCardinalityRestrictionTriples(ce, ce.getProperty(), OWLRDFVocabulary.OWL_CARDINALITY);
        }
    }

    @Override
    public void visit(OWLSubClassOfAxiom axiom) {
        this.addSingleTripleAxiom((OWLAxiom)axiom, (OWLObject)axiom.getSubClass(), OWLRDFVocabulary.RDFS_SUBCLASS_OF.getIRI(), (OWLObject)axiom.getSuperClass());
    }

    @Override
    public void visit(OWLEquivalentClassesAxiom axiom) {
        if (axiom.classExpressions().count() == 2L) {
            this.addPairwise(axiom, axiom.classExpressions(), OWLRDFVocabulary.OWL_EQUIVALENT_CLASS.getIRI());
        } else {
            axiom.splitToAnnotatedPairs().stream().sorted().forEach(ax -> ax.accept(this));
        }
    }

    @Override
    public void visit(OWLDisjointClassesAxiom axiom) {
        if (axiom.classExpressions().count() == 2L) {
            this.addPairwise(axiom, axiom.classExpressions(), OWLRDFVocabulary.OWL_DISJOINT_WITH.getIRI());
        } else {
            this.translateAnonymousNode(axiom);
            this.addTriple((OWLObject)axiom, OWLRDFVocabulary.RDF_TYPE.getIRI(), OWLRDFVocabulary.OWL_ALL_DISJOINT_CLASSES.getIRI());
            this.addListTriples(axiom, OWLRDFVocabulary.OWL_MEMBERS.getIRI(), axiom.classExpressions());
            this.translateAnnotations(axiom);
        }
    }

    @Override
    public void visit(OWLDisjointUnionAxiom axiom) {
        this.addSingleTripleAxiom((OWLAxiom)axiom, (OWLObject)axiom.getOWLClass(), OWLRDFVocabulary.OWL_DISJOINT_UNION_OF.getIRI(), axiom.classExpressions());
    }

    @Override
    public void visit(OWLSubObjectPropertyOfAxiom axiom) {
        this.addSingleTripleAxiom((OWLAxiom)axiom, (OWLObject)axiom.getSubProperty(), OWLRDFVocabulary.RDFS_SUB_PROPERTY_OF.getIRI(), (OWLObject)axiom.getSuperProperty());
    }

    @Override
    public void visit(OWLSubPropertyChainOfAxiom axiom) {
        this.addSingleTripleAxiom((OWLAxiom)axiom, (OWLObject)axiom.getSuperProperty(), OWLRDFVocabulary.OWL_PROPERTY_CHAIN_AXIOM.getIRI(), axiom.getPropertyChain().stream());
    }

    @Override
    public void visit(OWLEquivalentObjectPropertiesAxiom axiom) {
        if (axiom.properties().count() == 2L) {
            this.addPairwise(axiom, axiom.properties(), OWLRDFVocabulary.OWL_EQUIVALENT_PROPERTY.getIRI());
        } else {
            axiom.splitToAnnotatedPairs().stream().sorted().forEach(ax -> ax.accept(this));
        }
    }

    @Override
    public void visit(OWLDisjointObjectPropertiesAxiom axiom) {
        if (axiom.properties().count() == 2L) {
            this.addPairwise(axiom, axiom.properties(), OWLRDFVocabulary.OWL_PROPERTY_DISJOINT_WITH.getIRI());
        } else {
            this.translateAnonymousNode(axiom);
            this.translateAnnotations(axiom);
            this.addTriple((OWLObject)axiom, OWLRDFVocabulary.RDF_TYPE.getIRI(), OWLRDFVocabulary.OWL_ALL_DISJOINT_PROPERTIES.getIRI());
            this.addListTriples(axiom, OWLRDFVocabulary.OWL_MEMBERS.getIRI(), axiom.properties());
        }
    }

    @Override
    public void visit(OWLObjectPropertyDomainAxiom axiom) {
        this.addSingleTripleAxiom((OWLAxiom)axiom, (OWLObject)axiom.getProperty(), OWLRDFVocabulary.RDFS_DOMAIN.getIRI(), (OWLObject)axiom.getDomain());
    }

    @Override
    public void visit(OWLObjectPropertyRangeAxiom axiom) {
        this.addSingleTripleAxiom((OWLAxiom)axiom, (OWLObject)axiom.getProperty(), OWLRDFVocabulary.RDFS_RANGE.getIRI(), (OWLObject)axiom.getRange());
    }

    @Override
    public void visit(OWLInverseObjectPropertiesAxiom axiom) {
        this.addSingleTripleAxiom((OWLAxiom)axiom, (OWLObject)axiom.getFirstProperty(), OWLRDFVocabulary.OWL_INVERSE_OF.getIRI(), (OWLObject)axiom.getSecondProperty());
    }

    @Override
    public void visit(OWLFunctionalObjectPropertyAxiom axiom) {
        this.addSingleTripleAxiom((OWLAxiom)axiom, (OWLObject)axiom.getProperty(), OWLRDFVocabulary.RDF_TYPE.getIRI(), OWLRDFVocabulary.OWL_FUNCTIONAL_PROPERTY.getIRI());
    }

    @Override
    public void visit(OWLInverseFunctionalObjectPropertyAxiom axiom) {
        this.addSingleTripleAxiom((OWLAxiom)axiom, (OWLObject)axiom.getProperty(), OWLRDFVocabulary.RDF_TYPE.getIRI(), OWLRDFVocabulary.OWL_INVERSE_FUNCTIONAL_PROPERTY.getIRI());
    }

    @Override
    public void visit(OWLReflexiveObjectPropertyAxiom axiom) {
        this.addSingleTripleAxiom((OWLAxiom)axiom, (OWLObject)axiom.getProperty(), OWLRDFVocabulary.RDF_TYPE.getIRI(), OWLRDFVocabulary.OWL_REFLEXIVE_PROPERTY.getIRI());
    }

    @Override
    public void visit(OWLIrreflexiveObjectPropertyAxiom axiom) {
        this.addSingleTripleAxiom((OWLAxiom)axiom, (OWLObject)axiom.getProperty(), OWLRDFVocabulary.RDF_TYPE.getIRI(), OWLRDFVocabulary.OWL_IRREFLEXIVE_PROPERTY.getIRI());
    }

    @Override
    public void visit(OWLSymmetricObjectPropertyAxiom axiom) {
        this.addSingleTripleAxiom((OWLAxiom)axiom, (OWLObject)axiom.getProperty(), OWLRDFVocabulary.RDF_TYPE.getIRI(), OWLRDFVocabulary.OWL_SYMMETRIC_PROPERTY.getIRI());
    }

    @Override
    public void visit(OWLAsymmetricObjectPropertyAxiom axiom) {
        this.addSingleTripleAxiom((OWLAxiom)axiom, (OWLObject)axiom.getProperty(), OWLRDFVocabulary.RDF_TYPE.getIRI(), OWLRDFVocabulary.OWL_ASYMMETRIC_PROPERTY.getIRI());
    }

    @Override
    public void visit(OWLTransitiveObjectPropertyAxiom axiom) {
        this.addSingleTripleAxiom((OWLAxiom)axiom, (OWLObject)axiom.getProperty(), OWLRDFVocabulary.RDF_TYPE.getIRI(), OWLRDFVocabulary.OWL_TRANSITIVE_PROPERTY.getIRI());
    }

    @Override
    public void visit(OWLSubDataPropertyOfAxiom axiom) {
        this.addSingleTripleAxiom((OWLAxiom)axiom, (OWLObject)axiom.getSubProperty(), OWLRDFVocabulary.RDFS_SUB_PROPERTY_OF.getIRI(), (OWLObject)axiom.getSuperProperty());
    }

    @Override
    public void visit(OWLEquivalentDataPropertiesAxiom axiom) {
        if (axiom.properties().count() == 2L) {
            this.addPairwise(axiom, axiom.properties(), OWLRDFVocabulary.OWL_EQUIVALENT_PROPERTY.getIRI());
        } else {
            axiom.splitToAnnotatedPairs().stream().sorted().forEach(ax -> ax.accept(this));
        }
    }

    @Override
    public void visit(OWLDisjointDataPropertiesAxiom axiom) {
        if (axiom.properties().count() == 2L) {
            this.addPairwise(axiom, axiom.properties(), OWLRDFVocabulary.OWL_PROPERTY_DISJOINT_WITH.getIRI());
        } else {
            this.translateAnonymousNode(axiom);
            this.translateAnnotations(axiom);
            this.addTriple((OWLObject)axiom, OWLRDFVocabulary.RDF_TYPE.getIRI(), OWLRDFVocabulary.OWL_ALL_DISJOINT_PROPERTIES.getIRI());
            this.addListTriples(axiom, OWLRDFVocabulary.OWL_MEMBERS.getIRI(), axiom.properties());
        }
    }

    @Override
    public void visit(OWLDataPropertyDomainAxiom axiom) {
        this.addSingleTripleAxiom((OWLAxiom)axiom, (OWLObject)axiom.getProperty(), OWLRDFVocabulary.RDFS_DOMAIN.getIRI(), (OWLObject)axiom.getDomain());
    }

    @Override
    public void visit(OWLDataPropertyRangeAxiom axiom) {
        this.addSingleTripleAxiom((OWLAxiom)axiom, (OWLObject)axiom.getProperty(), OWLRDFVocabulary.RDFS_RANGE.getIRI(), (OWLObject)axiom.getRange());
    }

    @Override
    public void visit(OWLFunctionalDataPropertyAxiom axiom) {
        this.addSingleTripleAxiom((OWLAxiom)axiom, (OWLObject)axiom.getProperty(), OWLRDFVocabulary.RDF_TYPE.getIRI(), OWLRDFVocabulary.OWL_FUNCTIONAL_PROPERTY.getIRI());
    }

    @Override
    public void visit(OWLDatatypeDefinitionAxiom axiom) {
        this.addSingleTripleAxiom((OWLAxiom)axiom, (OWLObject)axiom.getDatatype(), OWLRDFVocabulary.OWL_EQUIVALENT_CLASS.getIRI(), (OWLObject)axiom.getDataRange());
    }

    @Override
    public void visit(OWLHasKeyAxiom axiom) {
        this.addSingleTripleAxiom((OWLAxiom)axiom, (OWLObject)axiom.getClassExpression(), OWLRDFVocabulary.OWL_HAS_KEY.getIRI(), axiom.propertyExpressions());
    }

    @Override
    public void visit(OWLSameIndividualAxiom axiom) {
        axiom.splitToAnnotatedPairs().forEach(a -> this.addSingleTripleAxiom((OWLAxiom)a, (OWLObject)a.getIndividualsAsList().get(0), OWLRDFVocabulary.OWL_SAME_AS.getIRI(), (OWLObject)a.getIndividualsAsList().get(1)));
        this.processIfAnonymous(axiom.individuals(), (OWLAxiom)axiom);
    }

    @Override
    public void visit(OWLDifferentIndividualsAxiom axiom) {
        this.translateAnonymousNode(axiom);
        this.addTriple((OWLObject)axiom, OWLRDFVocabulary.RDF_TYPE.getIRI(), OWLRDFVocabulary.OWL_ALL_DIFFERENT.getIRI());
        this.addListTriples(axiom, OWLRDFVocabulary.OWL_DISTINCT_MEMBERS.getIRI(), axiom.individuals());
        this.translateAnnotations(axiom);
        this.processIfAnonymous(axiom.individuals(), (OWLAxiom)axiom);
    }

    @Override
    public void visit(OWLClassAssertionAxiom axiom) {
        axiom.getIndividual().accept(this);
        this.addSingleTripleAxiom((OWLAxiom)axiom, (OWLObject)axiom.getIndividual(), OWLRDFVocabulary.RDF_TYPE.getIRI(), (OWLObject)axiom.getClassExpression());
        this.processIfAnonymous(axiom.getIndividual(), (OWLAxiom)axiom);
    }

    @Override
    public void visit(OWLObjectPropertyAssertionAxiom axiom) {
        OWLObjectPropertyAssertionAxiom simplified = axiom.getSimplified();
        this.addSingleTripleAxiom((OWLAxiom)simplified, (OWLObject)simplified.getSubject(), simplified.getProperty(), (OWLObject)simplified.getObject());
        this.processIfAnonymous((OWLIndividual)simplified.getObject(), (OWLAxiom)axiom);
        this.processIfAnonymous(simplified.getSubject(), (OWLAxiom)axiom);
    }

    @Override
    public void visit(OWLNegativeObjectPropertyAssertionAxiom axiom) {
        this.translateAnonymousNode(axiom);
        this.addTriple((OWLObject)axiom, OWLRDFVocabulary.RDF_TYPE.getIRI(), OWLRDFVocabulary.OWL_NEGATIVE_PROPERTY_ASSERTION.getIRI());
        this.addTriple((OWLObject)axiom, OWLRDFVocabulary.OWL_SOURCE_INDIVIDUAL.getIRI(), (OWLObject)axiom.getSubject());
        this.addTriple((OWLObject)axiom, OWLRDFVocabulary.OWL_ASSERTION_PROPERTY.getIRI(), axiom.getProperty());
        this.addTriple((OWLObject)axiom, OWLRDFVocabulary.OWL_TARGET_INDIVIDUAL.getIRI(), (OWLObject)axiom.getObject());
        this.translateAnnotations(axiom);
        this.processIfAnonymous(axiom.getSubject(), (OWLAxiom)axiom);
        this.processIfAnonymous((OWLIndividual)axiom.getObject(), (OWLAxiom)axiom);
    }

    @Override
    public void visit(OWLDataPropertyAssertionAxiom axiom) {
        this.addSingleTripleAxiom((OWLAxiom)axiom, (OWLObject)axiom.getSubject(), axiom.getProperty(), (OWLObject)axiom.getObject());
    }

    @Override
    public void visit(OWLNegativeDataPropertyAssertionAxiom axiom) {
        this.translateAnonymousNode(axiom);
        this.addTriple((OWLObject)axiom, OWLRDFVocabulary.RDF_TYPE.getIRI(), OWLRDFVocabulary.OWL_NEGATIVE_PROPERTY_ASSERTION.getIRI());
        this.addTriple((OWLObject)axiom, OWLRDFVocabulary.OWL_SOURCE_INDIVIDUAL.getIRI(), (OWLObject)axiom.getSubject());
        this.addTriple((OWLObject)axiom, OWLRDFVocabulary.OWL_ASSERTION_PROPERTY.getIRI(), axiom.getProperty());
        this.addTriple((OWLObject)axiom, OWLRDFVocabulary.OWL_TARGET_VALUE.getIRI(), (OWLObject)axiom.getObject());
        this.translateAnnotations(axiom);
        this.processIfAnonymous(axiom.getSubject(), (OWLAxiom)axiom);
    }

    @Override
    public void visit(OWLAnnotationAssertionAxiom axiom) {
        this.addSingleTripleAxiom((OWLAxiom)axiom, (OWLObject)axiom.getSubject(), (OWLObject)axiom.getProperty(), (OWLObject)axiom.getValue());
        if (axiom.getValue() instanceof OWLAnonymousIndividual) {
            this.processIfAnonymous((OWLAnonymousIndividual)axiom.getValue(), (OWLAxiom)axiom);
        }
    }

    @Override
    public void visit(OWLSubAnnotationPropertyOfAxiom axiom) {
        this.addSingleTripleAxiom((OWLAxiom)axiom, (OWLObject)axiom.getSubProperty(), OWLRDFVocabulary.RDFS_SUB_PROPERTY_OF.getIRI(), (OWLObject)axiom.getSuperProperty());
    }

    @Override
    public void visit(OWLAnnotationPropertyDomainAxiom axiom) {
        this.addSingleTripleAxiom((OWLAxiom)axiom, (OWLObject)axiom.getProperty(), OWLRDFVocabulary.RDFS_DOMAIN.getIRI(), (IRI)axiom.getDomain());
    }

    @Override
    public void visit(OWLAnnotationPropertyRangeAxiom axiom) {
        this.addSingleTripleAxiom((OWLAxiom)axiom, (OWLObject)axiom.getProperty(), OWLRDFVocabulary.RDFS_RANGE.getIRI(), (IRI)axiom.getRange());
    }

    protected <T extends OWLObject> N putHasIRI(T i, Function<T, IRI> f) {
        Serializable n = (Serializable)this.nodeMap.get(i);
        if (n != null) {
            return (N)n;
        }
        n = this.getResourceNode(f.apply(i));
        this.nodeMap.put(i, n);
        return (N)n;
    }

    protected void putLiteral(OWLLiteral i) {
        if (this.expressionMap.containsKey(i)) {
            return;
        }
        this.expressionMap.put(i, this.getLiteralNode(i));
    }

    protected void putProperty(OWLProperty p) {
        if (this.nodeMap.containsKey(p)) {
            return;
        }
        this.nodeMap.put(p, this.getPredicateNode(p.getIRI()));
    }

    @Override
    public void visit(OWLClass ce) {
        this.putHasIRI(ce, x -> x.getIRI());
        this.addStrongTyping(ce);
    }

    @Override
    public void visit(OWLDatatype node) {
        this.putHasIRI(node, x -> x.getIRI());
        this.addStrongTyping(node);
    }

    @Override
    public void visit(OWLFacetRestriction node) {
        this.translateAnonymousNode(node);
        this.addTriple((OWLObject)node, node.getFacet().getIRI(), (OWLObject)node.getFacetValue());
    }

    @Override
    public void visit(IRI iri) {
        this.putHasIRI(iri, x -> x);
    }

    @Override
    public void visit(OWLLiteral node) {
        this.putLiteral(node);
    }

    @Override
    public void visit(OWLDataProperty property) {
        this.putProperty(property);
        this.addStrongTyping(property);
    }

    @Override
    public void visit(OWLObjectProperty property) {
        this.putProperty(property);
        this.addStrongTyping(property);
    }

    @Override
    public void visit(OWLAnnotationProperty property) {
        this.putProperty(property);
        this.addStrongTyping(property);
    }

    @Override
    public void visit(OWLNamedIndividual individual) {
        this.putHasIRI(individual, x -> x.getIRI());
        this.addStrongTyping(individual);
    }

    @Override
    public void visit(OWLAnonymousIndividual individual) {
        this.translateAnonymousNode(individual);
    }

    @Override
    public void visit(OWLOntology ontology) {
        Optional<IRI> ontologyIRI = ontology.getOntologyID().getOntologyIRI();
        if (ontologyIRI.isPresent()) {
            this.putHasIRI(ontology, x -> x.getOntologyID().getOntologyIRI().get());
        } else {
            this.translateAnonymousNode(ontology);
        }
        this.addTriple((OWLObject)ontology, OWLRDFVocabulary.RDF_TYPE.getIRI(), OWLRDFVocabulary.OWL_ONTOLOGY.getIRI());
        this.addVersionIRIToOntologyHeader(ontology);
        this.addImportsDeclarationsToOntologyHeader(ontology);
        this.addAnnotationsToOntologyHeader(ontology);
        this.graph.setOntology((RDFResource)this.getMappedNode(ontology));
    }

    private void addVersionIRIToOntologyHeader(OWLOntology ontology) {
        OWLOntologyID ontID = ontology.getOntologyID();
        if (ontID.getVersionIRI().isPresent()) {
            this.addTriple((OWLObject)ontology, OWLRDFVocabulary.OWL_VERSION_IRI.getIRI(), ontID.getVersionIRI().get());
        }
    }

    private void addImportsDeclarationsToOntologyHeader(OWLOntology ontology) {
        ontology.importsDeclarations().forEach(decl -> this.addTriple((OWLObject)ontology, OWLRDFVocabulary.OWL_IMPORTS.getIRI(), decl.getIRI()));
    }

    private void addAnnotationsToOntologyHeader(OWLOntology ontology) {
        ontology.annotations().forEach(a -> this.translateAnnotation(ontology, (OWLAnnotation)a));
    }

    @Override
    public void visit(SWRLRule rule) {
        this.translateAnonymousNode(rule);
        this.translateAnnotations(rule);
        this.addTriple((OWLObject)rule, OWLRDFVocabulary.RDF_TYPE.getIRI(), SWRLVocabulary.IMP.getIRI());
        this.addTriple(rule, SWRLVocabulary.BODY.getIRI(), rule.body(), SWRLVocabulary.ATOM_LIST.getIRI());
        this.addTriple(rule, SWRLVocabulary.HEAD.getIRI(), rule.head(), SWRLVocabulary.ATOM_LIST.getIRI());
    }

    @Override
    public void visit(SWRLClassAtom node) {
        this.translateAnonymousNode(node);
        this.addTriple((OWLObject)node, OWLRDFVocabulary.RDF_TYPE.getIRI(), SWRLVocabulary.CLASS_ATOM.getIRI());
        node.getPredicate().accept(this);
        this.addTriple((OWLObject)node, SWRLVocabulary.CLASS_PREDICATE.getIRI(), (OWLObject)node.getPredicate());
        ((SWRLIArgument)node.getArgument()).accept((SWRLObjectVisitor)this);
        this.addTriple((OWLObject)node, SWRLVocabulary.ARGUMENT_1.getIRI(), (OWLObject)node.getArgument());
    }

    @Override
    public void visit(SWRLDataRangeAtom node) {
        this.translateAnonymousNode(node);
        this.addTriple((OWLObject)node, OWLRDFVocabulary.RDF_TYPE.getIRI(), SWRLVocabulary.DATA_RANGE_ATOM.getIRI());
        node.getPredicate().accept(this);
        this.addTriple((OWLObject)node, SWRLVocabulary.DATA_RANGE.getIRI(), (OWLObject)node.getPredicate());
        ((SWRLDArgument)node.getArgument()).accept((SWRLObjectVisitor)this);
        this.addTriple((OWLObject)node, SWRLVocabulary.ARGUMENT_1.getIRI(), (OWLObject)node.getArgument());
    }

    @Override
    public void visit(SWRLObjectPropertyAtom node) {
        this.translateAnonymousNode(node);
        this.addTriple((OWLObject)node, OWLRDFVocabulary.RDF_TYPE.getIRI(), SWRLVocabulary.INDIVIDUAL_PROPERTY_ATOM.getIRI());
        node.getPredicate().accept(this);
        this.addTriple((OWLObject)node, SWRLVocabulary.PROPERTY_PREDICATE.getIRI(), (OWLObject)node.getPredicate());
        ((SWRLIArgument)node.getFirstArgument()).accept((SWRLObjectVisitor)this);
        this.addTriple((OWLObject)node, SWRLVocabulary.ARGUMENT_1.getIRI(), (OWLObject)node.getFirstArgument());
        ((SWRLIArgument)node.getSecondArgument()).accept((SWRLObjectVisitor)this);
        this.addTriple((OWLObject)node, SWRLVocabulary.ARGUMENT_2.getIRI(), (OWLObject)node.getSecondArgument());
    }

    @Override
    public void visit(SWRLDataPropertyAtom node) {
        this.translateAnonymousNode(node);
        this.addTriple((OWLObject)node, OWLRDFVocabulary.RDF_TYPE.getIRI(), SWRLVocabulary.DATAVALUED_PROPERTY_ATOM.getIRI());
        node.getPredicate().accept(this);
        this.addTriple((OWLObject)node, SWRLVocabulary.PROPERTY_PREDICATE.getIRI(), (OWLObject)node.getPredicate());
        ((SWRLIArgument)node.getFirstArgument()).accept((SWRLObjectVisitor)this);
        this.addTriple((OWLObject)node, SWRLVocabulary.ARGUMENT_1.getIRI(), (OWLObject)node.getFirstArgument());
        ((SWRLDArgument)node.getSecondArgument()).accept((SWRLObjectVisitor)this);
        this.addTriple((OWLObject)node, SWRLVocabulary.ARGUMENT_2.getIRI(), (OWLObject)node.getSecondArgument());
    }

    @Override
    public void visit(SWRLBuiltInAtom node) {
        this.translateAnonymousNode(node);
        this.addTriple((OWLObject)node, OWLRDFVocabulary.RDF_TYPE.getIRI(), SWRLVocabulary.BUILT_IN_ATOM.getIRI());
        this.addTriple((OWLObject)node, SWRLVocabulary.BUILT_IN.getIRI(), node.getPredicate());
        this.addTriple(this.getResourceNode(node.getPredicate()), this.getPredicateNode(OWLRDFVocabulary.RDF_TYPE.getIRI()), this.getResourceNode(SWRLVocabulary.BUILT_IN_CLASS.getIRI()));
        this.addTriple((Serializable)this.getNode(node), this.getPredicateNode(SWRLVocabulary.ARGUMENTS.getIRI()), this.translateList(new ArrayList<SWRLDArgument>(node.getArguments())));
    }

    @Override
    public void visit(SWRLDifferentIndividualsAtom node) {
        this.translateAnonymousNode(node);
        this.addTriple((OWLObject)node, OWLRDFVocabulary.RDF_TYPE.getIRI(), SWRLVocabulary.DIFFERENT_INDIVIDUALS_ATOM.getIRI());
        ((SWRLIArgument)node.getFirstArgument()).accept((SWRLObjectVisitor)this);
        this.addTriple((OWLObject)node, SWRLVocabulary.ARGUMENT_1.getIRI(), (OWLObject)node.getFirstArgument());
        ((SWRLIArgument)node.getSecondArgument()).accept((SWRLObjectVisitor)this);
        this.addTriple((OWLObject)node, SWRLVocabulary.ARGUMENT_2.getIRI(), (OWLObject)node.getSecondArgument());
    }

    @Override
    public void visit(SWRLSameIndividualAtom node) {
        this.translateAnonymousNode(node);
        this.addTriple((OWLObject)node, OWLRDFVocabulary.RDF_TYPE.getIRI(), SWRLVocabulary.SAME_INDIVIDUAL_ATOM.getIRI());
        ((SWRLIArgument)node.getFirstArgument()).accept((SWRLObjectVisitor)this);
        this.addTriple((OWLObject)node, SWRLVocabulary.ARGUMENT_1.getIRI(), (OWLObject)node.getFirstArgument());
        ((SWRLIArgument)node.getSecondArgument()).accept((SWRLObjectVisitor)this);
        this.addTriple((OWLObject)node, SWRLVocabulary.ARGUMENT_2.getIRI(), (OWLObject)node.getSecondArgument());
    }

    @Override
    public void visit(SWRLVariable node) {
        this.putHasIRI(node, x -> x.getIRI());
        if (!this.ont.containsIndividualInSignature(node.getIRI())) {
            this.addTriple((OWLObject)node, OWLRDFVocabulary.RDF_TYPE.getIRI(), SWRLVocabulary.VARIABLE.getIRI());
        }
    }

    protected void putSWRLEntity(SWRLArgument i, OWLObject o) {
        if (this.nodeMap.containsKey(i)) {
            return;
        }
        o.accept(this);
        this.nodeMap.put(i, this.getMappedNode(o));
    }

    @Override
    public void visit(SWRLIndividualArgument node) {
        this.putSWRLEntity(node, node.getIndividual());
    }

    @Override
    public void visit(SWRLLiteralArgument node) {
        this.putSWRLEntity(node, node.getLiteral());
    }

    private void addSingleTripleAxiom(OWLAxiom ax, OWLObject subject, IRI pred, OWLObject obj) {
        this.addSingleTripleAxiomRPN(ax, (Serializable)this.getNode(subject), this.getPredicateNode(pred), (Serializable)this.getNode(obj, subject, pred));
    }

    private void addSingleTripleAxiom(OWLAxiom ax, OWLObject subject, IRI pred, IRI obj) {
        this.addSingleTripleAxiomRPN(ax, (Serializable)this.getNode(subject), this.getPredicateNode(pred), this.getResourceNode(obj));
    }

    private void addSingleTripleAxiom(OWLAxiom ax, OWLObject subj, IRI pred, Stream<? extends OWLObject> obj) {
        this.addSingleTripleAxiomRPN(ax, (Serializable)this.getNode(subj), this.getPredicateNode(pred), this.translateList(OWLAPIStreamUtils.asList(obj)));
    }

    private void addSingleTripleAxiom(OWLAxiom ax, OWLObject subj, OWLObject pred, OWLObject obj) {
        this.addSingleTripleAxiomRPN(ax, (Serializable)this.getNode(subj), (Serializable)this.getNode(pred), (Serializable)this.getNode(obj));
    }

    private void addSingleTripleAxiomRPN(OWLAxiom ax, R subject, P predicate, N object) {
        this.addTriple(subject, predicate, object);
        if (!ax.isAnnotated()) {
            return;
        }
        this.translateAnonymousNode(ax);
        this.addTriple((Serializable)this.getNode(ax), this.getPredicateNode(OWLRDFVocabulary.RDF_TYPE.getIRI()), this.getResourceNode(OWLRDFVocabulary.OWL_AXIOM.getIRI()));
        this.addTriple((Serializable)this.getNode(ax), this.getPredicateNode(OWLRDFVocabulary.OWL_ANNOTATED_SOURCE.getIRI()), subject);
        this.addTriple((Serializable)this.getNode(ax), this.getPredicateNode(OWLRDFVocabulary.OWL_ANNOTATED_PROPERTY.getIRI()), predicate);
        this.addTriple((Serializable)this.getNode(ax), this.getPredicateNode(OWLRDFVocabulary.OWL_ANNOTATED_TARGET.getIRI()), object);
        this.translateAnnotations(ax);
    }

    private void translateAnnotations(OWLAxiom ax) {
        this.translateAnonymousNode(ax);
        ax.annotations().forEach(a -> this.translateAnnotation(ax, (OWLAnnotation)a));
    }

    private void translateAnnotation(OWLObject subject, OWLAnnotation annotation) {
        this.addTriple(subject, annotation.getProperty().getIRI(), (OWLObject)annotation.getValue());
        annotation.getProperty().accept(this);
        if (annotation.getValue() instanceof OWLAnonymousIndividual) {
            OWLAnonymousIndividual ind = (OWLAnonymousIndividual)annotation.getValue();
            this.translateAnonymousNode(ind);
            this.processIfAnonymous(ind);
        }
        if (annotation.annotations().count() == 0L) {
            return;
        }
        this.translateAnonymousNode(annotation);
        this.addTriple((OWLObject)annotation, OWLRDFVocabulary.RDF_TYPE.getIRI(), OWLRDFVocabulary.OWL_ANNOTATION.getIRI());
        this.addTriple((OWLObject)annotation, OWLRDFVocabulary.OWL_ANNOTATED_SOURCE.getIRI(), subject);
        this.addTriple((OWLObject)annotation, OWLRDFVocabulary.OWL_ANNOTATED_PROPERTY.getIRI(), annotation.getProperty().getIRI());
        this.addTriple((OWLObject)annotation, OWLRDFVocabulary.OWL_ANNOTATED_TARGET.getIRI(), (OWLObject)annotation.getValue());
        annotation.annotations().forEach(a -> this.translateAnnotation(annotation, (OWLAnnotation)a));
    }

    @Override
    public void visit(OWLAnnotation node) {
        throw new OWLRuntimeException("The translator should not be used directly on instances of OWLAnnotation because an annotation cannot be translated without a subject.");
    }

    private N translateAnonymousNode(OWLObject object) {
        R anonymousNode = this.getAnonymousNode(object);
        if (object.isAnonymousExpression()) {
            this.expressionMap.put(object, anonymousNode);
        } else {
            this.nodeMap.put(object, anonymousNode);
        }
        return (N)anonymousNode;
    }

    @Nullable
    public <T> T getMappedNode(OWLObject object) {
        return (T)this.expressionMap.getOrDefault(object, this.nodeMap.get(object));
    }

    public void addTriple(R subject, IRI pred, IRI object) {
        this.addTriple(subject, this.getPredicateNode(pred), this.getResourceNode(object));
    }

    public void addTriple(R subject, IRI pred, OWLObject object) {
        this.addTriple(subject, this.getPredicateNode(pred), (Serializable)this.getNode(object));
    }

    protected abstract R getResourceNode(IRI var1);

    protected abstract P getPredicateNode(IRI var1);

    protected abstract R getAnonymousNode(Object var1);

    protected abstract L getLiteralNode(OWLLiteral var1);

    protected abstract void addTriple(R var1, P var2, N var3);

    private <O> O getNode(OWLObject obj) {
        Object node = this.getMappedNode(obj);
        if (node == null) {
            obj.accept(this);
            node = this.getMappedNode(obj);
            if (node == null) {
                throw new IllegalStateException("Node is null. Attempting to get node for " + obj);
            }
        }
        return (O)node;
    }

    private <O> O getNode(OWLObject obj, OWLObject s, IRI p) {
        if (obj.isAnonymousExpression()) {
            OWLObject[] context = this.expressionContext.get(obj);
            if (context == null) {
                context = new OWLObject[]{s, p, obj};
                this.expressionContext.put(obj, context);
                return this.getNode(obj);
            }
            if (context[0].equals(s) && context[1].equals(p)) {
                return this.getNode(context[2]);
            }
            context = new OWLObject[]{s, p, obj};
            this.expressionContext.put(obj, context);
            return this.getNode(obj);
        }
        return this.getNode(obj);
    }

    private R translateList(List<? extends OWLObject> list) {
        return this.translateList(list, OWLRDFVocabulary.RDF_LIST.getIRI());
    }

    private R translateList(List<? extends OWLObject> list, IRI listType) {
        int listSize;
        if (list.isEmpty()) {
            return this.getResourceNode(OWLRDFVocabulary.RDF_NIL.getIRI());
        }
        R main = this.getResourceNode(OWLRDFVocabulary.RDF_NIL.getIRI());
        for (int i = listSize = list.size() - 1; i >= 0; --i) {
            R anonNode = this.getAnonymousNode(list.subList(i, listSize));
            this.addTriple(anonNode, this.getPredicateNode(OWLRDFVocabulary.RDF_TYPE.getIRI()), this.getResourceNode(listType));
            OWLObject obj = list.get(i);
            this.addTriple(anonNode, this.getPredicateNode(OWLRDFVocabulary.RDF_FIRST.getIRI()), (Serializable)this.getNode(obj));
            this.addTriple(anonNode, this.getPredicateNode(OWLRDFVocabulary.RDF_REST.getIRI()), main);
            main = anonNode;
        }
        return main;
    }

    private void addTriple(OWLObject subject, IRI pred, IRI object) {
        this.addTriple((Serializable)this.getNode(subject), this.getPredicateNode(pred), this.getResourceNode(object));
    }

    private void addTriple(OWLObject subject, IRI pred, OWLObject object) {
        this.addTriple((Serializable)this.getNode(subject), this.getPredicateNode(pred), (Serializable)this.getNode(object));
    }

    private void addListTriples(OWLObject subject, IRI pred, Stream<? extends OWLObject> objects) {
        this.addTriple((Serializable)this.getNode(subject), this.getPredicateNode(pred), this.translateList(OWLAPIStreamUtils.asList(objects.sorted())));
    }

    private void addTriple(OWLObject subject, IRI pred, Stream<? extends OWLObject> objects, IRI listType) {
        this.addTriple((Serializable)this.getNode(subject), this.getPredicateNode(pred), this.translateList(OWLAPIStreamUtils.asList(objects), listType));
    }

    private OWLLiteral toTypedConstant(int i) {
        return this.manager.getOWLDataFactory().getOWLLiteral(Integer.toString(i), this.manager.getOWLDataFactory().getOWLDatatype(XSDVocabulary.NON_NEGATIVE_INTEGER.getIRI()));
    }

    private void processIfAnonymous(Stream<? extends OWLIndividual> inds, @Nullable OWLAxiom root) {
        inds.sorted().forEach(i -> this.processIfAnonymous((OWLIndividual)i, root));
    }

    private void processIfAnonymous(OWLIndividual ind, @Nullable OWLAxiom root) {
        this.process(ind, x -> !Objects.equals(x, root));
    }

    protected void process(OWLIndividual ind, Predicate<OWLAxiom> include) {
        if (!this.currentIndividuals.contains(ind)) {
            this.currentIndividuals.add(ind);
            if (ind.isAnonymous()) {
                this.ont.axioms(ind).filter(include).map(this.desharer::deshareObject).sorted().forEach(this::translate);
                this.ont.annotationAssertionAxioms(ind.asOWLAnonymousIndividual()).filter(include).map(this.desharer::deshareObject).sorted().forEach(this::translate);
            }
            this.currentIndividuals.remove(ind);
        }
    }

    private void processIfAnonymous(OWLIndividual ind) {
        this.process(ind, x -> true);
    }

    private void addPairwise(OWLAxiom axiom, Stream<? extends OWLObject> objects, IRI iri) {
        List<? extends OWLObject> objectList = OWLAPIStreamUtils.asList(objects.sorted());
        for (int i = 0; i < objectList.size(); ++i) {
            for (int j = i; j < objectList.size(); ++j) {
                if (i == j) continue;
                this.addSingleTripleAxiom(axiom, objectList.get(i), iri, objectList.get(j));
            }
        }
    }

    private void addStrongTyping(OWLEntity entity) {
        if (!this.useStrongTyping) {
            return;
        }
        if (!OWLDocumentFormat.isMissingType(entity, this.ont)) {
            return;
        }
        this.addTriple((OWLObject)entity, OWLRDFVocabulary.RDF_TYPE.getIRI(), entity.getEntityType().getIRI());
    }

    public RDFGraph getGraph() {
        return this.graph;
    }

    public void reset() {
        this.graph = new RDFGraph();
    }
}

