/*
 * Decompiled with CFR 0.152.
 */
package uk.ac.manchester.cs.owl.explanation.ordering;

import java.io.PrintWriter;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.Comparator;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import javax.annotation.Nullable;
import org.semanticweb.owlapi.util.OWLAPIPreconditions;
import uk.ac.manchester.cs.owl.explanation.ordering.NodeRenderer;
import uk.ac.manchester.cs.owl.explanation.ordering.Tree;

public class MutableTree<N>
implements Tree<N> {
    @Nullable
    private final N userObject;
    @Nullable
    private MutableTree<N> parent;
    private final List<MutableTree<N>> children;
    private final Map<Tree<N>, Object> child2EdgeMap;
    private NodeRenderer<N> toStringRenderer;

    public MutableTree(N userObject) {
        this.userObject = userObject;
        this.children = new ArrayList<MutableTree<N>>();
        this.child2EdgeMap = new HashMap<Tree<N>, Object>();
        this.toStringRenderer = Object::toString;
    }

    @Override
    @Nullable
    public N getUserObject() {
        return this.userObject;
    }

    public void setParent(MutableTree<N> parent) {
        if (this.parent != null) {
            this.parent.children.remove(this);
        }
        this.parent = parent;
        this.parent.children.add(this);
    }

    public void addChild(MutableTree<N> child) {
        this.children.add(child);
        child.parent = this;
    }

    public void addChild(MutableTree<N> child, Object edge) {
        this.addChild(child);
        this.child2EdgeMap.put(child, edge);
    }

    public void removeChild(MutableTree<N> child) {
        this.children.remove(child);
        child.parent = null;
    }

    @Override
    @Nullable
    public Object getEdge(Tree<N> child) {
        return this.child2EdgeMap.get(child);
    }

    @Override
    public void sortChildren(Comparator<Tree<N>> comparator) {
        Collections.sort(this.children, comparator);
    }

    public void clearChildren() {
        this.children.forEach(c -> {
            c.parent = null;
        });
        this.children.clear();
    }

    @Override
    @Nullable
    public Tree<N> getParent() {
        return this.parent;
    }

    @Override
    public List<Tree<N>> getChildren() {
        return new ArrayList<Tree<N>>(this.children);
    }

    @Override
    public int getChildCount() {
        return this.children.size();
    }

    @Override
    public boolean isRoot() {
        return this.parent == null;
    }

    @Override
    public boolean isLeaf() {
        return this.children.isEmpty();
    }

    @Override
    public Tree<N> getRoot() {
        if (this.parent == null) {
            return this;
        }
        return OWLAPIPreconditions.verifyNotNull(this.parent).getRoot();
    }

    @Override
    public List<Tree<N>> getPathToRoot() {
        ArrayList<Tree<N>> path = new ArrayList<Tree<N>>();
        path.add(0, this);
        for (Tree<N> par = this.parent; par != null; par = par.getParent()) {
            path.add(0, par);
        }
        return path;
    }

    @Override
    public List<N> getUserObjectPathToRoot() {
        ArrayList path = new ArrayList();
        path.add(0, this.getUserObject());
        for (Tree<N> par = this.parent; par != null; par = par.getParent()) {
            path.add(0, par.getUserObject());
        }
        return path;
    }

    @Override
    public Set<N> getUserObjectClosure() {
        HashSet objects = new HashSet();
        this.getUserObjectClosure(this, objects);
        return objects;
    }

    private void getUserObjectClosure(Tree<N> tree, Set<N> bin) {
        bin.add(tree.getUserObject());
        tree.getChildren().forEach(c -> this.getUserObjectClosure((Tree<N>)c, bin));
    }

    @Override
    public void dump(PrintWriter writer) {
        this.dump(writer, 0);
    }

    @Override
    public void dump(PrintWriter writer, int indent) {
        int depth = this.getPathToRoot().size();
        char[] chars = new char[depth + indent];
        Arrays.fill(chars, '\t');
        String tabs = new String(chars);
        writer.print(tabs);
        String ren = this.toStringRenderer.render(this);
        ren = ren.replace("\n", "\n" + tabs);
        writer.println(ren);
        for (Tree<N> child : this.getChildren()) {
            Object edge = this.getEdge(child);
            if (edge != null) {
                writer.print("\t--- ");
                writer.print(edge);
                writer.print(" ---\n\n");
            }
            child.dump(writer, indent);
        }
        writer.flush();
    }

    @Override
    public void setNodeRenderer(NodeRenderer<N> renderer) {
        this.toStringRenderer = renderer;
        this.children.forEach(c -> c.setNodeRenderer(this.toStringRenderer));
    }

    @Override
    public List<N> fillDepthFirst() {
        ArrayList results = new ArrayList();
        this.fillDepthFirst(this, results);
        return results;
    }

    private void fillDepthFirst(Tree<N> tree, List<N> bin) {
        bin.add(tree.getUserObject());
        tree.getChildren().forEach(c -> this.fillDepthFirst((Tree<N>)c, bin));
    }

    public void replace(MutableTree<N> tree) {
        OWLAPIPreconditions.verifyNotNull(this.parent, (String)"parent cannot be null here").children.remove(this);
        OWLAPIPreconditions.verifyNotNull(this.parent, (String)"parent cannot be null here").children.add(tree);
        this.parent = null;
        tree.children.clear();
        tree.children.addAll(this.children);
        this.children.clear();
    }

    public String toString() {
        if (this.userObject != null) {
            return this.userObject.toString();
        }
        return "";
    }

    public int getSize() {
        return this.getUserObjectClosure().size();
    }

    public int getMaxDepth() {
        return this.getMaxDepth(this);
    }

    private int getMaxDepth(Tree<N> tree) {
        int maxChildDepth = tree.getPathToRoot().size();
        return tree.getChildren().stream().mapToInt(this::getMaxDepth).max().orElse(maxChildDepth);
    }
}

