/*
 * Decompiled with CFR 0.152.
 */
package org.semanticweb.owlapi.rdf.rdfxml.renderer;

import java.io.PrintWriter;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Set;
import org.semanticweb.owlapi.io.RDFLiteral;
import org.semanticweb.owlapi.io.RDFNode;
import org.semanticweb.owlapi.io.RDFResource;
import org.semanticweb.owlapi.io.RDFResourceBlankNode;
import org.semanticweb.owlapi.io.RDFTriple;
import org.semanticweb.owlapi.io.XMLUtils;
import org.semanticweb.owlapi.model.IRI;
import org.semanticweb.owlapi.model.OWLAnnotationProperty;
import org.semanticweb.owlapi.model.OWLClass;
import org.semanticweb.owlapi.model.OWLDataProperty;
import org.semanticweb.owlapi.model.OWLDatatype;
import org.semanticweb.owlapi.model.OWLDocumentFormat;
import org.semanticweb.owlapi.model.OWLEntity;
import org.semanticweb.owlapi.model.OWLNamedIndividual;
import org.semanticweb.owlapi.model.OWLObjectProperty;
import org.semanticweb.owlapi.model.OWLOntology;
import org.semanticweb.owlapi.model.OWLOntologyManager;
import org.semanticweb.owlapi.rdf.RDFRendererBase;
import org.semanticweb.owlapi.rdf.rdfxml.renderer.RDFXMLNamespaceManager;
import org.semanticweb.owlapi.rdf.rdfxml.renderer.RDFXMLWriter;
import org.semanticweb.owlapi.rdf.rdfxml.renderer.XMLWriterImpl;
import org.semanticweb.owlapi.util.AnnotationValueShortFormProvider;
import org.semanticweb.owlapi.util.OWLAPIPreconditions;
import org.semanticweb.owlapi.util.ShortFormProvider;
import org.semanticweb.owlapi.util.VersionInfo;
import org.semanticweb.owlapi.vocab.OWLRDFVocabulary;

public class RDFXMLRenderer
extends RDFRendererBase {
    private final RDFXMLWriter writer;
    private final Set<RDFResource> pending = new HashSet<RDFResource>();
    private final RDFXMLNamespaceManager qnameManager;
    private final OWLDocumentFormat format;
    private final ShortFormProvider labelMaker;

    public RDFXMLRenderer(OWLOntology ontology, PrintWriter w) {
        this(ontology, w, OWLAPIPreconditions.verifyNotNull(ontology.getFormat()));
    }

    public RDFXMLRenderer(OWLOntology ontology, PrintWriter w, OWLDocumentFormat format) {
        super(OWLAPIPreconditions.checkNotNull(ontology, "ontology cannot be null"), OWLAPIPreconditions.checkNotNull(format, "format cannot be null"), ontology.getOWLOntologyManager().getOntologyWriterConfiguration());
        this.format = OWLAPIPreconditions.checkNotNull(format, "format cannot be null");
        this.qnameManager = new RDFXMLNamespaceManager(ontology, format);
        String defaultNamespace = this.qnameManager.getDefaultNamespace();
        String base = RDFXMLRenderer.base(defaultNamespace);
        this.writer = new RDFXMLWriter(new XMLWriterImpl(OWLAPIPreconditions.checkNotNull(w, "w cannot be null"), this.qnameManager, base, ontology.getOWLOntologyManager().getOntologyWriterConfiguration()));
        HashMap<OWLAnnotationProperty, List<String>> prefLangMap = new HashMap<OWLAnnotationProperty, List<String>>();
        OWLOntologyManager manager = ontology.getOWLOntologyManager();
        OWLAnnotationProperty labelProp = manager.getOWLDataFactory().getRDFSLabel();
        this.labelMaker = new AnnotationValueShortFormProvider(Collections.singletonList(labelProp), prefLangMap, manager);
    }

    private static String base(String defaultNamespace) {
        String base = defaultNamespace.endsWith("#") ? defaultNamespace.substring(0, defaultNamespace.length() - 1) : defaultNamespace;
        return base;
    }

    @Override
    protected void beginDocument() {
        this.writer.startDocument();
    }

    @Override
    protected void endDocument() {
        this.writer.endDocument();
        this.writer.writeComment(VersionInfo.getVersionInfo().getGeneratedByMessage());
        if (!this.format.isAddMissingTypes()) {
            this.writer.writeComment("Warning: type declarations were not added automatically.");
        }
    }

    @Override
    protected void writeIndividualComments(OWLNamedIndividual ind) {
        this.writeCommentForEntity("ind cannot be null", ind);
    }

    @Override
    protected void writeAnnotationPropertyComment(OWLAnnotationProperty prop) {
        this.writeCommentForEntity("prop cannot be null", prop);
    }

    @Override
    protected void writeClassComment(OWLClass cls) {
        this.writeCommentForEntity("cls cannot be null", cls);
    }

    @Override
    protected void writeDataPropertyComment(OWLDataProperty prop) {
        this.writeCommentForEntity("prop cannot be null", prop);
    }

    @Override
    protected void writeDatatypeComment(OWLDatatype datatype) {
        this.writeCommentForEntity("datatype cannot be null", datatype);
    }

    @Override
    protected void writeObjectPropertyComment(OWLObjectProperty prop) {
        this.writeCommentForEntity("prop cannot be null", prop);
    }

    @Override
    protected void writeBanner(String name) {
        this.writer.writeComment("\n///////////////////////////////////////////////////////////////////////////////////////\n//\n// " + OWLAPIPreconditions.checkNotNull(name, "name cannot be null") + "\n//\n///////////////////////////////////////////////////////////////////////////////////////\n");
    }

    private void writeCommentForEntity(String msg, OWLEntity entity) {
        if (this.config.shouldUseBanners()) {
            OWLAPIPreconditions.checkNotNull(entity, msg);
            String iriString = entity.getIRI().toString();
            if (this.config.isLabelsAsBanner()) {
                String labelString = this.labelMaker.getShortForm(entity);
                String commentString = !iriString.equals(labelString) ? labelString : iriString;
                this.writer.writeComment(XMLUtils.escapeXML(commentString));
            } else {
                this.writer.writeComment(XMLUtils.escapeXML(iriString));
            }
        }
    }

    @Override
    public void render(RDFResource node) {
        OWLAPIPreconditions.checkNotNull(node, "node cannot be null");
        if (this.pending.contains(node)) {
            return;
        }
        this.pending.add(node);
        RDFTriple candidatePrettyPrintTypeTriple = null;
        Collection<RDFTriple> triples = this.getRDFGraph().getTriplesForSubject(node);
        for (RDFTriple triple : triples) {
            IRI propertyIRI = triple.getPredicate().getIRI();
            if (!propertyIRI.equals(OWLRDFVocabulary.RDF_TYPE.getIRI()) || triple.getObject().isAnonymous() || !OWLRDFVocabulary.BUILT_IN_VOCABULARY_IRIS.contains(triple.getObject().getIRI()) || !this.prettyPrintedTypes.contains(triple.getObject().getIRI())) continue;
            candidatePrettyPrintTypeTriple = triple;
        }
        if (candidatePrettyPrintTypeTriple == null) {
            this.writer.writeStartElement(OWLRDFVocabulary.RDF_DESCRIPTION.getIRI());
        } else {
            this.writer.writeStartElement(candidatePrettyPrintTypeTriple.getObject().getIRI());
        }
        if (!node.isAnonymous()) {
            this.writer.writeAboutAttribute(node.getIRI());
        } else if (node.isIndividual() && node.shouldOutputId()) {
            this.writer.writeNodeIDAttribute(node);
        }
        for (RDFTriple triple : triples) {
            if (candidatePrettyPrintTypeTriple != null && candidatePrettyPrintTypeTriple.equals(triple)) continue;
            this.writer.writeStartElement(triple.getPredicate().getIRI());
            triple = this.remapNodesIfNecessary(node, triple);
            RDFNode objectNode = triple.getObject();
            if (!objectNode.isLiteral()) {
                RDFResource objectRes = (RDFResource)objectNode;
                if (objectRes.isAnonymous()) {
                    if (this.isObjectList(objectRes)) {
                        this.writer.writeParseTypeAttribute();
                        ArrayList<RDFNode> list = new ArrayList<RDFNode>();
                        this.toJavaList(objectRes, list);
                        for (RDFNode n : list) {
                            if (n.isAnonymous()) {
                                this.render((RDFResourceBlankNode)n);
                                continue;
                            }
                            if (n.isLiteral()) {
                                RDFLiteral litNode = (RDFLiteral)n;
                                this.writer.writeStartElement(OWLRDFVocabulary.RDFS_LITERAL.getIRI());
                                if (!litNode.isPlainLiteral()) {
                                    this.writer.writeDatatypeAttribute(litNode.getDatatype());
                                } else if (litNode.hasLang()) {
                                    this.writer.writeLangAttribute(litNode.getLang());
                                }
                                this.writer.writeTextContent(litNode.getLexicalValue());
                                this.writer.writeEndElement();
                                continue;
                            }
                            this.writer.writeStartElement(OWLRDFVocabulary.RDF_DESCRIPTION.getIRI());
                            this.writer.writeAboutAttribute(n.getIRI());
                            this.writer.writeEndElement();
                        }
                    } else if (objectRes.equals(node)) {
                        this.writer.writeNodeIDAttribute(objectRes);
                    } else {
                        this.render(objectRes);
                    }
                } else {
                    this.writer.writeResourceAttribute(objectRes.getIRI());
                }
            } else {
                RDFLiteral rdfLiteralNode = (RDFLiteral)objectNode;
                if (rdfLiteralNode.hasLang()) {
                    this.writer.writeLangAttribute(rdfLiteralNode.getLang());
                } else if (!rdfLiteralNode.isPlainLiteral()) {
                    this.writer.writeDatatypeAttribute(rdfLiteralNode.getDatatype());
                }
                this.writer.writeTextContent(rdfLiteralNode.getLexicalValue());
            }
            this.writer.writeEndElement();
        }
        this.writer.writeEndElement();
        this.pending.remove(node);
    }

    public Set<OWLEntity> getUnserialisableEntities() {
        return this.qnameManager.getEntitiesWithInvalidQNames();
    }
}

