/*
 * Decompiled with CFR 0.152.
 */
package org.semanticweb.owlapi.rdf.rdfxml.parser;

import com.google.common.collect.ArrayListMultimap;
import com.google.common.collect.Sets;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.Set;
import java.util.concurrent.atomic.AtomicInteger;
import java.util.function.Consumer;
import java.util.stream.Stream;
import javax.annotation.Nullable;
import org.semanticweb.owlapi.formats.RDFDocumentFormat;
import org.semanticweb.owlapi.io.OWLParserException;
import org.semanticweb.owlapi.io.RDFLiteral;
import org.semanticweb.owlapi.io.RDFOntologyHeaderStatus;
import org.semanticweb.owlapi.io.RDFParserMetaData;
import org.semanticweb.owlapi.io.RDFResource;
import org.semanticweb.owlapi.io.RDFResourceBlankNode;
import org.semanticweb.owlapi.io.RDFResourceIRI;
import org.semanticweb.owlapi.io.RDFResourceParseError;
import org.semanticweb.owlapi.io.RDFTriple;
import org.semanticweb.owlapi.model.AddImport;
import org.semanticweb.owlapi.model.AddOntologyAnnotation;
import org.semanticweb.owlapi.model.EntityType;
import org.semanticweb.owlapi.model.IRI;
import org.semanticweb.owlapi.model.NodeID;
import org.semanticweb.owlapi.model.OWLAnnotation;
import org.semanticweb.owlapi.model.OWLAnnotationAssertionAxiom;
import org.semanticweb.owlapi.model.OWLAnnotationAxiom;
import org.semanticweb.owlapi.model.OWLAnnotationProperty;
import org.semanticweb.owlapi.model.OWLAnnotationSubject;
import org.semanticweb.owlapi.model.OWLAnnotationValue;
import org.semanticweb.owlapi.model.OWLAnonymousIndividual;
import org.semanticweb.owlapi.model.OWLAxiom;
import org.semanticweb.owlapi.model.OWLClass;
import org.semanticweb.owlapi.model.OWLClassExpression;
import org.semanticweb.owlapi.model.OWLDataFactory;
import org.semanticweb.owlapi.model.OWLDataProperty;
import org.semanticweb.owlapi.model.OWLDataPropertyExpression;
import org.semanticweb.owlapi.model.OWLDataRange;
import org.semanticweb.owlapi.model.OWLDatatype;
import org.semanticweb.owlapi.model.OWLEntity;
import org.semanticweb.owlapi.model.OWLFacetRestriction;
import org.semanticweb.owlapi.model.OWLImportsDeclaration;
import org.semanticweb.owlapi.model.OWLIndividual;
import org.semanticweb.owlapi.model.OWLLiteral;
import org.semanticweb.owlapi.model.OWLNamedIndividual;
import org.semanticweb.owlapi.model.OWLObjectProperty;
import org.semanticweb.owlapi.model.OWLObjectPropertyExpression;
import org.semanticweb.owlapi.model.OWLOntology;
import org.semanticweb.owlapi.model.OWLOntologyID;
import org.semanticweb.owlapi.model.OWLOntologyLoaderConfiguration;
import org.semanticweb.owlapi.model.OWLOntologyManager;
import org.semanticweb.owlapi.model.OWLRuntimeException;
import org.semanticweb.owlapi.model.SetOntologyID;
import org.semanticweb.owlapi.model.parameters.Imports;
import org.semanticweb.owlapi.model.providers.AnonymousIndividualByIdProvider;
import org.semanticweb.owlapi.rdf.rdfxml.parser.IRIProvider;
import org.semanticweb.owlapi.rdf.rdfxml.parser.LiteralTripleIterator;
import org.semanticweb.owlapi.rdf.rdfxml.parser.RDFConsumer;
import org.semanticweb.owlapi.rdf.rdfxml.parser.ResourceTripleIterator;
import org.semanticweb.owlapi.rdf.rdfxml.parser.Translators;
import org.semanticweb.owlapi.rdf.rdfxml.parser.TripleHandlers;
import org.semanticweb.owlapi.rdf.rdfxml.parser.TripleLogger;
import org.semanticweb.owlapi.util.AnonymousNodeChecker;
import org.semanticweb.owlapi.util.AnonymousNodeCheckerImpl;
import org.semanticweb.owlapi.util.CollectionFactory;
import org.semanticweb.owlapi.util.OWLAPIPreconditions;
import org.semanticweb.owlapi.util.OWLAPIStreamUtils;
import org.semanticweb.owlapi.util.RemappingIndividualProvider;
import org.semanticweb.owlapi.vocab.Namespaces;
import org.semanticweb.owlapi.vocab.OWL2Datatype;
import org.semanticweb.owlapi.vocab.OWLFacet;
import org.semanticweb.owlapi.vocab.OWLRDFVocabulary;
import org.semanticweb.owlapi.vocab.XSDVocabulary;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class OWLRDFConsumer
implements RDFConsumer,
AnonymousNodeChecker,
AnonymousIndividualByIdProvider {
    private static final String DAML_OIL = "http://www.daml.org/2001/03/daml+oil#";
    private static final Logger LOGGER = LoggerFactory.getLogger(OWLRDFConsumer.class);
    final TripleLogger tripleLogger;
    private final OWLOntologyLoaderConfiguration configuration;
    private final Set<IRI> classIRIs = CollectionFactory.createSet();
    private final Set<IRI> objectPropertyIRIs = CollectionFactory.createSet();
    private final Set<IRI> dataPropertyIRIs = CollectionFactory.createSet();
    private final Set<IRI> propertyIRIs = CollectionFactory.createSet();
    private final Set<IRI> individualIRIs = CollectionFactory.createSet();
    private final Set<IRI> annPropertyIRIs = CollectionFactory.createSet();
    private final Set<IRI> annotationIRIs = CollectionFactory.createSet();
    private final Set<IRI> dataRangeIRIs = CollectionFactory.createSet();
    @Nullable
    private IRI firstOntologyIRI;
    private final Set<IRI> ontologyIRIs = CollectionFactory.createSet();
    private final Set<IRI> restrictionIRIs = CollectionFactory.createSet();
    private final Map<IRI, IRI> listRestTripleMap = CollectionFactory.createMap();
    private final Map<IRI, IRI> listFirstResourceTripleMap = CollectionFactory.createMap();
    private final Map<IRI, OWLLiteral> listFirstLiteralTripleMap = CollectionFactory.createMap();
    private final Set<IRI> axioms = CollectionFactory.createSet();
    private final Map<IRI, Object> sharedAnonymousNodes = CollectionFactory.createMap();
    private final Set<OWLAnnotation> pendingAnnotations = CollectionFactory.createSet();
    private final Map<IRI, Set<IRI>> annotatedAnonSource2AnnotationMap = CollectionFactory.createMap();
    private final OWLOntology ontology;
    @Nullable
    private RDFDocumentFormat ontologyFormat;
    private final OWLDataFactory df;
    @Nullable
    private OWLAxiom lastAddedAxiom;
    private final Map<IRI, IRI> synonymMap = CollectionFactory.createMap();
    private final Set<IRI> swrlRules = CollectionFactory.createSet();
    private final Set<IRI> swrlIndividualPropertyAtoms = CollectionFactory.createSet();
    private final Set<IRI> swrlDataValuedPropertyAtoms = CollectionFactory.createSet();
    private final Set<IRI> swrlClassAtoms = CollectionFactory.createSet();
    private final Set<IRI> swrlDataRangeAtoms = CollectionFactory.createSet();
    private final Set<IRI> swrlBuiltInAtoms = CollectionFactory.createSet();
    private final Set<IRI> swrlVariables = CollectionFactory.createSet();
    private final Set<IRI> swrlSameAsAtoms = CollectionFactory.createSet();
    private final Set<IRI> swrlDifferentFromAtoms = CollectionFactory.createSet();
    @Nullable
    private IRIProvider iriProvider;
    private final Collection<OWLAnnotationAxiom> parsedAnnotationAxioms = new ArrayList<OWLAnnotationAxiom>();
    private final Collection<OWLAxiom> axiomsToBeRemoved = new ArrayList<OWLAxiom>();
    private boolean parsedAllTriples = false;
    final TripleHandlers.HandlerAccessor handlerAccessor;
    final Translators.TranslatorAccessor translatorAccessor;
    private final AnonymousNodeChecker nodeCheckerDelegate;
    private final ArrayListMultimap<IRI, Class<?>> guessedDeclarations = ArrayListMultimap.create();
    private final Map<IRI, OWLObjectPropertyExpression> translatedProperties = CollectionFactory.createMap();
    private final Map<IRI, Map<IRI, Collection<IRI>>> resTriplesBySubject = CollectionFactory.createMap();
    private final Map<IRI, Map<IRI, IRI>> singleValuedResTriplesByPredicate = CollectionFactory.createMap();
    private final Map<IRI, Map<IRI, Collection<OWLLiteral>>> litTriplesBySubject = CollectionFactory.createMap();
    private final Map<IRI, Map<IRI, OWLLiteral>> singleValuedLitTriplesByPredicate = CollectionFactory.createMap();
    private final Map<IRI, IRI> remappedIRIs = CollectionFactory.createMap();
    private final Map<String, IRI> remappedIRIStrings = CollectionFactory.createMap();
    private final Map<String, IRI> IRIMap = CollectionFactory.createMap();
    private static final AtomicInteger ERRORCOUNTER = new AtomicInteger(0);
    private static final Set<IRI> entityTypes = Sets.newHashSet((Object[])new IRI[]{OWLRDFVocabulary.OWL_CLASS.getIRI(), OWLRDFVocabulary.OWL_OBJECT_PROPERTY.getIRI(), OWLRDFVocabulary.OWL_DATA_PROPERTY.getIRI(), OWLRDFVocabulary.OWL_ANNOTATION_PROPERTY.getIRI(), OWLRDFVocabulary.RDFS_DATATYPE.getIRI(), OWLRDFVocabulary.OWL_NAMED_INDIVIDUAL.getIRI()});
    RemappingIndividualProvider anonProvider;

    public OWLRDFConsumer(OWLOntology ontology, OWLOntologyLoaderConfiguration configuration) {
        this(ontology, new AnonymousNodeCheckerImpl(), configuration);
    }

    public OWLRDFConsumer(OWLOntology ontology, AnonymousNodeChecker checker, OWLOntologyLoaderConfiguration configuration) {
        this.nodeCheckerDelegate = checker;
        this.ontology = ontology;
        this.df = ontology.getOWLOntologyManager().getOWLDataFactory();
        this.anonProvider = new RemappingIndividualProvider(ontology.getOWLOntologyManager().getOntologyConfigurator(), this.df);
        this.configuration = configuration;
        this.handlerAccessor = new TripleHandlers.HandlerAccessor(this);
        this.translatorAccessor = new Translators.TranslatorAccessor(this);
        OWLRDFVocabulary.BUILT_IN_AP_IRIS.forEach(this.annPropertyIRIs::add);
        this.dataRangeIRIs.add(OWLRDFVocabulary.RDFS_LITERAL.getIRI());
        Stream.of(OWL2Datatype.values()).forEach(v -> this.dataRangeIRIs.add(v.getIRI()));
        if (!configuration.isStrict()) {
            Stream.of(XSDVocabulary.values()).forEach(v -> this.dataRangeIRIs.add(v.getIRI()));
        }
        this.classIRIs.add(OWLRDFVocabulary.OWL_THING.getIRI());
        this.classIRIs.add(OWLRDFVocabulary.OWL_NOTHING.getIRI());
        this.objectPropertyIRIs.add(OWLRDFVocabulary.OWL_TOP_OBJECT_PROPERTY.getIRI());
        this.objectPropertyIRIs.add(OWLRDFVocabulary.OWL_BOTTOM_OBJECT_PROPERTY.getIRI());
        this.dataPropertyIRIs.add(OWLRDFVocabulary.OWL_TOP_DATA_PROPERTY.getIRI());
        this.dataPropertyIRIs.add(OWLRDFVocabulary.OWL_BOTTOM_DATA_PROPERTY.getIRI());
        this.setupSynonymMap();
        this.setupSinglePredicateMaps();
        this.importsClosureChanged();
        if (this.ontology.getOntologyID().getOntologyIRI().isPresent()) {
            this.addOntology(this.ontology.getOntologyID().getOntologyIRI().get());
        }
        this.tripleLogger = new TripleLogger();
    }

    @Override
    public void addPrefix(String abbreviation, String value) {
        if (this.getOntologyFormat().isPrefixOWLDocumentFormat()) {
            this.getOntologyFormat().asPrefixOWLDocumentFormat().setPrefix(abbreviation, value);
        }
    }

    protected void setIRIProvider(IRIProvider iriProvider) {
        this.iriProvider = iriProvider;
    }

    private void setupSinglePredicateMaps() {
        Stream.of(OWLRDFVocabulary.OWL_ON_PROPERTY, OWLRDFVocabulary.OWL_SOME_VALUES_FROM, OWLRDFVocabulary.OWL_ALL_VALUES_FROM, OWLRDFVocabulary.OWL_ON_CLASS, OWLRDFVocabulary.OWL_ON_DATA_RANGE).forEach(v -> this.singleValuedResTriplesByPredicate.put(v.getIRI(), CollectionFactory.createMap()));
    }

    private void setupSynonymMap() {
        this.synonymMap.clear();
        this.synonymMap.put(IRI.create(Namespaces.OWL.getPrefixIRI(), "valuesFrom"), OWLRDFVocabulary.OWL_ON_CLASS.getIRI());
        if (!this.configuration.isStrict()) {
            this.addDAMLOILVocabulary();
            this.addIntermediateOWLSpecVocabulary();
        }
    }

    private static IRI daml(String i) {
        return IRI.create(DAML_OIL, i);
    }

    private void addDAMLOILVocabulary() {
        this.synonymMap.put(OWLRDFConsumer.daml("subClassOf"), OWLRDFVocabulary.RDFS_SUBCLASS_OF.getIRI());
        this.synonymMap.put(OWLRDFConsumer.daml("imports"), OWLRDFVocabulary.OWL_IMPORTS.getIRI());
        this.synonymMap.put(OWLRDFConsumer.daml("range"), OWLRDFVocabulary.RDFS_RANGE.getIRI());
        this.synonymMap.put(OWLRDFConsumer.daml("hasValue"), OWLRDFVocabulary.OWL_HAS_VALUE.getIRI());
        this.synonymMap.put(OWLRDFConsumer.daml("type"), OWLRDFVocabulary.RDF_TYPE.getIRI());
        this.synonymMap.put(OWLRDFConsumer.daml("domain"), OWLRDFVocabulary.RDFS_DOMAIN.getIRI());
        this.synonymMap.put(OWLRDFConsumer.daml("versionInfo"), OWLRDFVocabulary.OWL_VERSION_INFO.getIRI());
        this.synonymMap.put(OWLRDFConsumer.daml("comment"), OWLRDFVocabulary.RDFS_COMMENT.getIRI());
        this.synonymMap.put(OWLRDFConsumer.daml("onProperty"), OWLRDFVocabulary.OWL_ON_PROPERTY.getIRI());
        this.synonymMap.put(OWLRDFConsumer.daml("toClass"), OWLRDFVocabulary.OWL_ALL_VALUES_FROM.getIRI());
        this.synonymMap.put(OWLRDFConsumer.daml("hasClass"), OWLRDFVocabulary.OWL_SOME_VALUES_FROM.getIRI());
        this.synonymMap.put(OWLRDFConsumer.daml("Restriction"), OWLRDFVocabulary.OWL_RESTRICTION.getIRI());
        this.synonymMap.put(OWLRDFConsumer.daml("Class"), OWLRDFVocabulary.OWL_CLASS.getIRI());
        this.synonymMap.put(OWLRDFConsumer.daml("Thing"), OWLRDFVocabulary.OWL_THING.getIRI());
        this.synonymMap.put(OWLRDFConsumer.daml("Nothing"), OWLRDFVocabulary.OWL_NOTHING.getIRI());
        this.synonymMap.put(OWLRDFConsumer.daml("minCardinality"), OWLRDFVocabulary.OWL_MIN_CARDINALITY.getIRI());
        this.synonymMap.put(OWLRDFConsumer.daml("cardinality"), OWLRDFVocabulary.OWL_CARDINALITY.getIRI());
        this.synonymMap.put(OWLRDFConsumer.daml("maxCardinality"), OWLRDFVocabulary.OWL_MAX_CARDINALITY.getIRI());
        this.synonymMap.put(OWLRDFConsumer.daml("inverseOf"), OWLRDFVocabulary.OWL_INVERSE_OF.getIRI());
        this.synonymMap.put(OWLRDFConsumer.daml("samePropertyAs"), OWLRDFVocabulary.OWL_EQUIVALENT_PROPERTY.getIRI());
        this.synonymMap.put(OWLRDFConsumer.daml("hasClassQ"), OWLRDFVocabulary.OWL_ON_CLASS.getIRI());
        this.synonymMap.put(OWLRDFConsumer.daml("cardinalityQ"), OWLRDFVocabulary.OWL_CARDINALITY.getIRI());
        this.synonymMap.put(OWLRDFConsumer.daml("maxCardinalityQ"), OWLRDFVocabulary.OWL_MAX_CARDINALITY.getIRI());
        this.synonymMap.put(OWLRDFConsumer.daml("minCardinalityQ"), OWLRDFVocabulary.OWL_MIN_CARDINALITY.getIRI());
        this.synonymMap.put(OWLRDFConsumer.daml("complementOf"), OWLRDFVocabulary.OWL_COMPLEMENT_OF.getIRI());
        this.synonymMap.put(OWLRDFConsumer.daml("unionOf"), OWLRDFVocabulary.OWL_UNION_OF.getIRI());
        this.synonymMap.put(OWLRDFConsumer.daml("intersectionOf"), OWLRDFVocabulary.OWL_INTERSECTION_OF.getIRI());
        this.synonymMap.put(OWLRDFConsumer.daml("label"), OWLRDFVocabulary.RDFS_LABEL.getIRI());
        this.synonymMap.put(OWLRDFConsumer.daml("ObjectProperty"), OWLRDFVocabulary.OWL_OBJECT_PROPERTY.getIRI());
        this.synonymMap.put(OWLRDFConsumer.daml("DatatypeProperty"), OWLRDFVocabulary.OWL_DATA_PROPERTY.getIRI());
    }

    private void addIntermediateOWLSpecVocabulary() {
        for (OWLRDFVocabulary v2 : OWLRDFVocabulary.values()) {
            this.addLegacyMapping(v2);
        }
        Stream.of(OWLFacet.values()).forEach(v -> Stream.of(Namespaces.OWL, Namespaces.OWL11, Namespaces.OWL2).forEach(p -> this.synonymMap.put(IRI.create(p.getPrefixIRI(), v.getShortForm()), v.getIRI())));
        this.synonymMap.put(OWLRDFVocabulary.OWL_NEGATIVE_DATA_PROPERTY_ASSERTION.getIRI(), OWLRDFVocabulary.OWL_NEGATIVE_PROPERTY_ASSERTION.getIRI());
        this.synonymMap.put(OWLRDFVocabulary.OWL_NEGATIVE_OBJECT_PROPERTY_ASSERTION.getIRI(), OWLRDFVocabulary.OWL_NEGATIVE_PROPERTY_ASSERTION.getIRI());
        this.synonymMap.put(OWLRDFVocabulary.OWL_SUBJECT.getIRI(), OWLRDFVocabulary.OWL_ANNOTATED_SOURCE.getIRI());
        this.synonymMap.put(OWLRDFVocabulary.OWL_PREDICATE.getIRI(), OWLRDFVocabulary.OWL_ANNOTATED_PROPERTY.getIRI());
        this.synonymMap.put(OWLRDFVocabulary.OWL_OBJECT.getIRI(), OWLRDFVocabulary.OWL_ANNOTATED_TARGET.getIRI());
        this.synonymMap.put(IRI.create(Namespaces.OWL.getPrefixIRI(), "cardinalityType"), OWLRDFVocabulary.OWL_ON_CLASS.getIRI());
        this.synonymMap.put(IRI.create(Namespaces.OWL.getPrefixIRI(), "dataComplementOf"), OWLRDFVocabulary.OWL_COMPLEMENT_OF.getIRI());
        this.synonymMap.put(OWLRDFVocabulary.OWL_ANTI_SYMMETRIC_PROPERTY.getIRI(), OWLRDFVocabulary.OWL_ASYMMETRIC_PROPERTY.getIRI());
        this.synonymMap.put(OWLRDFVocabulary.OWL_FUNCTIONAL_DATA_PROPERTY.getIRI(), OWLRDFVocabulary.OWL_FUNCTIONAL_PROPERTY.getIRI());
        this.synonymMap.put(OWLRDFVocabulary.OWL_FUNCTIONAL_OBJECT_PROPERTY.getIRI(), OWLRDFVocabulary.OWL_FUNCTIONAL_PROPERTY.getIRI());
        this.synonymMap.put(OWLRDFVocabulary.OWL_SUB_DATA_PROPERTY_OF.getIRI(), OWLRDFVocabulary.RDFS_SUB_PROPERTY_OF.getIRI());
        this.synonymMap.put(OWLRDFVocabulary.OWL_SUB_OBJECT_PROPERTY_OF.getIRI(), OWLRDFVocabulary.RDFS_SUB_PROPERTY_OF.getIRI());
        this.synonymMap.put(OWLRDFVocabulary.OWL_OBJECT_PROPERTY_RANGE.getIRI(), OWLRDFVocabulary.RDFS_RANGE.getIRI());
        this.synonymMap.put(OWLRDFVocabulary.OWL_DATA_PROPERTY_RANGE.getIRI(), OWLRDFVocabulary.RDFS_RANGE.getIRI());
        this.synonymMap.put(OWLRDFVocabulary.OWL_OBJECT_PROPERTY_DOMAIN.getIRI(), OWLRDFVocabulary.RDFS_DOMAIN.getIRI());
        this.synonymMap.put(OWLRDFVocabulary.OWL_DATA_PROPERTY_DOMAIN.getIRI(), OWLRDFVocabulary.RDFS_DOMAIN.getIRI());
        this.synonymMap.put(OWLRDFVocabulary.OWL_DISJOINT_DATA_PROPERTIES.getIRI(), OWLRDFVocabulary.OWL_PROPERTY_DISJOINT_WITH.getIRI());
        this.synonymMap.put(OWLRDFVocabulary.OWL_DISJOINT_OBJECT_PROPERTIES.getIRI(), OWLRDFVocabulary.OWL_PROPERTY_DISJOINT_WITH.getIRI());
        this.synonymMap.put(OWLRDFVocabulary.OWL_EQUIVALENT_DATA_PROPERTIES.getIRI(), OWLRDFVocabulary.OWL_EQUIVALENT_PROPERTY.getIRI());
        this.synonymMap.put(OWLRDFVocabulary.OWL_EQUIVALENT_OBJECT_PROPERTIES.getIRI(), OWLRDFVocabulary.OWL_EQUIVALENT_PROPERTY.getIRI());
        this.synonymMap.put(OWLRDFVocabulary.OWL_OBJECT_RESTRICTION.getIRI(), OWLRDFVocabulary.OWL_RESTRICTION.getIRI());
        this.synonymMap.put(OWLRDFVocabulary.OWL_DATA_RESTRICTION.getIRI(), OWLRDFVocabulary.OWL_RESTRICTION.getIRI());
        this.synonymMap.put(OWLRDFVocabulary.OWL_DATA_RANGE.getIRI(), OWLRDFVocabulary.RDFS_DATATYPE.getIRI());
        this.synonymMap.put(OWLRDFVocabulary.OWL_SUBJECT.getIRI(), OWLRDFVocabulary.OWL_ANNOTATED_SOURCE.getIRI());
        this.synonymMap.put(OWLRDFVocabulary.OWL_PREDICATE.getIRI(), OWLRDFVocabulary.OWL_ANNOTATED_PROPERTY.getIRI());
        this.synonymMap.put(OWLRDFVocabulary.OWL_OBJECT.getIRI(), OWLRDFVocabulary.OWL_ANNOTATED_TARGET.getIRI());
    }

    private void addLegacyMapping(OWLRDFVocabulary v) {
        this.synonymMap.put(IRI.create(Namespaces.OWL2.getPrefixIRI(), v.getShortForm()), v.getIRI());
        this.synonymMap.put(IRI.create(Namespaces.OWL11.getPrefixIRI(), v.getShortForm()), v.getIRI());
    }

    public OWLOntology getOntology() {
        return this.ontology;
    }

    public RDFDocumentFormat getOntologyFormat() {
        return OWLAPIPreconditions.verifyNotNull(this.ontologyFormat, "ontology format has not been set yet");
    }

    public void setOntologyFormat(RDFDocumentFormat format) {
        this.ontologyFormat = format;
        if (this.getOntologyFormat().isPrefixOWLDocumentFormat()) {
            this.tripleLogger.setPrefixManager(this.getOntologyFormat().asPrefixOWLDocumentFormat());
        }
    }

    public OWLDataFactory getDataFactory() {
        return this.df;
    }

    public Set<OWLAnnotation> getPendingAnnotations() {
        LinkedHashSet<OWLAnnotation> annos = new LinkedHashSet<OWLAnnotation>(this.pendingAnnotations);
        this.pendingAnnotations.clear();
        return annos;
    }

    protected void addPendingAnnotations(Set<OWLAnnotation> annotations) {
        this.pendingAnnotations.addAll(annotations);
    }

    private IRI getIRI(String s) {
        OWLAPIPreconditions.checkNotNull(s, "s cannot be null");
        IRI iri = null;
        if (this.iriProvider != null) {
            iri = this.iriProvider.getIRI(s);
        }
        if (iri != null) {
            return iri;
        }
        return this.IRIMap.computeIfAbsent(s, IRI::create);
    }

    protected final void importsClosureChanged() {
        this.ontology.annotationPropertiesInSignature(Imports.INCLUDED).forEach(e -> this.annPropertyIRIs.add(e.getIRI()));
        this.ontology.dataPropertiesInSignature(Imports.INCLUDED).forEach(e -> this.dataPropertyIRIs.add(e.getIRI()));
        this.ontology.objectPropertiesInSignature(Imports.INCLUDED).forEach(e -> this.objectPropertyIRIs.add(e.getIRI()));
        this.ontology.classesInSignature(Imports.INCLUDED).forEach(e -> this.classIRIs.add(e.getIRI()));
        this.ontology.datatypesInSignature(Imports.INCLUDED).forEach(e -> this.dataRangeIRIs.add(e.getIRI()));
        this.ontology.individualsInSignature(Imports.INCLUDED).forEach(e -> this.individualIRIs.add(e.getIRI()));
    }

    @Override
    public boolean isAnonymousNode(String iri) {
        return this.nodeCheckerDelegate.isAnonymousNode(iri);
    }

    @Override
    public boolean isAnonymousSharedNode(String iri) {
        return this.nodeCheckerDelegate.isAnonymousSharedNode(iri);
    }

    @Override
    public boolean isAnonymousNode(IRI iri) {
        return this.nodeCheckerDelegate.isAnonymousNode(iri);
    }

    protected void addSharedAnonymousNode(IRI iri, Object translation) {
        this.sharedAnonymousNodes.put(iri, translation);
    }

    protected Object getSharedAnonymousNode(IRI iri) {
        return this.sharedAnonymousNodes.get(iri);
    }

    protected void addAxiom(OWLAxiom axiom) {
        if (axiom.isAnnotationAxiom()) {
            if (this.configuration.isLoadAnnotationAxioms()) {
                this.parsedAnnotationAxioms.add((OWLAnnotationAxiom)axiom);
            }
        } else {
            this.ontology.add(axiom);
        }
        this.lastAddedAxiom = axiom;
    }

    protected void removeAxiom(OWLAxiom axiom) {
        this.axiomsToBeRemoved.add(axiom);
    }

    protected void checkForAndProcessAnnotatedDeclaration(IRI n) {
        IRI property = this.getResourceObject(n, OWLRDFVocabulary.OWL_ANNOTATED_PROPERTY, false);
        if (property == null) {
            return;
        }
        boolean rdfTypePredicate = property.equals(OWLRDFVocabulary.RDF_TYPE.getIRI());
        if (!rdfTypePredicate) {
            return;
        }
        IRI object = this.getResourceObject(n, OWLRDFVocabulary.OWL_ANNOTATED_TARGET, false);
        if (object == null) {
            return;
        }
        IRI subject = this.getResourceObject(n, OWLRDFVocabulary.OWL_ANNOTATED_SOURCE, false);
        if (subject == null) {
            return;
        }
        boolean isEntityType = OWLRDFConsumer.isEntityTypeIRI(object);
        if (isEntityType) {
            this.handlerAccessor.handle(subject, property, object);
        }
    }

    private static boolean isEntityTypeIRI(IRI iri) {
        return entityTypes.contains(iri);
    }

    protected void setOntologyID(OWLOntologyID ontologyID) {
        this.ontology.applyChange(new SetOntologyID(this.ontology, ontologyID));
    }

    protected void addOntologyAnnotation(OWLAnnotation annotation) {
        this.ontology.applyChange(new AddOntologyAnnotation(this.ontology, annotation));
    }

    protected void addImport(OWLImportsDeclaration declaration) {
        this.ontology.applyChange(new AddImport(this.ontology, declaration));
    }

    @Nullable
    public OWLAxiom getLastAddedAxiom() {
        return this.lastAddedAxiom;
    }

    protected boolean isIndividual(IRI iri) {
        return this.individualIRIs.contains(iri);
    }

    protected void addRDFProperty(IRI iri) {
        this.propertyIRIs.add(iri);
    }

    protected boolean isRDFProperty(IRI iri) {
        return this.propertyIRIs.contains(iri);
    }

    public void addClassExpression(IRI iri, boolean explicitlyTyped) {
        this.updateGuesses(iri, OWLClass.class, explicitlyTyped);
        this.addType(iri, this.classIRIs, explicitlyTyped);
    }

    private void updateGuesses(IRI iri, Class<?> class1, boolean explicitlyTyped) {
        if (explicitlyTyped && this.guessedDeclarations.containsKey((Object)iri)) {
            this.guessedDeclarations.remove((Object)iri, class1);
        }
        if (!explicitlyTyped) {
            this.guessedDeclarations.put((Object)iri, class1);
        }
    }

    public boolean isClassExpression(IRI iri) {
        return this.classIRIs.contains(iri);
    }

    public void addObjectProperty(IRI iri, boolean explicitlyTyped) {
        this.updateGuesses(iri, OWLObjectProperty.class, explicitlyTyped);
        this.addType(iri, this.objectPropertyIRIs, explicitlyTyped);
    }

    public void addDataProperty(IRI iri, boolean explicitlyTyped) {
        this.updateGuesses(iri, OWLDataProperty.class, explicitlyTyped);
        this.addType(iri, this.dataPropertyIRIs, explicitlyTyped);
    }

    protected void addAnnotationProperty(IRI iri, boolean explicitlyTyped) {
        this.updateGuesses(iri, OWLAnnotationProperty.class, explicitlyTyped);
        this.addType(iri, this.annPropertyIRIs, explicitlyTyped);
    }

    public void addDataRange(IRI iri, boolean explicitlyTyped) {
        this.updateGuesses(iri, OWLDataRange.class, explicitlyTyped);
        this.addType(iri, this.dataRangeIRIs, explicitlyTyped);
    }

    protected void addOWLNamedIndividual(IRI iri, boolean explicitlyTyped) {
        this.updateGuesses(iri, OWLNamedIndividual.class, explicitlyTyped);
        this.addType(iri, this.individualIRIs, explicitlyTyped);
    }

    protected void addOWLRestriction(IRI iri, boolean explicitlyTyped) {
        this.updateGuesses(iri, OWLClassExpression.class, explicitlyTyped);
        this.addType(iri, this.restrictionIRIs, explicitlyTyped);
    }

    private void addType(IRI iri, Set<IRI> types, boolean explicitlyTyped) {
        if (this.configuration.isStrict() && !explicitlyTyped) {
            LOGGER.warn("STRICT: Not adding implicit type iri={} types={}", (Object)iri, types);
            return;
        }
        types.add(iri);
    }

    public boolean isRestriction(IRI iri) {
        return this.restrictionIRIs.contains(iri);
    }

    protected void addAnnotationIRI(IRI iri) {
        this.annotationIRIs.add(iri);
    }

    protected boolean isAnnotation(IRI iri) {
        return this.annotationIRIs.contains(iri);
    }

    protected boolean isObjectPropertyOnly(@Nullable IRI iri) {
        return iri != null && !this.dataPropertyIRIs.contains(iri) && !this.annPropertyIRIs.contains(iri) && this.objectPropertyIRIs.contains(iri);
    }

    protected boolean isObjectProperty(IRI iri) {
        return this.objectPropertyIRIs.contains(iri);
    }

    protected boolean isDataPropertyOnly(@Nullable IRI iri) {
        return iri != null && !this.objectPropertyIRIs.contains(iri) && !this.annPropertyIRIs.contains(iri) && this.dataPropertyIRIs.contains(iri);
    }

    protected boolean isDataProperty(IRI iri) {
        return this.dataPropertyIRIs.contains(iri);
    }

    protected boolean isAnnotationPropertyOnly(IRI iri) {
        OWLAPIPreconditions.checkNotNull(iri);
        return !this.objectPropertyIRIs.contains(iri) && !this.dataPropertyIRIs.contains(iri) && this.annPropertyIRIs.contains(iri);
    }

    protected boolean isAnnotationProperty(IRI iri) {
        return this.annPropertyIRIs.contains(iri);
    }

    protected boolean isOntology(IRI iri) {
        return this.ontologyIRIs.contains(iri);
    }

    public OWLOntologyManager getOWLOntologyManager() {
        return this.ontology.getOWLOntologyManager();
    }

    public void addAnnotatedSource(IRI annotatedAnonSource, IRI annotationMainNode) {
        this.annotatedAnonSource2AnnotationMap.computeIfAbsent(annotatedAnonSource, x -> CollectionFactory.createLinkedSet()).add(annotationMainNode);
    }

    public Set<IRI> getAnnotatedSourceAnnotationMainNodes(IRI source) {
        return this.annotatedAnonSource2AnnotationMap.getOrDefault(source, Collections.emptySet());
    }

    protected OWLClass getOWLClass(IRI iri) {
        return this.df.getOWLClass(iri);
    }

    protected OWLObjectProperty getOWLObjectProperty(IRI iri) {
        return this.df.getOWLObjectProperty(iri);
    }

    protected OWLDataProperty getOWLDataProperty(IRI iri) {
        return this.df.getOWLDataProperty(iri);
    }

    protected OWLIndividual getOWLIndividual(IRI iri) {
        if (this.isAnonymousNode(iri)) {
            return this.getOWLAnonymousIndividual(iri.toString());
        }
        return this.df.getOWLNamedIndividual(iri);
    }

    @Override
    public OWLAnonymousIndividual getOWLAnonymousIndividual(String nodeId) {
        return this.anonProvider.getOWLAnonymousIndividual(nodeId);
    }

    protected void consumeTriple(IRI subject, IRI predicate, IRI object) {
        LOGGER.trace("consuming triple");
        this.tripleLogger.justLog(subject, predicate, object);
        this.isTriplePresent(subject, predicate, object, true);
    }

    protected void consumeTriple(IRI subject, IRI predicate, OWLLiteral con) {
        LOGGER.trace("consuming triple");
        this.tripleLogger.justLog(subject, predicate, con);
        this.isTriplePresent(subject, predicate, con, true);
    }

    protected void addSWRLRule(IRI iri) {
        this.swrlRules.add(iri);
    }

    protected boolean isSWRLRule(IRI iri) {
        return this.swrlRules.contains(iri);
    }

    protected void addSWRLIndividualPropertyAtom(IRI iri) {
        this.swrlIndividualPropertyAtoms.add(iri);
    }

    protected boolean isSWRLIndividualPropertyAtom(IRI iri) {
        return this.swrlIndividualPropertyAtoms.contains(iri);
    }

    protected void addSWRLDataPropertyAtom(IRI iri) {
        this.swrlDataValuedPropertyAtoms.add(iri);
    }

    protected boolean isSWRLDataValuedPropertyAtom(IRI iri) {
        return this.swrlDataValuedPropertyAtoms.contains(iri);
    }

    protected void addSWRLClassAtom(IRI iri) {
        this.swrlClassAtoms.add(iri);
    }

    protected boolean isSWRLClassAtom(IRI iri) {
        return this.swrlClassAtoms.contains(iri);
    }

    protected void addSWRLSameAsAtom(IRI iri) {
        this.swrlSameAsAtoms.add(iri);
    }

    protected boolean isSWRLSameAsAtom(IRI iri) {
        return this.swrlSameAsAtoms.contains(iri);
    }

    protected void addSWRLDifferentFromAtom(IRI iri) {
        this.swrlDifferentFromAtoms.add(iri);
    }

    protected boolean isSWRLDifferentFromAtom(IRI iri) {
        return this.swrlDifferentFromAtoms.contains(iri);
    }

    protected void addSWRLDataRangeAtom(IRI iri) {
        this.swrlDataRangeAtoms.add(iri);
    }

    protected boolean isSWRLDataRangeAtom(IRI iri) {
        return this.swrlDataRangeAtoms.contains(iri);
    }

    protected void addSWRLBuiltInAtom(IRI iri) {
        this.swrlBuiltInAtoms.add(iri);
    }

    protected boolean isSWRLBuiltInAtom(IRI iri) {
        return this.swrlBuiltInAtoms.contains(iri);
    }

    protected void addSWRLVariable(IRI iri) {
        this.swrlVariables.add(iri);
    }

    protected boolean isSWRLVariable(IRI iri) {
        return this.swrlVariables.contains(iri);
    }

    private static void printTriple(Object subject, Object predicate, Object object) {
        LOGGER.info("Unparsed triple: {} -> {} -> {}", new Object[]{subject, predicate, object});
    }

    protected void dumpRemainingTriples() {
        if (LOGGER.isInfoEnabled() && this.singleValuedResTriplesByPredicate.size() + this.singleValuedLitTriplesByPredicate.size() + this.resTriplesBySubject.size() + this.litTriplesBySubject.size() > 0) {
            this.singleValuedResTriplesByPredicate.forEach((p, map) -> map.forEach((s, o) -> OWLRDFConsumer.printTriple(s, p, o)));
            this.singleValuedLitTriplesByPredicate.forEach((p, map) -> map.forEach((s, o) -> OWLRDFConsumer.printTriple(s, p, o)));
            this.resTriplesBySubject.forEach((p, map) -> map.forEach((s, o) -> o.forEach(x -> OWLRDFConsumer.printTriple(s, p, x))));
            this.litTriplesBySubject.forEach((p, map) -> map.forEach((s, o) -> o.forEach(x -> OWLRDFConsumer.printTriple(s, p, x))));
        }
    }

    @Override
    public void startModel(IRI physicalURI) {
    }

    public boolean isParsedAllTriples() {
        return this.parsedAllTriples;
    }

    @Override
    public void endModel() {
        this.parsedAllTriples = true;
        this.IRIMap.clear();
        this.tripleLogger.logNumberOfTriples();
        this.translatorAccessor.consumeSWRLRules(this.swrlRules);
        Set<RDFTriple> remainingTriples = this.handlerAccessor.mopUp();
        if (this.ontologyFormat != null) {
            RDFParserMetaData metaData = new RDFParserMetaData(RDFOntologyHeaderStatus.PARSED_ONE_HEADER, this.tripleLogger.count(), remainingTriples, this.guessedDeclarations);
            this.getOntologyFormat().setOntologyLoaderMetaData(metaData);
        }
        this.chooseAndSetOntologyIRI();
        TripleLogger.logOntologyID(this.ontology.getOntologyID());
        this.dumpRemainingTriples();
        this.cleanup();
        this.addAnnotationAxioms();
        this.removeAxiomsScheduledForRemoval();
    }

    private void addAnnotationAxioms() {
        this.ontology.add(this.parsedAnnotationAxioms);
    }

    private void removeAxiomsScheduledForRemoval() {
        this.ontology.remove(this.axiomsToBeRemoved);
    }

    private void chooseAndSetOntologyIRI() {
        Optional<Object> ontologyIRIToSet = OWLAPIPreconditions.emptyOptional();
        if (this.firstOntologyIRI != null) {
            List<OWLAnnotationAssertionAxiom> annotationsForOntology = OWLAPIStreamUtils.asList(this.ontology.annotationAssertionAxioms(this.firstOntologyIRI));
            for (OWLAnnotationAssertionAxiom ax : annotationsForOntology) {
                this.addOntologyAnnotation(ax.getAnnotation());
                if (ax.annotations().count() != 0L) continue;
                this.ontology.remove((OWLAxiom)ax);
            }
            ArrayList<OWLAnnotationAxiom> annotationsParsed = new ArrayList<OWLAnnotationAxiom>(this.parsedAnnotationAxioms);
            for (OWLAnnotationAxiom ax : annotationsParsed) {
                if (!(ax instanceof OWLAnnotationAssertionAxiom) || !((OWLAnnotationSubject)((OWLAnnotationAssertionAxiom)ax).getSubject()).equals(this.firstOntologyIRI)) continue;
                this.addOntologyAnnotation(((OWLAnnotationAssertionAxiom)ax).getAnnotation());
                if (ax.annotations().count() != 0L) continue;
                this.parsedAnnotationAxioms.remove(ax);
            }
        }
        if (!this.ontologyIRIs.isEmpty()) {
            if (this.ontologyIRIs.size() == 1) {
                IRI ontologyIRI = this.ontologyIRIs.iterator().next();
                if (!this.isAnonymousNode(ontologyIRI)) {
                    ontologyIRIToSet = OWLAPIPreconditions.optional(ontologyIRI);
                }
            } else {
                Set<Set<IRI>> candidateIRIs = CollectionFactory.createSet(this.ontologyIRIs);
                this.ontology.annotations().forEach(a -> a.getValue().asIRI().ifPresent(iri -> {
                    if (this.ontologyIRIs.contains(iri)) {
                        candidateIRIs.remove(iri);
                    }
                }));
                if (candidateIRIs.contains(this.firstOntologyIRI)) {
                    ontologyIRIToSet = OWLAPIPreconditions.optional(this.firstOntologyIRI);
                } else if (!candidateIRIs.isEmpty()) {
                    ontologyIRIToSet = OWLAPIPreconditions.optional(candidateIRIs.iterator().next());
                }
            }
        }
        if (ontologyIRIToSet.isPresent() && !NodeID.isAnonymousNodeIRI((IRI)ontologyIRIToSet.get())) {
            Optional<IRI> versionIRI = this.ontology.getOntologyID().getVersionIRI();
            OWLOntologyID ontologyID = new OWLOntologyID(ontologyIRIToSet, versionIRI);
            this.ontology.applyChange(new SetOntologyID(this.ontology, ontologyID));
        }
    }

    private void cleanup() {
        this.classIRIs.clear();
        this.objectPropertyIRIs.clear();
        this.dataPropertyIRIs.clear();
        this.dataRangeIRIs.clear();
        this.restrictionIRIs.clear();
        this.listFirstLiteralTripleMap.clear();
        this.listFirstResourceTripleMap.clear();
        this.listRestTripleMap.clear();
        this.translatorAccessor.cleanup();
        this.resTriplesBySubject.clear();
        this.litTriplesBySubject.clear();
        this.singleValuedLitTriplesByPredicate.clear();
        this.singleValuedResTriplesByPredicate.clear();
        this.guessedDeclarations.clear();
    }

    @Override
    public void includeModel(@Nullable String logicalURI, @Nullable String physicalURI) {
    }

    @Override
    public void logicalURI(IRI logicalURI) {
    }

    protected IRI getSynonym(IRI original) {
        IRI synonymIRI;
        if (!this.configuration.isStrict() && (synonymIRI = this.synonymMap.get(original)) != null) {
            return synonymIRI;
        }
        return original;
    }

    @Override
    public void statementWithLiteralValue(String subject, String predicate, String object, @Nullable String language, @Nullable String datatype) {
        this.tripleLogger.logTriple(subject, predicate, object, language, datatype);
        IRI subjectIRI = this.getIRI(this.remapOnlyIfRemapped(subject));
        IRI predicateIRI = this.getIRI(predicate);
        predicateIRI = this.getSynonym(predicateIRI);
        this.handlerAccessor.handleStreaming(subjectIRI, predicateIRI, object, datatype == null ? null : this.getIRI(datatype), language);
    }

    @Override
    public void statementWithLiteralValue(IRI subject, IRI predicate, String object, @Nullable String language, @Nullable IRI datatype) {
        this.tripleLogger.logTriple(subject, predicate, object, language, datatype);
        this.handlerAccessor.handleStreaming(subject, this.getSynonym(predicate), object, datatype, language);
    }

    @Override
    public void statementWithResourceValue(String subject, String predicate, String object) {
        this.tripleLogger.logTriple(subject, predicate, object);
        IRI subjectIRI = this.getIRI(subject);
        IRI predicateIRI = this.getSynonym(this.getIRI(predicate));
        IRI objectIRI = this.getSynonym(this.getIRI(object));
        this.handlerAccessor.handleStreaming(subjectIRI, predicateIRI, objectIRI);
    }

    @Override
    public void statementWithResourceValue(IRI subject, IRI predicate, IRI object) {
        this.tripleLogger.logTriple(subject, predicate, object);
        this.handlerAccessor.handleStreaming(subject, this.getSynonym(predicate), this.getSynonym(object));
    }

    OWLLiteral getOWLLiteral(String literal, @Nullable IRI datatype, @Nullable String lang) {
        if (lang != null && !lang.trim().isEmpty()) {
            return this.df.getOWLLiteral(literal, lang);
        }
        if (datatype != null) {
            return this.df.getOWLLiteral(literal, this.df.getOWLDatatype(datatype));
        }
        return this.df.getOWLLiteral(literal);
    }

    public OWLClassExpression translateClassExpression(IRI i) {
        return this.translatorAccessor.translateClassExpression(i);
    }

    public OWLDataRange translateDataRange(IRI n) {
        if (!this.isDataRange(n) && this.configuration.isStrict()) {
            return this.generateAndLogParseError(EntityType.DATATYPE, n);
        }
        if (!this.isAnonymousNode(n) && this.isDataRange(n)) {
            return this.df.getOWLDatatype(n);
        }
        IRI and = this.getResourceObject(n, OWLRDFVocabulary.OWL_INTERSECTION_OF, true);
        if (and != null) {
            return this.df.getOWLDataIntersectionOf(this.translatorAccessor.translateToDataRangeSet(and));
        }
        IRI or = this.getResourceObject(n, OWLRDFVocabulary.OWL_UNION_OF, true);
        if (or != null) {
            return this.df.getOWLDataUnionOf(this.translatorAccessor.translateToDataRangeSet(or));
        }
        IRI not = this.getResourceObject(n, OWLRDFVocabulary.OWL_DATATYPE_COMPLEMENT_OF, true);
        if (!this.configuration.isStrict() && not == null) {
            not = this.getResourceObject(n, OWLRDFVocabulary.OWL_COMPLEMENT_OF, true);
        }
        if (not != null) {
            return this.df.getOWLDataComplementOf(this.translateDataRange(not));
        }
        IRI oneOfObject = this.getResourceObject(n, OWLRDFVocabulary.OWL_ONE_OF, true);
        if (oneOfObject != null) {
            return this.df.getOWLDataOneOf(this.translatorAccessor.translateToConstantSet(oneOfObject));
        }
        IRI onDt = this.getResourceObject(n, OWLRDFVocabulary.OWL_ON_DATA_TYPE, true);
        if (onDt != null) {
            if (this.isAnonymousNode(onDt)) {
                return this.df.getOWLDatatype(n);
            }
            OWLDatatype dt = (OWLDatatype)this.translateDataRange(onDt);
            Set<OWLFacetRestriction> restrictions = CollectionFactory.createLinkedSet();
            IRI facets = this.getResourceObject(n, OWLRDFVocabulary.OWL_WITH_RESTRICTIONS, true);
            if (facets != null) {
                restrictions = this.translatorAccessor.translateToFacetRestrictionSet(facets);
            } else if (!this.configuration.isStrict()) {
                for (IRI facetIRI : OWLFacet.getFacetIRIs()) {
                    OWLLiteral val = this.getLiteralObject(n, facetIRI, true);
                    while (val != null) {
                        restrictions.add(this.df.getOWLFacetRestriction(OWLFacet.getFacet(facetIRI), val));
                        val = this.getLiteralObject(n, facetIRI, true);
                    }
                }
            }
            return this.df.getOWLDatatypeRestriction(dt, restrictions);
        }
        return this.generateAndLogParseError(EntityType.DATATYPE, n);
    }

    public OWLDataPropertyExpression translateDataPropertyExpression(IRI iri) {
        return this.df.getOWLDataProperty(iri);
    }

    public OWLObjectPropertyExpression translateObjectPropertyExpression(IRI mainNode) {
        OWLObjectPropertyExpression prop = this.translatedProperties.get(mainNode);
        if (prop != null) {
            return prop;
        }
        if (!this.isAnonymousNode(mainNode)) {
            prop = this.df.getOWLObjectProperty(mainNode);
            this.translatedProperties.put(mainNode, prop);
            return prop;
        }
        IRI inverseOfObject = this.getResourceObject(mainNode, OWLRDFVocabulary.OWL_INVERSE_OF, true);
        if (inverseOfObject != null) {
            OWLObjectPropertyExpression otherProperty = this.translateObjectPropertyExpression(inverseOfObject);
            if (otherProperty.isAnonymous()) {
                throw new OWLRuntimeException("Found nested object property expression but only object property allowed in inverseOf construct");
            }
            prop = this.df.getOWLObjectInverseOf(otherProperty.asOWLObjectProperty());
        } else {
            prop = this.df.getOWLObjectInverseOf(this.df.getOWLObjectProperty(mainNode));
        }
        this.objectPropertyIRIs.add(mainNode);
        this.translatedProperties.put(mainNode, prop);
        return prop;
    }

    public OWLIndividual translateIndividual(IRI node) {
        return this.getOWLIndividual(node);
    }

    public Set<OWLAnnotation> translateAnnotations(IRI n) {
        Map anns = CollectionFactory.createMap();
        this.getAnnotatedSourceAnnotationMainNodes(n).forEach(node -> {
            Collection cfr_ignored_0 = anns.put(node, this.translateAnnotations((IRI)node));
        });
        Set<OWLAnnotation> nodeAnns = CollectionFactory.createLinkedSet();
        this.getPredicatesBySubject(n).stream().filter(this::isAnnotationProperty).forEach(p -> this.mapAnnotation(n, anns, nodeAnns, (IRI)p));
        return nodeAnns;
    }

    protected void mapAnnotation(IRI n, Map<IRI, Collection<OWLAnnotation>> anns, Set<OWLAnnotation> nodeAnns, IRI p) {
        OWLAnnotationProperty ap = this.df.getOWLAnnotationProperty(p);
        IRI resVal = this.getResourceObject(n, p, true);
        while (resVal != null) {
            IRI annotation = this.getSubjectForAnnotatedPropertyAndObject(n, p, resVal);
            OWLAnnotationValue val = this.getAnnotationValue(resVal);
            nodeAnns.add(this.df.getOWLAnnotation(ap, val, anns.getOrDefault(annotation, Collections.emptyList())));
            resVal = this.getResourceObject(n, p, true);
        }
        OWLLiteral litVal = this.getLiteralObject(n, p, true);
        while (litVal != null) {
            IRI annotation = this.getSubjectForAnnotatedPropertyAndObject(n, p, litVal);
            nodeAnns.add(this.df.getOWLAnnotation(ap, (OWLAnnotationValue)litVal, anns.getOrDefault(annotation, Collections.emptyList())));
            litVal = this.getLiteralObject(n, p, true);
        }
    }

    @Nullable
    private IRI getSubjectForAnnotatedPropertyAndObject(IRI n, IRI p, OWLLiteral v) {
        return this.getAnnotatedSourceAnnotationMainNodes(n).stream().filter(i -> p.equals(this.getResourceObject((IRI)i, OWLRDFVocabulary.OWL_ANNOTATED_PROPERTY, false)) && v.equals(this.getLiteralObject((IRI)i, OWLRDFVocabulary.OWL_ANNOTATED_TARGET, false))).findAny().orElse(null);
    }

    @Nullable
    private IRI getSubjectForAnnotatedPropertyAndObject(IRI n, IRI p, IRI v) {
        return this.getAnnotatedSourceAnnotationMainNodes(n).stream().filter(i -> p.equals(this.getResourceObject((IRI)i, OWLRDFVocabulary.OWL_ANNOTATED_PROPERTY, false)) && v.equals(this.getResourceObject((IRI)i, OWLRDFVocabulary.OWL_ANNOTATED_TARGET, false))).findAny().orElse(null);
    }

    private OWLAnnotationValue getAnnotationValue(IRI resVal) {
        OWLAnnotationSubject val = this.isAnonymousNode(resVal) ? this.df.getOWLAnonymousIndividual(resVal.toString()) : resVal;
        return val;
    }

    private <E extends OWLEntity> E getErrorEntity(EntityType<E> entityType) {
        IRI iri = IRI.create("http://org.semanticweb.owlapi/error#", "Error" + ERRORCOUNTER.incrementAndGet());
        LOGGER.error("Entity not properly recognized, missing triples in input? {} for type {}", (Object)iri, entityType);
        if (this.configuration.isStrict()) {
            throw new OWLParserException("Entity not properly recognized, missing triples in input? " + iri + " for type " + entityType);
        }
        return this.df.getOWLEntity(entityType, iri);
    }

    private RDFResource getRDFResource(IRI iri) {
        if (this.isAnonymousNode(iri)) {
            return new RDFResourceBlankNode(iri, false, false);
        }
        return new RDFResourceIRI(iri);
    }

    private RDFTriple getRDFTriple(IRI subject, IRI predicate, IRI object) {
        return new RDFTriple(this.getRDFResource(subject), new RDFResourceIRI(predicate), this.getRDFResource(object));
    }

    private RDFTriple getRDFTriple(IRI subject, IRI predicate, OWLLiteral object) {
        return new RDFTriple(this.getRDFResource(subject), new RDFResourceIRI(predicate), new RDFLiteral(object));
    }

    private Set<RDFTriple> getTriplesForMainNode(IRI n, IRI ... augmentingTypes) {
        Set<RDFTriple> triples = CollectionFactory.createLinkedSet();
        this.getPredicatesBySubject(n).forEach(p -> {
            this.getResourceObjects(n, (IRI)p).forEach(o -> triples.add(this.getRDFTriple(n, (IRI)p, (IRI)o)));
            this.getLiteralObjects(n, (IRI)p).forEach(object -> triples.add(this.getRDFTriple(n, (IRI)p, (OWLLiteral)object)));
        });
        Stream.of(augmentingTypes).forEach(t -> triples.add(this.getRDFTriple(n, OWLRDFVocabulary.RDF_TYPE.getIRI(), (IRI)t)));
        return triples;
    }

    private void logError(RDFResourceParseError error) {
        this.getOntologyFormat().addError(error);
    }

    public <E extends OWLEntity> E generateAndLogParseError(EntityType<E> entityType, IRI mainNode) {
        E entity = this.getErrorEntity(entityType);
        RDFResource mainNodeResource = this.getRDFResource(mainNode);
        Set<RDFTriple> mainNodeTriples = this.getTriplesForMainNode(mainNode, new IRI[0]);
        RDFResourceParseError error = new RDFResourceParseError((OWLEntity)entity, mainNodeResource, mainNodeTriples);
        this.logError(error);
        return entity;
    }

    protected Set<IRI> getPredicatesBySubject(IRI subject) {
        Map<IRI, Collection<OWLLiteral>> predObjMapLit;
        Set<IRI> iris = CollectionFactory.createLinkedSet();
        Map<IRI, Collection<IRI>> predObjMap = this.resTriplesBySubject.get(subject);
        if (predObjMap != null) {
            iris.addAll(predObjMap.keySet());
        }
        if ((predObjMapLit = this.litTriplesBySubject.get(subject)) != null) {
            iris.addAll(predObjMapLit.keySet());
        }
        return iris;
    }

    @Nullable
    protected IRI getResourceObject(IRI subject, OWLRDFVocabulary predicate, boolean consume) {
        return this.getResourceObject(subject, predicate.getIRI(), consume);
    }

    @Nullable
    protected IRI getResourceObject(IRI subject, IRI predicate, boolean consume) {
        Collection<IRI> objects;
        Map<IRI, IRI> subjPredMap = this.singleValuedResTriplesByPredicate.get(predicate);
        if (subjPredMap != null) {
            IRI obj = subjPredMap.get(subject);
            if (consume) {
                subjPredMap.remove(subject);
            }
            return obj;
        }
        Map<IRI, Collection<IRI>> predObjMap = this.resTriplesBySubject.get(subject);
        if (predObjMap != null && (objects = predObjMap.get(predicate)) != null && !objects.isEmpty()) {
            IRI object = objects.iterator().next();
            if (consume) {
                objects.remove(object);
            }
            if (objects.isEmpty()) {
                predObjMap.remove(predicate);
                if (predObjMap.isEmpty()) {
                    this.resTriplesBySubject.remove(subject);
                }
            }
            return object;
        }
        return null;
    }

    protected Set<IRI> getResourceObjects(IRI subject, IRI predicate) {
        Collection<IRI> objects;
        Map<IRI, Collection<IRI>> predObjMap;
        IRI obj;
        Set<IRI> result = CollectionFactory.createLinkedSet();
        Map<IRI, IRI> subjPredMap = this.singleValuedResTriplesByPredicate.get(predicate);
        if (subjPredMap != null && (obj = subjPredMap.get(subject)) != null) {
            result.add(obj);
        }
        if ((predObjMap = this.resTriplesBySubject.get(subject)) != null && (objects = predObjMap.get(predicate)) != null) {
            result.addAll(objects);
        }
        return result;
    }

    @Nullable
    protected OWLLiteral getLiteralObject(IRI subject, OWLRDFVocabulary predicate, boolean consume) {
        return this.getLiteralObject(subject, predicate.getIRI(), consume);
    }

    @Nullable
    protected OWLLiteral getLiteralObject(IRI subject, IRI predicate, boolean consume) {
        Collection<OWLLiteral> objects;
        Map<IRI, OWLLiteral> subjPredMap = this.singleValuedLitTriplesByPredicate.get(predicate);
        if (subjPredMap != null) {
            OWLLiteral obj = subjPredMap.get(subject);
            if (consume) {
                subjPredMap.remove(subject);
            }
            return obj;
        }
        Map<IRI, Collection<OWLLiteral>> predObjMap = this.litTriplesBySubject.get(subject);
        if (predObjMap != null && (objects = predObjMap.get(predicate)) != null && !objects.isEmpty()) {
            OWLLiteral object = objects.iterator().next();
            if (consume) {
                objects.remove(object);
            }
            if (objects.isEmpty()) {
                predObjMap.remove(predicate);
            }
            return object;
        }
        return null;
    }

    protected Set<OWLLiteral> getLiteralObjects(IRI subject, IRI predicate) {
        Collection<OWLLiteral> objects;
        Map<IRI, Collection<OWLLiteral>> predObjMap;
        OWLLiteral obj;
        Set<OWLLiteral> result = CollectionFactory.createLinkedSet();
        Map<IRI, OWLLiteral> subjPredMap = this.singleValuedLitTriplesByPredicate.get(predicate);
        if (subjPredMap != null && (obj = subjPredMap.get(subject)) != null) {
            result.add(obj);
        }
        if ((predObjMap = this.litTriplesBySubject.get(subject)) != null && (objects = predObjMap.get(predicate)) != null) {
            result.addAll(objects);
        }
        return result;
    }

    protected boolean isTriplePresent(IRI subject, IRI predicate, IRI object, boolean consume) {
        Collection<IRI> objects;
        Map<IRI, IRI> subjPredMap = this.singleValuedResTriplesByPredicate.get(predicate);
        if (subjPredMap != null) {
            IRI obj = subjPredMap.get(subject);
            if (consume) {
                subjPredMap.remove(subject);
            }
            return obj != null;
        }
        Map<IRI, Collection<IRI>> predObjMap = this.resTriplesBySubject.get(subject);
        if (predObjMap != null && (objects = predObjMap.get(predicate)) != null && objects.contains(object)) {
            if (consume) {
                objects.remove(object);
                if (objects.isEmpty()) {
                    predObjMap.remove(predicate);
                    if (predObjMap.isEmpty()) {
                        this.resTriplesBySubject.remove(subject);
                    }
                }
            }
            return true;
        }
        return false;
    }

    protected static boolean isGeneralPredicate(IRI predicate) {
        return !predicate.isReservedVocabulary() || OWLRDFVocabulary.BUILT_IN_AP_IRIS.contains(predicate) || Namespaces.SWRL.inNamespace(predicate) || Namespaces.SWRLB.inNamespace(predicate);
    }

    protected boolean isTriplePresent(IRI subject, IRI predicate, OWLLiteral object, boolean consume) {
        Collection<OWLLiteral> objects;
        Map<IRI, OWLLiteral> subjPredMap = this.singleValuedLitTriplesByPredicate.get(predicate);
        if (subjPredMap != null) {
            OWLLiteral obj = subjPredMap.get(subject);
            if (consume) {
                subjPredMap.remove(subject);
            }
            return obj != null;
        }
        Map<IRI, Collection<OWLLiteral>> predObjMap = this.litTriplesBySubject.get(subject);
        if (predObjMap != null && (objects = predObjMap.get(predicate)) != null && objects.contains(object)) {
            if (consume) {
                objects.remove(object);
                if (objects.isEmpty()) {
                    predObjMap.remove(predicate);
                    if (predObjMap.isEmpty()) {
                        this.litTriplesBySubject.remove(subject);
                    }
                }
            }
            return true;
        }
        return false;
    }

    protected boolean hasPredicate(IRI subject, IRI predicate) {
        Map<IRI, IRI> resPredMap = this.singleValuedResTriplesByPredicate.get(predicate);
        if (resPredMap != null) {
            return resPredMap.containsKey(subject);
        }
        Map<IRI, OWLLiteral> litPredMap = this.singleValuedLitTriplesByPredicate.get(predicate);
        if (litPredMap != null) {
            return litPredMap.containsKey(subject);
        }
        Map<IRI, Collection<IRI>> resPredObjMap = this.resTriplesBySubject.get(subject);
        if (resPredObjMap != null && resPredObjMap.containsKey(predicate)) {
            return true;
        }
        Map<IRI, Collection<OWLLiteral>> litPredObjMap = this.litTriplesBySubject.get(subject);
        if (litPredObjMap != null) {
            return litPredObjMap.containsKey(predicate);
        }
        return false;
    }

    protected void addRest(IRI subject, IRI object) {
        this.listRestTripleMap.put(subject, object);
    }

    protected void addFirst(IRI subject, IRI object) {
        this.listFirstResourceTripleMap.put(subject, object);
    }

    @Nullable
    protected IRI getFirstResource(IRI subject, boolean consume) {
        if (consume) {
            return this.listFirstResourceTripleMap.remove(subject);
        }
        return this.listFirstResourceTripleMap.get(subject);
    }

    @Nullable
    protected OWLLiteral getFirstLiteral(IRI subject) {
        return this.listFirstLiteralTripleMap.get(subject);
    }

    @Nullable
    protected IRI getRest(IRI subject, boolean consume) {
        if (consume) {
            return this.listRestTripleMap.remove(subject);
        }
        return this.listRestTripleMap.get(subject);
    }

    protected void addFirst(IRI subject, OWLLiteral object) {
        this.listFirstLiteralTripleMap.put(subject, object);
    }

    protected void addOntology(IRI iri) {
        if (this.ontologyIRIs.isEmpty()) {
            this.firstOntologyIRI = iri;
        }
        this.ontologyIRIs.add(iri);
    }

    protected Set<IRI> getOntologies() {
        return this.ontologyIRIs;
    }

    protected void addAxiom(IRI axiomIRI) {
        this.axioms.add(axiomIRI);
    }

    protected boolean isAxiom(IRI iri) {
        return this.axioms.contains(iri);
    }

    protected boolean isDataRange(IRI iri) {
        return this.dataRangeIRIs.contains(iri);
    }

    @Override
    public OWLOntologyLoaderConfiguration getConfiguration() {
        return this.configuration;
    }

    protected void iterateResources(ResourceTripleIterator iterator) {
        new ArrayList<Map.Entry<IRI, Map<IRI, Collection<IRI>>>>(this.resTriplesBySubject.entrySet()).forEach((Consumer<Map.Entry<IRI, Map<IRI, Collection<IRI>>>>)((Consumer<Map.Entry>)e -> new ArrayList(((Map)e.getValue()).entrySet()).forEach(p -> new ArrayList<IRI>((Collection)p.getValue()).forEach(object -> iterator.handleResourceTriple((IRI)e.getKey(), (IRI)p.getKey(), (IRI)object)))));
    }

    protected void iterateLiterals(LiteralTripleIterator iterator) {
        new ArrayList<Map.Entry<IRI, Map<IRI, Collection<OWLLiteral>>>>(this.litTriplesBySubject.entrySet()).forEach((Consumer<Map.Entry<IRI, Map<IRI, Collection<OWLLiteral>>>>)((Consumer<Map.Entry>)e -> new ArrayList(((Map)e.getValue()).entrySet()).forEach(p -> new ArrayList<OWLLiteral>((Collection)p.getValue()).forEach(object -> iterator.handleLiteralTriple((IRI)e.getKey(), (IRI)p.getKey(), (OWLLiteral)object)))));
    }

    @Override
    public IRI remapIRI(IRI i) {
        if (this.nodeCheckerDelegate.isAnonymousNode(i)) {
            return i;
        }
        IRI computeIfAbsent = this.remappedIRIs.computeIfAbsent(i, x -> IRI.create(NodeID.nextAnonymousIRI()));
        this.remappedIRIStrings.put(i.toString(), computeIfAbsent);
        return computeIfAbsent;
    }

    @Override
    public String remapOnlyIfRemapped(String i) {
        if (this.nodeCheckerDelegate.isAnonymousNode(i) || this.nodeCheckerDelegate.isAnonymousSharedNode(i)) {
            return i;
        }
        IRI iri = this.remappedIRIStrings.get(i);
        return iri == null ? i : iri.toString();
    }

    protected void addTriple(IRI subject, IRI predicate, IRI object) {
        Map<IRI, IRI> subjObjMap = this.singleValuedResTriplesByPredicate.get(predicate);
        if (subjObjMap != null) {
            subjObjMap.put(subject, object);
        } else {
            this.resTriplesBySubject.computeIfAbsent(subject, x -> CollectionFactory.createMap()).computeIfAbsent(predicate, x -> CollectionFactory.createLinkedSet()).add(object);
        }
    }

    protected void addTriple(IRI subject, IRI predicate, OWLLiteral con) {
        Map<IRI, OWLLiteral> subjObjMap = this.singleValuedLitTriplesByPredicate.get(predicate);
        if (subjObjMap != null) {
            subjObjMap.put(subject, con);
        } else {
            this.litTriplesBySubject.computeIfAbsent(subject, x -> CollectionFactory.createMap()).computeIfAbsent(predicate, x -> CollectionFactory.createLinkedSet()).add(con);
        }
    }
}

