/*
 * Decompiled with CFR 0.152.
 */
package org.semanticweb.owlapi.model;

import java.io.OutputStream;
import java.util.Arrays;
import java.util.Collection;
import java.util.List;
import java.util.Set;
import java.util.stream.Stream;
import javax.annotation.Nullable;
import org.semanticweb.owlapi.io.OWLOntologyDocumentTarget;
import org.semanticweb.owlapi.model.HasAnnotations;
import org.semanticweb.owlapi.model.HasApplyChange;
import org.semanticweb.owlapi.model.HasApplyChanges;
import org.semanticweb.owlapi.model.HasApplyDirectChange;
import org.semanticweb.owlapi.model.HasDirectAddAxiom;
import org.semanticweb.owlapi.model.HasDirectAddAxioms;
import org.semanticweb.owlapi.model.HasDirectImports;
import org.semanticweb.owlapi.model.HasDirectRemoveAxiom;
import org.semanticweb.owlapi.model.HasDirectRemoveAxioms;
import org.semanticweb.owlapi.model.HasImportsClosure;
import org.semanticweb.owlapi.model.HasOntologyID;
import org.semanticweb.owlapi.model.HasSignature;
import org.semanticweb.owlapi.model.IRI;
import org.semanticweb.owlapi.model.OWLAxiom;
import org.semanticweb.owlapi.model.OWLAxiomCollection;
import org.semanticweb.owlapi.model.OWLAxiomCollectionBooleanArgs;
import org.semanticweb.owlapi.model.OWLAxiomIndex;
import org.semanticweb.owlapi.model.OWLClassAxiom;
import org.semanticweb.owlapi.model.OWLDocumentFormat;
import org.semanticweb.owlapi.model.OWLEntity;
import org.semanticweb.owlapi.model.OWLImportsDeclaration;
import org.semanticweb.owlapi.model.OWLNamedObjectVisitor;
import org.semanticweb.owlapi.model.OWLNamedObjectVisitorEx;
import org.semanticweb.owlapi.model.OWLObject;
import org.semanticweb.owlapi.model.OWLObjectVisitor;
import org.semanticweb.owlapi.model.OWLObjectVisitorEx;
import org.semanticweb.owlapi.model.OWLOntologyChange;
import org.semanticweb.owlapi.model.OWLOntologyManager;
import org.semanticweb.owlapi.model.OWLOntologyStorageException;
import org.semanticweb.owlapi.model.OWLSignature;
import org.semanticweb.owlapi.model.OWLSignatureBooleanArgs;
import org.semanticweb.owlapi.model.parameters.ChangeApplied;
import org.semanticweb.owlapi.model.parameters.Imports;
import org.semanticweb.owlapi.util.OWLAPIPreconditions;
import org.semanticweb.owlapi.util.OWLAPIStreamUtils;

public interface OWLOntology
extends OWLObject,
HasAnnotations,
HasDirectImports,
HasImportsClosure,
HasOntologyID,
OWLAxiomCollection,
OWLAxiomCollectionBooleanArgs,
OWLSignature,
OWLSignatureBooleanArgs,
OWLAxiomIndex,
HasApplyChange,
HasApplyChanges,
HasDirectAddAxiom,
HasDirectAddAxioms,
HasDirectRemoveAxiom,
HasDirectRemoveAxioms,
HasApplyDirectChange {
    @Override
    default public boolean isAxiom() {
        return false;
    }

    @Override
    default public boolean isIndividual() {
        return false;
    }

    @Override
    default public boolean isOntology() {
        return true;
    }

    @Override
    default public Stream<?> components() {
        return Stream.of(this.getOntologyID());
    }

    @Override
    default public int hashIndex() {
        return 0;
    }

    @Override
    default public int typeIndex() {
        return 1;
    }

    @Override
    default public ChangeApplied applyChange(OWLOntologyChange change) {
        return this.getOWLOntologyManager().applyChange(change);
    }

    @Override
    default public ChangeApplied applyDirectChange(OWLOntologyChange change) {
        return ChangeApplied.UNSUCCESSFULLY;
    }

    @Override
    default public ChangeApplied applyChanges(List<? extends OWLOntologyChange> changes) {
        return this.getOWLOntologyManager().applyChanges(changes);
    }

    @Override
    default public ChangeApplied addAxiom(OWLAxiom axiom) {
        return this.getOWLOntologyManager().addAxiom(this, axiom);
    }

    @Override
    default public ChangeApplied addAxioms(Collection<? extends OWLAxiom> axioms) {
        return this.getOWLOntologyManager().addAxioms(this, axioms.stream());
    }

    @Override
    default public ChangeApplied addAxioms(Stream<? extends OWLAxiom> axioms) {
        return this.getOWLOntologyManager().addAxioms(this, axioms);
    }

    @Override
    default public ChangeApplied addAxioms(OWLAxiom ... axioms) {
        return this.addAxioms(Arrays.asList(axioms));
    }

    @Override
    default public ChangeApplied removeAxiom(OWLAxiom axiom) {
        return this.getOWLOntologyManager().removeAxioms(this, Stream.of(axiom));
    }

    @Override
    default public ChangeApplied removeAxioms(Collection<? extends OWLAxiom> axioms) {
        return this.getOWLOntologyManager().removeAxioms(this, axioms.stream());
    }

    @Override
    default public ChangeApplied removeAxioms(Stream<? extends OWLAxiom> axioms) {
        return this.getOWLOntologyManager().removeAxioms(this, axioms);
    }

    @Override
    default public ChangeApplied removeAxioms(OWLAxiom ... axioms) {
        return this.removeAxioms(Arrays.asList(axioms));
    }

    default public void accept(OWLNamedObjectVisitor visitor) {
        visitor.visit(this);
    }

    default public <O> O accept(OWLNamedObjectVisitorEx<O> visitor) {
        return visitor.visit(this);
    }

    public OWLOntologyManager getOWLOntologyManager();

    @Nullable
    default public OWLDocumentFormat getFormat() {
        return this.getOWLOntologyManager().getOntologyFormat(this);
    }

    default public OWLDocumentFormat getNonnullFormat() {
        return OWLAPIPreconditions.verifyNotNull(this.getFormat(), () -> "There is no format specified for ontology " + this.getOntologyID() + ", the ontology format needs to be set before saving or specified in the save call");
    }

    public void setOWLOntologyManager(@Nullable OWLOntologyManager var1);

    @Deprecated
    default public Set<OWLOntology> getImports() {
        return OWLAPIStreamUtils.asSet(this.imports());
    }

    public Stream<OWLOntology> imports();

    @Deprecated
    default public Set<OWLImportsDeclaration> getImportsDeclarations() {
        return OWLAPIStreamUtils.asSet(this.importsDeclarations());
    }

    public Stream<OWLImportsDeclaration> importsDeclarations();

    public boolean isEmpty();

    @Deprecated
    default public Set<OWLAxiom> getTBoxAxioms(Imports includeImportsClosure) {
        return OWLAPIStreamUtils.asSet(this.tboxAxioms(includeImportsClosure));
    }

    public Stream<OWLAxiom> tboxAxioms(Imports var1);

    @Deprecated
    default public Set<OWLAxiom> getABoxAxioms(Imports includeImportsClosure) {
        return OWLAPIStreamUtils.asSet(this.aboxAxioms(includeImportsClosure));
    }

    public Stream<OWLAxiom> aboxAxioms(Imports var1);

    @Deprecated
    default public Set<OWLAxiom> getRBoxAxioms(Imports includeImportsClosure) {
        return OWLAPIStreamUtils.asSet(this.rboxAxioms(includeImportsClosure));
    }

    public Stream<OWLAxiom> rboxAxioms(Imports var1);

    @Deprecated
    default public Set<OWLClassAxiom> getGeneralClassAxioms() {
        return OWLAPIStreamUtils.asSet(this.generalClassAxioms());
    }

    public Stream<OWLClassAxiom> generalClassAxioms();

    @Deprecated
    default public Set<OWLEntity> getSignature(Imports imports) {
        return OWLAPIStreamUtils.asSet(this.signature(imports));
    }

    default public Stream<OWLEntity> signature(Imports imports) {
        return imports.stream(this).flatMap(HasSignature::signature);
    }

    public boolean isDeclared(OWLEntity var1);

    default public boolean isDeclared(OWLEntity owlEntity, Imports imports) {
        return imports.stream(this).anyMatch(o -> o.isDeclared(owlEntity));
    }

    default public void saveOntology() throws OWLOntologyStorageException {
        this.getOWLOntologyManager().saveOntology(this);
    }

    default public void saveOntology(IRI documentIRI) throws OWLOntologyStorageException {
        this.getOWLOntologyManager().saveOntology(this, documentIRI);
    }

    default public void saveOntology(OutputStream outputStream) throws OWLOntologyStorageException {
        this.getOWLOntologyManager().saveOntology(this, outputStream);
    }

    default public void saveOntology(OWLDocumentFormat ontologyFormat) throws OWLOntologyStorageException {
        this.getOWLOntologyManager().saveOntology(this, ontologyFormat);
    }

    default public void saveOntology(OWLDocumentFormat ontologyFormat, IRI documentIRI) throws OWLOntologyStorageException {
        this.getOWLOntologyManager().saveOntology(this, ontologyFormat, documentIRI);
    }

    default public void saveOntology(OWLDocumentFormat ontologyFormat, OutputStream outputStream) throws OWLOntologyStorageException {
        this.getOWLOntologyManager().saveOntology(this, ontologyFormat, outputStream);
    }

    default public void saveOntology(OWLOntologyDocumentTarget documentTarget) throws OWLOntologyStorageException {
        this.getOWLOntologyManager().saveOntology(this, documentTarget);
    }

    default public void saveOntology(OWLDocumentFormat ontologyFormat, OWLOntologyDocumentTarget documentTarget) throws OWLOntologyStorageException {
        this.getOWLOntologyManager().saveOntology(this, ontologyFormat, documentTarget);
    }

    @Override
    default public void accept(OWLObjectVisitor visitor) {
        visitor.visit(this);
    }

    @Override
    default public <O> O accept(OWLObjectVisitorEx<O> visitor) {
        return visitor.visit(this);
    }
}

