/*
 * Decompiled with CFR 0.152.
 */
package org.semanticweb.owlapi.metrics;

import java.util.HashSet;
import java.util.List;
import java.util.OptionalLong;
import org.semanticweb.owlapi.metrics.IntegerValuedMetric;
import org.semanticweb.owlapi.model.OWLClass;
import org.semanticweb.owlapi.model.OWLClassExpression;
import org.semanticweb.owlapi.model.OWLOntology;
import org.semanticweb.owlapi.model.OWLOntologyChange;
import org.semanticweb.owlapi.model.OWLSubClassOfAxiom;
import org.semanticweb.owlapi.search.Searcher;

public class MaximumNumberOfNamedSuperclasses
extends IntegerValuedMetric {
    public MaximumNumberOfNamedSuperclasses(OWLOntology o) {
        super(o);
    }

    @Override
    public String getName() {
        return "Maximum number of asserted named superclasses";
    }

    @Override
    public Integer recomputeMetric() {
        HashSet processedClasses = new HashSet();
        OptionalLong max = this.getOntologies().flatMapToLong(o -> o.classesInSignature().filter(processedClasses::add).mapToLong(cls -> Searcher.equivalent(o.equivalentClassesAxioms((OWLClass)cls), OWLClassExpression.class).filter(d -> !d.isAnonymous()).count())).max();
        return (int)max.orElse(0L);
    }

    @Override
    protected boolean isMetricInvalidated(List<? extends OWLOntologyChange> changes) {
        for (OWLOntologyChange oWLOntologyChange : changes) {
            if (!oWLOntologyChange.isAxiomChange() || !(oWLOntologyChange.getAxiom() instanceof OWLSubClassOfAxiom)) continue;
            return true;
        }
        return false;
    }
}

