/*
 * Decompiled with CFR 0.152.
 */
package org.obolibrary.macro;

import java.util.Collection;
import java.util.Optional;
import java.util.Set;
import java.util.concurrent.atomic.AtomicBoolean;
import javax.annotation.Nullable;
import org.obolibrary.obo2owl.OWLAPIObo2Owl;
import org.obolibrary.oboformat.model.OBODoc;
import org.semanticweb.owlapi.expression.OWLEntityChecker;
import org.semanticweb.owlapi.expression.ShortFormEntityChecker;
import org.semanticweb.owlapi.manchestersyntax.parser.ManchesterOWLSyntaxParserImpl;
import org.semanticweb.owlapi.model.AxiomType;
import org.semanticweb.owlapi.model.IRI;
import org.semanticweb.owlapi.model.OWLAnnotationAssertionAxiom;
import org.semanticweb.owlapi.model.OWLAnnotationProperty;
import org.semanticweb.owlapi.model.OWLAnnotationSubject;
import org.semanticweb.owlapi.model.OWLAnnotationValue;
import org.semanticweb.owlapi.model.OWLClass;
import org.semanticweb.owlapi.model.OWLClassExpression;
import org.semanticweb.owlapi.model.OWLDataFactory;
import org.semanticweb.owlapi.model.OWLDataProperty;
import org.semanticweb.owlapi.model.OWLDatatype;
import org.semanticweb.owlapi.model.OWLDeclarationAxiom;
import org.semanticweb.owlapi.model.OWLEntity;
import org.semanticweb.owlapi.model.OWLLiteral;
import org.semanticweb.owlapi.model.OWLNamedIndividual;
import org.semanticweb.owlapi.model.OWLObjectProperty;
import org.semanticweb.owlapi.model.OWLOntology;
import org.semanticweb.owlapi.model.OWLOntologyManager;
import org.semanticweb.owlapi.model.OWLRuntimeException;
import org.semanticweb.owlapi.model.OntologyConfigurator;
import org.semanticweb.owlapi.util.BidirectionalShortFormProviderAdapter;
import org.semanticweb.owlapi.util.IRIShortFormProvider;
import org.semanticweb.owlapi.util.OWLAPIStreamUtils;
import org.semanticweb.owlapi.util.OntologyAxiomPair;
import org.semanticweb.owlapi.util.ShortFormProvider;
import org.semanticweb.owlapi.util.SimpleIRIShortFormProvider;
import org.semanticweb.owlapi.util.mansyntax.ManchesterOWLSyntaxParser;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class ManchesterSyntaxTool {
    private static final Logger LOG = LoggerFactory.getLogger(ManchesterSyntaxTool.class);
    protected final IRIShortFormProvider iriShortFormProvider = new SimpleIRIShortFormProvider();
    private final OWLDataFactory dataFactory;
    private final AdvancedEntityChecker entityChecker;
    private final ShortFormProvider shortFormProvider = e -> this.iriShortFormProvider.getShortForm(e.getIRI());
    private final AtomicBoolean disposed = new AtomicBoolean(false);

    public ManchesterSyntaxTool(OWLOntology inputOntology) {
        this(inputOntology, null);
    }

    public ManchesterSyntaxTool(OWLOntology inputOntology, @Nullable Collection<OWLOntology> auxiliaryOntologies) {
        OWLOntologyManager manager = inputOntology.getOWLOntologyManager();
        this.dataFactory = manager.getOWLDataFactory();
        Set<OWLOntology> ontologies = OWLAPIStreamUtils.asUnorderedSet(inputOntology.importsClosure());
        if (auxiliaryOntologies != null) {
            auxiliaryOntologies.forEach(o -> OWLAPIStreamUtils.add(ontologies, o.importsClosure()));
        }
        ShortFormEntityChecker defaultInstance = new ShortFormEntityChecker(new BidirectionalShortFormProviderAdapter(manager, ontologies, this.shortFormProvider));
        this.entityChecker = new AdvancedEntityChecker(defaultInstance, ontologies, inputOntology.getOWLOntologyManager());
    }

    public Set<OntologyAxiomPair> parseManchesterExpressionFrames(String expression) {
        ManchesterOWLSyntaxParser parser = this.createParser(expression);
        return parser.parseFrames();
    }

    public OWLClassExpression parseManchesterExpression(String expression) {
        ManchesterOWLSyntaxParser parser = this.createParser(expression);
        return parser.parseClassExpression();
    }

    private ManchesterOWLSyntaxParser createParser(String expression) {
        if (this.disposed.get()) {
            throw new OWLRuntimeException("Illegal State: Trying to use an disposed instance.");
        }
        ManchesterOWLSyntaxParserImpl parser = new ManchesterOWLSyntaxParserImpl(new OntologyConfigurator(), this.dataFactory);
        parser.setStringToParse(expression);
        parser.setOWLEntityChecker(this.entityChecker);
        LOG.info("parsing: {}", (Object)expression);
        return parser;
    }

    public String getId(IRI iri) {
        if (this.disposed.get()) {
            throw new OWLRuntimeException("Illegal State: Trying to use an disposed instance.");
        }
        return this.iriShortFormProvider.getShortForm(iri);
    }

    public String getId(OWLEntity entity) {
        if (this.disposed.get()) {
            throw new OWLRuntimeException("Illegal State: Trying to use an disposed instance.");
        }
        return this.shortFormProvider.getShortForm(entity);
    }

    public void dispose() {
        if (!this.disposed.getAndSet(true)) {
            this.shortFormProvider.dispose();
        }
    }

    static class AdvancedEntityChecker
    implements OWLEntityChecker {
        private final OWLEntityChecker defaultInstance;
        private final Set<OWLOntology> ontologies;
        private final OWLOntologyManager manager;

        AdvancedEntityChecker(OWLEntityChecker defaultInstance, Set<OWLOntology> ontologies, OWLOntologyManager manager) {
            this.defaultInstance = defaultInstance;
            this.ontologies = ontologies;
            this.manager = manager;
        }

        @Override
        @Nullable
        public OWLClass getOWLClass(String name) {
            IRI iri;
            OWLClass owlClass = this.defaultInstance.getOWLClass(name);
            if (owlClass == null && (iri = this.getIRI(name)) != null) {
                owlClass = this.getOWLClass(iri);
            }
            return owlClass;
        }

        @Override
        @Nullable
        public OWLObjectProperty getOWLObjectProperty(String name) {
            IRI iri;
            OWLObjectProperty owlObjectProperty = this.defaultInstance.getOWLObjectProperty(name);
            if (owlObjectProperty == null && (iri = this.getIRI(name)) != null) {
                owlObjectProperty = this.getOWLObjectProperty(iri);
            }
            return owlObjectProperty;
        }

        @Override
        @Nullable
        public OWLDataProperty getOWLDataProperty(String name) {
            return this.defaultInstance.getOWLDataProperty(name);
        }

        @Override
        @Nullable
        public OWLNamedIndividual getOWLIndividual(String name) {
            IRI iri;
            OWLNamedIndividual owlIndividual = this.defaultInstance.getOWLIndividual(name);
            if (owlIndividual == null && (iri = this.getIRI(name)) != null) {
                owlIndividual = this.getOWLIndividual(iri);
            }
            return owlIndividual;
        }

        @Override
        @Nullable
        public OWLDatatype getOWLDatatype(String name) {
            return this.defaultInstance.getOWLDatatype(name);
        }

        @Override
        @Nullable
        public OWLAnnotationProperty getOWLAnnotationProperty(String name) {
            return this.defaultInstance.getOWLAnnotationProperty(name);
        }

        @Nullable
        protected IRI getIRI(String name) {
            if (AdvancedEntityChecker.isQuoted(name)) {
                return this.getIRIByLabel(name.substring(1, name.length() - 1));
            }
            if (name.length() > 2 && name.charAt(0) == '<' && name.charAt(name.length() - 1) == '>') {
                return IRI.create(name.substring(1, name.length() - 1));
            }
            return this.getIRIByIdentifier(name);
        }

        private static boolean isQuoted(String s) {
            int length = s.length();
            if (length >= 2) {
                return s.charAt(0) == '\'' && s.charAt(length - 1) == '\'';
            }
            return false;
        }

        @Nullable
        protected IRI getIRIByIdentifier(String id) {
            OWLAPIObo2Owl b = new OWLAPIObo2Owl(this.manager);
            b.setObodoc(new OBODoc());
            return b.oboIdToIRI(id);
        }

        @Nullable
        protected IRI getIRIByLabel(String label) {
            for (OWLOntology o : this.ontologies) {
                Optional<OWLAnnotationAssertionAxiom> anyMatch = o.axioms(AxiomType.ANNOTATION_ASSERTION).filter(aa -> this.isMatchingLabel(label, aa.getValue(), (OWLAnnotationProperty)aa.getProperty()) && ((OWLAnnotationSubject)aa.getSubject()).isIRI()).findAny();
                if (!anyMatch.isPresent()) continue;
                return (IRI)anyMatch.get().getSubject();
            }
            return null;
        }

        protected boolean isMatchingLabel(String label, OWLAnnotationValue v, OWLAnnotationProperty property) {
            return property.isLabel() && v instanceof OWLLiteral && label.equals(((OWLLiteral)v).getLiteral());
        }

        @Nullable
        protected OWLClass getOWLClass(IRI iri) {
            for (OWLOntology o : this.ontologies) {
                OWLClass c;
                if (!OWLAPIStreamUtils.asList(o.declarationAxioms(c = o.getOWLOntologyManager().getOWLDataFactory().getOWLClass(iri))).isEmpty()) {
                    return c;
                }
                if (!o.getOWLOntologyManager().getOWLDataFactory().getOWLNothing().equals(c)) continue;
                return c;
            }
            return null;
        }

        @Nullable
        protected OWLNamedIndividual getOWLIndividual(IRI iri) {
            for (OWLOntology o : this.ontologies) {
                OWLNamedIndividual c;
                Optional<OWLDeclarationAxiom> found = o.declarationAxioms(c = o.getOWLOntologyManager().getOWLDataFactory().getOWLNamedIndividual(iri)).filter(da -> da.getEntity().isOWLNamedIndividual()).findAny();
                if (!found.isPresent()) continue;
                return found.get().getEntity().asOWLNamedIndividual();
            }
            return null;
        }

        @Nullable
        protected OWLObjectProperty getOWLObjectProperty(IRI iri) {
            for (OWLOntology o : this.ontologies) {
                OWLObjectProperty p;
                if (OWLAPIStreamUtils.asList(o.declarationAxioms(p = o.getOWLOntologyManager().getOWLDataFactory().getOWLObjectProperty(iri))).isEmpty()) continue;
                return p;
            }
            return null;
        }
    }
}

