/*
 * Decompiled with CFR 0.152.
 */
package uk.ac.manchester.cs.owl.owlapi;

import com.google.common.collect.Sets;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.net.MalformedURLException;
import java.net.UnknownHostException;
import java.util.Arrays;
import java.util.HashSet;
import java.util.LinkedHashMap;
import java.util.Set;
import javax.annotation.Nonnull;
import javax.inject.Inject;
import org.semanticweb.owlapi.formats.RDFXMLDocumentFormat;
import org.semanticweb.owlapi.io.OWLOntologyCreationIOException;
import org.semanticweb.owlapi.io.OWLOntologyDocumentSource;
import org.semanticweb.owlapi.io.OWLParser;
import org.semanticweb.owlapi.io.OWLParserException;
import org.semanticweb.owlapi.io.OWLParserFactory;
import org.semanticweb.owlapi.io.UnparsableOntologyException;
import org.semanticweb.owlapi.model.IRI;
import org.semanticweb.owlapi.model.OWLDocumentFormat;
import org.semanticweb.owlapi.model.OWLOntology;
import org.semanticweb.owlapi.model.OWLOntologyBuilder;
import org.semanticweb.owlapi.model.OWLOntologyCreationException;
import org.semanticweb.owlapi.model.OWLOntologyFactory;
import org.semanticweb.owlapi.model.OWLOntologyID;
import org.semanticweb.owlapi.model.OWLOntologyLoaderConfiguration;
import org.semanticweb.owlapi.model.OWLOntologyManager;
import org.semanticweb.owlapi.model.PriorityCollectionSorting;
import org.semanticweb.owlapi.model.UnloadableImportException;
import org.semanticweb.owlapi.util.OWLAPIPreconditions;
import org.semanticweb.owlapi.util.PriorityCollection;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class OWLOntologyFactoryImpl
implements OWLOntologyFactory {
    private static final long serialVersionUID = 40000L;
    private static final Logger LOGGER = LoggerFactory.getLogger(OWLOntologyFactoryImpl.class);
    private final Set<String> parsableSchemes = new HashSet<String>(Arrays.asList("http", "https", "file", "ftp"));
    private final OWLOntologyBuilder ontologyBuilder;

    @Inject
    public OWLOntologyFactoryImpl(OWLOntologyBuilder ontologyBuilder) {
        this.ontologyBuilder = OWLAPIPreconditions.verifyNotNull(ontologyBuilder);
    }

    @Override
    public boolean canCreateFromDocumentIRI(@Nonnull IRI documentIRI) {
        return true;
    }

    @Override
    @Nonnull
    public OWLOntology createOWLOntology(@Nonnull OWLOntologyManager manager, @Nonnull OWLOntologyID ontologyID, @Nonnull IRI documentIRI, @Nonnull OWLOntologyFactory.OWLOntologyCreationHandler handler) throws OWLOntologyCreationException {
        OWLOntology ont = this.ontologyBuilder.createOWLOntology(manager, ontologyID);
        handler.ontologyCreated(ont);
        handler.setOntologyFormat(ont, new RDFXMLDocumentFormat());
        return ont;
    }

    private static PriorityCollection<OWLParserFactory> getParsers(OWLOntologyDocumentSource documentSource, PriorityCollection<OWLParserFactory> parsers) {
        if (parsers.isEmpty()) {
            return parsers;
        }
        if (!documentSource.isFormatKnown() && !documentSource.isMIMETypeKnown()) {
            return parsers;
        }
        PriorityCollection<OWLParserFactory> candidateParsers = parsers;
        if (documentSource.isFormatKnown()) {
            OWLDocumentFormat format = documentSource.getFormat();
            assert (format != null);
            candidateParsers = OWLOntologyFactoryImpl.getParsersByFormat(format, parsers);
        }
        if (candidateParsers.isEmpty() && documentSource.isMIMETypeKnown()) {
            String mimeType = documentSource.getMIMEType();
            assert (mimeType != null);
            candidateParsers = OWLOntologyFactoryImpl.getParserCandidatesByMIME(mimeType, parsers);
        }
        if (candidateParsers.isEmpty()) {
            return parsers;
        }
        return candidateParsers;
    }

    private static PriorityCollection<OWLParserFactory> getParsersByFormat(@Nonnull OWLDocumentFormat format, PriorityCollection<OWLParserFactory> parsers) {
        PriorityCollection<OWLParserFactory> candidateParsers = new PriorityCollection<OWLParserFactory>(PriorityCollectionSorting.NEVER);
        for (OWLParserFactory parser : parsers) {
            if (!parser.getSupportedFormat().getKey().equals(format.getKey())) continue;
            candidateParsers.add(parser);
        }
        return candidateParsers;
    }

    private static PriorityCollection<OWLParserFactory> getParserCandidatesByMIME(@Nonnull String mimeType, PriorityCollection<OWLParserFactory> parsers) {
        return parsers.getByMIMEType(mimeType);
    }

    @Override
    public boolean canLoad(@Nonnull OWLOntologyDocumentSource documentSource) {
        if (documentSource.isReaderAvailable()) {
            return true;
        }
        if (documentSource.isInputStreamAvailable()) {
            return true;
        }
        if (this.parsableSchemes.contains(documentSource.getDocumentIRI().getScheme())) {
            return true;
        }
        try {
            documentSource.getDocumentIRI().toURI().toURL().openConnection();
            return true;
        }
        catch (IllegalArgumentException e) {
            LOGGER.info("Illegal argument: {}", (Object)documentSource.getDocumentIRI(), (Object)e);
        }
        catch (UnknownHostException e) {
            LOGGER.info("Unknown host: {}", (Object)e.getMessage(), (Object)e);
        }
        catch (MalformedURLException e) {
            LOGGER.info("Malformed URL: {}", (Object)e.getMessage(), (Object)e);
        }
        catch (FileNotFoundException e) {
            LOGGER.info("File not found: {}", (Object)e.getMessage(), (Object)e);
        }
        catch (IOException e) {
            LOGGER.info("IO Exception: {}", (Object)e.getMessage(), (Object)e);
        }
        return false;
    }

    @Override
    @Nonnull
    public OWLOntology loadOWLOntology(@Nonnull OWLOntologyManager manager, @Nonnull OWLOntologyDocumentSource documentSource, @Nonnull OWLOntologyFactory.OWLOntologyCreationHandler handler, @Nonnull OWLOntologyLoaderConfiguration configuration) throws OWLOntologyCreationException {
        LinkedHashMap<OWLParser, OWLParserException> exceptions = new LinkedHashMap<OWLParser, OWLParserException>();
        OWLOntology existingOntology = null;
        IRI iri = documentSource.getDocumentIRI();
        if (manager.contains(iri)) {
            existingOntology = manager.getOntology(iri);
        }
        OWLOntologyID ontologyID = new OWLOntologyID();
        OWLOntology ont = this.createOWLOntology(manager, ontologyID, documentSource.getDocumentIRI(), handler);
        HashSet bannedParsers = Sets.newHashSet((Object[])configuration.getBannedParsers().split(" "));
        PriorityCollection<OWLParserFactory> parsers = OWLOntologyFactoryImpl.getParsers(documentSource, manager.getOntologyParsers());
        for (OWLParserFactory parserFactory : parsers) {
            if (bannedParsers.contains(parserFactory.getClass().getName())) continue;
            OWLParser parser = parserFactory.createParser();
            try {
                if (existingOntology == null && !ont.isEmpty()) {
                    manager.removeOntology(ont);
                    ont = this.createOWLOntology(manager, ontologyID, documentSource.getDocumentIRI(), handler);
                }
                OWLDocumentFormat format = parser.parse(documentSource, ont, configuration);
                handler.setOntologyFormat(ont, format);
                return ont;
            }
            catch (IOException e) {
                manager.removeOntology(ont);
                throw new OWLOntologyCreationIOException(e);
            }
            catch (UnloadableImportException e) {
                manager.removeOntology(ont);
                throw e;
            }
            catch (OWLParserException e) {
                exceptions.put(parser, e);
            }
            catch (RuntimeException e) {
                exceptions.put(parser, new OWLParserException(e));
                manager.removeOntology(ont);
                throw e;
            }
        }
        if (existingOntology == null) {
            manager.removeOntology(ont);
        }
        throw new UnparsableOntologyException(documentSource.getDocumentIRI(), exceptions, configuration);
    }
}

