/*
 * Decompiled with CFR 0.152.
 */
package org.semanticweb.owlapi.vocab;

import java.util.Set;
import java.util.stream.Stream;
import org.semanticweb.owlapi.model.HasIRI;
import org.semanticweb.owlapi.model.HasPrefixedName;
import org.semanticweb.owlapi.model.HasShortForm;
import org.semanticweb.owlapi.model.IRI;
import org.semanticweb.owlapi.util.OWLAPIStreamUtils;
import org.semanticweb.owlapi.vocab.Namespaces;

public enum OWLRDFVocabulary implements HasShortForm,
HasIRI,
HasPrefixedName
{
    OWL_THING(Namespaces.OWL, "Thing"),
    OWL_NOTHING(Namespaces.OWL, "Nothing"),
    OWL_CLASS(Namespaces.OWL, "Class"),
    OWL_ONTOLOGY(Namespaces.OWL, "Ontology"),
    OWL_IMPORTS(Namespaces.OWL, "imports"),
    OWL_VERSION_IRI(Namespaces.OWL, "versionIRI"),
    OWL_VERSION_INFO(Namespaces.OWL, "versionInfo"),
    OWL_EQUIVALENT_CLASS(Namespaces.OWL, "equivalentClass"),
    OWL_OBJECT_PROPERTY(Namespaces.OWL, "ObjectProperty"),
    OWL_DATA_PROPERTY(Namespaces.OWL, "DatatypeProperty"),
    OWL_FUNCTIONAL_PROPERTY(Namespaces.OWL, "FunctionalProperty"),
    OWL_ASYMMETRIC_PROPERTY(Namespaces.OWL, "AsymmetricProperty"),
    OWL_SYMMETRIC_PROPERTY(Namespaces.OWL, "SymmetricProperty"),
    OWL_RESTRICTION(Namespaces.OWL, "Restriction"),
    OWL_ON_PROPERTY(Namespaces.OWL, "onProperty"),
    OWL_INTERSECTION_OF(Namespaces.OWL, "intersectionOf"),
    OWL_UNION_OF(Namespaces.OWL, "unionOf"),
    OWL_ALL_VALUES_FROM(Namespaces.OWL, "allValuesFrom"),
    OWL_SOME_VALUES_FROM(Namespaces.OWL, "someValuesFrom"),
    OWL_HAS_VALUE(Namespaces.OWL, "hasValue"),
    OWL_DISJOINT_WITH(Namespaces.OWL, "disjointWith"),
    OWL_ONE_OF(Namespaces.OWL, "oneOf"),
    OWL_HAS_SELF(Namespaces.OWL, "hasSelf"),
    OWL_DISJOINT_UNION_OF(Namespaces.OWL, "disjointUnionOf"),
    OWL_MIN_CARDINALITY(Namespaces.OWL, "minCardinality"),
    OWL_CARDINALITY(Namespaces.OWL, "cardinality"),
    OWL_QUALIFIED_CARDINALITY(Namespaces.OWL, "qualifiedCardinality"),
    OWL_ANNOTATION_PROPERTY(Namespaces.OWL, "AnnotationProperty"),
    OWL_ANNOTATION(Namespaces.OWL, "Annotation"),
    OWL_INDIVIDUAL(Namespaces.OWL, "Individual"),
    OWL_NAMED_INDIVIDUAL(Namespaces.OWL, "NamedIndividual"),
    OWL_DATATYPE(Namespaces.OWL, "Datatype"),
    RDFS_SUBCLASS_OF(Namespaces.RDFS, "subClassOf"),
    RDFS_SUB_PROPERTY_OF(Namespaces.RDFS, "subPropertyOf"),
    RDF_TYPE(Namespaces.RDF, "type"),
    RDF_NIL(Namespaces.RDF, "nil"),
    RDF_REST(Namespaces.RDF, "rest"),
    RDF_FIRST(Namespaces.RDF, "first"),
    RDF_LIST(Namespaces.RDF, "List"),
    OWL_MAX_CARDINALITY(Namespaces.OWL, "maxCardinality"),
    RDFS_LABEL(Namespaces.RDFS, "label"),
    RDFS_COMMENT(Namespaces.RDFS, "comment"),
    RDFS_SEE_ALSO(Namespaces.RDFS, "seeAlso"),
    RDFS_IS_DEFINED_BY(Namespaces.RDFS, "isDefinedBy"),
    RDFS_RESOURCE(Namespaces.RDFS, "Resource"),
    RDFS_LITERAL(Namespaces.RDFS, "Literal"),
    RDFS_DATATYPE(Namespaces.RDFS, "Datatype"),
    OWL_TRANSITIVE_PROPERTY(Namespaces.OWL, "TransitiveProperty"),
    OWL_REFLEXIVE_PROPERTY(Namespaces.OWL, "ReflexiveProperty"),
    OWL_IRREFLEXIVE_PROPERTY(Namespaces.OWL, "IrreflexiveProperty"),
    OWL_INVERSE_OF(Namespaces.OWL, "inverseOf"),
    OWL_COMPLEMENT_OF(Namespaces.OWL, "complementOf"),
    OWL_DATATYPE_COMPLEMENT_OF(Namespaces.OWL, "datatypeComplementOf"),
    OWL_ALL_DIFFERENT(Namespaces.OWL, "AllDifferent"),
    OWL_DISTINCT_MEMBERS(Namespaces.OWL, "distinctMembers"),
    OWL_SAME_AS(Namespaces.OWL, "sameAs"),
    OWL_DIFFERENT_FROM(Namespaces.OWL, "differentFrom"),
    OWL_DEPRECATED_PROPERTY(Namespaces.OWL, "DeprecatedProperty"),
    OWL_EQUIVALENT_PROPERTY(Namespaces.OWL, "equivalentProperty"),
    OWL_DEPRECATED_CLASS(Namespaces.OWL, "DeprecatedClass"),
    OWL_DATA_RANGE(Namespaces.OWL, "DataRange"),
    RDFS_DOMAIN(Namespaces.RDFS, "domain"),
    RDFS_RANGE(Namespaces.RDFS, "range"),
    RDFS_CLASS(Namespaces.RDFS, "Class"),
    RDF_PROPERTY(Namespaces.RDF, "Property"),
    OWL_PRIOR_VERSION(Namespaces.OWL, "priorVersion"),
    OWL_DEPRECATED(Namespaces.OWL, "deprecated"),
    OWL_INCOMPATIBLE_WITH(Namespaces.OWL, "incompatibleWith"),
    OWL_PROPERTY_DISJOINT_WITH(Namespaces.OWL, "propertyDisjointWith"),
    OWL_ON_CLASS(Namespaces.OWL, "onClass"),
    OWL_ON_DATA_RANGE(Namespaces.OWL, "onDataRange"),
    OWL_ON_DATA_TYPE(Namespaces.OWL, "onDatatype"),
    OWL_WITH_RESTRICTIONS(Namespaces.OWL, "withRestrictions"),
    OWL_AXIOM(Namespaces.OWL, "Axiom"),
    OWL_PROPERTY_CHAIN_AXIOM(Namespaces.OWL, "propertyChainAxiom"),
    OWL_ALL_DISJOINT_CLASSES(Namespaces.OWL, "AllDisjointClasses"),
    OWL_MEMBERS(Namespaces.OWL, "members"),
    OWL_ALL_DISJOINT_PROPERTIES(Namespaces.OWL, "AllDisjointProperties"),
    OWL_TOP_OBJECT_PROPERTY(Namespaces.OWL, "topObjectProperty"),
    OWL_BOTTOM_OBJECT_PROPERTY(Namespaces.OWL, "bottomObjectProperty"),
    OWL_TOP_DATA_PROPERTY(Namespaces.OWL, "topDataProperty"),
    OWL_BOTTOM_DATA_PROPERTY(Namespaces.OWL, "bottomDataProperty"),
    OWL_HAS_KEY(Namespaces.OWL, "hasKey"),
    OWL_ANNOTATED_SOURCE(Namespaces.OWL, "annotatedSource"),
    OWL_ANNOTATED_PROPERTY(Namespaces.OWL, "annotatedProperty"),
    OWL_ANNOTATED_TARGET(Namespaces.OWL, "annotatedTarget"),
    OWL_SOURCE_INDIVIDUAL(Namespaces.OWL, "sourceIndividual"),
    OWL_ASSERTION_PROPERTY(Namespaces.OWL, "assertionProperty"),
    OWL_TARGET_INDIVIDUAL(Namespaces.OWL, "targetIndividual"),
    OWL_TARGET_VALUE(Namespaces.OWL, "targetValue"),
    OWL_INVERSE_FUNCTIONAL_PROPERTY(Namespaces.OWL, "InverseFunctionalProperty"),
    OWL_MIN_QUALIFIED_CARDINALITY(Namespaces.OWL, "minQualifiedCardinality"),
    OWL_MAX_QUALIFIED_CARDINALITY(Namespaces.OWL, "maxQualifiedCardinality"),
    OWL_NEGATIVE_PROPERTY_ASSERTION(Namespaces.OWL, "NegativePropertyAssertion"),
    RDF_LANG_STRING(Namespaces.RDF, "langString"),
    RDF_PLAIN_LITERAL(Namespaces.RDF, "PlainLiteral"),
    RDF_DESCRIPTION(Namespaces.RDF, "Description"),
    RDF_XML_LITERAL(Namespaces.RDF, "XMLLiteral"),
    OWL_BACKWARD_COMPATIBLE_WITH(Namespaces.OWL, "backwardCompatibleWith"),
    OWL_INVERSE_OBJECT_PROPERTY_EXPRESSION(Namespaces.OWL, "inverseObjectPropertyExpression"),
    OWL_ONTOLOGY_PROPERTY(Namespaces.OWL, "OntologyProperty"),
    OWL_ANTI_SYMMETRIC_PROPERTY(Namespaces.OWL, "AntisymmetricProperty"),
    OWL_DATA_RESTRICTION(Namespaces.OWL, "DataRestriction"),
    OWL_OBJECT_RESTRICTION(Namespaces.OWL, "ObjectRestriction"),
    OWL_SELF_RESTRICTION(Namespaces.OWL, "SelfRestriction"),
    OWL_DECLARED_AS(Namespaces.OWL, "declaredAs"),
    OWL_NEGATIVE_OBJECT_PROPERTY_ASSERTION(Namespaces.OWL, "NegativeObjectPropertyAssertion"),
    OWL_NEGATIVE_DATA_PROPERTY_ASSERTION(Namespaces.OWL, "NegativeDataPropertyAssertion"),
    RDF_SUBJECT(Namespaces.RDF, "subject"),
    RDF_PREDICATE(Namespaces.RDF, "predicate"),
    RDF_OBJECT(Namespaces.RDF, "object"),
    OWL_SUBJECT(Namespaces.OWL, "subject"),
    OWL_PREDICATE(Namespaces.OWL, "predicate"),
    OWL_OBJECT(Namespaces.OWL, "object"),
    OWL_OBJECT_PROPERTY_DOMAIN(Namespaces.OWL, "objectPropertyDomain"),
    OWL_DATA_PROPERTY_DOMAIN(Namespaces.OWL, "dataPropertyDomain"),
    OWL_DATA_PROPERTY_RANGE(Namespaces.OWL, "dataPropertyRange"),
    OWL_OBJECT_PROPERTY_RANGE(Namespaces.OWL, "objectPropertyRange"),
    OWL_SUB_OBJECT_PROPERTY_OF(Namespaces.OWL, "subObjectPropertyOf"),
    OWL_SUB_DATA_PROPERTY_OF(Namespaces.OWL, "subDataPropertyOf"),
    OWL_DISJOINT_DATA_PROPERTIES(Namespaces.OWL, "disjointDataProperties"),
    OWL_DISJOINT_OBJECT_PROPERTIES(Namespaces.OWL, "disjointObjectProperties"),
    OWL_EQUIVALENT_DATA_PROPERTIES(Namespaces.OWL, "equivalentDataProperty"),
    OWL_EQUIVALENT_OBJECT_PROPERTIES(Namespaces.OWL, "equivalentObjectProperty"),
    OWL_FUNCTIONAL_DATA_PROPERTY(Namespaces.OWL, "FunctionalDataProperty"),
    OWL_FUNCTIONAL_OBJECT_PROPERTY(Namespaces.OWL, "FunctionalObjectProperty"),
    OWL_PROPERTY_CHAIN(Namespaces.OWL, "propertyChain");

    public static final Set<IRI> BUILT_IN_VOCABULARY_IRIS;
    public static final Set<IRI> BUILT_IN_AP_IRIS;
    private final IRI iri;
    private final Namespaces namespace;
    private final String shortName;
    private final String prefixedName;

    private OWLRDFVocabulary(Namespaces namespace, String shortName) {
        this.namespace = namespace;
        this.shortName = shortName;
        this.prefixedName = namespace.getPrefixName() + ':' + shortName;
        this.iri = IRI.create(namespace.toString(), shortName);
    }

    @Override
    public IRI getIRI() {
        return this.iri;
    }

    public Namespaces getNamespace() {
        return this.namespace;
    }

    @Override
    public String getPrefixedName() {
        return this.prefixedName;
    }

    @Override
    public String getShortForm() {
        return this.shortName;
    }

    public String toString() {
        return this.iri.toString();
    }

    static {
        BUILT_IN_VOCABULARY_IRIS = OWLAPIStreamUtils.asSet(Stream.of(OWLRDFVocabulary.values()).map(i -> i.getIRI()));
        BUILT_IN_AP_IRIS = OWLAPIStreamUtils.asSet(Stream.of(RDFS_LABEL, RDFS_COMMENT, OWL_VERSION_INFO, OWL_BACKWARD_COMPATIBLE_WITH, OWL_PRIOR_VERSION, RDFS_SEE_ALSO, RDFS_IS_DEFINED_BY, OWL_INCOMPATIBLE_WITH, OWL_DEPRECATED).map(HasIRI::getIRI));
    }
}

