/*
 * Decompiled with CFR 0.152.
 */
package org.semanticweb.owlapi.util;

import java.util.Collections;
import java.util.HashMap;
import java.util.Map;
import org.semanticweb.owlapi.model.OWLAnonymousIndividual;
import org.semanticweb.owlapi.model.OWLDataFactory;
import org.semanticweb.owlapi.model.OWLOntologyWriterConfiguration;
import org.semanticweb.owlapi.model.OntologyConfigurator;
import org.semanticweb.owlapi.model.providers.AnonymousIndividualByIdProvider;

public class RemappingIndividualProvider
implements AnonymousIndividualByIdProvider {
    private OWLDataFactory df;
    private OWLOntologyWriterConfiguration cf;
    private Map<String, OWLAnonymousIndividual> map;

    public RemappingIndividualProvider(OntologyConfigurator m, OWLDataFactory df) {
        this.df = df;
        this.cf = m.buildWriterConfiguration();
        this.map = this.cf.shouldRemapAllAnonymousIndividualsIds() ? new HashMap<String, OWLAnonymousIndividual>() : Collections.emptyMap();
    }

    @Override
    public OWLAnonymousIndividual getOWLAnonymousIndividual(String nodeId) {
        if (!this.cf.shouldRemapAllAnonymousIndividualsIds()) {
            return this.df.getOWLAnonymousIndividual(nodeId);
        }
        OWLAnonymousIndividual toReturn = this.map.get(nodeId);
        if (toReturn == null) {
            toReturn = this.df.getOWLAnonymousIndividual();
            this.map.put(nodeId, toReturn);
        }
        return toReturn;
    }
}

