/*
 * Decompiled with CFR 0.152.
 */
package org.semanticweb.owlapi.model;

import java.io.Serializable;
import java.util.EnumMap;
import java.util.HashSet;
import java.util.Set;
import org.semanticweb.owlapi.model.IRI;
import org.semanticweb.owlapi.model.MissingImportHandlingStrategy;
import org.semanticweb.owlapi.model.MissingOntologyHeaderStrategy;
import org.semanticweb.owlapi.model.OWLOntologyLoaderConfiguration;
import org.semanticweb.owlapi.model.OWLOntologyWriterConfiguration;
import org.semanticweb.owlapi.model.PriorityCollectionSorting;
import org.semanticweb.owlapi.model.parameters.ConfigurationOptions;

public class OntologyConfigurator
implements Serializable {
    private final Set<IRI> ignoredImports = new HashSet<IRI>();
    private EnumMap<ConfigurationOptions, Object> overrides = new EnumMap(ConfigurationOptions.class);

    public OntologyConfigurator withBannedParsers(String ban) {
        this.overrides.put(ConfigurationOptions.BANNED_PARSERS, (Object)ban);
        return this;
    }

    public String getBannedParsers() {
        return ConfigurationOptions.BANNED_PARSERS.getValue(String.class, this.overrides);
    }

    public PriorityCollectionSorting getPriorityCollectionSorting() {
        return ConfigurationOptions.PRIORITY_COLLECTION_SORTING.getValue(PriorityCollectionSorting.class, this.overrides);
    }

    public OntologyConfigurator setPriorityCollectionSorting(PriorityCollectionSorting sorting) {
        this.overrides.put(ConfigurationOptions.PRIORITY_COLLECTION_SORTING, (Object)sorting);
        return this;
    }

    public OntologyConfigurator addIgnoredImport(IRI ontologyDocumentIRI) {
        this.ignoredImports.add(ontologyDocumentIRI);
        return this;
    }

    public OntologyConfigurator clearIgnoredImports() {
        this.ignoredImports.clear();
        return this;
    }

    public OntologyConfigurator removeIgnoredImport(IRI ontologyDocumentIRI) {
        this.ignoredImports.remove(ontologyDocumentIRI);
        return this;
    }

    public OntologyConfigurator setAcceptingHTTPCompression(boolean b) {
        this.overrides.put(ConfigurationOptions.ACCEPT_HTTP_COMPRESSION, (Object)b);
        return this;
    }

    public boolean shouldAcceptHTTPCompression() {
        return ConfigurationOptions.ACCEPT_HTTP_COMPRESSION.getValue(Boolean.class, this.overrides);
    }

    public int getConnectionTimeout() {
        return ConfigurationOptions.CONNECTION_TIMEOUT.getValue(Integer.class, this.overrides);
    }

    public OntologyConfigurator setConnectionTimeout(int l) {
        this.overrides.put(ConfigurationOptions.CONNECTION_TIMEOUT, (Object)l);
        return this;
    }

    public OntologyConfigurator setFollowRedirects(boolean value) {
        this.overrides.put(ConfigurationOptions.FOLLOW_REDIRECTS, (Object)value);
        return this;
    }

    public boolean shouldFollowRedirects() {
        return ConfigurationOptions.FOLLOW_REDIRECTS.getValue(Boolean.class, this.overrides);
    }

    public OntologyConfigurator setLoadAnnotationAxioms(boolean b) {
        this.overrides.put(ConfigurationOptions.LOAD_ANNOTATIONS, (Object)b);
        return this;
    }

    public boolean shouldLoadAnnotations() {
        return ConfigurationOptions.LOAD_ANNOTATIONS.getValue(Boolean.class, this.overrides);
    }

    public MissingImportHandlingStrategy getMissingImportHandlingStrategy() {
        return ConfigurationOptions.MISSING_IMPORT_HANDLING_STRATEGY.getValue(MissingImportHandlingStrategy.class, this.overrides);
    }

    public OntologyConfigurator setMissingImportHandlingStrategy(MissingImportHandlingStrategy strategy) {
        this.overrides.put(ConfigurationOptions.MISSING_IMPORT_HANDLING_STRATEGY, (Object)strategy);
        return this;
    }

    public MissingOntologyHeaderStrategy getMissingOntologyHeaderStrategy() {
        return ConfigurationOptions.MISSING_ONTOLOGY_HEADER_STRATEGY.getValue(MissingOntologyHeaderStrategy.class, this.overrides);
    }

    public OntologyConfigurator setMissingOntologyHeaderStrategy(MissingOntologyHeaderStrategy strategy) {
        this.overrides.put(ConfigurationOptions.MISSING_ONTOLOGY_HEADER_STRATEGY, (Object)strategy);
        return this;
    }

    public OntologyConfigurator setReportStackTraces(boolean b) {
        this.overrides.put(ConfigurationOptions.REPORT_STACK_TRACES, (Object)b);
        return this;
    }

    public boolean shouldReportStackTraces() {
        return ConfigurationOptions.REPORT_STACK_TRACES.getValue(Boolean.class, this.overrides);
    }

    public int getRetriesToAttempt() {
        return ConfigurationOptions.RETRIES_TO_ATTEMPT.getValue(Integer.class, this.overrides);
    }

    public OntologyConfigurator setRetriesToAttempt(int retries) {
        this.overrides.put(ConfigurationOptions.RETRIES_TO_ATTEMPT, (Object)retries);
        return this;
    }

    public OntologyConfigurator setStrict(boolean strict) {
        this.overrides.put(ConfigurationOptions.PARSE_WITH_STRICT_CONFIGURATION, (Object)strict);
        return this;
    }

    public boolean shouldParseWithStrictConfiguration() {
        return ConfigurationOptions.PARSE_WITH_STRICT_CONFIGURATION.getValue(Boolean.class, this.overrides);
    }

    public OntologyConfigurator setTreatDublinCoreAsBuiltIn(boolean value) {
        this.overrides.put(ConfigurationOptions.TREAT_DUBLINCORE_AS_BUILTIN, (Object)value);
        return this;
    }

    public boolean shouldTreatDublinCoreAsBuiltin() {
        return ConfigurationOptions.TREAT_DUBLINCORE_AS_BUILTIN.getValue(Boolean.class, this.overrides);
    }

    public boolean shouldRepairIllegalPunnings() {
        return ConfigurationOptions.REPAIR_ILLEGAL_PUNNINGS.getValue(Boolean.class, this.overrides);
    }

    public OntologyConfigurator withRepairIllegalPunnings(boolean b) {
        this.overrides.put(ConfigurationOptions.REPAIR_ILLEGAL_PUNNINGS, (Object)b);
        return this;
    }

    public OWLOntologyLoaderConfiguration buildLoaderConfiguration() {
        return new OWLOntologyLoaderConfiguration().setAcceptingHTTPCompression(this.shouldAcceptHTTPCompression()).setConnectionTimeout(this.getConnectionTimeout()).setFollowRedirects(this.shouldFollowRedirects()).setLoadAnnotationAxioms(this.shouldLoadAnnotations()).setMissingImportHandlingStrategy(this.getMissingImportHandlingStrategy()).setMissingOntologyHeaderStrategy(this.getMissingOntologyHeaderStrategy()).setPriorityCollectionSorting(this.getPriorityCollectionSorting()).setReportStackTraces(this.shouldReportStackTraces()).setRetriesToAttempt(this.getRetriesToAttempt()).setStrict(this.shouldParseWithStrictConfiguration()).setTreatDublinCoreAsBuiltIn(this.shouldTreatDublinCoreAsBuiltin()).setBannedParsers(this.getBannedParsers()).setRepairIllegalPunnings(this.shouldRepairIllegalPunnings());
    }

    public OntologyConfigurator withSaveIdsForAllAnonymousIndividuals(boolean b) {
        this.overrides.put(ConfigurationOptions.SAVE_IDS, (Object)b);
        return this;
    }

    public boolean shouldSaveIds() {
        return ConfigurationOptions.SAVE_IDS.getValue(Boolean.class, this.overrides);
    }

    public OntologyConfigurator withRemapAllAnonymousIndividualsIds(boolean b) {
        this.overrides.put(ConfigurationOptions.REMAP_IDS, (Object)b);
        return this;
    }

    public boolean shouldRemapIds() {
        return ConfigurationOptions.REMAP_IDS.getValue(Boolean.class, this.overrides);
    }

    public OntologyConfigurator withUseNamespaceEntities(boolean useEntities) {
        this.overrides.put(ConfigurationOptions.USE_NAMESPACE_ENTITIES, (Object)useEntities);
        return this;
    }

    public boolean shouldUseNamespaceEntities() {
        return ConfigurationOptions.USE_NAMESPACE_ENTITIES.getValue(Boolean.class, this.overrides);
    }

    public OntologyConfigurator withIndenting(boolean indent) {
        this.overrides.put(ConfigurationOptions.INDENTING, (Object)indent);
        return this;
    }

    public boolean shouldIndent() {
        return ConfigurationOptions.INDENTING.getValue(Boolean.class, this.overrides);
    }

    public OntologyConfigurator withIndentSize(int indent) {
        this.overrides.put(ConfigurationOptions.INDENT_SIZE, (Object)indent);
        return this;
    }

    public int getIndentSize() {
        return ConfigurationOptions.INDENT_SIZE.getValue(Integer.class, this.overrides);
    }

    public OntologyConfigurator withLabelsAsBanner(boolean label) {
        this.overrides.put(ConfigurationOptions.LABELS_AS_BANNER, (Object)label);
        return this;
    }

    public boolean shouldUseLabelsAsBanner() {
        return ConfigurationOptions.LABELS_AS_BANNER.getValue(Boolean.class, this.overrides);
    }

    public OntologyConfigurator withBannersEnabled(boolean label) {
        this.overrides.put(ConfigurationOptions.BANNERS_ENABLED, (Object)label);
        return this;
    }

    public boolean shouldUseBanners() {
        return ConfigurationOptions.BANNERS_ENABLED.getValue(Boolean.class, this.overrides);
    }

    public OWLOntologyWriterConfiguration buildWriterConfiguration() {
        return new OWLOntologyWriterConfiguration().withIndenting(this.shouldIndent()).withIndentSize(this.getIndentSize()).withLabelsAsBanner(this.shouldUseLabelsAsBanner()).withRemapAllAnonymousIndividualsIds(this.shouldRemapIds()).withSaveIdsForAllAnonymousIndividuals(this.shouldSaveIds()).withUseNamespaceEntities(this.shouldUseNamespaceEntities()).withBannersEnabled(this.shouldUseBanners());
    }
}

