/*
 * Decompiled with CFR 0.152.
 */
package org.semanticweb.owlapi.util;

import java.util.ArrayList;
import java.util.List;
import org.semanticweb.owlapi.model.AddImport;
import org.semanticweb.owlapi.model.IRI;
import org.semanticweb.owlapi.model.OWLImportsDeclaration;
import org.semanticweb.owlapi.model.OWLOntology;
import org.semanticweb.owlapi.model.OWLOntologyChange;
import org.semanticweb.owlapi.model.OWLOntologyID;
import org.semanticweb.owlapi.model.OWLOntologyManager;
import org.semanticweb.owlapi.model.RemoveImport;
import org.semanticweb.owlapi.model.SetOntologyID;
import org.semanticweb.owlapi.util.OWLAPIPreconditions;

public class OWLOntologyIRIChanger {
    private final OWLOntologyManager owlOntologyManager;

    public OWLOntologyIRIChanger(OWLOntologyManager owlOntologyManager) {
        this.owlOntologyManager = OWLAPIPreconditions.checkNotNull(owlOntologyManager, "owlOntologyManager cannot be null");
    }

    public List<OWLOntologyChange> getChanges(OWLOntology ontology, IRI newIRI) {
        ArrayList<OWLOntologyChange> changes = new ArrayList<OWLOntologyChange>();
        changes.add(new SetOntologyID(ontology, new OWLOntologyID(OWLAPIPreconditions.optional(newIRI), ontology.getOntologyID().getVersionIRI())));
        OWLImportsDeclaration owlImport = this.owlOntologyManager.getOWLDataFactory().getOWLImportsDeclaration(newIRI);
        IRI ontIRI = ontology.getOntologyID().getOntologyIRI().orElse(null);
        this.owlOntologyManager.ontologies().forEach(ont -> ont.importsDeclarations().filter(decl -> decl.getIRI().equals(ontIRI)).forEach(decl -> {
            changes.add(new RemoveImport((OWLOntology)ont, (OWLImportsDeclaration)decl));
            changes.add(new AddImport((OWLOntology)ont, owlImport));
        }));
        return changes;
    }
}

