/*
 * Decompiled with CFR 0.152.
 */
package org.semanticweb.owlapi.model;

import java.util.List;
import org.semanticweb.owlapi.model.OWLOntology;
import org.semanticweb.owlapi.model.OWLOntologyChange;
import org.semanticweb.owlapi.model.OWLOntologyChangeBroadcastStrategy;
import org.semanticweb.owlapi.model.OWLOntologyChangeListener;
import org.semanticweb.owlapi.util.OWLAPIPreconditions;
import org.semanticweb.owlapi.util.OWLAPIStreamUtils;

public class SpecificOntologyChangeBroadcastStrategy
implements OWLOntologyChangeBroadcastStrategy {
    private final OWLOntology ontology;

    public SpecificOntologyChangeBroadcastStrategy(OWLOntology ontology) {
        this.ontology = OWLAPIPreconditions.checkNotNull(ontology, "ontology cannot be null");
    }

    @Override
    public void broadcastChanges(OWLOntologyChangeListener listener, List<? extends OWLOntologyChange> changes) {
        OWLAPIPreconditions.checkNotNull(listener, "listener cannot be null");
        OWLAPIPreconditions.checkNotNull(changes, "changes cannot be null");
        List<OWLOntologyChange> broadcastChanges = OWLAPIStreamUtils.asList(changes.stream().filter(c -> c.getOntology().equals(this.ontology)), OWLOntologyChange.class);
        listener.ontologiesChanged(broadcastChanges);
    }
}

