/*
 * Decompiled with CFR 0.152.
 */
package org.semanticweb.owlapi.profiles;

import java.util.Collection;
import java.util.stream.Stream;
import org.semanticweb.owlapi.model.OWLAnnotation;
import org.semanticweb.owlapi.model.OWLAnnotationAssertionAxiom;
import org.semanticweb.owlapi.model.OWLAnnotationSubject;
import org.semanticweb.owlapi.model.OWLDeclarationAxiom;
import org.semanticweb.owlapi.model.OWLOntology;
import org.semanticweb.owlapi.util.OWLAPIStreamUtils;
import org.semanticweb.owlapi.util.OWLObjectWalker;
import org.semanticweb.owlapi.util.OWLOntologyWalker;
import org.semanticweb.owlapi.util.StructureWalker;

public class OWLOntologyProfileWalker
extends OWLOntologyWalker {
    public OWLOntologyProfileWalker(Stream<OWLOntology> objects) {
        this((Collection<OWLOntology>)OWLAPIStreamUtils.asList(objects));
    }

    public OWLOntologyProfileWalker(Collection<OWLOntology> objects) {
        super(objects);
        this.setStructureWalker(new ProfileWalker(this));
    }

    class ProfileWalker
    extends StructureWalker<OWLOntology> {
        ProfileWalker(OWLObjectWalker<OWLOntology> owlObjectWalker) {
            super(owlObjectWalker);
        }

        @Override
        public void visit(OWLAnnotationAssertionAxiom axiom) {
            this.process(axiom);
            if (((OWLAnnotationSubject)axiom.getSubject()).isIRI()) {
                ((OWLAnnotationSubject)axiom.getSubject()).accept(this);
            }
            axiom.getAnnotation().accept(this);
        }

        @Override
        public void visit(OWLAnnotation node) {
            this.process(node);
            node.getProperty().accept(this);
            if (node.getValue().isIRI()) {
                node.getValue().accept(this);
            }
        }

        @Override
        public void visit(OWLDeclarationAxiom axiom) {
            this.process(axiom);
            this.walkerCallback.setAxiom(axiom);
            axiom.getEntity().getIRI().accept(this);
        }
    }
}

