/*
 * Decompiled with CFR 0.152.
 */
package org.semanticweb.owlapi.model;

import java.io.File;
import java.io.InputStream;
import java.io.OutputStream;
import java.io.Serializable;
import java.util.Collection;
import java.util.List;
import java.util.Set;
import java.util.stream.Stream;
import javax.annotation.Nullable;
import org.semanticweb.owlapi.io.FileDocumentSource;
import org.semanticweb.owlapi.io.IRIDocumentSource;
import org.semanticweb.owlapi.io.OWLOntologyDocumentSource;
import org.semanticweb.owlapi.io.OWLOntologyDocumentTarget;
import org.semanticweb.owlapi.io.OWLParserFactory;
import org.semanticweb.owlapi.io.StreamDocumentSource;
import org.semanticweb.owlapi.io.StreamDocumentTarget;
import org.semanticweb.owlapi.model.HasAddAxiom;
import org.semanticweb.owlapi.model.HasAddAxioms;
import org.semanticweb.owlapi.model.HasApplyChange;
import org.semanticweb.owlapi.model.HasApplyChanges;
import org.semanticweb.owlapi.model.HasContainsOntology;
import org.semanticweb.owlapi.model.HasDataFactory;
import org.semanticweb.owlapi.model.HasGetOntologyById;
import org.semanticweb.owlapi.model.HasOntologyChangeListeners;
import org.semanticweb.owlapi.model.HasOntologyConfigurator;
import org.semanticweb.owlapi.model.HasOntologyLoaderConfiguration;
import org.semanticweb.owlapi.model.HasOntologyWriterConfiguration;
import org.semanticweb.owlapi.model.HasRemoveAxiom;
import org.semanticweb.owlapi.model.HasRemoveAxioms;
import org.semanticweb.owlapi.model.IRI;
import org.semanticweb.owlapi.model.ImpendingOWLOntologyChangeListener;
import org.semanticweb.owlapi.model.MissingImportListener;
import org.semanticweb.owlapi.model.OWLAxiom;
import org.semanticweb.owlapi.model.OWLDocumentFormat;
import org.semanticweb.owlapi.model.OWLImportsDeclaration;
import org.semanticweb.owlapi.model.OWLOntology;
import org.semanticweb.owlapi.model.OWLOntologyChangeBroadcastStrategy;
import org.semanticweb.owlapi.model.OWLOntologyChangeListener;
import org.semanticweb.owlapi.model.OWLOntologyChangeProgressListener;
import org.semanticweb.owlapi.model.OWLOntologyChangesVetoedListener;
import org.semanticweb.owlapi.model.OWLOntologyCreationException;
import org.semanticweb.owlapi.model.OWLOntologyFactory;
import org.semanticweb.owlapi.model.OWLOntologyID;
import org.semanticweb.owlapi.model.OWLOntologyIRIMapper;
import org.semanticweb.owlapi.model.OWLOntologyLoaderConfiguration;
import org.semanticweb.owlapi.model.OWLOntologyLoaderListener;
import org.semanticweb.owlapi.model.OWLOntologySetProvider;
import org.semanticweb.owlapi.model.OWLOntologyStorageException;
import org.semanticweb.owlapi.model.OWLStorerFactory;
import org.semanticweb.owlapi.model.parameters.OntologyCopy;
import org.semanticweb.owlapi.util.OWLAPIPreconditions;
import org.semanticweb.owlapi.util.OWLAPIStreamUtils;
import org.semanticweb.owlapi.util.PriorityCollection;

public interface OWLOntologyManager
extends OWLOntologySetProvider,
HasDataFactory,
HasGetOntologyById,
HasApplyChanges,
HasApplyChange,
HasAddAxioms,
HasAddAxiom,
HasRemoveAxioms,
HasRemoveAxiom,
HasContainsOntology,
HasOntologyChangeListeners,
HasOntologyConfigurator,
HasOntologyLoaderConfiguration,
HasOntologyWriterConfiguration,
Serializable {
    public void clearOntologies();

    @Deprecated
    default public Set<OWLOntology> getOntologies(OWLAxiom axiom) {
        return OWLAPIStreamUtils.asSet(this.ontologies(axiom));
    }

    default public Stream<OWLOntology> ontologies(OWLAxiom axiom) {
        return this.ontologies().filter(o -> o.containsAxiom(axiom));
    }

    @Deprecated
    default public Set<OWLOntology> getVersions(IRI ontology) {
        return OWLAPIStreamUtils.asSet(this.versions(ontology));
    }

    default public Stream<OWLOntology> versions(IRI ontology) {
        return this.ontologies().filter(o -> o.getOntologyID().matchOntology(ontology));
    }

    public boolean contains(OWLOntology var1);

    public boolean contains(IRI var1);

    @Override
    public boolean contains(OWLOntologyID var1);

    public boolean containsVersion(IRI var1);

    @Deprecated
    default public Set<OWLOntologyID> getOntologyIDsByVersion(IRI ontologyVersionIRI) {
        return OWLAPIStreamUtils.asSet(this.ontologyIDsByVersion(ontologyVersionIRI));
    }

    public Stream<OWLOntologyID> ontologyIDsByVersion(IRI var1);

    @Nullable
    public OWLOntology getOntology(IRI var1);

    @Override
    @Nullable
    public OWLOntology getOntology(OWLOntologyID var1);

    @Nullable
    public OWLOntology getImportedOntology(OWLImportsDeclaration var1);

    @Deprecated
    default public Set<OWLOntology> getDirectImports(OWLOntology ontology) {
        return OWLAPIStreamUtils.asSet(this.directImports(ontology));
    }

    public Stream<OWLOntology> directImports(OWLOntology var1);

    @Deprecated
    default public Set<OWLOntology> getImports(OWLOntology ontology) {
        return OWLAPIStreamUtils.asSet(this.imports(ontology));
    }

    public Stream<OWLOntology> imports(OWLOntology var1);

    @Deprecated
    default public Set<OWLOntology> getImportsClosure(OWLOntology ontology) {
        return OWLAPIStreamUtils.asSet(this.importsClosure(ontology));
    }

    public Stream<OWLOntology> importsClosure(OWLOntology var1);

    public List<OWLOntology> getSortedImportsClosure(OWLOntology var1);

    default public OWLOntology createOntology() throws OWLOntologyCreationException {
        return this.createOntology(new OWLOntologyID());
    }

    default public OWLOntology createOntology(Collection<OWLAxiom> axioms) throws OWLOntologyCreationException {
        return this.createOntology(axioms, IRI.getNextDocumentIRI("owlapi:ontology#ont"));
    }

    default public OWLOntology createOntology(Stream<OWLAxiom> axioms) throws OWLOntologyCreationException {
        return this.createOntology(axioms, IRI.getNextDocumentIRI("owlapi:ontology#ont"));
    }

    default public OWLOntology createOntology(Collection<OWLAxiom> axioms, IRI ontologyIRI) throws OWLOntologyCreationException {
        return this.createOntology(axioms.stream(), ontologyIRI);
    }

    public OWLOntology createOntology(Stream<OWLAxiom> var1, IRI var2) throws OWLOntologyCreationException;

    default public OWLOntology createOntology(IRI ontologyIRI) throws OWLOntologyCreationException {
        return this.createOntology(new OWLOntologyID(OWLAPIPreconditions.optional(ontologyIRI), OWLAPIPreconditions.emptyOptional(IRI.class)));
    }

    public OWLOntology createOntology(OWLOntologyID var1) throws OWLOntologyCreationException;

    default public OWLOntology createOntology(IRI ontologyIRI, Collection<OWLOntology> ontologies, boolean copyLogicalAxiomsOnly) throws OWLOntologyCreationException {
        return this.createOntology(ontologyIRI, ontologies.stream(), copyLogicalAxiomsOnly);
    }

    public OWLOntology createOntology(IRI var1, Stream<OWLOntology> var2, boolean var3) throws OWLOntologyCreationException;

    default public OWLOntology createOntology(IRI ontologyIRI, Collection<OWLOntology> ontologies) throws OWLOntologyCreationException {
        return this.createOntology(ontologyIRI, ontologies, false);
    }

    public OWLOntology copyOntology(OWLOntology var1, OntologyCopy var2) throws OWLOntologyCreationException;

    public OWLOntology loadOntology(IRI var1) throws OWLOntologyCreationException;

    default public OWLOntology loadOntologyFromOntologyDocument(IRI documentIRI) throws OWLOntologyCreationException {
        return this.loadOntologyFromOntologyDocument(new IRIDocumentSource(documentIRI, null, null), this.getOntologyLoaderConfiguration());
    }

    default public OWLOntology loadOntologyFromOntologyDocument(File file) throws OWLOntologyCreationException {
        return this.loadOntologyFromOntologyDocument(new FileDocumentSource(file));
    }

    default public OWLOntology loadOntologyFromOntologyDocument(InputStream inputStream) throws OWLOntologyCreationException {
        return this.loadOntologyFromOntologyDocument(new StreamDocumentSource(inputStream));
    }

    default public OWLOntology loadOntologyFromOntologyDocument(OWLOntologyDocumentSource documentSource) throws OWLOntologyCreationException {
        return this.loadOntologyFromOntologyDocument(documentSource, this.getOntologyLoaderConfiguration());
    }

    public OWLOntology loadOntologyFromOntologyDocument(OWLOntologyDocumentSource var1, OWLOntologyLoaderConfiguration var2) throws OWLOntologyCreationException;

    default public void removeOntology(OWLOntology ontology) {
        this.removeOntology(ontology.getOntologyID());
    }

    public void removeOntology(OWLOntologyID var1);

    public IRI getOntologyDocumentIRI(OWLOntology var1);

    public void setOntologyDocumentIRI(OWLOntology var1, IRI var2);

    @Nullable
    public OWLDocumentFormat getOntologyFormat(OWLOntology var1);

    default public OWLDocumentFormat getNonnullOntologyFormat(OWLOntology ontology) {
        return OWLAPIPreconditions.verifyNotNull(this.getOntologyFormat(ontology), () -> "There is no format specified for ontology " + ontology.getOntologyID() + ", the ontology format needs to be set before saving or specified in the save call");
    }

    public void setOntologyFormat(OWLOntology var1, OWLDocumentFormat var2);

    default public void saveOntology(OWLOntology ontology) throws OWLOntologyStorageException {
        this.saveOntology(ontology, this.getNonnullOntologyFormat(ontology));
    }

    default public void saveOntology(OWLOntology ontology, IRI documentIRI) throws OWLOntologyStorageException {
        this.saveOntology(ontology, this.getNonnullOntologyFormat(ontology), documentIRI);
    }

    default public void saveOntology(OWLOntology ontology, OutputStream outputStream) throws OWLOntologyStorageException {
        this.saveOntology(ontology, new StreamDocumentTarget(outputStream));
    }

    default public void saveOntology(OWLOntology ontology, OWLDocumentFormat ontologyFormat) throws OWLOntologyStorageException {
        this.saveOntology(ontology, ontologyFormat, this.getOntologyDocumentIRI(ontology));
    }

    public void saveOntology(OWLOntology var1, OWLDocumentFormat var2, IRI var3) throws OWLOntologyStorageException;

    default public void saveOntology(OWLOntology ontology, OWLDocumentFormat ontologyFormat, OutputStream outputStream) throws OWLOntologyStorageException {
        this.saveOntology(ontology, ontologyFormat, new StreamDocumentTarget(outputStream));
    }

    default public void saveOntology(OWLOntology ontology, OWLOntologyDocumentTarget documentTarget) throws OWLOntologyStorageException {
        this.saveOntology(ontology, this.getNonnullOntologyFormat(ontology), documentTarget);
    }

    public void saveOntology(OWLOntology var1, OWLDocumentFormat var2, OWLOntologyDocumentTarget var3) throws OWLOntologyStorageException;

    @Deprecated
    public void addIRIMapper(OWLOntologyIRIMapper var1);

    @Deprecated
    public void removeIRIMapper(OWLOntologyIRIMapper var1);

    @Deprecated
    public void clearIRIMappers();

    @Deprecated
    public void addOntologyStorer(OWLStorerFactory var1);

    @Deprecated
    public void removeOntologyStorer(OWLStorerFactory var1);

    @Deprecated
    public void clearOntologyStorers();

    public void setIRIMappers(Set<OWLOntologyIRIMapper> var1);

    public PriorityCollection<OWLOntologyIRIMapper> getIRIMappers();

    public void setOntologyParsers(Set<OWLParserFactory> var1);

    public PriorityCollection<OWLParserFactory> getOntologyParsers();

    public void setOntologyFactories(Set<OWLOntologyFactory> var1);

    public PriorityCollection<OWLOntologyFactory> getOntologyFactories();

    public void setOntologyStorers(Set<OWLStorerFactory> var1);

    public PriorityCollection<OWLStorerFactory> getOntologyStorers();

    public void addOntologyChangeListener(OWLOntologyChangeListener var1, OWLOntologyChangeBroadcastStrategy var2);

    public void addImpendingOntologyChangeListener(ImpendingOWLOntologyChangeListener var1);

    public void removeImpendingOntologyChangeListener(ImpendingOWLOntologyChangeListener var1);

    public void addOntologyChangesVetoedListener(OWLOntologyChangesVetoedListener var1);

    public void removeOntologyChangesVetoedListener(OWLOntologyChangesVetoedListener var1);

    public void setDefaultChangeBroadcastStrategy(OWLOntologyChangeBroadcastStrategy var1);

    default public void makeLoadImportRequest(OWLImportsDeclaration declaration) {
        this.makeLoadImportRequest(declaration, this.getOntologyLoaderConfiguration());
    }

    public void makeLoadImportRequest(OWLImportsDeclaration var1, OWLOntologyLoaderConfiguration var2);

    public void addMissingImportListener(MissingImportListener var1);

    public void removeMissingImportListener(MissingImportListener var1);

    public void addOntologyLoaderListener(OWLOntologyLoaderListener var1);

    public void removeOntologyLoaderListener(OWLOntologyLoaderListener var1);

    public void addOntologyChangeProgessListener(OWLOntologyChangeProgressListener var1);

    public void removeOntologyChangeProgessListener(OWLOntologyChangeProgressListener var1);
}

