/*
 * Decompiled with CFR 0.152.
 */
package org.semanticweb.binaryowl.owlobject.serializer;

import com.google.common.base.Optional;
import java.io.IOException;
import org.semanticweb.binaryowl.BinaryOWLParseException;
import org.semanticweb.binaryowl.owlobject.serializer.IRISerializer;
import org.semanticweb.binaryowl.stream.BinaryOWLInputStream;
import org.semanticweb.binaryowl.stream.BinaryOWLOutputStream;
import org.semanticweb.owlapi.model.IRI;
import org.semanticweb.owlapi.model.OWLOntologyID;

public class BinaryOWLOntologyID {
    private static final int ANONYMOUS_ONTOLOGY_MARKER = 0;
    private static final int ONTOLOGY_IRI_NO_VERSION_IRI_MARKER = 1;
    private static final int ONTOLOGY_IRI_PLUS_VERSION_IRI_MARKER = 2;
    private OWLOntologyID ontologyID;

    public BinaryOWLOntologyID(OWLOntologyID ontologyID) {
        this.ontologyID = ontologyID;
    }

    public BinaryOWLOntologyID(BinaryOWLInputStream inputStream) throws IOException, BinaryOWLParseException {
        this.read(inputStream);
    }

    public OWLOntologyID getOntologyID() {
        return this.ontologyID;
    }

    public void write(BinaryOWLOutputStream outputStream) throws IOException {
        if (this.ontologyID.isAnonymous()) {
            outputStream.writeByte(0);
        } else if (this.ontologyID.getVersionIRI().isPresent()) {
            outputStream.writeByte(2);
            outputStream.writeIRI((IRI)this.ontologyID.getOntologyIRI().get());
            outputStream.writeIRI((IRI)this.ontologyID.getVersionIRI().get());
        } else {
            outputStream.writeByte(1);
            outputStream.writeIRI((IRI)this.ontologyID.getOntologyIRI().get());
        }
    }

    private void read(BinaryOWLInputStream inputStream) throws IOException, BinaryOWLParseException {
        byte marker = inputStream.readByte();
        if (marker == 0) {
            this.ontologyID = new OWLOntologyID();
        } else if (marker == 1) {
            IRISerializer serializer = new IRISerializer();
            IRI ontologyIRI = serializer.readObject(inputStream);
            this.ontologyID = new OWLOntologyID(Optional.of((Object)ontologyIRI), Optional.absent());
        } else if (marker == 2) {
            IRISerializer serializer = new IRISerializer();
            IRI ontologyIRI = serializer.readObject(inputStream);
            IRI versionIRI = serializer.readObject(inputStream);
            this.ontologyID = new OWLOntologyID(Optional.of((Object)ontologyIRI), Optional.of((Object)versionIRI));
        } else {
            throw new BinaryOWLParseException("Unexpected OntologyID marker: " + marker);
        }
    }
}

