/*
 * Decompiled with CFR 0.152.
 */
package org.semanticweb.binaryowl.owlapi;

import java.io.IOException;
import java.io.InputStream;
import javax.annotation.Nonnull;
import org.semanticweb.binaryowl.BinaryOWLOntologyDocumentSerializer;
import org.semanticweb.binaryowl.BinaryOWLParseException;
import org.semanticweb.binaryowl.owlapi.BinaryOWLOntologyBuildingHandler;
import org.semanticweb.binaryowl.owlapi.BinaryOWLOntologyDocumentFormat;
import org.semanticweb.owlapi.io.OWLOntologyDocumentSource;
import org.semanticweb.owlapi.io.OWLParser;
import org.semanticweb.owlapi.model.IRI;
import org.semanticweb.owlapi.model.OWLDataFactory;
import org.semanticweb.owlapi.model.OWLDocumentFormat;
import org.semanticweb.owlapi.model.OWLDocumentFormatFactory;
import org.semanticweb.owlapi.model.OWLOntology;
import org.semanticweb.owlapi.model.OWLOntologyLoaderConfiguration;
import org.semanticweb.owlapi.model.UnloadableImportException;
import org.semanticweb.owlapi.util.OWLDocumentFormatFactoryImpl;

public class BinaryOWLOntologyDocumentParser
implements OWLParser {
    @Nonnull
    public String getName() {
        return "Binary OWL";
    }

    public OWLDocumentFormatFactory getSupportedFormat() {
        return new OWLDocumentFormatFactoryImpl(){

            public OWLDocumentFormat createFormat() {
                return new BinaryOWLOntologyDocumentFormat();
            }
        };
    }

    @Nonnull
    public OWLDocumentFormat parse(@Nonnull IRI documentIRI, @Nonnull OWLOntology ontology) throws IOException {
        return this.parse(documentIRI.toURI().toURL().openStream(), ontology, new OWLOntologyLoaderConfiguration());
    }

    @Nonnull
    public OWLDocumentFormat parse(@Nonnull OWLOntologyDocumentSource documentSource, @Nonnull OWLOntology ontology, @Nonnull OWLOntologyLoaderConfiguration configuration) throws IOException {
        if (documentSource.isInputStreamAvailable()) {
            try (InputStream is = documentSource.getInputStream();){
                OWLDocumentFormat oWLDocumentFormat = this.parse(is, ontology, configuration);
                return oWLDocumentFormat;
            }
        }
        try (InputStream is = documentSource.getDocumentIRI().toURI().toURL().openStream();){
            OWLDocumentFormat oWLDocumentFormat = this.parse(is, ontology, configuration);
            return oWLDocumentFormat;
        }
    }

    private OWLDocumentFormat parse(InputStream is, OWLOntology ontology, OWLOntologyLoaderConfiguration configuration) throws IOException, BinaryOWLParseException, UnloadableImportException {
        BinaryOWLOntologyDocumentSerializer serializer = new BinaryOWLOntologyDocumentSerializer();
        BinaryOWLOntologyBuildingHandler handler = new BinaryOWLOntologyBuildingHandler(configuration, ontology);
        OWLDataFactory df = ontology.getOWLOntologyManager().getOWLDataFactory();
        serializer.read(is, handler, df);
        return handler.getFormat();
    }
}

