/*
 * Decompiled with CFR 0.152.
 */
package org.semanticweb.binaryowl.lookup;

import java.io.DataInput;
import java.io.DataOutput;
import java.io.IOException;
import org.semanticweb.binaryowl.lookup.AnonymousIndividualLookupTable;
import org.semanticweb.binaryowl.lookup.IRILookupTable;
import org.semanticweb.binaryowl.lookup.LiteralLookupTable;
import org.semanticweb.owlapi.model.IRI;
import org.semanticweb.owlapi.model.OWLAnnotationProperty;
import org.semanticweb.owlapi.model.OWLAnonymousIndividual;
import org.semanticweb.owlapi.model.OWLClass;
import org.semanticweb.owlapi.model.OWLDataProperty;
import org.semanticweb.owlapi.model.OWLDatatype;
import org.semanticweb.owlapi.model.OWLLiteral;
import org.semanticweb.owlapi.model.OWLNamedIndividual;
import org.semanticweb.owlapi.model.OWLObjectProperty;

public class LookupTable {
    private IRILookupTable iriLookupTable;
    private AnonymousIndividualLookupTable anonymousIndividualLookupTable;
    private LiteralLookupTable literalLookupTable;
    private static LookupTable EMPTY_LOOKUP_TABLE = new LookupTable(new IRILookupTable(), new AnonymousIndividualLookupTable(){

        @Override
        public int getIndex(OWLAnonymousIndividual ind) {
            return System.identityHashCode(ind);
        }
    }, new LiteralLookupTable(){

        @Override
        public int getIndex(OWLLiteral literal) {
            return -1;
        }
    });

    public LookupTable(IRILookupTable iriLookupTable, AnonymousIndividualLookupTable anonymousIndividualLookupTable, LiteralLookupTable literalLookupTable) {
        this.iriLookupTable = iriLookupTable;
        this.anonymousIndividualLookupTable = anonymousIndividualLookupTable;
        this.literalLookupTable = literalLookupTable;
    }

    public LookupTable(IRILookupTable iriLookupTable) {
        this(iriLookupTable, new AnonymousIndividualLookupTable(), null);
    }

    public LookupTable() {
        this(new IRILookupTable(), new AnonymousIndividualLookupTable(), new LiteralLookupTable());
    }

    public static LookupTable emptyLookupTable() {
        return EMPTY_LOOKUP_TABLE;
    }

    public IRILookupTable getIRILookupTable() {
        return this.iriLookupTable;
    }

    public AnonymousIndividualLookupTable getAnonymousIndividualLookupTable() {
        return this.anonymousIndividualLookupTable;
    }

    public LiteralLookupTable getLiteralLookupTable() {
        return this.literalLookupTable;
    }

    public void writeIRI(IRI iri, DataOutput dataOutput) throws IOException {
        this.iriLookupTable.writeIRI(iri, dataOutput);
    }

    public IRI readIRI(DataInput dataInput) throws IOException {
        return this.iriLookupTable.readIRI(dataInput);
    }

    public OWLClass readClassIRI(DataInput dataInput) throws IOException {
        return this.iriLookupTable.readClassIRI(dataInput);
    }

    public OWLObjectProperty readObjectPropertyIRI(DataInput dataInput) throws IOException {
        return this.iriLookupTable.readObjectPropertyIRI(dataInput);
    }

    public OWLDataProperty readDataPropertyIRI(DataInput dataInput) throws IOException {
        return this.iriLookupTable.readDataPropertyIRI(dataInput);
    }

    public OWLAnnotationProperty readAnnotationPropertyIRI(DataInput dataInput) throws IOException {
        return this.iriLookupTable.readAnnotationPropertyIRI(dataInput);
    }

    public OWLNamedIndividual readIndividualIRI(DataInput dataInput) throws IOException {
        return this.iriLookupTable.readIndividualIRI(dataInput);
    }

    public OWLDatatype readDatatypeIRI(DataInput dataInput) throws IOException {
        return this.iriLookupTable.readDataypeIRI(dataInput);
    }
}

