/*
 * Decompiled with CFR 0.152.
 */
package org.semanticweb.binaryowl.lookup;

import com.google.common.base.Optional;
import java.io.DataInput;
import java.io.DataOutput;
import java.io.IOException;
import java.util.ArrayList;
import java.util.LinkedHashMap;
import java.util.Map;
import java.util.Set;
import org.semanticweb.binaryowl.doc.OWLOntologyDocument;
import org.semanticweb.owlapi.model.IRI;
import org.semanticweb.owlapi.model.OWLAnnotationProperty;
import org.semanticweb.owlapi.model.OWLClass;
import org.semanticweb.owlapi.model.OWLDataProperty;
import org.semanticweb.owlapi.model.OWLDatatype;
import org.semanticweb.owlapi.model.OWLEntity;
import org.semanticweb.owlapi.model.OWLNamedIndividual;
import org.semanticweb.owlapi.model.OWLObjectProperty;
import uk.ac.manchester.cs.owl.owlapi.OWLAnnotationPropertyImpl;
import uk.ac.manchester.cs.owl.owlapi.OWLClassImpl;
import uk.ac.manchester.cs.owl.owlapi.OWLDataPropertyImpl;
import uk.ac.manchester.cs.owl.owlapi.OWLDatatypeImpl;
import uk.ac.manchester.cs.owl.owlapi.OWLNamedIndividualImpl;
import uk.ac.manchester.cs.owl.owlapi.OWLObjectPropertyImpl;

public class IRILookupTable {
    public static final int NOT_INDEXED_MARKER = -8;
    private Map<String, Integer> startIndex = new LinkedHashMap<String, Integer>();
    private Map<IRI, Integer> iri2IndexMap = new LinkedHashMap<IRI, Integer>();
    private IRI[] iriTable;
    private OWLClass[] clsTable;
    private OWLObjectProperty[] objectPropertyTable;
    private OWLDataProperty[] dataPropertyTable;
    private OWLAnnotationProperty[] annotationPropertyTable;
    private OWLNamedIndividual[] individualTable;
    private OWLDatatype[] datatypeTable;

    public IRILookupTable(OWLOntologyDocument ontology) {
        this.processSignatureSubset(ontology.getClassesInSignature());
        this.processSignatureSubset(ontology.getObjectPropertiesInSignature());
        this.processSignatureSubset(ontology.getDataPropertiesInSignature());
        this.processSignatureSubset(ontology.getAnnotationPropertiesInSignature());
        this.processSignatureSubset(ontology.getIndividualsInSignature());
        this.processSignatureSubset(ontology.getDatatypesInSignature());
    }

    public IRILookupTable(Set<? extends OWLEntity> signature) {
        this.processSignatureSubset(signature);
    }

    public IRILookupTable(DataInput dis) throws IOException {
        this.read(dis);
    }

    public IRILookupTable() {
    }

    private void processSignatureSubset(Set<? extends OWLEntity> signature) {
        for (OWLEntity oWLEntity : signature) {
            this.processEntity(oWLEntity);
        }
    }

    private void processEntity(OWLEntity entity) {
        IRI iri = entity.getIRI();
        this.processIRI(iri);
    }

    private void processIRI(IRI iri) {
        String start;
        if (!this.iri2IndexMap.containsKey(iri)) {
            int iriIndex = this.iri2IndexMap.size();
            this.iri2IndexMap.put(iri, iriIndex);
        }
        if (!this.startIndex.containsKey(start = iri.getNamespace())) {
            this.startIndex.put(start, this.startIndex.size());
        }
    }

    private int get(OWLEntity e) {
        return this.iri2IndexMap.get(e.getIRI());
    }

    private int get(IRI iri) {
        return this.getIndex(iri);
    }

    private IRI get(int index) {
        return this.iriTable[index];
    }

    private int getIndex(IRI iri) {
        Integer i = this.iri2IndexMap.get(iri);
        if (i == null) {
            return -1;
        }
        return i;
    }

    public void write(DataOutput os) throws IOException {
        os.writeInt(this.startIndex.size());
        for (String start : this.startIndex.keySet()) {
            os.writeUTF(start);
        }
        os.writeInt(this.iri2IndexMap.size());
        for (IRI iri : this.iri2IndexMap.keySet()) {
            int si = this.startIndex.get(iri.getNamespace());
            os.writeInt(si);
            Optional remainder = iri.getRemainder();
            if (!remainder.isPresent()) {
                os.writeUTF("");
                continue;
            }
            os.writeUTF((String)remainder.get());
        }
    }

    private void read(DataInput is) throws IOException {
        int startIndexSize = is.readInt();
        ArrayList<String> startIndexes = new ArrayList<String>(startIndexSize);
        for (int i = 0; i < startIndexSize; ++i) {
            String s = is.readUTF();
            startIndexes.add(s);
        }
        int size = is.readInt();
        if (size == 0) {
            return;
        }
        this.iriTable = new IRI[size];
        for (int i = 0; i < size; ++i) {
            IRI iri;
            int startIndex = is.readInt();
            String start = (String)startIndexes.get(startIndex);
            String s = is.readUTF();
            this.iriTable[i] = iri = IRI.create((String)start, (String)s);
        }
        this.clsTable = new OWLClass[size];
        this.annotationPropertyTable = new OWLAnnotationProperty[size];
        this.datatypeTable = new OWLDatatype[size];
    }

    public IRI readIRI(DataInput dis) throws IOException {
        int index = this.readIndex(dis);
        if (index == -8) {
            return this.readNonIndexedIRI(dis);
        }
        return this.iriTable[index];
    }

    private IRI readNonIndexedIRI(DataInput dis) throws IOException {
        byte startMarker = dis.readByte();
        String start = startMarker == 0 ? null : dis.readUTF();
        byte fragmentMarker = dis.readByte();
        String fragment = fragmentMarker == 0 ? null : dis.readUTF();
        return IRI.create((String)start, (String)fragment);
    }

    private int readIndex(DataInput dataInput) throws IOException {
        byte size = dataInput.readByte();
        if (size == 0) {
            return 0;
        }
        if (size == -8) {
            return -8;
        }
        if (size == -2) {
            return dataInput.readShort();
        }
        if (size == -4) {
            return dataInput.readInt();
        }
        if (size < 127) {
            return size;
        }
        throw new RuntimeException();
    }

    private void writeIndex(int i, DataOutput dos) throws IOException {
        if (i == -8) {
            dos.writeByte(i);
        } else if (i == 0) {
            dos.writeByte(0);
        } else if (i < 127) {
            dos.writeByte(i);
        } else if (i < Short.MAX_VALUE) {
            dos.writeByte(-2);
            dos.writeShort(i);
        } else {
            dos.writeByte(-4);
            dos.writeInt(i);
        }
    }

    public OWLClass readClassIRI(DataInput dis) throws IOException {
        if (this.iriTable == null) {
            IRI iri = this.readIRI(dis);
            return new OWLClassImpl(iri);
        }
        int index = this.readIndex(dis);
        if (index == -8) {
            IRI iri = this.readNonIndexedIRI(dis);
            return new OWLClassImpl(iri);
        }
        OWLClass cls = this.clsTable[index];
        if (cls == null) {
            this.clsTable[index] = cls = new OWLClassImpl(this.iriTable[index]);
        }
        return cls;
    }

    public OWLObjectProperty readObjectPropertyIRI(DataInput dis) throws IOException {
        int index;
        if (this.iriTable == null) {
            IRI iri = this.readIRI(dis);
            return new OWLObjectPropertyImpl(iri);
        }
        if (this.objectPropertyTable == null) {
            this.objectPropertyTable = new OWLObjectProperty[this.iriTable.length];
        }
        if ((index = this.readIndex(dis)) == -8) {
            IRI iri = this.readNonIndexedIRI(dis);
            return new OWLObjectPropertyImpl(iri);
        }
        OWLObjectProperty prop = this.objectPropertyTable[index];
        if (prop == null) {
            this.objectPropertyTable[index] = prop = new OWLObjectPropertyImpl(this.iriTable[index]);
        }
        return prop;
    }

    public OWLDataProperty readDataPropertyIRI(DataInput dis) throws IOException {
        int index;
        if (this.iriTable == null) {
            IRI iri = this.readIRI(dis);
            return new OWLDataPropertyImpl(iri);
        }
        if (this.dataPropertyTable == null) {
            this.dataPropertyTable = new OWLDataProperty[this.iriTable.length];
        }
        if ((index = this.readIndex(dis)) == -8) {
            IRI iri = this.readNonIndexedIRI(dis);
            return new OWLDataPropertyImpl(iri);
        }
        OWLDataProperty prop = this.dataPropertyTable[index];
        if (prop == null) {
            this.dataPropertyTable[index] = prop = new OWLDataPropertyImpl(this.iriTable[index]);
        }
        return prop;
    }

    public OWLAnnotationProperty readAnnotationPropertyIRI(DataInput dis) throws IOException {
        if (this.iriTable == null) {
            IRI iri = this.readIRI(dis);
            return new OWLAnnotationPropertyImpl(iri);
        }
        int index = this.readIndex(dis);
        if (index == -8) {
            IRI iri = this.readNonIndexedIRI(dis);
            return new OWLAnnotationPropertyImpl(iri);
        }
        OWLAnnotationProperty prop = this.annotationPropertyTable[index];
        if (prop == null) {
            this.annotationPropertyTable[index] = prop = new OWLAnnotationPropertyImpl(this.iriTable[index]);
        }
        return prop;
    }

    public OWLDatatype readDataypeIRI(DataInput dis) throws IOException {
        if (this.iriTable == null) {
            IRI iri = this.readIRI(dis);
            return new OWLDatatypeImpl(iri);
        }
        int index = this.readIndex(dis);
        if (index == -8) {
            IRI iri = this.readNonIndexedIRI(dis);
            return new OWLDatatypeImpl(iri);
        }
        OWLDatatype prop = this.datatypeTable[index];
        if (prop == null) {
            this.datatypeTable[index] = prop = new OWLDatatypeImpl(this.iriTable[index]);
        }
        return prop;
    }

    public OWLNamedIndividual readIndividualIRI(DataInput dis) throws IOException {
        int index;
        if (this.iriTable == null) {
            IRI iri = this.readIRI(dis);
            return new OWLNamedIndividualImpl(iri);
        }
        if (this.individualTable == null) {
            this.individualTable = new OWLNamedIndividual[this.iriTable.length];
        }
        if ((index = this.readIndex(dis)) == -8) {
            IRI iri = this.readNonIndexedIRI(dis);
            return new OWLNamedIndividualImpl(iri);
        }
        OWLNamedIndividual ind = this.individualTable[index];
        if (ind == null) {
            this.individualTable[index] = ind = new OWLNamedIndividualImpl(this.iriTable[index]);
        }
        return ind;
    }

    public void writeIRI(IRI iri, DataOutput dataOutput) throws IOException {
        int index = this.getIndex(iri);
        if (index == -1) {
            this.writeIndex(-8, dataOutput);
            String start = iri.getNamespace();
            if (start == null) {
                dataOutput.writeByte(0);
            } else {
                dataOutput.writeByte(1);
                dataOutput.writeUTF(start);
            }
            Optional fragment = iri.getRemainder();
            if (!fragment.isPresent()) {
                dataOutput.writeByte(0);
            } else {
                dataOutput.writeByte(1);
                dataOutput.writeUTF((String)fragment.get());
            }
        } else {
            this.writeIndex(index, dataOutput);
        }
    }
}

