/*
 * Decompiled with CFR 0.152.
 */
package org.semanticweb.binaryowl.change;

import java.io.IOException;
import org.semanticweb.binaryowl.BinaryOWLParseException;
import org.semanticweb.binaryowl.change.OntologyChangeData2OntologyChangeInfoTypeTranslator;
import org.semanticweb.binaryowl.change.serializer.AddAxiomDataSerializer;
import org.semanticweb.binaryowl.change.serializer.AddImportDataSerializer;
import org.semanticweb.binaryowl.change.serializer.AddOntologyAnnotationDataSerializer;
import org.semanticweb.binaryowl.change.serializer.OntologyChangeDataSerializer;
import org.semanticweb.binaryowl.change.serializer.RemoveAxiomDataSerializer;
import org.semanticweb.binaryowl.change.serializer.RemoveImportDataSerializer;
import org.semanticweb.binaryowl.change.serializer.RemoveOntologyAnnotationDataSerializer;
import org.semanticweb.binaryowl.change.serializer.SetOntologyIDDataSerializer;
import org.semanticweb.binaryowl.stream.BinaryOWLInputStream;
import org.semanticweb.binaryowl.stream.BinaryOWLOutputStream;
import org.semanticweb.owlapi.change.AddAxiomData;
import org.semanticweb.owlapi.change.AddImportData;
import org.semanticweb.owlapi.change.AddOntologyAnnotationData;
import org.semanticweb.owlapi.change.OWLOntologyChangeData;
import org.semanticweb.owlapi.change.OWLOntologyChangeDataVisitor;
import org.semanticweb.owlapi.change.RemoveAxiomData;
import org.semanticweb.owlapi.change.RemoveImportData;
import org.semanticweb.owlapi.change.RemoveOntologyAnnotationData;
import org.semanticweb.owlapi.change.SetOntologyIDData;

public enum OntologyChangeDataType {
    SET_ONTOLOGY_ID(1, SetOntologyIDData.class, new SetOntologyIDDataSerializer()),
    ADD_IMPORT(2, AddImportData.class, new AddImportDataSerializer()),
    REMOVE_IMPORT(3, RemoveImportData.class, new RemoveImportDataSerializer()),
    ADD_ONTOLOGY_ANNOTATION(4, AddOntologyAnnotationData.class, new AddOntologyAnnotationDataSerializer()),
    REMOVE_ONTOLOGY_ANNOTATION(5, RemoveOntologyAnnotationData.class, new RemoveOntologyAnnotationDataSerializer()),
    ADD_AXIOM(6, AddAxiomData.class, new AddAxiomDataSerializer()),
    REMOVE_AXIOM(7, RemoveAxiomData.class, new RemoveAxiomDataSerializer());

    private byte marker;
    private Class<? extends OWLOntologyChangeData> ontologyChangeClass;
    private OntologyChangeDataSerializer<?> serializer;

    private <C extends OWLOntologyChangeData> OntologyChangeDataType(int marker, Class<C> ontologyChangeClass, OntologyChangeDataSerializer<C> serializer) {
        this.marker = (byte)marker;
        this.ontologyChangeClass = ontologyChangeClass;
        this.serializer = serializer;
    }

    public static OntologyChangeDataType get(byte marker) {
        return OntologyChangeDataType.values()[marker - 1];
    }

    public static OntologyChangeDataType get(OWLOntologyChangeData Data) {
        OntologyChangeData2OntologyChangeInfoTypeTranslator translator = new OntologyChangeData2OntologyChangeInfoTypeTranslator();
        return (OntologyChangeDataType)((Object)Data.accept((OWLOntologyChangeDataVisitor)translator));
    }

    public byte getMarker() {
        return this.marker;
    }

    public Class<? extends OWLOntologyChangeData> getOntologyChangeClass() {
        return this.ontologyChangeClass;
    }

    public static void write(OWLOntologyChangeData info, BinaryOWLOutputStream outputStream) throws IOException {
        OntologyChangeDataType type = OntologyChangeDataType.get(info);
        outputStream.writeByte(type.getMarker());
        OntologyChangeDataSerializer<?> serializer = type.serializer;
        serializer.write(info, outputStream);
    }

    public static OWLOntologyChangeData read(BinaryOWLInputStream inputStream) throws IOException, BinaryOWLParseException {
        byte marker = inputStream.readByte();
        OntologyChangeDataType type = OntologyChangeDataType.get(marker);
        OntologyChangeDataSerializer<?> serializer = type.serializer;
        return serializer.read(inputStream);
    }
}

