/*
 * Decompiled with CFR 0.152.
 */
package net.sf.mpxj.mspdi;

import java.math.BigDecimal;
import java.math.BigInteger;
import java.text.DateFormat;
import java.text.DecimalFormat;
import java.text.DecimalFormatSymbols;
import java.text.NumberFormat;
import java.text.ParseException;
import java.text.SimpleDateFormat;
import java.util.Calendar;
import java.util.Date;
import java.util.Locale;
import net.sf.mpxj.AccrueType;
import net.sf.mpxj.BookingType;
import net.sf.mpxj.ConstraintType;
import net.sf.mpxj.CurrencySymbolPosition;
import net.sf.mpxj.DataType;
import net.sf.mpxj.Day;
import net.sf.mpxj.Duration;
import net.sf.mpxj.EarnedValueMethod;
import net.sf.mpxj.FieldContainer;
import net.sf.mpxj.FieldType;
import net.sf.mpxj.Priority;
import net.sf.mpxj.ProjectFile;
import net.sf.mpxj.ProjectHeader;
import net.sf.mpxj.Rate;
import net.sf.mpxj.ResourceType;
import net.sf.mpxj.TaskType;
import net.sf.mpxj.TimeUnit;
import net.sf.mpxj.WorkContour;
import net.sf.mpxj.WorkGroup;
import net.sf.mpxj.mspdi.MSPDIWriter;
import net.sf.mpxj.mspdi.XsdDuration;
import net.sf.mpxj.utility.NumberUtility;

public final class DatatypeConverter {
    private static final ThreadLocal<DateFormat> DATE_FORMAT = new ThreadLocal();
    private static final ThreadLocal<DateFormat> TIME_FORMAT = new ThreadLocal();
    private static final ThreadLocal<NumberFormat> NUMBER_FORMAT = new ThreadLocal();
    private static final BigDecimal BIGDECIMAL_ONE = BigDecimal.valueOf(1L);
    private static final ThreadLocal<ProjectFile> PARENT_FILE = new ThreadLocal();

    public static final String printExtendedAttributeCurrency(Number value) {
        return value == null ? null : DatatypeConverter.getNumberFormat().format(value.doubleValue() * 100.0);
    }

    public static final Number parseExtendedAttributeCurrency(String value) {
        Double result = value == null ? null : NumberUtility.getDouble(Double.parseDouble(value) / 100.0);
        return result;
    }

    public static final String printExtendedAttributeNumber(Number value) {
        return DatatypeConverter.getNumberFormat().format(value.doubleValue());
    }

    public static final Number parseExtendedAttributeNumber(String value) {
        return new Double(value);
    }

    public static final String printExtendedAttributeBoolean(Boolean value) {
        return value != false ? "1" : "0";
    }

    public static final Boolean parseExtendedAttributeBoolean(String value) {
        return value.equals("1") ? Boolean.TRUE : Boolean.FALSE;
    }

    public static final String printExtendedAttributeDate(Date value) {
        return value == null ? null : DatatypeConverter.getDateFormat().format(value);
    }

    public static final Date parseExtendedAttributeDate(String value) {
        Date result = null;
        if (value != null) {
            try {
                result = DatatypeConverter.getDateFormat().parse(value);
            }
            catch (ParseException parseException) {
                // empty catch block
            }
        }
        return result;
    }

    public static final String printExtendedAttribute(MSPDIWriter writer, Object value, DataType type) {
        String result = type == DataType.DATE ? DatatypeConverter.printExtendedAttributeDate((Date)value) : (value instanceof Boolean ? DatatypeConverter.printExtendedAttributeBoolean((Boolean)value) : (value instanceof Duration ? DatatypeConverter.printDuration(writer, (Duration)value) : (type == DataType.CURRENCY ? DatatypeConverter.printExtendedAttributeCurrency((Number)value) : (value instanceof Number ? DatatypeConverter.printExtendedAttributeNumber((Number)value) : value.toString()))));
        return result;
    }

    public static final void parseExtendedAttribute(ProjectFile file, FieldContainer mpx, String value, FieldType mpxFieldID) {
        if (mpxFieldID != null) {
            switch (mpxFieldID.getDataType()) {
                case STRING: {
                    mpx.set(mpxFieldID, value);
                    break;
                }
                case DATE: {
                    mpx.set(mpxFieldID, DatatypeConverter.parseExtendedAttributeDate(value));
                    break;
                }
                case CURRENCY: {
                    mpx.set(mpxFieldID, DatatypeConverter.parseExtendedAttributeCurrency(value));
                    break;
                }
                case BOOLEAN: {
                    mpx.set(mpxFieldID, DatatypeConverter.parseExtendedAttributeBoolean(value));
                    break;
                }
                case NUMERIC: {
                    mpx.set(mpxFieldID, DatatypeConverter.parseExtendedAttributeNumber(value));
                    break;
                }
                case DURATION: {
                    mpx.set(mpxFieldID, DatatypeConverter.parseDuration(file, null, value));
                    break;
                }
            }
        }
    }

    public static final String printCurrencySymbolPosition(CurrencySymbolPosition value) {
        String result;
        switch (value) {
            default: {
                result = "0";
                break;
            }
            case AFTER: {
                result = "1";
                break;
            }
            case BEFORE_WITH_SPACE: {
                result = "2";
                break;
            }
            case AFTER_WITH_SPACE: {
                result = "3";
            }
        }
        return result;
    }

    public static final CurrencySymbolPosition parseCurrencySymbolPosition(String value) {
        CurrencySymbolPosition result = CurrencySymbolPosition.BEFORE;
        switch (NumberUtility.getInt(value)) {
            case 0: {
                result = CurrencySymbolPosition.BEFORE;
                break;
            }
            case 1: {
                result = CurrencySymbolPosition.AFTER;
                break;
            }
            case 2: {
                result = CurrencySymbolPosition.BEFORE_WITH_SPACE;
                break;
            }
            case 3: {
                result = CurrencySymbolPosition.AFTER_WITH_SPACE;
            }
        }
        return result;
    }

    public static final String printAccrueType(AccrueType value) {
        return Integer.toString(value == null ? AccrueType.PRORATED.getValue() : value.getValue());
    }

    public static final AccrueType parseAccrueType(String value) {
        return AccrueType.getInstance(NumberUtility.getInt(value));
    }

    public static final String printResourceType(ResourceType value) {
        return Integer.toString(value == null ? ResourceType.WORK.getValue() : value.getValue());
    }

    public static final ResourceType parseResourceType(String value) {
        return ResourceType.getInstance(NumberUtility.getInt(value));
    }

    public static final String printWorkGroup(WorkGroup value) {
        return Integer.toString(value == null ? WorkGroup.DEFAULT.getValue() : value.getValue());
    }

    public static final WorkGroup parseWorkGroup(String value) {
        return WorkGroup.getInstance(NumberUtility.getInt(value));
    }

    public static final String printWorkContour(WorkContour value) {
        return Integer.toString(value == null ? WorkContour.FLAT.getValue() : value.getValue());
    }

    public static final WorkContour parseWorkContour(String value) {
        return WorkContour.getInstance(NumberUtility.getInt(value));
    }

    public static final String printBookingType(BookingType value) {
        return Integer.toString(value == null ? BookingType.COMMITTED.getValue() : value.getValue());
    }

    public static final BookingType parseBookingType(String value) {
        return BookingType.getInstance(NumberUtility.getInt(value));
    }

    public static final String printTaskType(TaskType value) {
        return Integer.toString(value == null ? TaskType.FIXED_UNITS.getValue() : value.getValue());
    }

    public static final TaskType parseTaskType(String value) {
        return TaskType.getInstance(NumberUtility.getInt(value));
    }

    public static final BigInteger printEarnedValueMethod(EarnedValueMethod value) {
        return value == null ? BigInteger.valueOf(EarnedValueMethod.PERCENT_COMPLETE.getValue()) : BigInteger.valueOf(value.getValue());
    }

    public static final EarnedValueMethod parseEarnedValueMethod(Number value) {
        return EarnedValueMethod.getInstance(NumberUtility.getInt(value));
    }

    public static final BigDecimal printUnits(Number value) {
        return value == null ? BIGDECIMAL_ONE : new BigDecimal(value.doubleValue() / 100.0);
    }

    public static final Number parseUnits(Number value) {
        return value == null ? null : NumberUtility.getDouble(value.doubleValue() * 100.0);
    }

    public static final BigInteger printTimeUnit(TimeUnit value) {
        return BigInteger.valueOf(value == null ? (long)(TimeUnit.DAYS.getValue() + 1) : (long)(value.getValue() + 1));
    }

    public static final TimeUnit parseTimeUnit(Number value) {
        return TimeUnit.getInstance(NumberUtility.getInt(value) - 1);
    }

    public static final Calendar printDate(Date value) {
        Calendar cal = null;
        if (value != null) {
            cal = Calendar.getInstance();
            cal.setTime(value);
            cal.set(14, 0);
            cal.set(13, 0);
        }
        return cal;
    }

    public static final Date parseDate(Calendar value) {
        Date result = null;
        if (value != null) {
            Calendar cal = Calendar.getInstance();
            cal.set(1, value.get(1));
            cal.set(2, value.get(2));
            cal.set(5, value.get(5));
            cal.set(11, value.get(11));
            cal.set(12, value.get(12));
            cal.set(13, value.get(13));
            cal.set(14, value.get(14));
            result = cal.getTime();
        }
        return result;
    }

    public static final Calendar printTime(Date value) {
        Calendar cal = null;
        if (value != null) {
            cal = Calendar.getInstance();
            cal.setTime(value);
            cal.set(14, 0);
            cal.set(13, 0);
        }
        return cal;
    }

    public static final Date parseTime(Calendar value) {
        Date result = null;
        if (value != null) {
            Calendar cal = Calendar.getInstance();
            cal.set(11, value.get(11));
            cal.set(12, value.get(12));
            cal.set(13, value.get(13));
            cal.set(14, value.get(14));
            result = cal.getTime();
        }
        return result;
    }

    public static final TimeUnit parseWorkUnits(BigInteger value) {
        TimeUnit result = TimeUnit.HOURS;
        if (value != null) {
            switch (value.intValue()) {
                case 1: {
                    result = TimeUnit.MINUTES;
                    break;
                }
                case 3: {
                    result = TimeUnit.DAYS;
                    break;
                }
                case 4: {
                    result = TimeUnit.WEEKS;
                    break;
                }
                case 5: {
                    result = TimeUnit.MONTHS;
                    break;
                }
                case 7: {
                    result = TimeUnit.YEARS;
                    break;
                }
                default: {
                    result = TimeUnit.HOURS;
                }
            }
        }
        return result;
    }

    public static final BigInteger printWorkUnits(TimeUnit value) {
        int result;
        if (value == null) {
            value = TimeUnit.HOURS;
        }
        switch (value) {
            case MINUTES: {
                result = 1;
                break;
            }
            case DAYS: {
                result = 3;
                break;
            }
            case WEEKS: {
                result = 4;
                break;
            }
            case MONTHS: {
                result = 5;
                break;
            }
            case YEARS: {
                result = 7;
                break;
            }
            default: {
                result = 2;
            }
        }
        return BigInteger.valueOf(result);
    }

    public static final Duration parseDuration(ProjectFile file, TimeUnit defaultUnits, String value) {
        Duration result = null;
        if (value != null && value.length() != 0) {
            XsdDuration xsd = new XsdDuration(value);
            TimeUnit units = TimeUnit.DAYS;
            if (xsd.getSeconds() != 0.0 || xsd.getMinutes() != 0) {
                units = TimeUnit.MINUTES;
            }
            if (xsd.getHours() != 0) {
                units = TimeUnit.HOURS;
            }
            if (xsd.getDays() != 0) {
                units = TimeUnit.DAYS;
            }
            if (xsd.getMonths() != 0) {
                units = TimeUnit.MONTHS;
            }
            if (xsd.getYears() != 0) {
                units = TimeUnit.YEARS;
            }
            double duration = 0.0;
            switch (units) {
                case YEARS: {
                    duration += (double)xsd.getYears();
                    duration += (double)xsd.getMonths() / 12.0;
                    duration += (double)xsd.getDays() / 365.0;
                    duration += (double)xsd.getHours() / 8760.0;
                    duration += (double)xsd.getMinutes() / 525600.0;
                    duration += xsd.getSeconds() / 3.1536E7;
                    break;
                }
                case ELAPSED_YEARS: {
                    duration += (double)xsd.getYears();
                    duration += (double)xsd.getMonths() / 12.0;
                    duration += (double)xsd.getDays() / 365.0;
                    duration += (double)xsd.getHours() / 8760.0;
                    duration += (double)xsd.getMinutes() / 525600.0;
                    duration += xsd.getSeconds() / 3.1536E7;
                    break;
                }
                case MONTHS: {
                    duration += (double)(xsd.getYears() * 12);
                    duration += (double)xsd.getMonths();
                    duration += (double)xsd.getDays() / 30.0;
                    duration += (double)xsd.getHours() / 720.0;
                    duration += (double)xsd.getMinutes() / 43200.0;
                    duration += xsd.getSeconds() / 2592000.0;
                    break;
                }
                case ELAPSED_MONTHS: {
                    duration += (double)(xsd.getYears() * 12);
                    duration += (double)xsd.getMonths();
                    duration += (double)xsd.getDays() / 30.0;
                    duration += (double)xsd.getHours() / 720.0;
                    duration += (double)xsd.getMinutes() / 43200.0;
                    duration += xsd.getSeconds() / 2592000.0;
                    break;
                }
                case WEEKS: {
                    duration += (double)(xsd.getYears() * 52);
                    duration += (double)(xsd.getMonths() * 4);
                    duration += (double)xsd.getDays() / 7.0;
                    duration += (double)xsd.getHours() / 168.0;
                    duration += (double)xsd.getMinutes() / 10080.0;
                    duration += xsd.getSeconds() / 604800.0;
                    break;
                }
                case ELAPSED_WEEKS: {
                    duration += (double)(xsd.getYears() * 52);
                    duration += (double)(xsd.getMonths() * 4);
                    duration += (double)xsd.getDays() / 7.0;
                    duration += (double)xsd.getHours() / 168.0;
                    duration += (double)xsd.getMinutes() / 10080.0;
                    duration += xsd.getSeconds() / 604800.0;
                    break;
                }
                case DAYS: {
                    duration += (double)(xsd.getYears() * 365);
                    duration += (double)(xsd.getMonths() * 30);
                    duration += (double)xsd.getDays();
                    duration += (double)xsd.getHours() / 24.0;
                    duration += (double)xsd.getMinutes() / 1440.0;
                    duration += xsd.getSeconds() / 86400.0;
                    break;
                }
                case ELAPSED_DAYS: {
                    duration += (double)(xsd.getYears() * 365);
                    duration += (double)(xsd.getMonths() * 30);
                    duration += (double)xsd.getDays();
                    duration += (double)xsd.getHours() / 24.0;
                    duration += (double)xsd.getMinutes() / 1440.0;
                    duration += xsd.getSeconds() / 86400.0;
                    break;
                }
                case HOURS: 
                case ELAPSED_HOURS: {
                    duration += (double)(xsd.getYears() * 8760);
                    duration += (double)(xsd.getMonths() * 720);
                    duration += (double)(xsd.getDays() * 24);
                    duration += (double)xsd.getHours();
                    duration += (double)xsd.getMinutes() / 60.0;
                    duration += xsd.getSeconds() / 3600.0;
                    break;
                }
                case MINUTES: 
                case ELAPSED_MINUTES: {
                    duration += (double)(xsd.getYears() * 525600);
                    duration += (double)(xsd.getMonths() * 43200);
                    duration += (double)(xsd.getDays() * 1440);
                    duration += (double)(xsd.getHours() * 60);
                    duration += (double)xsd.getMinutes();
                    duration += xsd.getSeconds() / 60.0;
                    break;
                }
            }
            ProjectHeader header = file.getProjectHeader();
            if (defaultUnits == null) {
                defaultUnits = header.getDefaultDurationUnits();
            }
            result = Duration.convertUnits(duration, units, defaultUnits, header);
        }
        return result;
    }

    public static final String printDuration(MSPDIWriter writer, Duration duration) {
        String result = null;
        if (duration != null && duration.getDuration() != 0.0) {
            result = DatatypeConverter.printDurationMandatory(writer, duration);
        }
        return result;
    }

    public static final String printDurationMandatory(MSPDIWriter writer, Duration duration) {
        String result = null;
        if (duration != null) {
            TimeUnit durationType = duration.getUnits();
            if (durationType == TimeUnit.HOURS || durationType == TimeUnit.ELAPSED_HOURS) {
                result = new XsdDuration(duration).toString();
            } else {
                duration = duration.convertUnits(TimeUnit.HOURS, writer.getProjectFile().getProjectHeader());
                result = new XsdDuration(duration).toString();
            }
        }
        return result;
    }

    public static final BigInteger printDurationTimeUnits(Duration duration, boolean estimated) {
        BigInteger result = null;
        if (duration != null) {
            result = DatatypeConverter.printDurationTimeUnits(duration.getUnits(), estimated);
        }
        return result;
    }

    public static final Double parseCurrency(Number value) {
        return value == null ? null : NumberUtility.getDouble(value.doubleValue() / 100.0);
    }

    public static final BigDecimal printCurrency(Number value) {
        return value == null || value.doubleValue() == 0.0 ? null : new BigDecimal(value.doubleValue() * 100.0);
    }

    public static final TimeUnit parseDurationTimeUnits(BigInteger value) {
        TimeUnit result = TimeUnit.HOURS;
        if (value != null) {
            switch (value.intValue()) {
                case 3: 
                case 35: {
                    result = TimeUnit.MINUTES;
                    break;
                }
                case 4: 
                case 36: {
                    result = TimeUnit.ELAPSED_MINUTES;
                    break;
                }
                case 5: 
                case 37: {
                    result = TimeUnit.HOURS;
                    break;
                }
                case 6: 
                case 38: {
                    result = TimeUnit.ELAPSED_HOURS;
                    break;
                }
                case 7: 
                case 39: 
                case 53: {
                    result = TimeUnit.DAYS;
                    break;
                }
                case 8: 
                case 40: {
                    result = TimeUnit.ELAPSED_DAYS;
                    break;
                }
                case 9: 
                case 41: {
                    result = TimeUnit.WEEKS;
                    break;
                }
                case 10: 
                case 42: {
                    result = TimeUnit.ELAPSED_WEEKS;
                    break;
                }
                case 11: 
                case 43: {
                    result = TimeUnit.MONTHS;
                    break;
                }
                case 12: 
                case 44: {
                    result = TimeUnit.ELAPSED_MONTHS;
                    break;
                }
                case 19: 
                case 51: {
                    result = TimeUnit.PERCENT;
                    break;
                }
                case 20: 
                case 52: {
                    result = TimeUnit.ELAPSED_PERCENT;
                }
            }
        }
        return result;
    }

    public static final BigInteger printDurationTimeUnits(TimeUnit value, boolean estimated) {
        int result;
        if (value == null) {
            value = TimeUnit.HOURS;
        }
        switch (value) {
            case MINUTES: {
                result = estimated ? 35 : 3;
                break;
            }
            case ELAPSED_MINUTES: {
                result = estimated ? 36 : 4;
                break;
            }
            case ELAPSED_HOURS: {
                result = estimated ? 38 : 6;
                break;
            }
            case DAYS: {
                result = estimated ? 39 : 7;
                break;
            }
            case ELAPSED_DAYS: {
                result = estimated ? 40 : 8;
                break;
            }
            case WEEKS: {
                result = estimated ? 41 : 9;
                break;
            }
            case ELAPSED_WEEKS: {
                result = estimated ? 42 : 10;
                break;
            }
            case MONTHS: {
                result = estimated ? 43 : 11;
                break;
            }
            case ELAPSED_MONTHS: {
                result = estimated ? 44 : 12;
                break;
            }
            case PERCENT: {
                result = estimated ? 51 : 19;
                break;
            }
            case ELAPSED_PERCENT: {
                result = estimated ? 52 : 20;
                break;
            }
            default: {
                result = estimated ? 37 : 5;
            }
        }
        return BigInteger.valueOf(result);
    }

    public static final Priority parsePriority(BigInteger priority) {
        return priority == null ? null : Priority.getInstance(priority.intValue());
    }

    public static final BigInteger printPriority(Priority priority) {
        int result = 500;
        if (priority != null) {
            result = priority.getValue();
        }
        return BigInteger.valueOf(result);
    }

    public static final Duration parseDurationInThousanthsOfMinutes(Number value) {
        return DatatypeConverter.parseDurationInFractionsOfMinutes(null, value, TimeUnit.MINUTES, 1000);
    }

    public static final Duration parseDurationInThousanthsOfMinutes(ProjectHeader header, Number value, TimeUnit targetTimeUnit) {
        return DatatypeConverter.parseDurationInFractionsOfMinutes(header, value, targetTimeUnit, 1000);
    }

    public static final Duration parseDurationInTenthsOfMinutes(ProjectHeader header, Number value, TimeUnit targetTimeUnit) {
        return DatatypeConverter.parseDurationInFractionsOfMinutes(header, value, targetTimeUnit, 10);
    }

    public static final BigInteger printDurationInIntegerThousandthsOfMinutes(Duration duration) {
        BigInteger result = null;
        if (duration != null && duration.getDuration() != 0.0) {
            result = BigInteger.valueOf((long)DatatypeConverter.printDurationFractionsOfMinutes(duration, 1000));
        }
        return result;
    }

    public static final BigDecimal printDurationInDecimalThousandthsOfMinutes(Duration duration) {
        BigDecimal result = null;
        if (duration != null && duration.getDuration() != 0.0) {
            result = BigDecimal.valueOf(DatatypeConverter.printDurationFractionsOfMinutes(duration, 1000));
        }
        return result;
    }

    public static final BigInteger printDurationInTenthsOfInMinutes(Duration duration) {
        BigInteger result = null;
        if (duration != null && duration.getDuration() != 0.0) {
            result = BigInteger.valueOf((long)DatatypeConverter.printDurationFractionsOfMinutes(duration, 10));
        }
        return result;
    }

    private static final Duration parseDurationInFractionsOfMinutes(ProjectHeader header, Number value, TimeUnit targetTimeUnit, int factor) {
        Duration result = null;
        if (value != null && targetTimeUnit != (result = Duration.getInstance(value.intValue() / factor, TimeUnit.MINUTES)).getUnits()) {
            result = result.convertUnits(targetTimeUnit, header);
        }
        return result;
    }

    private static final double printDurationFractionsOfMinutes(Duration duration, int factor) {
        double result = 0.0;
        if (duration != null) {
            result = duration.getDuration();
            switch (duration.getUnits()) {
                case HOURS: 
                case ELAPSED_HOURS: {
                    result *= 60.0;
                    break;
                }
                case DAYS: {
                    result *= 480.0;
                    break;
                }
                case ELAPSED_DAYS: {
                    result *= 1440.0;
                    break;
                }
                case WEEKS: {
                    result *= 2400.0;
                    break;
                }
                case ELAPSED_WEEKS: {
                    result *= 10080.0;
                    break;
                }
                case MONTHS: {
                    result *= 9600.0;
                    break;
                }
                case ELAPSED_MONTHS: {
                    result *= 43200.0;
                    break;
                }
                case YEARS: {
                    result *= 124800.0;
                    break;
                }
                case ELAPSED_YEARS: {
                    result *= 525600.0;
                    break;
                }
            }
        }
        return result *= (double)factor;
    }

    public static final BigDecimal printRate(Rate rate) {
        BigDecimal result = null;
        if (rate != null && rate.getAmount() != 0.0) {
            result = new BigDecimal(rate.getAmount());
        }
        return result;
    }

    public static final Rate parseRate(BigDecimal value) {
        Rate result = null;
        if (value != null) {
            result = new Rate(value, TimeUnit.HOURS);
        }
        return result;
    }

    public static final BigInteger printDay(Day day) {
        return day == null ? null : BigInteger.valueOf(day.getValue() - 1);
    }

    public static final Day parseDay(Number value) {
        return Day.getInstance(NumberUtility.getInt(value) + 1);
    }

    public static final ConstraintType parseConstraintType(Number value) {
        return ConstraintType.getInstance(value);
    }

    public static final BigInteger printConstraintType(ConstraintType value) {
        return value == null ? null : BigInteger.valueOf(value.getValue());
    }

    public static final String printTaskUID(Integer value) {
        ProjectFile file = PARENT_FILE.get();
        if (file != null) {
            file.fireTaskWrittenEvent(file.getTaskByUniqueID(value));
        }
        return value.toString();
    }

    public static final Integer parseTaskUID(String value) {
        return new Integer(value);
    }

    public static final String printResourceUID(Integer value) {
        ProjectFile file = PARENT_FILE.get();
        if (file != null) {
            file.fireResourceWrittenEvent(file.getResourceByUniqueID(value));
        }
        return value.toString();
    }

    public static final Integer parseResourceUID(String value) {
        return new Integer(value);
    }

    public static final String printBoolean(Boolean value) {
        return value == null || value == false ? "0" : "1";
    }

    public static final Boolean parseBoolean(String value) {
        return value == null || value.charAt(0) != '1' ? Boolean.FALSE : Boolean.TRUE;
    }

    public static final String printTime(Calendar value) {
        return value == null ? null : DatatypeConverter.getTimeFormat().format(value.getTime());
    }

    public static final Calendar parseTime(String value) {
        Calendar cal = null;
        if (value != null && value.length() != 0) {
            cal = Calendar.getInstance();
            try {
                cal.setTime(DatatypeConverter.getTimeFormat().parse(value));
            }
            catch (ParseException ex) {
                cal = null;
            }
        }
        return cal;
    }

    public static final String printDateTime(Calendar value) {
        return value == null ? null : DatatypeConverter.getDateFormat().format(value.getTime());
    }

    public static final Calendar parseDateTime(String value) {
        Calendar result = null;
        if (value != null && value.length() != 0) {
            try {
                result = Calendar.getInstance();
                result.setTime(DatatypeConverter.getDateFormat().parse(value));
            }
            catch (ParseException ex) {
                result = null;
            }
        }
        return result;
    }

    public static final String printString(String value) {
        return value;
    }

    public static final String parseString(String value) {
        return value;
    }

    public static final void setParentFile(ProjectFile file) {
        PARENT_FILE.set(file);
    }

    private static final NumberFormat getNumberFormat() {
        NumberFormat format = NUMBER_FORMAT.get();
        if (format == null) {
            format = new DecimalFormat("#.##", new DecimalFormatSymbols(Locale.US));
            format.setGroupingUsed(false);
            NUMBER_FORMAT.set(format);
        }
        return format;
    }

    private static final DateFormat getDateFormat() {
        DateFormat df = DATE_FORMAT.get();
        if (df == null) {
            df = new SimpleDateFormat("yyyy-MM-dd'T'HH:mm:ss");
            df.setLenient(false);
        }
        return df;
    }

    private static final DateFormat getTimeFormat() {
        DateFormat df = TIME_FORMAT.get();
        if (df == null) {
            df = new SimpleDateFormat("HH:mm:ss");
            df.setLenient(false);
        }
        return df;
    }
}

