/*
 * Decompiled with CFR 0.152.
 */
package net.sf.mpxj.mpx;

import java.io.BufferedInputStream;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.text.ParseException;
import java.util.Calendar;
import java.util.Date;
import java.util.LinkedList;
import java.util.List;
import java.util.Locale;
import net.sf.mpxj.DateRange;
import net.sf.mpxj.Day;
import net.sf.mpxj.DayType;
import net.sf.mpxj.Duration;
import net.sf.mpxj.FieldType;
import net.sf.mpxj.FileCreationRecord;
import net.sf.mpxj.FileVersion;
import net.sf.mpxj.MPXJException;
import net.sf.mpxj.ProjectCalendar;
import net.sf.mpxj.ProjectCalendarException;
import net.sf.mpxj.ProjectCalendarHours;
import net.sf.mpxj.ProjectFile;
import net.sf.mpxj.ProjectHeader;
import net.sf.mpxj.RecurringTask;
import net.sf.mpxj.Relation;
import net.sf.mpxj.RelationType;
import net.sf.mpxj.Resource;
import net.sf.mpxj.ResourceAssignment;
import net.sf.mpxj.ResourceAssignmentWorkgroupFields;
import net.sf.mpxj.ResourceField;
import net.sf.mpxj.Task;
import net.sf.mpxj.TaskField;
import net.sf.mpxj.TaskType;
import net.sf.mpxj.TimeUnit;
import net.sf.mpxj.listener.ProjectListener;
import net.sf.mpxj.mpx.ConstraintTypeUtility;
import net.sf.mpxj.mpx.DurationUtility;
import net.sf.mpxj.mpx.LocaleData;
import net.sf.mpxj.mpx.LocaleUtility;
import net.sf.mpxj.mpx.MPXResourceField;
import net.sf.mpxj.mpx.MPXTaskField;
import net.sf.mpxj.mpx.PriorityUtility;
import net.sf.mpxj.mpx.Record;
import net.sf.mpxj.mpx.RecurrenceUtility;
import net.sf.mpxj.mpx.RelationTypeUtility;
import net.sf.mpxj.mpx.ResourceModel;
import net.sf.mpxj.mpx.TaskModel;
import net.sf.mpxj.reader.AbstractProjectReader;
import net.sf.mpxj.utility.InputStreamTokenizer;
import net.sf.mpxj.utility.MPXJFormats;
import net.sf.mpxj.utility.NumberUtility;
import net.sf.mpxj.utility.ReaderTokenizer;
import net.sf.mpxj.utility.Tokenizer;

public final class MPXReader
extends AbstractProjectReader {
    private Locale m_locale = Locale.ENGLISH;
    private boolean m_ignoreTextModels = true;
    private ProjectFile m_projectFile;
    private Task m_lastTask;
    private Resource m_lastResource;
    private ProjectCalendar m_lastResourceCalendar;
    private ResourceAssignment m_lastResourceAssignment;
    private ProjectCalendar m_lastBaseCalendar;
    private boolean m_resourceTableDefinition;
    private boolean m_taskTableDefinition;
    private TaskModel m_taskModel;
    private ResourceModel m_resourceModel;
    private char m_delimiter;
    private MPXJFormats m_formats;
    private List<DeferredRelationship> m_deferredRelationships;
    private List<ProjectListener> m_projectListeners;
    private int m_baseOutlineLevel;

    public void addProjectListener(ProjectListener listener) {
        if (this.m_projectListeners == null) {
            this.m_projectListeners = new LinkedList<ProjectListener>();
        }
        this.m_projectListeners.add(listener);
    }

    public ProjectFile read(InputStream is) throws MPXJException {
        int line = 1;
        try {
            BufferedInputStream bis = new BufferedInputStream(is);
            byte[] data = new byte[4];
            data[0] = (byte)bis.read();
            bis.mark(1024);
            data[1] = (byte)bis.read();
            data[2] = (byte)bis.read();
            data[3] = (byte)bis.read();
            if (data[0] != 77 || data[1] != 80 || data[2] != 88) {
                throw new MPXJException("Invalid file format");
            }
            this.m_projectFile = new ProjectFile();
            this.m_projectFile.addProjectListeners(this.m_projectListeners);
            this.m_projectFile.setAutoTaskID(false);
            this.m_projectFile.setAutoTaskUniqueID(false);
            this.m_projectFile.setAutoResourceID(false);
            this.m_projectFile.setAutoResourceUniqueID(false);
            this.m_projectFile.setAutoOutlineLevel(false);
            this.m_projectFile.setAutoOutlineNumber(false);
            this.m_projectFile.setAutoWBS(false);
            LocaleUtility.setLocale(this.m_projectFile, this.m_locale);
            this.m_delimiter = (char)data[3];
            this.m_projectFile.setDelimiter(this.m_delimiter);
            this.m_taskModel = new TaskModel(this.m_projectFile, this.m_locale);
            this.m_taskModel.setLocale(this.m_locale);
            this.m_resourceModel = new ResourceModel(this.m_projectFile, this.m_locale);
            this.m_resourceModel.setLocale(this.m_locale);
            this.m_baseOutlineLevel = -1;
            this.m_formats = new MPXJFormats(this.m_locale, LocaleData.getString(this.m_locale, "NA"), this.m_projectFile);
            this.m_deferredRelationships = new LinkedList<DeferredRelationship>();
            bis.reset();
            Tokenizer tk = new InputStreamTokenizer(bis);
            tk.setDelimiter(this.m_delimiter);
            this.parseRecord(Integer.toString(999), new Record(this.m_locale, tk, this.m_formats));
            ++line;
            InputStreamReader reader = new InputStreamReader((InputStream)bis, this.m_projectFile.getFileCreationRecord().getCodePage().getCharset());
            tk = new ReaderTokenizer(reader);
            tk.setDelimiter(this.m_delimiter);
            while (tk.getType() != -1) {
                Record record = new Record(this.m_locale, tk, this.m_formats);
                String number = record.getRecordNumber();
                if (number != null) {
                    this.parseRecord(number, record);
                }
                ++line;
            }
            this.processDeferredRelationships();
            this.m_projectFile.updateStructure();
            this.m_projectFile.updateUniqueCounters();
            this.m_projectFile.setAutoCalendarUniqueID(false);
            ProjectFile projectFile = this.m_projectFile;
            Object var11_11 = null;
            this.m_projectFile = null;
            this.m_lastTask = null;
            this.m_lastResource = null;
            this.m_lastResourceCalendar = null;
            this.m_lastResourceAssignment = null;
            this.m_lastBaseCalendar = null;
            this.m_resourceTableDefinition = false;
            this.m_taskTableDefinition = false;
            this.m_taskModel = null;
            this.m_resourceModel = null;
            this.m_formats = null;
            this.m_deferredRelationships = null;
            return projectFile;
        }
        catch (Exception ex) {
            try {
                throw new MPXJException("Error reading file (failed at line " + line + ")", ex);
            }
            catch (Throwable throwable) {
                Object var11_12 = null;
                this.m_projectFile = null;
                this.m_lastTask = null;
                this.m_lastResource = null;
                this.m_lastResourceCalendar = null;
                this.m_lastResourceAssignment = null;
                this.m_lastBaseCalendar = null;
                this.m_resourceTableDefinition = false;
                this.m_taskTableDefinition = false;
                this.m_taskModel = null;
                this.m_resourceModel = null;
                this.m_formats = null;
                this.m_deferredRelationships = null;
                throw throwable;
            }
        }
    }

    private void parseRecord(String recordNumber, Record record) throws MPXJException {
        switch (Integer.parseInt(recordNumber)) {
            case 0: 
            case 80: 
            case 81: {
                break;
            }
            case 10: {
                this.populateCurrencySettings(record, this.m_projectFile.getProjectHeader());
                this.m_formats.update();
                break;
            }
            case 11: {
                this.populateDefaultSettings(record, this.m_projectFile.getProjectHeader());
                this.m_formats.update();
                break;
            }
            case 12: {
                this.populateDateTimeSettings(record, this.m_projectFile.getProjectHeader());
                this.m_formats.update();
                break;
            }
            case 20: {
                this.m_lastBaseCalendar = this.m_projectFile.addBaseCalendar();
                this.populateCalendar(record, this.m_lastBaseCalendar, true);
                break;
            }
            case 25: {
                if (this.m_lastBaseCalendar == null) break;
                ProjectCalendarHours hours = this.m_lastBaseCalendar.addCalendarHours();
                this.populateCalendarHours(record, hours);
                break;
            }
            case 26: {
                if (this.m_lastBaseCalendar == null) break;
                this.populateCalendarException(record, this.m_lastBaseCalendar);
                break;
            }
            case 30: {
                this.populateProjectHeader(record, this.m_projectFile.getProjectHeader());
                this.m_formats.update();
                break;
            }
            case 40: {
                if (this.m_resourceTableDefinition || this.m_ignoreTextModels) break;
                this.m_resourceModel.update(record, true);
                this.m_resourceTableDefinition = true;
                break;
            }
            case 41: {
                if (this.m_resourceTableDefinition) break;
                this.m_resourceModel.update(record, false);
                this.m_resourceTableDefinition = true;
                break;
            }
            case 50: {
                this.m_lastResource = this.m_projectFile.addResource();
                this.populateResource(this.m_lastResource, record);
                this.m_projectFile.fireResourceReadEvent(this.m_lastResource);
                break;
            }
            case 51: {
                if (this.m_lastResource == null) break;
                this.m_lastResource.setNotes(record.getString(0));
                break;
            }
            case 55: {
                if (this.m_lastResource == null) break;
                this.m_lastResourceCalendar = this.m_lastResource.addResourceCalendar();
                this.populateCalendar(record, this.m_lastResourceCalendar, false);
                break;
            }
            case 56: {
                if (this.m_lastResourceCalendar == null) break;
                ProjectCalendarHours hours = this.m_lastResourceCalendar.addCalendarHours();
                this.populateCalendarHours(record, hours);
                break;
            }
            case 57: {
                if (this.m_lastResourceCalendar == null) break;
                this.populateCalendarException(record, this.m_lastResourceCalendar);
                break;
            }
            case 60: {
                if (this.m_taskTableDefinition || this.m_ignoreTextModels) break;
                this.m_taskModel.update(record, true);
                this.m_taskTableDefinition = true;
                break;
            }
            case 61: {
                if (this.m_taskTableDefinition) break;
                this.m_taskModel.update(record, false);
                this.m_taskTableDefinition = true;
                break;
            }
            case 70: {
                this.m_lastTask = this.m_projectFile.addTask();
                this.populateTask(record, this.m_lastTask);
                int outlineLevel = NumberUtility.getInt(this.m_lastTask.getOutlineLevel());
                if (this.m_baseOutlineLevel == -1) {
                    this.m_baseOutlineLevel = outlineLevel;
                }
                if (outlineLevel != this.m_baseOutlineLevel) {
                    List<Task> childTasks = this.m_projectFile.getChildTasks();
                    if (childTasks.isEmpty()) {
                        throw new MPXJException("Invalid outline level");
                    }
                    childTasks.get(childTasks.size() - 1).addChildTask(this.m_lastTask, outlineLevel);
                }
                this.m_projectFile.fireTaskReadEvent(this.m_lastTask);
                break;
            }
            case 71: {
                if (this.m_lastTask == null) break;
                this.m_lastTask.setNotes(record.getString(0));
                break;
            }
            case 72: {
                if (this.m_lastTask == null) break;
                this.m_lastTask.setRecurring(true);
                RecurringTask task = this.m_lastTask.addRecurringTask();
                this.populateRecurringTask(record, task);
                break;
            }
            case 75: {
                if (this.m_lastTask == null) break;
                this.m_lastResourceAssignment = this.m_lastTask.addResourceAssignment((Resource)null);
                this.populateResourceAssignment(record, this.m_lastResourceAssignment);
                break;
            }
            case 76: {
                if (this.m_lastResourceAssignment == null) break;
                ResourceAssignmentWorkgroupFields workgroup = this.m_lastResourceAssignment.addWorkgroupAssignment();
                this.populateResourceAssignmentWorkgroupFields(record, workgroup);
                break;
            }
            case 999: {
                MPXReader.populateFileCreationRecord(record, this.m_projectFile.getFileCreationRecord());
                break;
            }
            default: {
                throw new MPXJException("Invalid record");
            }
        }
    }

    private void populateCurrencySettings(Record record, ProjectHeader projectHeader) {
        projectHeader.setCurrencySymbol(record.getString(0));
        projectHeader.setSymbolPosition(record.getCurrencySymbolPosition(1));
        projectHeader.setCurrencyDigits(record.getInteger(2));
        Character c = record.getCharacter(3);
        if (c != null) {
            projectHeader.setThousandsSeparator(c.charValue());
        }
        if ((c = record.getCharacter(4)) != null) {
            projectHeader.setDecimalSeparator(c.charValue());
        }
    }

    private void populateDefaultSettings(Record record, ProjectHeader projectHeader) throws MPXJException {
        projectHeader.setDefaultDurationUnits(record.getTimeUnit(0));
        projectHeader.setDefaultDurationIsFixed(record.getNumericBoolean(1));
        projectHeader.setDefaultWorkUnits(record.getTimeUnit(2));
        projectHeader.setMinutesPerDay(NumberUtility.getDouble(record.getFloat(3)) * 60.0);
        projectHeader.setMinutesPerWeek(NumberUtility.getDouble(record.getFloat(4)) * 60.0);
        projectHeader.setDefaultStandardRate(record.getRate(5));
        projectHeader.setDefaultOvertimeRate(record.getRate(6));
        projectHeader.setUpdatingTaskStatusUpdatesResourceStatus(record.getNumericBoolean(7));
        projectHeader.setSplitInProgressTasks(record.getNumericBoolean(8));
    }

    private void populateDateTimeSettings(Record record, ProjectHeader projectHeader) {
        Character c;
        projectHeader.setDateOrder(record.getDateOrder(0));
        projectHeader.setTimeFormat(record.getTimeFormat(1));
        Date time = this.getTimeFromInteger(record.getInteger(2));
        if (time != null) {
            projectHeader.setDefaultStartTime(time);
        }
        if ((c = record.getCharacter(3)) != null) {
            projectHeader.setDateSeparator(c.charValue());
        }
        projectHeader.setTimeSeparator(record.getCharacter(4));
        projectHeader.setAMText(record.getString(5));
        projectHeader.setPMText(record.getString(6));
        projectHeader.setDateFormat(record.getDateFormat(7));
        projectHeader.setBarTextDateFormat(record.getDateFormat(8));
    }

    private Date getTimeFromInteger(Integer time) {
        Date result = null;
        if (time != null) {
            int minutes = time;
            int hours = minutes / 60;
            Calendar cal = Calendar.getInstance();
            cal.set(14, 0);
            cal.set(13, 0);
            cal.set(12, minutes -= hours * 60);
            cal.set(11, hours);
            result = cal.getTime();
        }
        return result;
    }

    private void populateProjectHeader(Record record, ProjectHeader projectHeader) throws MPXJException {
        projectHeader.setProjectTitle(record.getString(0));
        projectHeader.setCompany(record.getString(1));
        projectHeader.setManager(record.getString(2));
        projectHeader.setCalendarName(record.getString(3));
        projectHeader.setStartDate(record.getDateTime(4));
        projectHeader.setFinishDate(record.getDateTime(5));
        projectHeader.setScheduleFrom(record.getScheduleFrom(6));
        projectHeader.setCurrentDate(record.getDateTime(7));
        projectHeader.setComments(record.getString(8));
        projectHeader.setCost(record.getCurrency(9));
        projectHeader.setBaselineCost(record.getCurrency(10));
        projectHeader.setActualCost(record.getCurrency(11));
        projectHeader.setWork(record.getDuration(12));
        projectHeader.setBaselineWork(record.getDuration(13));
        projectHeader.setActualWork(record.getDuration(14));
        projectHeader.setWork2(record.getPercentage(15));
        projectHeader.setDuration(record.getDuration(16));
        projectHeader.setBaselineDuration(record.getDuration(17));
        projectHeader.setActualDuration(record.getDuration(18));
        projectHeader.setPercentageComplete(record.getPercentage(19));
        projectHeader.setBaselineStart(record.getDateTime(20));
        projectHeader.setBaselineFinish(record.getDateTime(21));
        projectHeader.setActualStart(record.getDateTime(22));
        projectHeader.setActualFinish(record.getDateTime(23));
        projectHeader.setStartVariance(record.getDuration(24));
        projectHeader.setFinishVariance(record.getDuration(25));
        projectHeader.setSubject(record.getString(26));
        projectHeader.setAuthor(record.getString(27));
        projectHeader.setKeywords(record.getString(28));
    }

    private void populateCalendarHours(Record record, ProjectCalendarHours hours) throws MPXJException {
        hours.setDay(Day.getInstance(NumberUtility.getInt(record.getInteger(0))));
        this.addDateRange(hours, record.getTime(1), record.getTime(2));
        this.addDateRange(hours, record.getTime(3), record.getTime(4));
        this.addDateRange(hours, record.getTime(5), record.getTime(6));
    }

    private void addDateRange(ProjectCalendarHours hours, Date start, Date end) {
        if (start != null && end != null) {
            Calendar cal = Calendar.getInstance();
            cal.setTime(end);
            if (cal.get(11) == 0 && cal.get(12) == 0 && cal.get(13) == 0 && cal.get(14) == 0) {
                cal.add(6, 1);
            }
            end = cal.getTime();
            hours.addRange(new DateRange(start, end));
        }
    }

    private void populateCalendarException(Record record, ProjectCalendar calendar) throws MPXJException {
        Date fromDate = record.getDate(0);
        Date toDate = record.getDate(1);
        boolean working = record.getNumericBoolean(2);
        ProjectCalendarException exception = calendar.addCalendarException(fromDate, toDate);
        if (working) {
            exception.addRange(new DateRange(record.getTime(3), record.getTime(4)));
            exception.addRange(new DateRange(record.getTime(5), record.getTime(6)));
            exception.addRange(new DateRange(record.getTime(7), record.getTime(8)));
        }
    }

    private void populateCalendar(Record record, ProjectCalendar calendar, boolean isBaseCalendar) {
        if (isBaseCalendar) {
            calendar.setName(record.getString(0));
        } else {
            calendar.setParent(this.m_projectFile.getBaseCalendar(record.getString(0)));
        }
        calendar.setWorkingDay(Day.SUNDAY, DayType.getInstance(record.getInteger(1)));
        calendar.setWorkingDay(Day.MONDAY, DayType.getInstance(record.getInteger(2)));
        calendar.setWorkingDay(Day.TUESDAY, DayType.getInstance(record.getInteger(3)));
        calendar.setWorkingDay(Day.WEDNESDAY, DayType.getInstance(record.getInteger(4)));
        calendar.setWorkingDay(Day.THURSDAY, DayType.getInstance(record.getInteger(5)));
        calendar.setWorkingDay(Day.FRIDAY, DayType.getInstance(record.getInteger(6)));
        calendar.setWorkingDay(Day.SATURDAY, DayType.getInstance(record.getInteger(7)));
        this.m_projectFile.fireCalendarReadEvent(calendar);
    }

    private void populateResource(Resource resource, Record record) throws MPXJException {
        int mpxFieldType;
        String falseText = LocaleData.getString(this.m_locale, "NO");
        int length = record.getLength();
        int[] model = this.m_resourceModel.getModel();
        block12: for (int i = 0; i < length && (mpxFieldType = model[i]) != -1; ++i) {
            String field = record.getString(i);
            if (field == null || field.length() == 0) continue;
            ResourceField resourceField = MPXResourceField.getMpxjField(mpxFieldType);
            switch (resourceField) {
                case OBJECTS: {
                    resource.set((FieldType)resourceField, record.getInteger(i));
                    continue block12;
                }
                case ID: {
                    resource.setID(record.getInteger(i));
                    continue block12;
                }
                case UNIQUE_ID: {
                    resource.setUniqueID(record.getInteger(i));
                    continue block12;
                }
                case MAX_UNITS: {
                    resource.set((FieldType)resourceField, record.getUnits(i));
                    continue block12;
                }
                case PERCENT_WORK_COMPLETE: 
                case PEAK: {
                    resource.set((FieldType)resourceField, record.getPercentage(i));
                    continue block12;
                }
                case COST: 
                case COST_PER_USE: 
                case COST_VARIANCE: 
                case BASELINE_COST: 
                case ACTUAL_COST: 
                case REMAINING_COST: {
                    resource.set((FieldType)resourceField, record.getCurrency(i));
                    continue block12;
                }
                case OVERTIME_RATE: 
                case STANDARD_RATE: {
                    resource.set((FieldType)resourceField, record.getRate(i));
                    continue block12;
                }
                case REMAINING_WORK: 
                case OVERTIME_WORK: 
                case BASELINE_WORK: 
                case ACTUAL_WORK: 
                case WORK: 
                case WORK_VARIANCE: {
                    resource.set((FieldType)resourceField, record.getDuration(i));
                    continue block12;
                }
                case ACCRUE_AT: {
                    resource.set((FieldType)resourceField, record.getAccrueType(i));
                    continue block12;
                }
                case OVERALLOCATED: {
                    resource.set((FieldType)resourceField, record.getBoolean(i, falseText));
                    continue block12;
                }
                default: {
                    resource.set((FieldType)resourceField, field);
                }
            }
        }
        if (this.m_projectFile.getAutoResourceUniqueID()) {
            resource.setUniqueID(this.m_projectFile.getResourceUniqueID());
        }
        if (this.m_projectFile.getAutoResourceID()) {
            resource.setID(this.m_projectFile.getResourceID());
        }
        if (resource.getUniqueID() == null) {
            resource.setUniqueID(resource.getID());
        }
    }

    private void populateRelationList(Task task, TaskField field, String data) {
        DeferredRelationship dr = new DeferredRelationship();
        dr.setTask(task);
        dr.setField(field);
        dr.setData(data);
        this.m_deferredRelationships.add(dr);
    }

    private void processDeferredRelationships() throws MPXJException {
        for (DeferredRelationship dr : this.m_deferredRelationships) {
            this.processDeferredRelationship(dr);
        }
    }

    private void processDeferredRelationship(DeferredRelationship dr) throws MPXJException {
        String data = dr.getData();
        Task task = dr.getTask();
        int length = data.length();
        if (length != 0) {
            int start = 0;
            int end = 0;
            while (end != length) {
                end = data.indexOf(this.m_delimiter, start);
                if (end == -1) {
                    end = length;
                }
                this.populateRelation(dr.getField(), task, data.substring(start, end).trim());
                start = end + 1;
            }
        }
    }

    private void populateRelation(TaskField field, Task sourceTask, String relationship) throws MPXJException {
        Integer taskID;
        int index;
        int length = relationship.length();
        for (index = 0; index < length && Character.isDigit(relationship.charAt(index)); ++index) {
        }
        try {
            taskID = Integer.valueOf(relationship.substring(0, index));
        }
        catch (NumberFormatException ex) {
            throw new MPXJException("Invalid format '" + relationship + "'");
        }
        Task targetTask = field == TaskField.PREDECESSORS ? this.m_projectFile.getTaskByID(taskID) : this.m_projectFile.getTaskByUniqueID(taskID);
        RelationType type = null;
        Duration lag = null;
        if (index == length) {
            type = RelationType.FINISH_START;
            lag = Duration.getInstance(0, TimeUnit.DAYS);
        } else {
            if (index + 1 == length) {
                throw new MPXJException("Invalid format '" + relationship + "'");
            }
            type = RelationTypeUtility.getInstance(this.m_locale, relationship.substring(index, index + 2));
            if ((index += 2) == length) {
                lag = Duration.getInstance(0, TimeUnit.DAYS);
            } else {
                if (relationship.charAt(index) == '+') {
                    ++index;
                }
                lag = DurationUtility.getInstance(relationship.substring(index), this.m_formats.getDurationDecimalFormat(), this.m_locale);
            }
        }
        if (type == null) {
            throw new MPXJException("Invalid format '" + relationship + "'");
        }
        Relation relation = sourceTask.addPredecessor(targetTask, type, lag);
        this.m_projectFile.fireRelationReadEvent(relation);
    }

    private void populateTask(Record record, Task task) throws MPXJException {
        String falseText = LocaleData.getString(this.m_locale, "NO");
        int mpxFieldID = 0;
        int i = 0;
        int length = record.getLength();
        int[] model = this.m_taskModel.getModel();
        block23: while (i < length && (mpxFieldID = model[i]) != -1) {
            String field;
            if ((field = record.getString(i++)) == null || field.length() == 0) continue;
            TaskField taskField = MPXTaskField.getMpxjField(mpxFieldID);
            if (taskField == null) {
                System.out.println("Null Task Field " + mpxFieldID);
                continue;
            }
            switch (taskField) {
                case PREDECESSORS: 
                case UNIQUE_ID_PREDECESSORS: {
                    this.populateRelationList(task, taskField, field);
                    continue block23;
                }
                case PERCENT_COMPLETE: 
                case PERCENT_WORK_COMPLETE: {
                    try {
                        task.set((FieldType)taskField, this.m_formats.getPercentageDecimalFormat().parse(field));
                        continue block23;
                    }
                    catch (ParseException ex) {
                        throw new MPXJException("Failed to parse percentage", ex);
                    }
                }
                case ACTUAL_COST: 
                case BASELINE_COST: 
                case BCWP: 
                case BCWS: 
                case COST: 
                case COST1: 
                case COST2: 
                case COST3: 
                case COST_VARIANCE: 
                case CV: 
                case FIXED_COST: 
                case REMAINING_COST: 
                case SV: {
                    try {
                        task.set((FieldType)taskField, this.m_formats.getCurrencyFormat().parse(field));
                        continue block23;
                    }
                    catch (ParseException ex) {
                        throw new MPXJException("Failed to parse currency", ex);
                    }
                }
                case ACTUAL_DURATION: 
                case ACTUAL_WORK: 
                case BASELINE_DURATION: 
                case BASELINE_WORK: 
                case DURATION: 
                case DURATION1: 
                case DURATION2: 
                case DURATION3: 
                case DURATION_VARIANCE: 
                case FINISH_VARIANCE: 
                case FREE_SLACK: 
                case REMAINING_DURATION: 
                case REMAINING_WORK: 
                case START_VARIANCE: 
                case TOTAL_SLACK: 
                case WORK: 
                case WORK_VARIANCE: 
                case LEVELING_DELAY: {
                    task.set((FieldType)taskField, DurationUtility.getInstance(field, this.m_formats.getDurationDecimalFormat(), this.m_locale));
                    continue block23;
                }
                case ACTUAL_FINISH: 
                case ACTUAL_START: 
                case BASELINE_FINISH: 
                case BASELINE_START: 
                case CONSTRAINT_DATE: 
                case CREATED: 
                case EARLY_FINISH: 
                case EARLY_START: 
                case FINISH: 
                case FINISH1: 
                case FINISH2: 
                case FINISH3: 
                case FINISH4: 
                case FINISH5: 
                case LATE_FINISH: 
                case LATE_START: 
                case RESUME: 
                case START: 
                case START1: 
                case START2: 
                case START3: 
                case START4: 
                case START5: 
                case STOP: {
                    try {
                        task.set((FieldType)taskField, this.m_formats.getDateTimeFormat().parse(field));
                        continue block23;
                    }
                    catch (ParseException ex) {
                        throw new MPXJException("Failed to parse date time", ex);
                    }
                }
                case CONFIRMED: 
                case CRITICAL: 
                case FLAG1: 
                case FLAG2: 
                case FLAG3: 
                case FLAG4: 
                case FLAG5: 
                case FLAG6: 
                case FLAG7: 
                case FLAG8: 
                case FLAG9: 
                case FLAG10: 
                case HIDEBAR: 
                case LINKED_FIELDS: 
                case MARKED: 
                case MILESTONE: 
                case ROLLUP: 
                case SUMMARY: 
                case UPDATE_NEEDED: {
                    task.set((FieldType)taskField, field.equalsIgnoreCase(falseText) ? Boolean.FALSE : Boolean.TRUE);
                    continue block23;
                }
                case CONSTRAINT_TYPE: {
                    task.set((FieldType)taskField, ConstraintTypeUtility.getInstance(this.m_locale, field));
                    continue block23;
                }
                case OBJECTS: 
                case OUTLINE_LEVEL: {
                    task.set((FieldType)taskField, Integer.valueOf(field));
                    continue block23;
                }
                case ID: {
                    task.setID(Integer.valueOf(field));
                    continue block23;
                }
                case UNIQUE_ID: {
                    task.setUniqueID(Integer.valueOf(field));
                    continue block23;
                }
                case NUMBER1: 
                case NUMBER2: 
                case NUMBER3: 
                case NUMBER4: 
                case NUMBER5: {
                    try {
                        task.set((FieldType)taskField, this.m_formats.getDecimalFormat().parse(field));
                        continue block23;
                    }
                    catch (ParseException ex) {
                        throw new MPXJException("Failed to parse number", ex);
                    }
                }
                case PRIORITY: {
                    task.set((FieldType)taskField, PriorityUtility.getInstance(this.m_locale, field));
                    continue block23;
                }
                case TYPE: {
                    boolean fixed = !field.equalsIgnoreCase(falseText);
                    task.setType(fixed ? TaskType.FIXED_DURATION : TaskType.FIXED_UNITS);
                    continue block23;
                }
            }
            task.set((FieldType)taskField, field);
        }
        if (this.m_projectFile.getAutoWBS()) {
            task.generateWBS(null);
        }
        if (this.m_projectFile.getAutoOutlineNumber()) {
            task.generateOutlineNumber(null);
        }
        if (this.m_projectFile.getAutoOutlineLevel()) {
            task.setOutlineLevel(1);
        }
        if (this.m_projectFile.getAutoTaskUniqueID()) {
            task.setUniqueID(this.m_projectFile.getTaskUniqueID());
        }
        if (task.getID() == null || this.m_projectFile.getAutoTaskID()) {
            task.setID(this.m_projectFile.getTaskID());
        }
        if (task.getUniqueID() == null) {
            task.setUniqueID(task.getID());
        }
    }

    private void populateRecurringTask(Record record, RecurringTask task) throws MPXJException {
        task.setStartDate(record.getDateTime(1));
        task.setFinishDate(record.getDateTime(2));
        task.setDuration(RecurrenceUtility.getDuration(this.m_projectFile.getProjectHeader(), record.getInteger(3), record.getInteger(4)));
        task.setOccurrences(record.getInteger(5));
        task.setRecurrenceType(RecurrenceUtility.getRecurrenceType(record.getInteger(6)));
        task.setUseEndDate(NumberUtility.getInt(record.getInteger(8)) == 1);
        task.setDailyWorkday(NumberUtility.getInt(record.getInteger(9)) == 1);
        task.setWeeklyDays(RecurrenceUtility.getDays(record.getString(10)));
        task.setMonthlyRelative(NumberUtility.getInt(record.getInteger(11)) == 1);
        task.setYearlyAbsolute(NumberUtility.getInt(record.getInteger(12)) == 1);
        task.setDailyFrequency(record.getInteger(13));
        task.setWeeklyFrequency(record.getInteger(14));
        task.setMonthlyRelativeOrdinal(record.getInteger(15));
        task.setMonthlyRelativeDay(RecurrenceUtility.getDay(record.getInteger(16)));
        task.setMonthlyRelativeFrequency(record.getInteger(17));
        task.setMonthlyAbsoluteDay(record.getInteger(18));
        task.setMonthlyAbsoluteFrequency(record.getInteger(19));
        task.setYearlyRelativeOrdinal(record.getInteger(20));
        task.setYearlyRelativeDay(RecurrenceUtility.getDay(record.getInteger(21)));
        task.setYearlyRelativeMonth(record.getInteger(22));
        task.setYearlyAbsoluteDate(record.getDateTime(23));
    }

    private void populateResourceAssignment(Record record, ResourceAssignment assignment) throws MPXJException {
        Resource resource = this.m_projectFile.getResourceByUniqueID(record.getInteger(12));
        if (resource == null) {
            resource = this.m_projectFile.getResourceByID(record.getInteger(0));
        }
        assignment.setUnits(record.getUnits(1));
        assignment.setWork(record.getDuration(2));
        assignment.setBaselineWork(record.getDuration(3));
        assignment.setActualWork(record.getDuration(4));
        assignment.setOvertimeWork(record.getDuration(5));
        assignment.setCost(record.getCurrency(6));
        assignment.setBaselineCost(record.getCurrency(7));
        assignment.setActualCost(record.getCurrency(8));
        assignment.setStart(record.getDateTime(9));
        assignment.setFinish(record.getDateTime(10));
        assignment.setDelay(record.getDuration(11));
        Duration work = assignment.getWork();
        Duration actualWork = assignment.getActualWork();
        if (work != null && actualWork != null) {
            if (work.getUnits() != actualWork.getUnits()) {
                actualWork = actualWork.convertUnits(work.getUnits(), this.m_projectFile.getProjectHeader());
            }
            assignment.setRemainingWork(Duration.getInstance(work.getDuration() - actualWork.getDuration(), work.getUnits()));
        }
        if (resource != null) {
            assignment.setResourceUniqueID(resource.getUniqueID());
            resource.addResourceAssignment(assignment);
        }
        this.m_projectFile.fireAssignmentReadEvent(assignment);
    }

    private void populateResourceAssignmentWorkgroupFields(Record record, ResourceAssignmentWorkgroupFields workgroup) throws MPXJException {
        workgroup.setMessageUniqueID(record.getString(0));
        workgroup.setConfirmed(NumberUtility.getInt(record.getInteger(1)) == 1);
        workgroup.setResponsePending(NumberUtility.getInt(record.getInteger(1)) == 1);
        workgroup.setUpdateStart(record.getDateTime(3));
        workgroup.setUpdateFinish(record.getDateTime(4));
        workgroup.setScheduleID(record.getString(5));
    }

    static void populateFileCreationRecord(Record record, FileCreationRecord fcr) {
        fcr.setProgramName(record.getString(0));
        fcr.setFileVersion(FileVersion.getInstance(record.getString(1)));
        fcr.setCodePage(record.getCodePage(2));
    }

    public Locale getLocale() {
        return this.m_locale;
    }

    public void setLocale(Locale locale) {
        this.m_locale = locale;
    }

    public Locale[] getSupportedLocales() {
        return LocaleUtility.getSupportedLocales();
    }

    public void setIgnoreTextModels(boolean flag) {
        this.m_ignoreTextModels = flag;
    }

    public boolean getIgnoreTextModels() {
        return this.m_ignoreTextModels;
    }

    protected static class DeferredRelationship {
        private Task m_task;
        private TaskField m_field;
        private String m_data;

        protected DeferredRelationship() {
        }

        public Task getTask() {
            return this.m_task;
        }

        public void setTask(Task task) {
            this.m_task = task;
        }

        public TaskField getField() {
            return this.m_field;
        }

        public void setField(TaskField field) {
            this.m_field = field;
        }

        public String getData() {
            return this.m_data;
        }

        public void setData(String data) {
            this.m_data = data;
        }
    }
}

