/*
 * Decompiled with CFR 0.152.
 */
package net.sf.mpxj.mpp;

import net.sf.mpxj.utility.EnumUtility;
import net.sf.mpxj.utility.MpxjEnum;
import net.sf.mpxj.utility.NumberUtility;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public enum Interval implements MpxjEnum
{
    DAILY(0, "Daily"),
    WEEKLY(1, "Weekly"),
    MONTHLY(2, "Monthly");

    private static final Interval[] TYPE_VALUES;
    private int m_value;
    private String m_name;

    private Interval(int type, String name) {
        this.m_value = type;
        this.m_name = name;
    }

    public static Interval getInstance(int type) {
        if (type < 0 || type >= TYPE_VALUES.length) {
            type = DAILY.getValue();
        }
        return TYPE_VALUES[type];
    }

    public static Interval getInstance(Number type) {
        int value = type == null ? -1 : NumberUtility.getInt(type);
        return Interval.getInstance(value);
    }

    @Override
    public int getValue() {
        return this.m_value;
    }

    public String getName() {
        return this.m_name;
    }

    public String toString() {
        return this.getName();
    }

    static {
        TYPE_VALUES = (Interval[])EnumUtility.createTypeArray(Interval.class);
    }
}

