/*
 * Decompiled with CFR 0.152.
 */
package net.sf.mpxj.mpd;

import java.sql.Connection;
import java.sql.DatabaseMetaData;
import java.sql.PreparedStatement;
import java.sql.ResultSet;
import java.sql.ResultSetMetaData;
import java.sql.SQLException;
import java.util.HashMap;
import java.util.HashSet;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import javax.sql.DataSource;
import net.sf.mpxj.MPXJException;
import net.sf.mpxj.ProjectCalendar;
import net.sf.mpxj.ProjectFile;
import net.sf.mpxj.SubProject;
import net.sf.mpxj.Task;
import net.sf.mpxj.listener.ProjectListener;
import net.sf.mpxj.mpd.MPD9AbstractReader;
import net.sf.mpxj.mpd.ResultSetRow;
import net.sf.mpxj.mpd.Row;
import net.sf.mpxj.utility.NumberUtility;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public final class MPD9DatabaseReader
extends MPD9AbstractReader {
    private DataSource m_dataSource;
    private boolean m_allocatedConnection;
    private Connection m_connection;
    private PreparedStatement m_ps;
    private ResultSet m_rs;
    private Map<String, Integer> m_meta = new HashMap<String, Integer>();
    private List<ProjectListener> m_projectListeners;
    private boolean m_hasResourceBaselines;
    private boolean m_hasTaskBaselines;
    private boolean m_hasAssignmentBaselines;

    public void addProjectListener(ProjectListener listener) {
        if (this.m_projectListeners == null) {
            this.m_projectListeners = new LinkedList<ProjectListener>();
        }
        this.m_projectListeners.add(listener);
    }

    public Map<Integer, String> listProjects() throws MPXJException {
        try {
            HashMap<Integer, String> result = new HashMap<Integer, String>();
            List<ResultSetRow> rows = this.getRows("SELECT PROJ_ID, PROJ_NAME FROM MSP_PROJECTS");
            for (ResultSetRow row : rows) {
                this.processProjectListItem(result, row);
            }
            return result;
        }
        catch (SQLException ex) {
            throw new MPXJException("Error reading file", ex);
        }
    }

    public ProjectFile read() throws MPXJException {
        ProjectFile projectFile;
        try {
            this.m_project = new ProjectFile();
            this.m_project.addProjectListeners(this.m_projectListeners);
            this.m_project.setAutoTaskID(false);
            this.m_project.setAutoTaskUniqueID(false);
            this.m_project.setAutoResourceID(false);
            this.m_project.setAutoResourceUniqueID(false);
            this.m_project.setAutoOutlineLevel(false);
            this.m_project.setAutoOutlineNumber(false);
            this.m_project.setAutoWBS(false);
            this.m_project.setAutoCalendarUniqueID(false);
            this.m_project.setAutoAssignmentUniqueID(false);
            this.processProjectHeader();
            this.processCalendars();
            this.processResources();
            this.processResourceBaselines();
            this.processTasks();
            this.processTaskBaselines();
            this.processLinks();
            this.processAssignments();
            this.processAssignmentBaselines();
            this.processExtendedAttributes();
            this.processSubProjects();
            this.postProcessing();
            projectFile = this.m_project;
            Object var3_3 = null;
        }
        catch (SQLException ex) {
            try {
                throw new MPXJException("Error reading file", ex);
            }
            catch (Throwable throwable) {
                block9: {
                    Object var3_4 = null;
                    this.reset();
                    if (!this.m_allocatedConnection || this.m_connection == null) break block9;
                    try {
                        this.m_connection.close();
                    }
                    catch (SQLException ex2) {
                        // empty catch block
                    }
                    this.m_connection = null;
                }
                throw throwable;
            }
        }
        this.reset();
        if (this.m_allocatedConnection && this.m_connection != null) {
            try {
                this.m_connection.close();
            }
            catch (SQLException ex2) {
                // empty catch block
            }
            this.m_connection = null;
        }
        return projectFile;
    }

    private void processProjectHeader() throws SQLException {
        List<ResultSetRow> rows = this.getRows("SELECT * FROM MSP_PROJECTS WHERE PROJ_ID=?", this.m_projectID);
        if (!rows.isEmpty()) {
            this.processProjectHeader(rows.get(0));
        }
    }

    private void processCalendars() throws SQLException {
        for (ResultSetRow row : this.getRows("SELECT * FROM MSP_CALENDARS WHERE PROJ_ID=?", this.m_projectID)) {
            this.processCalendar(row);
        }
        this.updateBaseCalendarNames();
        this.processCalendarData(this.m_project.getBaseCalendars());
        this.processCalendarData(this.m_project.getResourceCalendars());
    }

    private void processCalendarData(List<ProjectCalendar> calendars) throws SQLException {
        for (ProjectCalendar calendar : calendars) {
            this.processCalendarData(calendar, this.getRows("SELECT * FROM MSP_CALENDAR_DATA WHERE PROJ_ID=? AND CAL_UID=?", this.m_projectID, calendar.getUniqueID()));
        }
    }

    private void processCalendarData(ProjectCalendar calendar, List<ResultSetRow> calendarData) {
        for (ResultSetRow row : calendarData) {
            this.processCalendarData(calendar, row);
        }
    }

    private void processResources() throws SQLException {
        for (ResultSetRow row : this.getRows("SELECT * FROM MSP_RESOURCES WHERE PROJ_ID=?", this.m_projectID)) {
            this.processResource(row);
        }
    }

    private void processResourceBaselines() throws SQLException {
        if (this.m_hasResourceBaselines) {
            for (ResultSetRow row : this.getRows("SELECT * FROM MSP_RESOURCE_BASELINES WHERE PROJ_ID=?", this.m_projectID)) {
                this.processResourceBaseline(row);
            }
        }
    }

    private void processTasks() throws SQLException {
        for (ResultSetRow row : this.getRows("SELECT * FROM MSP_TASKS WHERE PROJ_ID=?", this.m_projectID)) {
            this.processTask(row);
        }
    }

    private void processTaskBaselines() throws SQLException {
        if (this.m_hasTaskBaselines) {
            for (ResultSetRow row : this.getRows("SELECT * FROM MSP_TASK_BASELINES WHERE PROJ_ID=?", this.m_projectID)) {
                this.processTaskBaseline(row);
            }
        }
    }

    private void processLinks() throws SQLException {
        for (ResultSetRow row : this.getRows("SELECT * FROM MSP_LINKS WHERE PROJ_ID=?", this.m_projectID)) {
            this.processLink(row);
        }
    }

    private void processAssignments() throws SQLException {
        for (ResultSetRow row : this.getRows("SELECT * FROM MSP_ASSIGNMENTS WHERE PROJ_ID=?", this.m_projectID)) {
            this.processAssignment(row);
        }
    }

    private void processAssignmentBaselines() throws SQLException {
        if (this.m_hasAssignmentBaselines) {
            for (ResultSetRow row : this.getRows("SELECT * FROM MSP_ASSIGNMENT_BASELINES WHERE PROJ_ID=?", this.m_projectID)) {
                this.processAssignmentBaseline(row);
            }
        }
    }

    private void processExtendedAttributes() throws SQLException {
        this.processTextFields();
        this.processNumberFields();
        this.processFlagFields();
        this.processDurationFields();
        this.processDateFields();
        this.processOutlineCodeFields();
    }

    private void processSubProjects() {
        int subprojectIndex = 1;
        for (Task task : this.m_project.getAllTasks()) {
            String subProjectFileName = task.getSubprojectName();
            if (subProjectFileName == null) continue;
            String fileName = subProjectFileName;
            int offset = 0x1000000 + subprojectIndex * 0x400000;
            int index = subProjectFileName.lastIndexOf(92);
            if (index != -1) {
                fileName = subProjectFileName.substring(index + 1);
            }
            SubProject sp = new SubProject();
            sp.setFileName(fileName);
            sp.setFullPath(subProjectFileName);
            sp.setUniqueIDOffset(offset);
            sp.setTaskUniqueID(task.getUniqueID());
            task.setSubProject(sp);
            ++subprojectIndex;
        }
    }

    private void processTextFields() throws SQLException {
        for (ResultSetRow row : this.getRows("SELECT * FROM MSP_TEXT_FIELDS WHERE PROJ_ID=?", this.m_projectID)) {
            this.processTextField(row);
        }
    }

    private void processNumberFields() throws SQLException {
        for (ResultSetRow row : this.getRows("SELECT * FROM MSP_NUMBER_FIELDS WHERE PROJ_ID=?", this.m_projectID)) {
            this.processNumberField(row);
        }
    }

    private void processFlagFields() throws SQLException {
        for (ResultSetRow row : this.getRows("SELECT * FROM MSP_FLAG_FIELDS WHERE PROJ_ID=?", this.m_projectID)) {
            this.processFlagField(row);
        }
    }

    private void processDurationFields() throws SQLException {
        for (ResultSetRow row : this.getRows("SELECT * FROM MSP_DURATION_FIELDS WHERE PROJ_ID=?", this.m_projectID)) {
            this.processDurationField(row);
        }
    }

    private void processDateFields() throws SQLException {
        for (ResultSetRow row : this.getRows("SELECT * FROM MSP_DATE_FIELDS WHERE PROJ_ID=?", this.m_projectID)) {
            this.processDateField(row);
        }
    }

    private void processOutlineCodeFields() throws SQLException {
        for (ResultSetRow row : this.getRows("SELECT * FROM MSP_CODE_FIELDS WHERE PROJ_ID=?", this.m_projectID)) {
            this.processOutlineCodeFields(row);
        }
    }

    private void processOutlineCodeFields(Row parentRow) throws SQLException {
        Integer entityID = parentRow.getInteger("CODE_REF_UID");
        Integer outlineCodeEntityID = parentRow.getInteger("CODE_UID");
        for (ResultSetRow row : this.getRows("SELECT * FROM MSP_OUTLINE_CODES WHERE CODE_UID=?", outlineCodeEntityID)) {
            this.processOutlineCodeField(entityID, row);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private List<ResultSetRow> getRows(String sql) throws SQLException {
        this.allocateConnection();
        try {
            LinkedList<ResultSetRow> result = new LinkedList<ResultSetRow>();
            this.m_ps = this.m_connection.prepareStatement(sql);
            this.m_rs = this.m_ps.executeQuery();
            this.populateMetaData();
            while (this.m_rs.next()) {
                result.add(new ResultSetRow(this.m_rs, this.m_meta));
            }
            LinkedList<ResultSetRow> linkedList = result;
            Object var5_4 = null;
            this.releaseConnection();
            return linkedList;
        }
        catch (Throwable throwable) {
            Object var5_5 = null;
            this.releaseConnection();
            throw throwable;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private List<ResultSetRow> getRows(String sql, Integer var) throws SQLException {
        this.allocateConnection();
        try {
            LinkedList<ResultSetRow> result = new LinkedList<ResultSetRow>();
            this.m_ps = this.m_connection.prepareStatement(sql);
            this.m_ps.setInt(1, NumberUtility.getInt(var));
            this.m_rs = this.m_ps.executeQuery();
            this.populateMetaData();
            while (this.m_rs.next()) {
                result.add(new ResultSetRow(this.m_rs, this.m_meta));
            }
            LinkedList<ResultSetRow> linkedList = result;
            Object var6_5 = null;
            this.releaseConnection();
            return linkedList;
        }
        catch (Throwable throwable) {
            Object var6_6 = null;
            this.releaseConnection();
            throw throwable;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private List<ResultSetRow> getRows(String sql, Integer var1, Integer var2) throws SQLException {
        this.allocateConnection();
        try {
            LinkedList<ResultSetRow> result = new LinkedList<ResultSetRow>();
            this.m_ps = this.m_connection.prepareStatement(sql);
            this.m_ps.setInt(1, NumberUtility.getInt(var1));
            this.m_ps.setInt(2, NumberUtility.getInt(var2));
            this.m_rs = this.m_ps.executeQuery();
            this.populateMetaData();
            while (this.m_rs.next()) {
                result.add(new ResultSetRow(this.m_rs, this.m_meta));
            }
            LinkedList<ResultSetRow> linkedList = result;
            Object var7_6 = null;
            this.releaseConnection();
            return linkedList;
        }
        catch (Throwable throwable) {
            Object var7_7 = null;
            this.releaseConnection();
            throw throwable;
        }
    }

    private void allocateConnection() throws SQLException {
        if (this.m_connection == null) {
            this.m_connection = this.m_dataSource.getConnection();
            this.m_allocatedConnection = true;
            this.queryDatabaseMetaData();
        }
    }

    private void releaseConnection() {
        if (this.m_rs != null) {
            try {
                this.m_rs.close();
            }
            catch (SQLException ex) {
                // empty catch block
            }
            this.m_rs = null;
        }
        if (this.m_ps != null) {
            try {
                this.m_ps.close();
            }
            catch (SQLException sQLException) {
                // empty catch block
            }
            this.m_ps = null;
        }
    }

    private void populateMetaData() throws SQLException {
        this.m_meta.clear();
        ResultSetMetaData meta = this.m_rs.getMetaData();
        int columnCount = meta.getColumnCount() + 1;
        for (int loop = 1; loop < columnCount; ++loop) {
            String name = meta.getColumnName(loop);
            Integer type = meta.getColumnType(loop);
            this.m_meta.put(name, type);
        }
    }

    public void setDataSource(DataSource dataSource) {
        this.m_dataSource = dataSource;
    }

    public void setConnection(Connection connection) {
        this.m_connection = connection;
        this.queryDatabaseMetaData();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Loose catch block
     */
    private void queryDatabaseMetaData() {
        block10: {
            ResultSet rs = null;
            HashSet<String> tables = new HashSet<String>();
            DatabaseMetaData dmd = this.m_connection.getMetaData();
            rs = dmd.getTables(null, null, null, null);
            while (rs.next()) {
                tables.add(rs.getString("TABLE_NAME"));
            }
            this.m_hasResourceBaselines = tables.contains("MSP_RESOURCE_BASELINES");
            this.m_hasTaskBaselines = tables.contains("MSP_TASK_BASELINES");
            this.m_hasAssignmentBaselines = tables.contains("MSP_ASSIGNMENT_BASELINES");
            Object var5_5 = null;
            if (rs == null) break block10;
            try {
                rs.close();
            }
            catch (SQLException ex) {
                // empty catch block
            }
            rs = null;
            {
                break block10;
                catch (Exception exception) {
                    Object var5_6 = null;
                    if (rs == null) break block10;
                    try {
                        rs.close();
                    }
                    catch (SQLException ex) {
                        // empty catch block
                    }
                    rs = null;
                }
            }
            catch (Throwable throwable) {
                Object var5_7 = null;
                if (rs != null) {
                    try {
                        rs.close();
                    }
                    catch (SQLException ex) {
                        // empty catch block
                    }
                    rs = null;
                }
                throw throwable;
            }
        }
    }
}

