/*
 * Decompiled with CFR 0.152.
 */
package net.sf.mpxj.junit;

import java.text.SimpleDateFormat;
import java.util.List;
import net.sf.mpxj.Duration;
import net.sf.mpxj.ProjectFile;
import net.sf.mpxj.ResourceAssignment;
import net.sf.mpxj.Task;
import net.sf.mpxj.TimeUnit;
import net.sf.mpxj.junit.MPXJTestCase;
import net.sf.mpxj.mpd.MPDDatabaseReader;
import net.sf.mpxj.mpp.MPPReader;
import net.sf.mpxj.mspdi.MSPDIReader;

public class MppAssignmentTest
extends MPXJTestCase {
    private static final int[][] BASELINE_COSTS = new int[][]{{1, 2, 3, 4, 5, 6, 7, 8, 9, 10}, {11, 12, 13, 14, 15, 16, 17, 18, 19, 20}};
    private static final int[][] BASELINE_WORKS = new int[][]{{1, 2, 3, 4, 5, 6, 7, 8, 9, 10}, {11, 12, 13, 14, 15, 16, 17, 18, 19, 20}};
    private static final String[][] BASELINE_STARTS = new String[][]{{"01/01/10 08:00", "02/01/10 08:00", "03/01/10 08:00", "04/01/10 08:00", "05/01/10 08:00", "06/01/10 08:00", "07/01/10 08:00", "08/01/10 08:00", "09/01/10 08:00", "10/01/10 08:00"}, {"01/02/10 08:00", "02/02/10 08:00", "03/02/10 08:00", "04/02/10 08:00", "05/02/10 08:00", "06/02/10 08:00", "07/02/10 08:00", "08/02/10 08:00", "09/02/10 08:00", "10/02/10 08:00"}};
    private static final String[][] BASELINE_FINISHES = new String[][]{{"01/01/09 17:00", "02/01/09 17:00", "03/01/09 17:00", "04/01/09 17:00", "05/01/09 17:00", "06/01/09 17:00", "07/01/09 17:00", "08/01/09 17:00", "09/01/09 17:00", "10/01/09 17:00"}, {"01/02/09 17:00", "02/02/09 17:00", "03/02/09 17:00", "04/02/09 17:00", "05/02/09 17:00", "06/02/09 17:00", "07/02/09 17:00", "08/02/09 17:00", "09/02/09 17:00", "10/02/09 17:00"}};
    private static final String[][] CUSTOM_TEXT = new String[][]{{"t1", "t2", "t3", "t4", "t5", "t6", "t7", "t8", "t9", "t10", "t11", "t12", "t13", "t14", "t15", "t16", "t17", "t18", "t19", "t20", "t21", "t22", "t23", "t24", "t25", "t26", "t27", "t28", "t29", "t30"}, {"a1", "a2", "a3", "a4", "a5", "a6", "a7", "a8", "a9", "a10", "a11", "a12", "a13", "a14", "a15", "a16", "a17", "a18", "a19", "a20", "a21", "a22", "a23", "a24", "a25", "a26", "a27", "a28", "a29", "a30"}};
    private static final String[][] CUSTOM_START = new String[][]{{"01/01/11 08:00", "02/01/11 08:00", "03/01/11 08:00", "04/01/11 08:00", "05/06/11 08:00", "06/01/11 08:00", "07/01/11 08:00", "08/01/11 08:00", "09/01/11 08:00", "10/01/11 08:00"}, {"01/02/11 08:00", "02/02/11 08:00", "03/02/11 08:00", "04/02/11 08:00", "05/02/11 08:00", "06/02/11 08:00", "07/02/11 08:00", "08/02/11 08:00", "09/02/11 08:00", "10/02/11 08:00"}};
    private static final String[][] CUSTOM_FINISH = new String[][]{{"01/03/11 17:00", "02/03/11 17:00", "03/03/11 17:00", "04/03/11 17:00", "05/03/11 17:00", "06/03/11 17:00", "07/03/11 17:00", "08/03/11 17:00", "09/03/11 17:00", "10/03/11 17:00"}, {"01/04/11 17:00", "02/04/11 17:00", "03/04/11 17:00", "04/04/11 17:00", "05/04/11 17:00", "06/04/11 17:00", "07/04/11 17:00", "08/04/11 17:00", "09/04/11 17:00", "10/04/11 17:00"}};
    private static final String[][] CUSTOM_DATE = new String[][]{{"01/05/11 08:00", "02/05/11 08:00", "03/05/11 08:00", "04/05/11 08:00", "05/05/11 08:00", "06/05/11 08:00", "07/05/11 08:00", "08/05/11 08:00", "09/05/11 08:00", "10/05/11 08:00"}, {"01/06/11 08:00", "02/06/11 08:00", "03/06/11 08:00", "04/06/11 08:00", "05/06/11 08:00", "06/06/11 08:00", "07/06/11 08:00", "08/06/11 08:00", "09/06/11 08:00", "10/06/11 08:00"}};
    private static final int[][] CUSTOM_NUMBER = new int[][]{{1, 2, 3, 4, 5, 6, 7, 8, 9, 10, 11, 12, 13, 14, 15, 16, 17, 18, 19, 20}, {21, 22, 23, 24, 25, 26, 27, 28, 29, 30, 31, 32, 33, 34, 35, 36, 37, 38, 39, 40}};
    private static final double[][] CUSTOM_DURATION = new double[][]{{0.13, 0.25, 0.38, 0.5, 0.63, 0.75, 0.88, 1.0, 1.13, 1.25}, {1.38, 1.5, 1.63, 1.75, 1.88, 2.0, 2.13, 2.25, 2.38, 2.5}};
    private static final double[][] CUSTOM_COST = new double[][]{{0.01, 0.2, 0.03, 0.04, 0.05, 0.06, 0.07, 0.08, 0.09, 0.1}, {0.11, 0.12, 0.13, 0.14, 0.15, 0.16, 0.17, 0.18, 0.19, 0.2}};
    private static final boolean[][] CUSTOM_FLAG = new boolean[][]{{true, false, true, false, true, false, true, false, true, false, true, false, true, false, true, false, true, false, true, false}, {false, true, false, true, false, true, false, true, false, true, false, true, false, true, false, true, false, true, false, true}};

    public void testMpp9CustomFields() throws Exception {
        MPPReader reader = new MPPReader();
        ProjectFile mpp = reader.read(this.m_basedir + "/mpp9assignmentcustom.mpp");
        this.testCustomFields(mpp);
    }

    public void testMpp9CustomFieldsFrom12() throws Exception {
        MPPReader reader = new MPPReader();
        ProjectFile mpp = reader.read(this.m_basedir + "/mpp9assignmentcustom-from12.mpp");
        this.testCustomFields(mpp);
    }

    public void testMpp12CustomFields() throws Exception {
        MPPReader reader = new MPPReader();
        ProjectFile mpp = reader.read(this.m_basedir + "/mpp12assignmentcustom.mpp");
        this.testCustomFields(mpp);
    }

    public void testMpp14CustomFields() throws Exception {
        MPPReader reader = new MPPReader();
        ProjectFile mpp = reader.read(this.m_basedir + "/mpp14assignmentcustom.mpp");
        this.testCustomFields(mpp);
    }

    public void testMspdiCustomFields() throws Exception {
        MSPDIReader reader = new MSPDIReader();
        ProjectFile mpp = reader.read(this.m_basedir + "/mspdiassignmentcustom.xml");
        this.testCustomFields(mpp);
    }

    public void testMpdCustomFields() throws Exception {
        MPDDatabaseReader reader = new MPDDatabaseReader();
        ProjectFile mpp = reader.read(this.m_basedir + "/mpdassignmentcustom.mpd");
        this.testCustomFields(mpp);
    }

    private void testCustomFields(ProjectFile mpp) throws Exception {
        int loop;
        SimpleDateFormat df = new SimpleDateFormat("dd/MM/yy HH:mm");
        Task task = mpp.getTaskByID(1);
        MppAssignmentTest.assertEquals((String)"Task One", (String)task.getName());
        List<ResourceAssignment> assignments = task.getResourceAssignments();
        ResourceAssignment assignment1 = assignments.get(0);
        MppAssignmentTest.assertEquals((String)"Resource One", (String)assignment1.getResource().getName());
        ResourceAssignment assignment2 = assignments.get(1);
        MppAssignmentTest.assertEquals((String)"Resource Two", (String)assignment2.getResource().getName());
        for (loop = 0; loop < 10; ++loop) {
            MppAssignmentTest.assertEquals((String)("Assignment 1 baseline cost " + (loop + 1)), (int)BASELINE_COSTS[0][loop], (int)assignment1.getBaselineCost(loop + 1).intValue());
            MppAssignmentTest.assertEquals((String)("Assignment 2 baseline cost " + (loop + 1)), (int)BASELINE_COSTS[1][loop], (int)assignment2.getBaselineCost(loop + 1).intValue());
            MppAssignmentTest.assertEquals((String)("Assignment 1 baseline work " + (loop + 1)), (int)BASELINE_WORKS[0][loop], (int)((int)assignment1.getBaselineWork(loop + 1).getDuration()));
            MppAssignmentTest.assertEquals((String)("Assignment 2 baseline work " + (loop + 1)), (int)BASELINE_WORKS[1][loop], (int)((int)assignment2.getBaselineWork(loop + 1).getDuration()));
            MppAssignmentTest.assertEquals((String)("Assignment 1 baseline work " + (loop + 1)), (Object)TimeUnit.HOURS, (Object)assignment1.getBaselineWork(loop + 1).getUnits());
            MppAssignmentTest.assertEquals((String)("Assignment 2 baseline work " + (loop + 1)), (Object)TimeUnit.HOURS, (Object)assignment2.getBaselineWork(loop + 1).getUnits());
            MppAssignmentTest.assertEquals((String)("Assignment 1 baseline start " + (loop + 1)), (String)BASELINE_STARTS[0][loop], (String)df.format(assignment1.getBaselineStart(loop + 1)));
            MppAssignmentTest.assertEquals((String)("Assignment 2 baseline start " + (loop + 1)), (String)BASELINE_STARTS[1][loop], (String)df.format(assignment2.getBaselineStart(loop + 1)));
            MppAssignmentTest.assertEquals((String)("Assignment 1 baseline finish " + (loop + 1)), (String)BASELINE_FINISHES[0][loop], (String)df.format(assignment1.getBaselineFinish(loop + 1)));
            MppAssignmentTest.assertEquals((String)("Assignment 2 baseline finish " + (loop + 1)), (String)BASELINE_FINISHES[1][loop], (String)df.format(assignment2.getBaselineFinish(loop + 1)));
            MppAssignmentTest.assertEquals((String)("Assignment 1 start " + (loop + 1)), (String)CUSTOM_START[0][loop], (String)df.format(assignment1.getStart(loop + 1)));
            MppAssignmentTest.assertEquals((String)("Assignment 2 start " + (loop + 1)), (String)CUSTOM_START[1][loop], (String)df.format(assignment2.getStart(loop + 1)));
            MppAssignmentTest.assertEquals((String)("Assignment 1 finish " + (loop + 1)), (String)CUSTOM_FINISH[0][loop], (String)df.format(assignment1.getFinish(loop + 1)));
            MppAssignmentTest.assertEquals((String)("Assignment 2 finish " + (loop + 1)), (String)CUSTOM_FINISH[1][loop], (String)df.format(assignment2.getFinish(loop + 1)));
            MppAssignmentTest.assertEquals((String)("Assignment 1 date " + (loop + 1)), (String)CUSTOM_DATE[0][loop], (String)df.format(assignment1.getDate(loop + 1)));
            MppAssignmentTest.assertEquals((String)("Assignment 2 date " + (loop + 1)), (String)CUSTOM_DATE[1][loop], (String)df.format(assignment2.getDate(loop + 1)));
            MppAssignmentTest.assertEquals((String)("Assignment 1 duration " + (loop + 1)), (double)CUSTOM_DURATION[0][loop], (double)assignment1.getDuration(loop + 1).getDuration(), (double)0.01);
            MppAssignmentTest.assertEquals((String)("Assignment 2 duration " + (loop + 1)), (double)CUSTOM_DURATION[1][loop], (double)assignment2.getDuration(loop + 1).getDuration(), (double)0.01);
            MppAssignmentTest.assertEquals((String)("Assignment 1 duration " + (loop + 1)), (Object)TimeUnit.DAYS, (Object)assignment1.getDuration(loop + 1).getUnits());
            MppAssignmentTest.assertEquals((String)("Assignment 2 duration " + (loop + 1)), (Object)TimeUnit.DAYS, (Object)assignment2.getDuration(loop + 1).getUnits());
            MppAssignmentTest.assertEquals((String)("Assignment 1 cost " + (loop + 1)), (double)CUSTOM_COST[0][loop], (double)assignment1.getCost(loop + 1).doubleValue(), (double)0.01);
            MppAssignmentTest.assertEquals((String)("Assignment 2 cost " + (loop + 1)), (double)CUSTOM_COST[1][loop], (double)assignment2.getCost(loop + 1).doubleValue(), (double)0.01);
        }
        for (loop = 0; loop < CUSTOM_TEXT.length; ++loop) {
            MppAssignmentTest.assertEquals((String)("Assignment 1 text " + (loop + 1)), (String)CUSTOM_TEXT[0][loop], (String)assignment1.getText(loop + 1));
            MppAssignmentTest.assertEquals((String)("Assignment 2 text " + (loop + 1)), (String)CUSTOM_TEXT[1][loop], (String)assignment2.getText(loop + 1));
        }
        for (loop = 0; loop < CUSTOM_NUMBER.length; ++loop) {
            MppAssignmentTest.assertEquals((String)("Assignment 1 number " + (loop + 1)), (int)CUSTOM_NUMBER[0][loop], (int)assignment1.getNumber(loop + 1).intValue());
            MppAssignmentTest.assertEquals((String)("Assignment 2 number " + (loop + 1)), (int)CUSTOM_NUMBER[1][loop], (int)assignment2.getNumber(loop + 1).intValue());
        }
        for (loop = 0; loop < CUSTOM_FLAG.length; ++loop) {
            MppAssignmentTest.assertEquals((String)("Assignment 1 flag " + (loop + 1)), (boolean)CUSTOM_FLAG[0][loop], (boolean)assignment1.getFlag(loop + 1));
            MppAssignmentTest.assertEquals((String)("Assignment 2 flag " + (loop + 1)), (boolean)CUSTOM_FLAG[1][loop], (boolean)assignment2.getFlag(loop + 1));
        }
    }

    public void testMpp9Fields() throws Exception {
        MPPReader reader = new MPPReader();
        ProjectFile mpp = reader.read(this.m_basedir + "/mpp9assignmentfields.mpp");
        this.testFields(mpp, null, null);
    }

    public void testMpp9FieldsFrom14() throws Exception {
        MPPReader reader = new MPPReader();
        ProjectFile mpp = reader.read(this.m_basedir + "/mpp9assignmentfields-from14.mpp");
        this.testFields(mpp, null, null);
    }

    public void testMpp12Fields() throws Exception {
        MPPReader reader = new MPPReader();
        ProjectFile mpp = reader.read(this.m_basedir + "/mpp12assignmentfields.mpp");
        this.testFields(mpp, "230CA12B-3792-4F3B-B69E-89ABAF1C9042", "C3FDB823-3C82-422B-A854-391F7E235EA2");
    }

    public void testMpp12FieldsFrom14() throws Exception {
        MPPReader reader = new MPPReader();
        ProjectFile mpp = reader.read(this.m_basedir + "/mpp12assignmentfields-from14.mpp");
        this.testFields(mpp, "230CA12B-3792-4F3B-B69E-89ABAF1C9042", "C3FDB823-3C82-422B-A854-391F7E235EA2");
    }

    public void testMpp14Fields() throws Exception {
        MPPReader reader = new MPPReader();
        ProjectFile mpp = reader.read(this.m_basedir + "/mpp14assignmentfields.mpp");
        this.testFields(mpp, "81DC0978-D218-4D29-A139-EF691CDBF851", "0040EAF6-D0A2-41DF-9F67-A3CAEBCC8C5B");
    }

    public void testMspdiFields() throws Exception {
        MSPDIReader reader = new MSPDIReader();
        ProjectFile mpp = reader.read(this.m_basedir + "/mspdiassignmentfields.xml");
        this.testFields(mpp, null, null);
    }

    public void testMpdFields() throws Exception {
        MPDDatabaseReader reader = new MPDDatabaseReader();
        ProjectFile mpp = reader.read(this.m_basedir + "/mpdassignmentfields.mpd");
        this.testFields(mpp, null, null);
    }

    private void testFields(ProjectFile mpp, String guid1, String guid2) {
        ResourceAssignment assignment;
        List<ResourceAssignment> assignments;
        Task task;
        SimpleDateFormat df = new SimpleDateFormat("dd/MM/yy HH:mm");
        if (mpp.getMppFileType() > 9) {
            Duration work;
            Number cost;
            int loop;
            task = mpp.getTaskByID(0);
            assignments = task.getResourceAssignments();
            assignment = assignments.get(0);
            MppAssignmentTest.assertEquals((String)"Budget Work Resource", (String)assignment.getResource().getName());
            MppAssignmentTest.assertEquals((int)97, (int)((int)assignment.getBudgetWork().getDuration()));
            MppAssignmentTest.assertEquals((int)98, (int)((int)assignment.getBaselineBudgetWork().getDuration()));
            for (loop = 1; loop <= 10; ++loop) {
                cost = assignment.getBaselineBudgetCost(loop);
                MppAssignmentTest.assertEquals((int)0, (int)cost.intValue());
                work = assignment.getBaselineBudgetWork(loop);
                MppAssignmentTest.assertEquals((int)loop, (int)((int)work.getDuration()));
                MppAssignmentTest.assertEquals((Object)TimeUnit.HOURS, (Object)work.getUnits());
            }
            assignment = assignments.get(1);
            MppAssignmentTest.assertEquals((String)"Budget Cost Resource", (String)assignment.getResource().getName());
            MppAssignmentTest.assertEquals((int)96, (int)assignment.getBudgetCost().intValue());
            MppAssignmentTest.assertEquals((int)95, (int)assignment.getBaselineBudgetCost().intValue());
            for (loop = 1; loop <= 10; ++loop) {
                cost = assignment.getBaselineBudgetCost(loop);
                MppAssignmentTest.assertEquals((int)loop, (int)cost.intValue());
                work = assignment.getBaselineBudgetWork(loop);
                MppAssignmentTest.assertEquals((int)0, (int)((int)work.getDuration()));
            }
        }
        task = mpp.getTaskByID(1);
        assignments = task.getResourceAssignments();
        assignment = assignments.get(0);
        MppAssignmentTest.assertEquals((String)"Resource One", (String)assignment.getResource().getName());
        this.assertEquals(2.0, TimeUnit.HOURS, assignment.getActualWork());
        this.assertEquals(71.0, TimeUnit.HOURS, assignment.getRegularWork());
        this.assertEquals(1.1, TimeUnit.HOURS, assignment.getActualOvertimeWork());
        this.assertEquals(7.9, TimeUnit.HOURS, assignment.getRemainingOvertimeWork());
        MppAssignmentTest.assertEquals((int)540, (int)assignment.getOvertimeCost().intValue());
        if (mpp.getMppFileType() != 12) {
            MppAssignmentTest.assertEquals((double)3978.92, (double)assignment.getRemainingCost().doubleValue(), (double)0.005);
        }
        MppAssignmentTest.assertEquals((double)66.08, (double)assignment.getActualOvertimeCost().doubleValue(), (double)0.005);
        MppAssignmentTest.assertEquals((double)473.92, (double)assignment.getRemainingOvertimeCost().doubleValue(), (double)0.005);
        MppAssignmentTest.assertEquals((double)4090.0, (double)assignment.getCostVariance().doubleValue(), (double)0.001);
        MppAssignmentTest.assertEquals((double)3.0, (double)assignment.getPercentageWorkComplete().doubleValue(), (double)0.5);
        MppAssignmentTest.assertEquals((String)"Assignment Notes", (String)assignment.getNotes().trim());
        if (mpp.getMppFileType() != 0) {
            MppAssignmentTest.assertEquals((boolean)true, (boolean)assignment.getConfirmed());
            MppAssignmentTest.assertEquals((boolean)true, (boolean)assignment.getResponsePending());
            MppAssignmentTest.assertEquals((boolean)false, (boolean)assignment.getTeamStatusPending());
        }
        this.assertEquals(80.0, TimeUnit.HOURS, assignment.getWorkVariance());
        this.assertEquals(2.0, TimeUnit.DAYS, assignment.getStartVariance());
        this.assertEquals(-2.12, TimeUnit.DAYS, assignment.getFinishVariance());
        MppAssignmentTest.assertEquals((int)0, (int)assignment.getCostRateTableIndex());
        if (mpp.getMppFileType() > 9) {
            MppAssignmentTest.assertEquals((String)"06/07/11 12:09", (String)df.format(assignment.getCreateDate()));
        }
        if (guid1 != null) {
            MppAssignmentTest.assertEquals((String)guid1, (String)assignment.getGUID().toString().toUpperCase());
        }
        assignment = assignments.get(1);
        MppAssignmentTest.assertEquals((String)"Resource Two", (String)assignment.getResource().getName());
        this.assertEquals(5.0, TimeUnit.HOURS, assignment.getActualWork());
        this.assertEquals(3.0, TimeUnit.HOURS, assignment.getRegularWork());
        this.assertEquals(2.0, TimeUnit.HOURS, assignment.getActualOvertimeWork());
        this.assertEquals(18.0, TimeUnit.HOURS, assignment.getRemainingOvertimeWork());
        MppAssignmentTest.assertEquals((int)860, (int)assignment.getOvertimeCost().intValue());
        MppAssignmentTest.assertEquals((double)774.0, (double)assignment.getRemainingCost().doubleValue(), (double)0.005);
        MppAssignmentTest.assertEquals((double)86.0, (double)assignment.getActualOvertimeCost().doubleValue(), (double)0.005);
        MppAssignmentTest.assertEquals((double)774.0, (double)assignment.getRemainingOvertimeCost().doubleValue(), (double)0.005);
        MppAssignmentTest.assertEquals((double)962.0, (double)assignment.getCostVariance().doubleValue(), (double)0.001);
        MppAssignmentTest.assertEquals((double)22.0, (double)assignment.getPercentageWorkComplete().doubleValue(), (double)0.5);
        MppAssignmentTest.assertEquals((String)"", (String)assignment.getNotes());
        this.assertEquals(23.0, TimeUnit.HOURS, assignment.getWorkVariance());
        this.assertEquals(1.11, TimeUnit.DAYS, assignment.getStartVariance());
        this.assertEquals(-10.39, TimeUnit.DAYS, assignment.getFinishVariance());
        MppAssignmentTest.assertEquals((int)1, (int)assignment.getCostRateTableIndex());
        if (mpp.getMppFileType() != 0) {
            MppAssignmentTest.assertEquals((boolean)false, (boolean)assignment.getConfirmed());
            MppAssignmentTest.assertEquals((boolean)false, (boolean)assignment.getResponsePending());
            MppAssignmentTest.assertEquals((boolean)true, (boolean)assignment.getTeamStatusPending());
            MppAssignmentTest.assertEquals((String)"Test Hyperlink Screen Tip", (String)assignment.getHyperlinkScreenTip());
        }
        if (mpp.getMppFileType() > 9) {
            MppAssignmentTest.assertEquals((String)"06/07/11 15:31", (String)df.format(assignment.getCreateDate()));
        }
        if (guid2 != null) {
            MppAssignmentTest.assertEquals((String)guid2, (String)assignment.getGUID().toString().toUpperCase());
        }
        MppAssignmentTest.assertEquals((String)"Test Hyperlink Display Text", (String)assignment.getHyperlink());
        MppAssignmentTest.assertEquals((String)"http://news.bbc.co.uk", (String)assignment.getHyperlinkAddress());
        MppAssignmentTest.assertEquals((String)"x", (String)assignment.getHyperlinkSubAddress());
    }
}

