/*
 * Decompiled with CFR 0.152.
 */
package net.sf.mpxj;

import net.sf.mpxj.utility.EnumUtility;
import net.sf.mpxj.utility.MpxjEnum;
import net.sf.mpxj.utility.NumberUtility;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public enum TaskType implements MpxjEnum
{
    FIXED_UNITS(0),
    FIXED_DURATION(1),
    FIXED_WORK(2);

    private static final TaskType[] TYPE_VALUES;
    private int m_value;

    private TaskType(int type) {
        this.m_value = type;
    }

    public static TaskType getInstance(int type) {
        if (type < 0 || type >= TYPE_VALUES.length) {
            type = FIXED_WORK.getValue();
        }
        return TYPE_VALUES[type];
    }

    public static TaskType getInstance(Number type) {
        int value = type == null ? -1 : NumberUtility.getInt(type);
        return TaskType.getInstance(value);
    }

    @Override
    public int getValue() {
        return this.m_value;
    }

    static {
        TYPE_VALUES = (TaskType[])EnumUtility.createTypeArray(TaskType.class);
    }
}

