/*
 * Decompiled with CFR 0.152.
 */
package net.sourceforge.mailprobe.smtp;

import java.io.InputStream;
import java.util.Date;
import java.util.Properties;
import java.util.logging.Level;
import java.util.logging.Logger;
import javax.mail.Address;
import javax.mail.Message;
import javax.mail.Session;
import javax.mail.Transport;
import javax.mail.internet.InternetAddress;
import javax.mail.internet.MimeMessage;
import net.sourceforge.mailprobe.util.ExecStats;
import net.sourceforge.mailprobe.util.Protocol;

public class SMTPSender {
    private Protocol protocol;
    private String hostname;
    private String ehloLocalhost;
    private int port;
    private String username;
    private String password;
    private boolean useStarttls;
    private static final Logger logger = Logger.getLogger(SMTPSender.class.getName());

    private SMTPSender() {
    }

    public SMTPSender(Protocol protocol, String hostname, String ehloLocalhost, String port, String username, String password, boolean useStarttls) {
        this.protocol = protocol;
        this.hostname = hostname;
        this.ehloLocalhost = ehloLocalhost;
        this.port = port != null ? Integer.parseInt(port) : -1;
        this.username = username;
        this.password = password;
        this.useStarttls = useStarttls;
    }

    public ExecStats sendMessage(InputStream mimeMessageStream, String uuid) throws Exception {
        Properties props = new Properties(System.getProperties());
        props.put("mail.transport.protocol", this.protocol.toString());
        props.setProperty("mail." + this.protocol.toString() + ".host", this.hostname);
        if (this.port > 0) {
            props.setProperty("mail." + this.protocol.toString() + ".port", Integer.toString(this.port));
        }
        props.setProperty("mail." + this.protocol.toString() + ".connectiontimeout", "30000");
        props.setProperty("mail." + this.protocol.toString() + ".timeout", "30000");
        if (this.ehloLocalhost != null) {
            props.setProperty("mail." + this.protocol.toString() + ".localhost", this.ehloLocalhost);
        }
        if (this.username != null && this.password != null) {
            props.setProperty("mail." + this.protocol.toString() + ".auth", "true");
        }
        props.setProperty("mail." + this.protocol.toString() + ".starttls.enable", this.useStarttls ? "true" : "false");
        props.setProperty("mail." + this.protocol.toString() + ".ssl.trust", "*");
        ExecStats result = new ExecStats(new Date());
        Session session = Session.getInstance((Properties)props, null);
        MimeMessage msg = new MimeMessage(session, mimeMessageStream);
        msg.setSentDate(new Date());
        msg.addHeader("X-MailProbe-UUID", uuid);
        msg.saveChanges();
        Transport tr = session.getTransport(this.protocol.toString());
        if (this.username != null && this.password != null) {
            tr.connect(this.username, this.password);
        } else {
            tr.connect();
        }
        tr.sendMessage((Message)msg, msg.getAllRecipients());
        result.setSuccess(true);
        result.setEndDate(new Date());
        return result;
    }

    public ExecStats sendStandardMessage(String toAddress, String fromAddress, String uuid, String content) {
        Properties props = new Properties(System.getProperties());
        props.put("mail.transport.protocol", this.protocol.toString());
        props.setProperty("mail." + this.protocol.toString() + ".host", this.hostname);
        if (this.port > 0) {
            props.setProperty("mail." + this.protocol.toString() + ".port", Integer.toString(this.port));
        }
        props.setProperty("mail." + this.protocol.toString() + ".connectiontimeout", "30000");
        props.setProperty("mail." + this.protocol.toString() + ".timeout", "30000");
        if (this.ehloLocalhost != null) {
            props.setProperty("mail." + this.protocol.toString() + ".localhost", this.ehloLocalhost);
        }
        if (this.username != null && this.password != null) {
            props.setProperty("mail." + this.protocol.toString() + ".auth", "true");
        }
        props.setProperty("mail." + this.protocol.toString() + ".starttls.enable", this.useStarttls ? "true" : "false");
        props.setProperty("mail." + this.protocol.toString() + ".ssl.trust", "*");
        ExecStats result = new ExecStats(new Date());
        try {
            Session session = Session.getInstance((Properties)props, null);
            MimeMessage msg = new MimeMessage(session);
            msg.setFrom((Address)new InternetAddress(fromAddress));
            msg.setRecipient(Message.RecipientType.TO, (Address)new InternetAddress(toAddress));
            msg.setSubject("[MAILPROBE] Standard Probe");
            msg.setSentDate(new Date());
            msg.addHeader("X-MailProbe-UUID", uuid);
            msg.addHeader("X-Mailprobe-Type", "Standard-SMTP");
            msg.setText(content);
            msg.saveChanges();
            Transport tr = session.getTransport(this.protocol.toString());
            if (this.username != null && this.password != null) {
                tr.connect(this.username, this.password);
            } else {
                tr.connect();
            }
            tr.sendMessage((Message)msg, msg.getAllRecipients());
            result.setSuccess(true);
        }
        catch (Exception exception) {
            logger.log(Level.WARNING, "", exception);
        }
        result.setEndDate(new Date());
        return result;
    }
}

