/*
 * Decompiled with CFR 0.152.
 */
package net.sourceforge.mailprobe.check;

import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.OutputStream;
import java.util.Date;
import java.util.UUID;
import java.util.logging.Level;
import java.util.logging.Logger;
import javax.mail.Flags;
import javax.mail.Message;
import javax.mail.MessagingException;
import javax.mail.internet.MimeMessage;
import net.sourceforge.mailprobe.check.StoreChecker;
import net.sourceforge.mailprobe.smtp.SMTPSender;
import net.sourceforge.mailprobe.store.Mailstore;
import net.sourceforge.mailprobe.util.ExecStats;
import net.sourceforge.mailprobe.util.Protocol;

public class SendReceiveCheck {
    private static final Logger logger = Logger.getLogger(SendReceiveCheck.class.getName());

    public ExecStats check(Protocol smtpProtocol, String smtpHostname, String smtpEhloLocalhost, String smtpPort, String smtpUsername, String smtpPassword, boolean smtpUseStarttls, Protocol mailstoreProtocol, String mailstoreHostname, String mailstorePort, String mailstoreUsername, String mailstorePassword, boolean mailstoreUseStarttls, MimeMessage mimeMessage, long timeout) {
        SMTPSender smtpSender = new SMTPSender(smtpProtocol, smtpHostname, smtpEhloLocalhost, smtpPort, smtpUsername, smtpPassword, smtpUseStarttls);
        String uuid = UUID.randomUUID().toString();
        ByteArrayOutputStream baos = null;
        try {
            int size = mimeMessage.getSize();
            baos = size > 0 ? new ByteArrayOutputStream(size) : new ByteArrayOutputStream();
            mimeMessage.writeTo((OutputStream)baos);
            baos.close();
        }
        catch (Exception exception) {
            ExecStats result = new ExecStats(new Date());
            result.setSuccess(false);
            result.setEndDate(new Date());
            logger.log(Level.WARNING, "While copying mimeMessage", exception);
            return result;
        }
        ExecStats result = new ExecStats(new Date());
        try {
            result = smtpSender.sendMessage(new ByteArrayInputStream(baos.toByteArray()), uuid);
            Date timeoutDate = new Date(result.getStartDate().getTime() + timeout);
            Mailstore mailstore = new Mailstore(mailstoreProtocol, mailstoreHostname, mailstorePort, mailstoreUsername, mailstorePassword, mailstoreUseStarttls);
            boolean foundMail = false;
            StoreChecker storeChecker = StoreChecker.getInstance();
            while (!foundMail) {
                if (timeoutDate.getTime() < new Date().getTime()) {
                    throw new InterruptedException("Inner timeout in standardCheck occured");
                }
                Thread.sleep(5000L);
                logger.log(Level.FINE, "Before storeChecker on UUID: {0}", uuid);
                foundMail = storeChecker.searchUUID(mailstore, uuid);
                logger.log(Level.FINE, "After storeChecker on UUID: {0}", uuid);
            }
        }
        catch (InterruptedException interruptedException) {
            result.setSuccess(false);
            result.setInnerTimeoutOccured(true);
            logger.log(Level.WARNING, interruptedException.getMessage());
        }
        catch (Exception ex) {
            result.setSuccess(false);
            logger.log(Level.WARNING, ex.getMessage());
        }
        result.setEndDate(new Date());
        return result;
    }

    public ExecStats standardCheck(Protocol smtpProtocol, String smtpHostname, String smtpEhloLocalhost, String smtpPort, String smtpUsername, String smtpPassword, boolean smtpUseStarttls, Protocol mailstoreProtocol, String mailstoreHostname, String mailstorePort, String mailstoreUsername, String mailstorePassword, boolean mailstoreUseStarttls, String mailText, String toAddress, String fromAddress, long timeout) {
        SMTPSender smtpSender = new SMTPSender(smtpProtocol, smtpHostname, smtpEhloLocalhost, smtpPort, smtpUsername, smtpPassword, smtpUseStarttls);
        String uuid = UUID.randomUUID().toString();
        ExecStats result = smtpSender.sendStandardMessage(toAddress, fromAddress, uuid, mailText);
        Date timeoutDate = new Date(result.getStartDate().getTime() + timeout);
        Mailstore mailstore = new Mailstore(mailstoreProtocol, mailstoreHostname, mailstorePort, mailstoreUsername, mailstorePassword, mailstoreUseStarttls);
        try {
            boolean foundMail = false;
            Message msg = null;
            while (!foundMail) {
                if (timeoutDate.getTime() < new Date().getTime()) {
                    throw new InterruptedException("Inner timeout in standardCheck occured");
                }
                Thread.sleep(5000L);
                boolean connectSuccesful = mailstore.connect();
                if (!connectSuccesful) {
                    throw new MessagingException("Connect to INBOX wasn't successful.");
                }
                msg = mailstore.searchForSubjectAndUUID("[MAILPROBE]", uuid);
                if (msg != null) {
                    foundMail = true;
                    msg.setFlag(Flags.Flag.DELETED, true);
                    mailstore.disconnect(true);
                    continue;
                }
                mailstore.disconnect(false);
            }
        }
        catch (InterruptedException interruptedException) {
            result.setSuccess(false);
            result.setInnerTimeoutOccured(true);
            logger.log(Level.WARNING, "", interruptedException);
        }
        catch (MessagingException messagingException) {
            result.setSuccess(false);
            logger.log(Level.WARNING, "", messagingException);
        }
        result.setEndDate(new Date());
        return result;
    }
}

