/*
 * Decompiled with CFR 0.152.
 */
package net.sourceforge.jwebunit.htmlunit;

import com.gargoylesoftware.htmlunit.html.DomElement;
import com.gargoylesoftware.htmlunit.html.DomNode;
import com.gargoylesoftware.htmlunit.html.HtmlElement;
import com.gargoylesoftware.htmlunit.html.HtmlInput;
import com.gargoylesoftware.htmlunit.html.HtmlOption;
import com.gargoylesoftware.htmlunit.html.HtmlTextArea;
import java.util.ArrayList;
import java.util.List;
import net.sourceforge.jwebunit.api.IElement;

public class HtmlUnitElementImpl
implements IElement {
    private DomElement element;

    public HtmlUnitElementImpl(DomElement element) {
        if (element == null) {
            throw new NullPointerException("Cannot create an IElement for a null element.");
        }
        this.element = element;
    }

    public String getAttribute(String name) {
        if ("value".equals(name) && this.element instanceof HtmlOption) {
            return ((HtmlOption)this.element).getValueAttribute();
        }
        if (!this.element.hasAttribute(name)) {
            return null;
        }
        return this.element.getAttribute(name);
    }

    public String getName() {
        return this.element.getNodeName();
    }

    public List<IElement> getChildren() {
        ArrayList<IElement> children = new ArrayList<IElement>();
        for (DomElement e : this.element.getChildElements()) {
            if (e == null) continue;
            children.add(new HtmlUnitElementImpl(e));
        }
        return children;
    }

    public IElement getParent() {
        DomNode p = this.element.getParentNode();
        while (p != null) {
            if (p instanceof HtmlElement) {
                return new HtmlUnitElementImpl((DomElement)((HtmlElement)p));
            }
            p = p.getParentNode();
        }
        return null;
    }

    public String getTextContent() {
        return this.element.getTextContent();
    }

    public IElement getElement(String xpath) {
        return new HtmlUnitElementImpl((DomElement)((HtmlElement)this.element.getFirstByXPath(xpath)));
    }

    public List<IElement> getElements(String xpath) {
        ArrayList<IElement> elements = new ArrayList<IElement>();
        for (Object o : this.element.getByXPath(xpath)) {
            if (!(o instanceof HtmlElement)) continue;
            elements.add(new HtmlUnitElementImpl((DomElement)((HtmlElement)o)));
        }
        return elements;
    }

    public String toString() {
        return "IElement[name=" + this.getName() + " wrapped=" + this.element + "]";
    }

    public void setAttribute(String string) {
        this.element.setAttributeNS(null, string, "1");
    }

    public void setAttribute(String name, String value) {
        if ("value".equals(name) && this.element instanceof HtmlInput) {
            ((HtmlInput)this.element).setValueAttribute(value);
        } else {
            this.element.setAttribute(name, value);
        }
    }

    public void setTextContent(String value) {
        if (this.element instanceof HtmlTextArea) {
            ((HtmlTextArea)this.element).setText(value);
        } else {
            this.element.setTextContent(value);
        }
    }

    public int hashCode() {
        int prime = 31;
        int result = 1;
        result = 31 * result + (this.element == null ? 0 : this.element.hashCode());
        return result;
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (this.getClass() != obj.getClass()) {
            return false;
        }
        HtmlUnitElementImpl other = (HtmlUnitElementImpl)obj;
        return !(this.element == null ? other.element != null : !this.element.equals(other.element));
    }

    public DomElement getHtmlElement() {
        return this.element;
    }
}

