/*
 * Decompiled with CFR 0.152.
 */
package net.sourceforge.javaflacencoder;

import net.sourceforge.javaflacencoder.CRC16;

public class EncodedElement {
    static int DEBUG_LEV = 0;
    EncodedElement previous = null;
    EncodedElement next = null;
    byte[] data = null;
    int usableBits = 0;
    protected int offset;

    public EncodedElement() {
        this.offset = 0;
        this.usableBits = 0;
        this.data = new byte[100];
    }

    public EncodedElement(byte[] array, int off) {
        assert (array.length % 4 == 0);
        this.offset = off;
        this.usableBits = off;
        this.data = array;
    }

    public EncodedElement(byte[] array, int off, int usedBits) {
        assert (array.length % 4 == 0);
        this.offset = off;
        this.usableBits = usedBits;
        this.data = array;
    }

    public EncodedElement(int size, int off) {
        if (size % 4 != 4) {
            size = (size / 4 + 1) * 4;
        }
        this.data = new byte[size];
        this.usableBits = off;
        this.offset = off;
    }

    public void clear(int size, int off) {
        if (size % 4 != 4) {
            size = (size / 4 + 1) * 4;
        }
        this.next = null;
        this.previous = null;
        this.data = new byte[size];
        this.offset = off;
        for (int i = 0; i < this.data.length; ++i) {
            this.data[i] = 0;
        }
        this.usableBits = off;
    }

    public void clear(int size, int off, boolean keep) {
        if (size % 4 != 4) {
            size = (size / 4 + 1) * 4;
        }
        this.next = null;
        this.previous = null;
        if (!keep) {
            this.data = new byte[size];
        }
        this.offset = off;
        for (int i = 0; i < this.data.length; ++i) {
            this.data[i] = 0;
        }
        this.usableBits = off;
    }

    void setPrevious(EncodedElement ele) {
        this.previous = ele;
    }

    void setNext(EncodedElement ele) {
        this.next = ele;
    }

    EncodedElement getPrevious() {
        return this.previous;
    }

    EncodedElement getNext() {
        return this.next;
    }

    void setData(byte[] data) {
        assert (data.length % 4 == 0);
        this.data = data;
    }

    void setUsableBits(int bits) {
        this.usableBits = bits;
    }

    byte[] getData() {
        return this.data;
    }

    int getUsableBits() {
        return this.usableBits;
    }

    protected static EncodedElement getEnd_S(EncodedElement e) {
        if (e == null) {
            return null;
        }
        EncodedElement temp = e.next;
        EncodedElement end = e;
        while (temp != null) {
            end = temp;
            temp = temp.next;
        }
        return end;
    }

    public EncodedElement getEnd() {
        EncodedElement temp = this.next;
        EncodedElement end = this;
        while (temp != null) {
            end = temp;
            temp = temp.next;
        }
        return end;
    }

    public boolean attachEnd(EncodedElement e) {
        if (DEBUG_LEV > 0) {
            System.err.println("EncodedElement::attachEnd : Begin");
        }
        boolean attached = true;
        EncodedElement current = this;
        while (current.getNext() != null) {
            current = current.getNext();
        }
        current.setNext(e);
        e.setPrevious(current);
        if (DEBUG_LEV > 0) {
            System.err.println("EncodedElement::attachEnd : End");
        }
        return attached;
    }

    public EncodedElement addLong(long input, int bitCount) {
        if (this.next != null) {
            EncodedElement end = EncodedElement.getEnd_S(this.next);
            return end.addLong(input, bitCount);
        }
        if (this.data.length * 8 <= this.usableBits + bitCount) {
            int tOff = this.usableBits % 8;
            int size = this.data.length / 2 + 1;
            if (size < bitCount) {
                size = bitCount * 10;
            }
            this.next = new EncodedElement(size, tOff);
            return this.next.addLong(input, bitCount);
        }
        int startPos = this.usableBits;
        byte[] dest = this.data;
        EncodedElement.addLong(input, bitCount, startPos, dest);
        this.usableBits += bitCount;
        return this;
    }

    public EncodedElement addInt(int input, int bitCount) {
        if (this.next != null) {
            EncodedElement end = EncodedElement.getEnd_S(this.next);
            return end.addInt(input, bitCount);
        }
        if (this.data.length * 8 < this.usableBits + bitCount) {
            int tOff = this.usableBits % 8;
            int size = 1000;
            this.next = new EncodedElement(size, tOff);
            System.err.println("creating next node of size:bitCount " + size + ":" + bitCount + ":" + this.usableBits + ":" + this.data.length);
            System.err.println("value: " + input);
            return this.next.addInt(input, bitCount);
        }
        int startPos = this.usableBits;
        byte[] dest = this.data;
        EncodedElement.addInt_new(input, bitCount, startPos, dest);
        this.usableBits += bitCount;
        return this;
    }

    public EncodedElement packInt(int[] inputArray, int bitSize, int start, int skip, int countA) {
        if (this.next != null) {
            EncodedElement end = EncodedElement.getEnd_S(this.next);
            return end.packInt(inputArray, bitSize, start, skip, countA);
        }
        int writeCount = (this.data.length * 8 - this.usableBits) / bitSize;
        if (writeCount > countA) {
            writeCount = countA;
        }
        EncodedElement.packInt(inputArray, bitSize, this.usableBits, start, skip, countA, this.data);
        this.usableBits += writeCount * bitSize;
        if ((countA -= writeCount) > 0) {
            int tOff = this.usableBits % 8;
            int size = this.data.length / 2 + 1;
            if (size < bitSize * countA) {
                size = bitSize * countA + 10;
            }
            this.next = new EncodedElement(size, tOff);
            return this.next.packInt(inputArray, bitSize, start + writeCount * (skip + 1), skip, countA);
        }
        return this;
    }

    public EncodedElement packIntByBits(int[] inputA, int[] inputBits, int inputOffset, int countA) {
        if (this.next != null) {
            EncodedElement end = EncodedElement.getEnd_S(this.next);
            return end.packIntByBits(inputA, inputBits, inputOffset, countA);
        }
        int writeBitsRemaining = this.data.length * 8 - this.usableBits;
        int willWrite = 0;
        int writeCount = 0;
        for (int i = 0; i < countA && (writeBitsRemaining -= inputBits[inputOffset + i]) >= 0; ++i) {
            ++writeCount;
            willWrite += inputBits[inputOffset + i];
        }
        if (writeCount > 0) {
            EncodedElement.packIntByBits(inputA, inputBits, inputOffset, writeCount, this.usableBits, this.data);
            this.usableBits += willWrite;
        }
        if ((countA -= writeCount) > 0) {
            inputOffset += writeCount;
            int tOff = this.usableBits % 8;
            int size = this.data.length / 2 + 1;
            int remainingToWrite = 0;
            for (int i = 0; i < countA; ++i) {
                remainingToWrite += inputBits[inputOffset + i];
            }
            if (size < (remainingToWrite = remainingToWrite / 8 + 1)) {
                size = remainingToWrite + 10;
            }
            this.next = new EncodedElement(size, tOff);
            return this.next.packIntByBits(inputA, inputBits, inputOffset, countA);
        }
        return this;
    }

    public int getTotalBits() {
        int total = 0;
        EncodedElement iter = this;
        while (iter != null) {
            total += iter.usableBits - iter.offset;
            iter = iter.next;
        }
        return total;
    }

    protected static void addInt_new(int value, int count, int startPos, byte[] dest) {
        if (count <= 0) {
            return;
        }
        int secondInt = 0;
        int secondCount = 0;
        boolean doWrite = true;
        while (doWrite) {
            int workingInt;
            int shiftCount;
            boolean onIndex;
            secondCount = startPos % 8 + count - 32;
            int mask = 32 - count >= 32 ? 0 : -1 >>> 32 - count;
            value &= mask;
            boolean bl = onIndex = startPos % 8 == 0;
            if (secondCount > 0) {
                secondInt = value = secondCount >= 32 ? 0 : value >>> secondCount;
                count -= secondCount;
            }
            int index = startPos / 8;
            int workingIntCache = 0;
            int bytesToUse = dest.length - startPos / 8;
            if (bytesToUse > 4) {
                bytesToUse = 4;
            }
            switch (bytesToUse) {
                case 4: {
                    workingIntCache = dest[index++] << 24 | dest[index++] << 16 | dest[index++] << 8 | dest[index];
                    break;
                }
                case 3: {
                    workingIntCache = dest[index++] << 24 | dest[index++] << 16 | dest[index++] << 8;
                    break;
                }
                case 2: {
                    workingIntCache = dest[index++] << 24 | dest[index++] << 16;
                    break;
                }
                case 1: {
                    workingIntCache = dest[index++] << 24;
                }
            }
            if (!onIndex) {
                shiftCount = 32 - (startPos % 8 + count);
                value = shiftCount >= 32 ? 0 : value << shiftCount;
                workingInt = workingIntCache;
                mask = 32 - startPos % 8 >= 32 ? 0 : -1 << 32 - startPos % 8;
                workingInt &= mask;
                shiftCount = 32 - count - startPos % 8;
                value = shiftCount >= 32 ? 0 : (workingInt |= value) >>> shiftCount;
            }
            value = (shiftCount = 32 - count - startPos % 8) >= 32 ? 0 : value << shiftCount;
            workingInt = workingIntCache;
            mask = count + startPos % 8 >= 32 ? 0 : -1 >>> count + startPos % 8;
            workingInt &= mask;
            workingInt |= value;
            index = startPos / 8;
            int tempIndex = index + bytesToUse - 1;
            index += bytesToUse;
            switch (bytesToUse) {
                case 4: {
                    dest[tempIndex--] = (byte)workingInt;
                }
                case 3: {
                    dest[tempIndex--] = (byte)(workingInt >>> 8);
                }
                case 2: {
                    dest[tempIndex--] = (byte)(workingInt >>> 16);
                }
                case 1: {
                    dest[tempIndex--] = (byte)(workingInt >>> 24);
                }
            }
            if (secondCount > 0) {
                startPos += count;
                count = secondCount;
                value = secondInt;
                continue;
            }
            doWrite = false;
        }
    }

    private static void addLong(long input, int count, int startPos, byte[] dest) {
        if (DEBUG_LEV > 30) {
            System.err.println("EncodedElement::addLong : Begin");
        }
        int currentByte = startPos / 8;
        int currentOffset = startPos % 8;
        while (count > 0) {
            int bitRoom = 8 - currentOffset;
            int downShift = count - bitRoom;
            long upMask = 255 >>> currentOffset;
            int upShift = 0;
            if (downShift < 0) {
                upShift = bitRoom - count;
                upMask = 255 >>> currentOffset + upShift;
                downShift = 0;
            }
            if (DEBUG_LEV > 30) {
                System.err.println("count:offset:bitRoom:downShift:upShift:" + count + ":" + currentOffset + ":" + bitRoom + ":" + downShift + ":" + upShift);
            }
            long currentBits = input >>> downShift & upMask;
            upMask = (byte)upMask << upShift;
            dest[currentByte] = (byte)((long)dest[currentByte] & (upMask ^ 0xFFFFFFFFFFFFFFFFL));
            dest[currentByte] = (byte)((long)dest[currentByte] | (currentBits <<= upShift));
            count -= bitRoom;
            currentOffset = 0;
            ++currentByte;
        }
        if (DEBUG_LEV > 30) {
            System.err.println("EncodedElement::addLong : End");
        }
    }

    private static void packInt(int[] inputArray, int bitSize, int startPosIn, int start, int skip, int countA, byte[] dest) {
        if (DEBUG_LEV > 30) {
            System.err.println("EncodedElement::packInt : Begin");
        }
        for (int valI = 0; valI < countA; ++valI) {
            int input = inputArray[valI * (skip + 1) + start];
            int count = bitSize;
            int startPos = startPosIn + valI * bitSize;
            int currentByte = startPos / 8;
            int currentOffset = startPos % 8;
            while (count > 0) {
                int bitRoom = 8 - currentOffset;
                int downShift = count - bitRoom;
                int upMask = currentOffset >= 32 ? 0 : 255 >>> currentOffset;
                int upShift = 0;
                if (downShift < 0) {
                    upShift = bitRoom - count;
                    upMask = currentOffset + upShift >= 32 ? 0 : 255 >>> currentOffset + upShift;
                    downShift = 0;
                }
                if (DEBUG_LEV > 30) {
                    System.err.println("count:offset:bitRoom:downShift:upShift:" + count + ":" + currentOffset + ":" + bitRoom + ":" + downShift + ":" + upShift);
                }
                int currentBits = downShift >= 32 ? 0 : input >>> downShift & upMask;
                currentBits = upShift >= 32 ? 0 : currentBits << upShift;
                upMask = upShift >= 32 ? 0 : (byte)upMask << upShift;
                dest[currentByte] = (byte)(dest[currentByte] & ~upMask);
                dest[currentByte] = (byte)(dest[currentByte] | currentBits);
                count -= bitRoom;
                currentOffset = 0;
                ++currentByte;
            }
        }
        if (DEBUG_LEV > 30) {
            System.err.println("EncodedElement::packInt: End");
        }
    }

    public boolean padToByte() {
        boolean padded = false;
        EncodedElement end = EncodedElement.getEnd_S(this);
        int tempVal = end.usableBits;
        if (tempVal % 8 != 0) {
            int toWrite = 8 - tempVal % 8;
            end.addInt(0, toWrite);
            assert ((this.getTotalBits() + this.offset) % 8 == 0);
            padded = true;
        }
        return padded;
    }

    public short getCRC16() {
        assert (this.getTotalBits() % 8 == 0);
        assert (this.offset == 0);
        CRC16 crc = new CRC16();
        byte[] input = this.data;
        int stop = this.usableBits / 8;
        crc.update(input, 0, stop);
        EncodedElement nextEl = this.getNext();
        if (nextEl != null) {
            byte partial;
            byte by = partial = this.usableBits % 8 == 0 ? (byte)0 : input[stop];
            if (this.usableBits % 8 != 0) {
                System.err.println("UsableBits%8 == " + this.usableBits % 8);
            }
            nextEl.getCRC16(partial, this.usableBits % 8, crc);
        }
        return crc.checksum();
    }

    private void getCRC16(byte leadByte, int bitCount, CRC16 crc) {
        assert (bitCount == this.offset % 8);
        int start = this.offset / 8;
        int stop = this.usableBits / 8;
        byte[] input = this.data;
        if (bitCount > 0) {
            int inputByteMask = 255 >>> bitCount & 0xFF;
            int leadByteMask = 255 << 8 - bitCount;
            byte fullByte = (byte)(input[start] & inputByteMask);
            leadByte = (byte)(leadByte & leadByteMask);
            fullByte = (byte)(fullByte | leadByte);
            ++start;
            crc.update(fullByte);
        }
        crc.update(input, start, stop);
        EncodedElement nextEl = this.getNext();
        if (nextEl != null) {
            byte partial = this.usableBits % 8 == 0 ? (byte)0 : this.data[stop];
            nextEl.getCRC16(partial, this.usableBits % 8, crc);
        }
    }

    protected void print() {
        System.err.println("EncodedElement 0: ");
        System.err.println("\toffset: " + this.offset);
        System.err.println("\tusableBits: " + this.usableBits);
        System.err.println("\tdataLength: " + this.data.length);
        System.err.println("\tlastIndex: " + this.usableBits / 8);
        System.err.println("\tleftoverBits: " + this.usableBits % 8);
        if (this.next != null) {
            this.next.print(1);
        }
    }

    protected void print(int childCount) {
        System.err.println("EncodedElement " + childCount++ + ": ");
        System.err.println("\toffset: " + this.offset);
        System.err.println("\tusableBits: " + this.usableBits);
        System.err.println("\tdataLength: " + this.data.length);
        System.err.println("\tlastIndex: " + this.usableBits / 8);
        System.err.println("\tleftoverBits: " + this.usableBits % 8);
        if (this.next != null) {
            this.next.print(childCount);
        }
    }

    protected static int packIntByBitsToByteBoundary(int[] input, int[] inputBits, int inputIndex, int inputCount, int destPos, byte[] dest) {
        int bitsNeeded = destPos % 8;
        if (bitsNeeded != 0) {
            bitsNeeded = 8 - bitsNeeded;
        }
        while (bitsNeeded > 0 && inputCount > 0) {
            int inputVal = input[inputIndex];
            int inBits = inputBits[inputIndex];
            if (inBits > bitsNeeded) {
                inputVal = inBits - bitsNeeded >= 32 ? 0 : inputVal >>> inBits - bitsNeeded;
                EncodedElement.addInt_new(inputVal, bitsNeeded, destPos, dest);
                destPos += bitsNeeded;
                inputBits[inputIndex] = inBits - bitsNeeded;
                bitsNeeded = 0;
                continue;
            }
            if (inBits > 0) {
                EncodedElement.addInt_new(inputVal, inBits, destPos, dest);
                destPos += inBits;
                inputBits[inputIndex] = 0;
                bitsNeeded -= inBits;
            }
            ++inputIndex;
            --inputCount;
        }
        if (inputCount == 0) {
            inputIndex = -1;
        }
        return inputIndex;
    }

    protected static void packIntByBits(int[] inputA, int[] inputBits, int inputIndex, int inputCount, int destPos, byte[] dest) {
        int origInputIndex = inputIndex;
        inputIndex = EncodedElement.packIntByBitsToByteBoundary(inputA, inputBits, inputIndex, inputCount, destPos, dest);
        if (destPos % 8 > 0) {
            destPos = (destPos / 8 + 1) * 8;
        }
        if (inputIndex < 0) {
            return;
        }
        inputCount -= inputIndex - origInputIndex;
        inputCount = EncodedElement.compressIntArrayByBits(inputA, inputBits, inputCount, inputIndex);
        assert (destPos % 8 == 0);
        if (inputCount > 1) {
            int stopIndex = inputCount - 1;
            EncodedElement.mergeFullOnByte(inputA, stopIndex, dest, destPos / 8);
            destPos += stopIndex * 32;
        }
        if (inputCount > 0) {
            int index = inputCount - 1;
            EncodedElement.addInt_new(inputA[index], inputBits[index], destPos, dest);
            destPos += inputBits[index];
        }
    }

    protected static int cleanInts(int[] input, int[] inputBits, int inputIndex, int count) {
        int outIndex = 0;
        for (int i = inputIndex; i < inputIndex + count; ++i) {
            if (inputBits[i] <= 0) continue;
            int mask = -1 >>> 32 - inputBits[i];
            inputBits[outIndex] = inputBits[i];
            input[outIndex++] = input[i] & mask;
        }
        return outIndex;
    }

    protected static int compressIntArrayByBits(int[] input, int[] inputBits, int inCount, int inputIndex) {
        inCount = EncodedElement.cleanInts(input, inputBits, inputIndex, inCount);
        int outIndex = 0;
        int workingVal = 0;
        int workingBits = 0;
        for (int i = 0; i < inCount; ++i) {
            int bits = inputBits[i];
            if (bits + workingBits <= 32) {
                workingVal |= input[i] << 32 - (workingBits += bits);
                if (workingBits != 32) continue;
                inputBits[outIndex] = workingBits;
                input[outIndex++] = workingVal;
                workingBits = 0;
                workingVal = 0;
                continue;
            }
            inputBits[outIndex] = workingBits;
            input[outIndex++] = workingVal |= input[i] >>> (workingBits += bits) - 32;
            workingVal = input[i] << 32 - (workingBits -= 32);
        }
        if (workingBits > 0) {
            inputBits[outIndex] = workingBits;
            input[outIndex++] = workingVal >>> 32 - workingBits;
        } else if (workingBits == 0 && outIndex == 0) {
            outIndex = -1;
        }
        return outIndex;
    }

    protected static void mergeFullOnByte(int[] input, int inCount, byte[] dest, int destIndex) {
        int INPUT_WIDTH = 32;
        int DEST_WIDTH = 8;
        assert (inCount * (INPUT_WIDTH / DEST_WIDTH) <= dest.length - destIndex);
        for (int i = 0; i < inCount; ++i) {
            int inVal = input[i];
            dest[destIndex++] = (byte)(inVal >>> 24);
            dest[destIndex++] = (byte)(inVal >>> 16);
            dest[destIndex++] = (byte)(inVal >>> 8);
            dest[destIndex++] = (byte)inVal;
        }
    }

    private static final int uRSHFT2(int value, int count) {
        if (count >= 32) {
            return 0;
        }
        return value >>> count;
    }

    private static long uRSHFT_L(long value, int count) {
        if (count >= 64) {
            return 0L;
        }
        return value >>> count;
    }

    private static final int lSHFT2(int value, int count) {
        if (count >= 32) {
            return 0;
        }
        return value << count;
    }

    private static final long lSHFT_L(long value, int count) {
        if (count >= 64) {
            return 0L;
        }
        return value << count;
    }
}

