/*
 * Decompiled with CFR 0.152.
 */
package net.sourceforge.javaflacencoder;

public class CRC16 {
    public static int DEBUG_LEV = 0;
    static final int divisorCRC16 = 32773;
    protected int workingCRC;
    private static final short[] xorTable = CRC16.generateTable();

    public CRC16() {
        this.reset();
    }

    public void reset() {
        this.workingCRC = 0;
    }

    public short checksum() {
        return (short)(this.workingCRC & 0xFFFF);
    }

    public int update(byte input) {
        this.workingCRC = this.workingCRC << 8 ^ xorTable[(this.workingCRC >>> 8 ^ input) & 0xFF];
        return this.workingCRC;
    }

    public int update(byte[] input, int start, int stop) {
        for (int i = start; i < stop; ++i) {
            byte b = input[i];
            this.workingCRC = this.workingCRC << 8 ^ xorTable[(this.workingCRC >>> 8 ^ b) & 0xFF];
        }
        return this.workingCRC;
    }

    private static short[] generateTable() {
        short[] table = new short[256];
        for (int i = 0; i < table.length; ++i) {
            int polynomial = 32773;
            int xorVal = i << 8;
            int topmask = 65536;
            for (int x = 0; x < 8; ++x) {
                if (((xorVal <<= 1) & topmask) <= 0) continue;
                xorVal ^= polynomial;
            }
            table[i] = (short)(xorVal & 0xFFFF);
        }
        return table;
    }
}

