/*
 * Decompiled with CFR 0.152.
 */
package com.gargoylesoftware.htmlunit.javascript.host.xml;

import com.gargoylesoftware.htmlunit.html.DomAttr;
import com.gargoylesoftware.htmlunit.html.DomNode;
import com.gargoylesoftware.htmlunit.html.HtmlPage;
import com.gargoylesoftware.htmlunit.javascript.SimpleScriptable;
import com.gargoylesoftware.htmlunit.javascript.host.Document;
import com.gargoylesoftware.htmlunit.javascript.host.DocumentFragment;
import com.gargoylesoftware.htmlunit.javascript.host.Element;
import com.gargoylesoftware.htmlunit.javascript.host.Node;
import org.w3c.dom.NamedNodeMap;

public class XMLSerializer
extends SimpleScriptable {
    private static final long serialVersionUID = -934136191731299896L;

    public void jsConstructor() {
    }

    public String jsxFunction_serializeToString(Node root) {
        if (root instanceof Document) {
            root = ((Document)root).jsxGet_documentElement();
        } else if (root instanceof DocumentFragment) {
            root = root.jsxGet_firstChild();
        }
        if (root instanceof Element) {
            StringBuilder buffer = new StringBuilder();
            boolean isIE = this.getBrowserVersion().isIE();
            this.toXml(1, root.getDomNodeOrDie(), buffer, isIE);
            if (isIE) {
                buffer.append('\r').append('\n');
            }
            return buffer.toString();
        }
        if (root == null) {
            return "";
        }
        return root.getDomNodeOrDie().asXml();
    }

    private void toXml(int indent, DomNode node, StringBuilder buffer, boolean isIE) {
        String nodeName = node.getNodeName();
        if (!isIE && node.getPage() instanceof HtmlPage) {
            nodeName = nodeName.toUpperCase();
        }
        buffer.append('<').append(nodeName);
        NamedNodeMap attributesMap = node.getAttributes();
        for (int i = 0; i < attributesMap.getLength(); ++i) {
            DomAttr attrib = (DomAttr)attributesMap.item(i);
            buffer.append(' ').append(attrib.getQualifiedName()).append('=').append('\"').append(attrib.getValue()).append('\"');
        }
        boolean startTagClosed = false;
        block6: for (DomNode child : node.getChildren()) {
            if (!startTagClosed) {
                buffer.append('>');
                startTagClosed = true;
            }
            switch (child.getNodeType()) {
                case 1: {
                    this.toXml(indent + 1, child, buffer, isIE);
                    break;
                }
                case 3: {
                    String value = child.getNodeValue();
                    if (isIE && value.trim().length() == 0) {
                        buffer.append('\r').append('\n');
                        DomNode sibling = child.getNextSibling();
                        if (sibling == null || sibling.getNodeType() != 1) continue block6;
                        for (int i = 0; i < indent; ++i) {
                            buffer.append('\t');
                        }
                        continue block6;
                    }
                    buffer.append(child.getNodeValue());
                    break;
                }
                case 4: {
                    buffer.append(child.asXml());
                    break;
                }
            }
        }
        if (!startTagClosed) {
            buffer.append('/').append('>');
        } else {
            buffer.append('<').append('/').append(node.getNodeName()).append('>');
        }
    }
}

