/*
 * Decompiled with CFR 0.152.
 */
package com.gargoylesoftware.htmlunit.html.impl;

import com.gargoylesoftware.htmlunit.html.DomElement;
import java.io.Serializable;
import org.apache.commons.lang.mutable.MutableBoolean;
import org.w3c.dom.DOMException;
import org.w3c.dom.DocumentFragment;
import org.w3c.dom.Node;
import org.w3c.dom.NodeList;
import org.w3c.dom.ranges.Range;
import org.w3c.dom.ranges.RangeException;

public class SimpleRange
implements Range,
Serializable {
    private static final long serialVersionUID = 5779974839466976193L;
    private Node startContainer_;
    private Node endContainer_;
    private int startOffset_;
    private int endOffset_;

    public SimpleRange() {
    }

    public SimpleRange(DomElement domElement) {
        this.startContainer_ = domElement;
        this.endContainer_ = domElement;
        this.startOffset_ = 0;
        this.endOffset_ = domElement.getTextContent().length();
    }

    private SimpleRange(SimpleRange other) {
        this.startContainer_ = other.getStartContainer();
        this.endContainer_ = other.getEndContainer();
        this.startOffset_ = other.getStartOffset();
        this.endOffset_ = other.getEndOffset();
    }

    public DocumentFragment cloneContents() throws DOMException {
        throw new RuntimeException("Not implemented!");
    }

    public Range cloneRange() throws DOMException {
        return new SimpleRange(this);
    }

    public void collapse(boolean toStart) throws DOMException {
        if (toStart) {
            this.endContainer_ = this.startContainer_;
            this.endOffset_ = this.startOffset_;
        } else {
            this.startContainer_ = this.endContainer_;
            this.startOffset_ = this.endOffset_;
        }
    }

    public short compareBoundaryPoints(short how, Range sourceRange) throws DOMException {
        throw new RuntimeException("Not implemented!");
    }

    public void deleteContents() throws DOMException {
        throw new RuntimeException("Not implemented!");
    }

    public void detach() throws DOMException {
        throw new RuntimeException("Not implemented!");
    }

    public DocumentFragment extractContents() throws DOMException {
        throw new RuntimeException("Not implemented!");
    }

    public boolean getCollapsed() throws DOMException {
        return this.startContainer_ == this.endContainer_ && this.startOffset_ == this.endOffset_;
    }

    public Node getCommonAncestorContainer() throws DOMException {
        if (this.startContainer_ != null && this.endContainer_ != null) {
            for (Node p1 = this.startContainer_; p1 != null; p1 = p1.getParentNode()) {
                for (Node p2 = this.endContainer_; p2 != null; p2 = p2.getParentNode()) {
                    if (p1 != p2) continue;
                    return p1;
                }
            }
        }
        return null;
    }

    public Node getEndContainer() throws DOMException {
        return this.endContainer_;
    }

    public int getEndOffset() throws DOMException {
        return this.endOffset_;
    }

    public Node getStartContainer() throws DOMException {
        return this.startContainer_;
    }

    public int getStartOffset() throws DOMException {
        return this.startOffset_;
    }

    public void insertNode(Node newNode) throws DOMException, RangeException {
        throw new RuntimeException("Not implemented!");
    }

    public void selectNode(Node refNode) throws RangeException, DOMException {
        this.startContainer_ = refNode;
        this.startOffset_ = 0;
        this.endContainer_ = refNode;
        this.endOffset_ = refNode.getTextContent().length();
    }

    public void selectNodeContents(Node refNode) throws RangeException, DOMException {
        this.startContainer_ = refNode.getFirstChild();
        this.startOffset_ = 0;
        this.endContainer_ = refNode.getLastChild();
        this.endOffset_ = refNode.getLastChild().getTextContent().length();
    }

    public void setEnd(Node refNode, int offset) throws RangeException, DOMException {
        this.endContainer_ = refNode;
        this.endOffset_ = offset;
    }

    public void setEndAfter(Node refNode) throws RangeException, DOMException {
        throw new RuntimeException("Not implemented!");
    }

    public void setEndBefore(Node refNode) throws RangeException, DOMException {
        throw new RuntimeException("Not implemented!");
    }

    public void setStart(Node refNode, int offset) throws RangeException, DOMException {
        this.startContainer_ = refNode;
        this.startOffset_ = offset;
    }

    public void setStartAfter(Node refNode) throws RangeException, DOMException {
        throw new RuntimeException("Not implemented!");
    }

    public void setStartBefore(Node refNode) throws RangeException, DOMException {
        throw new RuntimeException("Not implemented!");
    }

    public void surroundContents(Node newParent) throws DOMException, RangeException {
        throw new RuntimeException("Not implemented!");
    }

    public String toString() {
        Node ancestor = this.getCommonAncestorContainer();
        StringBuilder sb = new StringBuilder();
        if (ancestor != null) {
            this.getText(ancestor, sb, new MutableBoolean(false));
        }
        return sb.toString();
    }

    private boolean getText(Node node, StringBuilder sb, MutableBoolean started) {
        NodeList children = node.getChildNodes();
        for (int i = 0; i < children.getLength(); ++i) {
            boolean stop;
            Node child = children.item(i);
            if (started.booleanValue()) {
                if (child == this.endContainer_) {
                    sb.append(this.endContainer_.getTextContent().substring(0, this.endOffset_));
                    return true;
                }
                if (child.hasChildNodes()) {
                    stop = this.getText(child, sb, started);
                    if (!stop) continue;
                    return true;
                }
                sb.append(child.getTextContent());
                continue;
            }
            started.setValue(child == this.startContainer_);
            if (started.booleanValue()) {
                sb.append(this.startContainer_.getTextContent().substring(this.startOffset_));
                continue;
            }
            stop = this.getText(child, sb, started);
            if (!stop) continue;
            return true;
        }
        return false;
    }
}

