/*
 * Decompiled with CFR 0.152.
 */
package com.gargoylesoftware.htmlunit.javascript.host;

import com.gargoylesoftware.htmlunit.SgmlPage;
import com.gargoylesoftware.htmlunit.WebClient;
import com.gargoylesoftware.htmlunit.WebRequestSettings;
import com.gargoylesoftware.htmlunit.WebResponse;
import com.gargoylesoftware.htmlunit.html.ClickableElement;
import com.gargoylesoftware.htmlunit.html.DomAttr;
import com.gargoylesoftware.htmlunit.html.DomCharacterData;
import com.gargoylesoftware.htmlunit.html.DomComment;
import com.gargoylesoftware.htmlunit.html.DomDocumentFragment;
import com.gargoylesoftware.htmlunit.html.DomNode;
import com.gargoylesoftware.htmlunit.html.DomText;
import com.gargoylesoftware.htmlunit.html.HTMLParser;
import com.gargoylesoftware.htmlunit.html.HtmlAnchor;
import com.gargoylesoftware.htmlunit.html.HtmlBody;
import com.gargoylesoftware.htmlunit.html.HtmlDivision;
import com.gargoylesoftware.htmlunit.html.HtmlElement;
import com.gargoylesoftware.htmlunit.html.HtmlFrameSet;
import com.gargoylesoftware.htmlunit.html.HtmlPage;
import com.gargoylesoftware.htmlunit.html.HtmlTable;
import com.gargoylesoftware.htmlunit.html.HtmlTableDataCell;
import com.gargoylesoftware.htmlunit.javascript.HtmlUnitContextFactory;
import com.gargoylesoftware.htmlunit.javascript.NamedNodeMap;
import com.gargoylesoftware.htmlunit.javascript.ScriptableWithFallbackGetter;
import com.gargoylesoftware.htmlunit.javascript.host.Attr;
import com.gargoylesoftware.htmlunit.javascript.host.BoxObject;
import com.gargoylesoftware.htmlunit.javascript.host.CSSStyleDeclaration;
import com.gargoylesoftware.htmlunit.javascript.host.ComputedCSSStyleDeclaration;
import com.gargoylesoftware.htmlunit.javascript.host.Element;
import com.gargoylesoftware.htmlunit.javascript.host.Event;
import com.gargoylesoftware.htmlunit.javascript.host.EventHandler;
import com.gargoylesoftware.htmlunit.javascript.host.HTMLBodyElement;
import com.gargoylesoftware.htmlunit.javascript.host.HTMLCollection;
import com.gargoylesoftware.htmlunit.javascript.host.HTMLDocument;
import com.gargoylesoftware.htmlunit.javascript.host.MouseEvent;
import com.gargoylesoftware.htmlunit.javascript.host.Node;
import com.gargoylesoftware.htmlunit.javascript.host.TextRange;
import com.gargoylesoftware.htmlunit.javascript.host.TextRectangle;
import com.gargoylesoftware.htmlunit.javascript.host.Window;
import java.io.IOException;
import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import java.net.MalformedURLException;
import java.net.URL;
import java.util.Arrays;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import org.apache.commons.lang.StringUtils;
import org.apache.commons.logging.LogFactory;
import org.mozilla.javascript.Context;
import org.mozilla.javascript.ContextAction;
import org.mozilla.javascript.Function;
import org.mozilla.javascript.NativeArray;
import org.mozilla.javascript.Scriptable;
import org.xml.sax.SAXException;
import org.xml.sax.helpers.AttributesImpl;

public class HTMLElement
extends Element
implements ScriptableWithFallbackGetter {
    private static final long serialVersionUID = -6864034414262085851L;
    private static final int BEHAVIOR_ID_UNKNOWN = -1;
    static final int BEHAVIOR_ID_CLIENT_CAPS = 0;
    static final int BEHAVIOR_ID_HOMEPAGE = 1;
    static final int BEHAVIOR_ID_DOWNLOAD = 2;
    private static final String BEHAVIOR_CLIENT_CAPS = "#default#clientCaps";
    private static final String BEHAVIOR_HOMEPAGE = "#default#homePage";
    private static final String BEHAVIOR_DOWNLOAD = "#default#download";
    static final String POSITION_BEFORE_BEGIN = "beforeBegin";
    static final String POSITION_AFTER_BEGIN = "afterBegin";
    static final String POSITION_BEFORE_END = "beforeEnd";
    static final String POSITION_AFTER_END = "afterEnd";
    private static int UniqueID_Counter_ = 1;
    private final Set<String> behaviors_ = new HashSet<String>();
    private BoxObject boxObject_;
    private HTMLCollection all_;
    private int scrollLeft_;
    private int scrollTop_;
    private String uniqueID_;
    private Map<String, HTMLCollection> elementsByTagName_ = new HashMap<String, HTMLCollection>();
    private CSSStyleDeclaration style_;
    private static final List<String> INNER_HTML_READONLY_IN_IE = Arrays.asList("col", "colgroup", "frameset", "head", "html", "style", "table", "tbody", "tfoot", "thead", "title", "tr");
    private static final List<String> INNER_TEXT_READONLY = Arrays.asList("html", "table", "tbody", "tfoot", "thead", "tr");
    private static final List<String> OUTER_HTML_READONLY = Arrays.asList("caption", "col", "colgroup", "frameset", "html", "tbody", "td", "tfoot", "th", "thead", "tr");

    public HTMLCollection jsxGet_all() {
        if (this.all_ == null) {
            this.all_ = new HTMLCollection(this);
            this.all_.init(this.getDomNodeOrDie(), ".//*");
        }
        return this.all_;
    }

    public CSSStyleDeclaration jsxGet_style() {
        return this.style_;
    }

    public ComputedCSSStyleDeclaration jsxGet_currentStyle() {
        return this.getWindow().jsxFunction_getComputedStyle(this, null);
    }

    protected void setDefaults(ComputedCSSStyleDeclaration style) {
    }

    public CSSStyleDeclaration jsxGet_runtimeStyle() {
        return this.style_;
    }

    public void setDomNode(DomNode domNode) {
        super.setDomNode(domNode);
        this.style_ = new CSSStyleDeclaration(this);
        HtmlElement htmlElt = (HtmlElement)domNode;
        for (DomAttr attr : htmlElt.getAttributesMap().values()) {
            String eventName = attr.getName();
            if (!eventName.startsWith("on")) continue;
            this.createEventHandler(eventName, attr.getValue());
        }
    }

    protected void createEventHandler(String eventName, String attrValue) {
        HtmlElement htmlElt = (HtmlElement)this.getDomNodeOrDie();
        EventHandler eventHandler = new EventHandler(htmlElt, eventName, attrValue);
        this.setEventHandler(eventName, (Function)eventHandler);
        if (htmlElt instanceof HtmlBody || htmlElt instanceof HtmlFrameSet) {
            this.getWindow().getEventListenersContainer().setEventHandlerProp(eventName.substring(2), (Object)eventHandler);
        }
    }

    public String jsxGet_id() {
        return this.getHtmlElementOrDie().getId();
    }

    public void jsxSet_id(String newId) {
        this.getHtmlElementOrDie().setId(newId);
    }

    public String jsxGet_title() {
        return this.getHtmlElementOrDie().getAttribute("title");
    }

    public void jsxSet_title(String newTitle) {
        this.getHtmlElementOrDie().setAttribute("title", newTitle);
    }

    public boolean jsxGet_disabled() {
        return this.getHtmlElementOrDie().hasAttribute("disabled");
    }

    public void jsxSet_disabled(boolean disabled) {
        HtmlElement element = this.getHtmlElementOrDie();
        if (disabled) {
            element.setAttribute("disabled", "disabled");
        } else {
            element.removeAttribute("disabled");
        }
    }

    public Object jsxGet_namespaceURI() {
        if (this.getBrowserVersion().isIE()) {
            if (this.getDomNodeOrDie().getPage() instanceof HtmlPage) {
                return NOT_FOUND;
            }
            return this.getHtmlElementOrDie().getNamespaceURI();
        }
        if (this.getDomNodeOrDie().getPage() instanceof HtmlPage) {
            return null;
        }
        return this.getHtmlElementOrDie().getNamespaceURI();
    }

    public Object jsxGet_localName() {
        if (this.getBrowserVersion().isIE()) {
            return NOT_FOUND;
        }
        DomNode domNode = this.getDomNodeOrDie();
        String localName = domNode.getLocalName();
        if (domNode.getPage() instanceof HtmlPage) {
            if (domNode.getPrefix() != null) {
                localName = domNode.getPrefix() + ':' + localName;
            }
            return localName.toUpperCase();
        }
        return localName;
    }

    public Object getWithFallback(String name) {
        String value;
        HtmlElement htmlElement = this.getHtmlElementOrNull();
        if (htmlElement != null && this.isAttributeName(name) && HtmlElement.ATTRIBUTE_NOT_DEFINED != (value = htmlElement.getAttribute(name))) {
            this.getLog().debug((Object)("Found attribute for evaluation of property \"" + name + "\" for of " + this));
            return value;
        }
        return NOT_FOUND;
    }

    protected boolean isAttributeName(String name) {
        return name.toLowerCase().equals(name);
    }

    protected String fixAttributeName(String attributeName) {
        if (this.getBrowserVersion().isIE()) {
            if ("className".equals(attributeName)) {
                return "class";
            }
            if ("class".equals(attributeName)) {
                return "_class";
            }
        }
        return attributeName;
    }

    public String jsxFunction_getAttributeNS(String namespaceURI, String localName) {
        return this.getHtmlElementOrDie().getAttributeNS(namespaceURI, localName);
    }

    public boolean jsxFunction_hasAttributeNS(String namespaceURI, String localName) {
        return this.getHtmlElementOrDie().hasAttributeNS(namespaceURI, localName);
    }

    public void jsxFunction_setAttribute(String name, String value) {
        name = this.fixAttributeName(name);
        this.getHtmlElementOrDie().setAttribute(name, value);
        if (this.getBrowserVersion().isFirefox()) {
            try {
                Method method = this.getClass().getMethod("jsxSet_" + name, Object.class);
                String source = "function(){" + value + "}";
                method.invoke((Object)this, Context.getCurrentContext().compileFunction((Scriptable)this.getWindow(), source, "", 0, null));
            }
            catch (NoSuchMethodException e) {
            }
            catch (IllegalAccessException e) {
            }
            catch (InvocationTargetException e) {
                throw new RuntimeException(e.getCause());
            }
        }
    }

    public void jsxFunction_setAttributeNS(String namespaceURI, String qualifiedName, String value) {
        this.getHtmlElementOrDie().setAttributeNS(namespaceURI, qualifiedName, value);
    }

    public void jsxFunction_removeAttribute(String name) {
        this.getHtmlElementOrDie().removeAttribute(name);
        if (this.getBrowserVersion().isIE()) {
            this.delete(name);
        }
    }

    public void jsxFunction_removeAttributeNS(String namespaceURI, String localName) {
        this.getHtmlElementOrDie().removeAttributeNS(namespaceURI, localName);
    }

    public Object jsxFunction_getAttributeNode(String attributeName) {
        return ((NamedNodeMap)this.jsxGet_attributes()).jsxFunction_getNamedItem(attributeName);
    }

    public Attr jsxFunction_setAttributeNode(Attr newAtt) {
        String name = newAtt.jsxGet_name();
        String value = newAtt.jsxGet_value();
        Attr replacedAtt = (Attr)((Object)this.jsxFunction_getAttributeNode(name));
        replacedAtt.detachFromParent();
        this.getHtmlElementOrDie().setAttribute(name, value);
        return replacedAtt;
    }

    public Object jsxFunction_getElementsByTagName(String tagName) {
        HTMLCollection collection = this.elementsByTagName_.get(tagName = tagName.toLowerCase());
        if (collection != null) {
            return collection;
        }
        DomNode node = this.getDomNodeOrDie();
        collection = new HTMLCollection(this);
        String xpath = "*".equals(tagName) ? ".//*" : ".//*[local-name() = '" + tagName + "']";
        collection.init(node, xpath);
        this.elementsByTagName_.put(tagName, collection);
        return collection;
    }

    public Object jsxGet_className() {
        return this.getHtmlElementOrDie().getAttribute("class");
    }

    public int jsxGet_clientHeight() {
        boolean includePadding = !this.getBrowserVersion().isIE();
        ComputedCSSStyleDeclaration style = this.getWindow().jsxFunction_getComputedStyle(this, null);
        return style.getCalculatedHeight(false, includePadding);
    }

    public int jsxGet_clientWidth() {
        boolean includePadding = !this.getBrowserVersion().isIE();
        ComputedCSSStyleDeclaration style = this.getWindow().jsxFunction_getComputedStyle(this, null);
        return style.getCalculatedWidth(false, includePadding);
    }

    public int jsxGet_clientLeft() {
        return 2;
    }

    public int jsxGet_clientTop() {
        return 2;
    }

    public void jsxSet_className(String className) {
        this.getHtmlElementOrDie().setAttribute("class", className);
    }

    public String jsxGet_innerHTML() {
        StringBuilder buf = new StringBuilder();
        this.printChildren(buf, this.getDomNodeOrDie(), !"SCRIPT".equals(this.jsxGet_tagName()));
        return buf.toString();
    }

    public String jsxGet_innerText() {
        StringBuilder buf = new StringBuilder();
        this.printChildren(buf, this.getDomNodeOrDie(), false);
        return buf.toString();
    }

    public String jsxGet_textContent() {
        return this.jsxGet_innerText();
    }

    public String jsxGet_outerHTML() {
        StringBuilder buf = new StringBuilder();
        this.printNode(buf, this.getDomNodeOrDie(), true);
        return buf.toString();
    }

    private void printChildren(StringBuilder buffer, DomNode node, boolean html) {
        for (DomNode child : node.getChildren()) {
            this.printNode(buffer, child, html);
        }
    }

    private void printNode(StringBuilder buffer, DomNode node, boolean html) {
        if (node instanceof DomComment) {
            String s = node.getNodeValue().replaceAll("  ", " ");
            buffer.append("<!--").append(s).append("-->");
        } else if (node instanceof DomCharacterData) {
            String s = node.getNodeValue().replaceAll("  ", " ");
            if (html) {
                s = com.gargoylesoftware.htmlunit.util.StringUtils.escapeXmlChars(s);
            }
            buffer.append(s);
        } else if (html) {
            HtmlElement element = (HtmlElement)node;
            boolean ie = this.getBrowserVersion().isIE();
            String tag = element.getTagName();
            if (ie) {
                tag = tag.toUpperCase();
            }
            buffer.append("<").append(tag);
            for (DomAttr attr : element.getAttributesMap().values()) {
                String name = attr.getName();
                String value = attr.getValue().replaceAll("\"", "&quot;");
                boolean quote = !ie || com.gargoylesoftware.htmlunit.util.StringUtils.containsWhitespace(value) || value.length() == 0 || element instanceof HtmlAnchor && "href".equals(name);
                buffer.append(' ').append(name).append("=");
                if (quote) {
                    buffer.append("\"");
                }
                buffer.append(value);
                if (!quote) continue;
                buffer.append("\"");
            }
            buffer.append(">");
            this.printChildren(buffer, node, html);
            buffer.append("</").append(tag).append(">");
        } else {
            HtmlElement element = (HtmlElement)node;
            if (element.getTagName().equals("p")) {
                buffer.append("\r\n");
            }
            if (!element.getTagName().equals("script")) {
                this.printChildren(buffer, node, html);
            }
        }
    }

    public void jsxSet_innerHTML(Object value) {
        DomNode domNode = this.getDomNodeOrDie();
        boolean ie = this.getBrowserVersion().isIE();
        if (ie && INNER_HTML_READONLY_IN_IE.contains(domNode.getNodeName())) {
            throw Context.reportRuntimeError((String)("innerHTML is read-only for tag " + domNode.getNodeName()));
        }
        domNode.removeAllChildren();
        if (value == null && ie || value != null && !"".equals(value)) {
            String valueAsString = Context.toString((Object)value);
            HTMLElement.parseHtmlSnippet(domNode, true, valueAsString);
            if (domNode.getParentNode() == null && ie) {
                DomDocumentFragment fragment = ((HtmlPage)domNode.getPage()).createDomDocumentFragment();
                fragment.appendChild(domNode);
            }
        }
    }

    public void jsxSet_innerText(String value) {
        DomNode domNode = this.getDomNodeOrDie();
        if (INNER_TEXT_READONLY.contains(domNode.getNodeName())) {
            throw Context.reportRuntimeError((String)("innerText is read-only for tag " + domNode.getNodeName()));
        }
        domNode.removeAllChildren();
        DomText node = new DomText(this.getDomNodeOrDie().getPage(), value);
        domNode.appendChild(node);
        if (domNode.getParentNode() == null && this.getBrowserVersion().isIE()) {
            DomDocumentFragment fragment = ((HtmlPage)domNode.getPage()).createDomDocumentFragment();
            fragment.appendChild(domNode);
        }
    }

    public void jsxSet_textContent(String value) {
        this.jsxSet_innerText(value);
    }

    public void jsxSet_outerHTML(String value) {
        DomNode domNode = this.getDomNodeOrDie();
        if (OUTER_HTML_READONLY.contains(domNode.getNodeName())) {
            throw Context.reportRuntimeError((String)("outerHTML is read-only for tag " + domNode.getNodeName()));
        }
        HTMLElement.parseHtmlSnippet(domNode, false, value);
        domNode.remove();
    }

    static void parseHtmlSnippet(DomNode target, boolean append, String source) {
        HtmlPage page = (HtmlPage)target.getPage();
        ProxyDomNode proxyNode = new ProxyDomNode(page, target, append);
        try {
            HTMLParser.parseFragment(proxyNode, source);
        }
        catch (IOException e) {
            LogFactory.getLog(HtmlElement.class).error((Object)"Unexpected exception occurred while parsing HTML snippet", (Throwable)e);
            throw Context.reportRuntimeError((String)("Unexpected exception occurred while parsing HTML snippet: " + e.getMessage()));
        }
        catch (SAXException e) {
            LogFactory.getLog(HtmlElement.class).error((Object)"Unexpected exception occurred while parsing HTML snippet", (Throwable)e);
            throw Context.reportRuntimeError((String)("Unexpected exception occurred while parsing HTML snippet: " + e.getMessage()));
        }
    }

    protected AttributesImpl readAttributes(HtmlElement element) {
        AttributesImpl attributes = new AttributesImpl();
        for (DomAttr entry : element.getAttributesMap().values()) {
            String name = entry.getName();
            String value = entry.getValue();
            attributes.addAttribute(null, name, name, null, value);
        }
        return attributes;
    }

    public void jsxFunction_insertAdjacentHTML(String where, String text) {
        Object[] values = this.getInsertAdjacentLocation(where);
        DomNode node = (DomNode)values[0];
        boolean append = (Boolean)values[1];
        HTMLElement.parseHtmlSnippet(node, append, text);
    }

    public Object jsxFunction_insertAdjacentElement(String where, Object object) {
        if (object instanceof Node) {
            DomNode childNode = ((Node)((Object)object)).getDomNodeOrDie();
            Object[] values = this.getInsertAdjacentLocation(where);
            DomNode node = (DomNode)values[0];
            boolean append = (Boolean)values[1];
            if (append) {
                node.appendChild(childNode);
            } else {
                node.insertBefore(childNode);
            }
            return object;
        }
        throw Context.reportRuntimeError((String)("Passed object is not an element: " + object));
    }

    private Object[] getInsertAdjacentLocation(String where) {
        boolean append;
        DomNode node;
        DomNode currentNode = this.getDomNodeOrDie();
        if (POSITION_AFTER_BEGIN.equalsIgnoreCase(where)) {
            if (currentNode.getFirstChild() == null) {
                node = currentNode;
                append = true;
            } else {
                node = currentNode.getFirstChild();
                append = false;
            }
        } else if (POSITION_BEFORE_BEGIN.equalsIgnoreCase(where)) {
            node = currentNode;
            append = false;
        } else if (POSITION_BEFORE_END.equalsIgnoreCase(where)) {
            node = currentNode;
            append = true;
        } else if (POSITION_AFTER_END.equalsIgnoreCase(where)) {
            if (currentNode.getNextSibling() == null) {
                node = currentNode.getParentNode();
                append = true;
            } else {
                node = currentNode.getNextSibling();
                append = false;
            }
        } else {
            throw Context.reportRuntimeError((String)("Illegal position value: \"" + where + "\""));
        }
        if (append) {
            return new Object[]{node, Boolean.TRUE};
        }
        return new Object[]{node, Boolean.FALSE};
    }

    public int jsxFunction_addBehavior(String behavior) {
        if (this.behaviors_.contains(behavior)) {
            return 0;
        }
        Class<?> c = this.getClass();
        if (BEHAVIOR_CLIENT_CAPS.equalsIgnoreCase(behavior)) {
            this.defineProperty("availHeight", c, 0);
            this.defineProperty("availWidth", c, 0);
            this.defineProperty("bufferDepth", c, 0);
            this.defineProperty("colorDepth", c, 0);
            this.defineProperty("connectionType", c, 0);
            this.defineProperty("cookieEnabled", c, 0);
            this.defineProperty("cpuClass", c, 0);
            this.defineProperty("height", c, 0);
            this.defineProperty("javaEnabled", c, 0);
            this.defineProperty("platform", c, 0);
            this.defineProperty("systemLanguage", c, 0);
            this.defineProperty("userLanguage", c, 0);
            this.defineProperty("width", c, 0);
            this.defineFunctionProperties(new String[]{"addComponentRequest"}, c, 0);
            this.defineFunctionProperties(new String[]{"clearComponentRequest"}, c, 0);
            this.defineFunctionProperties(new String[]{"compareVersions"}, c, 0);
            this.defineFunctionProperties(new String[]{"doComponentRequest"}, c, 0);
            this.defineFunctionProperties(new String[]{"getComponentVersion"}, c, 0);
            this.defineFunctionProperties(new String[]{"isComponentInstalled"}, c, 0);
            this.behaviors_.add(BEHAVIOR_CLIENT_CAPS);
            return 0;
        }
        if (BEHAVIOR_HOMEPAGE.equalsIgnoreCase(behavior)) {
            this.defineFunctionProperties(new String[]{"isHomePage"}, c, 0);
            this.defineFunctionProperties(new String[]{"setHomePage"}, c, 0);
            this.defineFunctionProperties(new String[]{"navigateHomePage"}, c, 0);
            this.behaviors_.add(BEHAVIOR_CLIENT_CAPS);
            return 1;
        }
        if (BEHAVIOR_DOWNLOAD.equalsIgnoreCase(behavior)) {
            this.defineFunctionProperties(new String[]{"startDownload"}, c, 0);
            this.behaviors_.add(BEHAVIOR_DOWNLOAD);
            return 2;
        }
        this.getLog().warn((Object)("Unimplemented behavior: " + behavior));
        return -1;
    }

    public void jsxFunction_removeBehavior(int id) {
        switch (id) {
            case 0: {
                this.delete("availHeight");
                this.delete("availWidth");
                this.delete("bufferDepth");
                this.delete("colorDepth");
                this.delete("connectionType");
                this.delete("cookieEnabled");
                this.delete("cpuClass");
                this.delete("height");
                this.delete("javaEnabled");
                this.delete("platform");
                this.delete("systemLanguage");
                this.delete("userLanguage");
                this.delete("width");
                this.delete("addComponentRequest");
                this.delete("clearComponentRequest");
                this.delete("compareVersions");
                this.delete("doComponentRequest");
                this.delete("getComponentVersion");
                this.delete("isComponentInstalled");
                this.behaviors_.remove(BEHAVIOR_CLIENT_CAPS);
                break;
            }
            case 1: {
                this.delete("isHomePage");
                this.delete("setHomePage");
                this.delete("navigateHomePage");
                this.behaviors_.remove(BEHAVIOR_HOMEPAGE);
                break;
            }
            case 2: {
                this.delete("startDownload");
                this.behaviors_.remove(BEHAVIOR_DOWNLOAD);
                break;
            }
            default: {
                this.getLog().warn((Object)("Unexpected behavior id: " + id + ". Ignoring."));
            }
        }
    }

    public int getAvailHeight() {
        return this.getWindow().jsxGet_screen().jsxGet_availHeight();
    }

    public int getAvailWidth() {
        return this.getWindow().jsxGet_screen().jsxGet_availWidth();
    }

    public int getBufferDepth() {
        return this.getWindow().jsxGet_screen().jsxGet_bufferDepth();
    }

    public BoxObject getBoxObject() {
        if (this.boxObject_ == null) {
            this.boxObject_ = new BoxObject(this);
            this.boxObject_.setParentScope(this.getWindow());
            this.boxObject_.setPrototype(this.getPrototype(((Object)((Object)this.boxObject_)).getClass()));
        }
        return this.boxObject_;
    }

    public int getColorDepth() {
        return this.getWindow().jsxGet_screen().jsxGet_colorDepth();
    }

    public String getConnectionType() {
        return "modem";
    }

    public boolean getCookieEnabled() {
        return this.getWindow().jsxGet_navigator().jsxGet_cookieEnabled();
    }

    public String getCpuClass() {
        return this.getWindow().jsxGet_navigator().jsxGet_cpuClass();
    }

    public int getHeight() {
        return this.getWindow().jsxGet_screen().jsxGet_height();
    }

    public boolean getJavaEnabled() {
        return this.getWindow().jsxGet_navigator().jsxFunction_javaEnabled();
    }

    public String getPlatform() {
        return this.getWindow().jsxGet_navigator().jsxGet_platform();
    }

    public String getSystemLanguage() {
        return this.getWindow().jsxGet_navigator().jsxGet_systemLanguage();
    }

    public String getUserLanguage() {
        return this.getWindow().jsxGet_navigator().jsxGet_userLanguage();
    }

    public int getWidth() {
        return this.getWindow().jsxGet_screen().jsxGet_width();
    }

    public void addComponentRequest(String id, String idType, String minVersion) {
        this.getLog().debug((Object)("Call to addComponentRequest(" + id + ", " + idType + ", " + minVersion + ") ignored."));
    }

    public void clearComponentRequest() {
        this.getLog().debug((Object)"Call to clearComponentRequest() ignored.");
    }

    public int compareVersions(String v1, String v2) {
        int i = v1.compareTo(v2);
        if (i == 0) {
            return 0;
        }
        if (i < 0) {
            return -1;
        }
        return 1;
    }

    public boolean doComponentRequest() {
        return false;
    }

    public String getComponentVersion(String id, String idType) {
        if ("{E5D12C4E-7B4F-11D3-B5C9-0050045C3C96}".equals(id)) {
            return "";
        }
        return "1.0";
    }

    public boolean isComponentInstalled(String id, String idType, String minVersion) {
        return false;
    }

    public void startDownload(String uri, Function callback) throws MalformedURLException {
        HtmlPage page = (HtmlPage)this.getWindow().getWebWindow().getEnclosedPage();
        URL url = page.getFullyQualifiedUrl(uri);
        if (!page.getWebResponse().getRequestUrl().getHost().equals(url.getHost())) {
            throw Context.reportRuntimeError((String)("Not authorized url: " + url));
        }
        DownloadBehaviorDownloader t = new DownloadBehaviorDownloader(url, callback);
        this.getLog().debug((Object)("Starting download thread for " + url));
        t.start();
    }

    public boolean isHomePage(String url) {
        try {
            URL newUrl = new URL(url);
            URL currentUrl = this.getDomNodeOrDie().getPage().getWebResponse().getRequestUrl();
            String home = this.getDomNodeOrDie().getPage().getEnclosingWindow().getWebClient().getHomePage();
            boolean sameDomains = newUrl.getHost().equalsIgnoreCase(currentUrl.getHost());
            boolean isHomePage = home != null && home.equals(url);
            return sameDomains && isHomePage;
        }
        catch (MalformedURLException e) {
            return false;
        }
    }

    public void setHomePage(String url) {
        this.getDomNodeOrDie().getPage().getEnclosingWindow().getWebClient().setHomePage(url);
    }

    public void navigateHomePage() throws IOException {
        WebClient webClient = this.getDomNodeOrDie().getPage().getEnclosingWindow().getWebClient();
        webClient.getPage(webClient.getHomePage());
    }

    public Object jsxGet_children() {
        HTMLCollection children = new HTMLCollection(this);
        children.init(this.getDomNodeOrDie(), "./*");
        return children;
    }

    public int jsxGet_offsetHeight() {
        MouseEvent event = MouseEvent.getCurrentMouseEvent();
        if (this.isAncestorOfEventTarget(event)) {
            return event.jsxGet_clientY() - this.getPosY() + 50;
        }
        return this.jsxGet_currentStyle().getCalculatedHeight(true, true);
    }

    public int jsxGet_offsetWidth() {
        MouseEvent event = MouseEvent.getCurrentMouseEvent();
        if (this.isAncestorOfEventTarget(event)) {
            return event.jsxGet_clientX() - this.getPosX() + 50;
        }
        return this.jsxGet_currentStyle().getCalculatedWidth(true, true);
    }

    private boolean isAncestorOfEventTarget(MouseEvent event) {
        if (event == null) {
            return false;
        }
        HTMLElement target = (HTMLElement)event.jsxGet_target();
        return this.getHtmlElementOrDie().isAncestorOf(target.getHtmlElementOrDie());
    }

    int getPosX() {
        int cumulativeOffset = 0;
        for (HTMLElement element = this; element != null; element = element.getOffsetParent()) {
            cumulativeOffset += element.jsxGet_offsetLeft();
            if (element == this) continue;
            cumulativeOffset += element.jsxGet_currentStyle().getBorderLeft();
        }
        return cumulativeOffset;
    }

    private HTMLElement getOffsetParent() {
        Object offsetParent = this.jsxGet_offsetParent();
        if (offsetParent instanceof HTMLElement) {
            return (HTMLElement)offsetParent;
        }
        return null;
    }

    int getPosY() {
        int cumulativeOffset = 0;
        for (HTMLElement element = this; element != null; element = element.getOffsetParent()) {
            cumulativeOffset += element.jsxGet_offsetTop();
            if (element == this) continue;
            cumulativeOffset += element.jsxGet_currentStyle().getBorderTop();
        }
        return cumulativeOffset;
    }

    public int jsxGet_offsetLeft() {
        if (this instanceof HTMLBodyElement) {
            return 0;
        }
        int left = 0;
        HTMLElement offsetParent = this.getOffsetParent();
        DomNode node = this.getDomNodeOrDie();
        HTMLElement element = (HTMLElement)node.getScriptObject();
        left += element.jsxGet_currentStyle().getLeft(true, false, false);
        String position = element.jsxGet_currentStyle().jsxGet_position();
        if ("absolute".equals(position)) {
            return left;
        }
        for (node = node.getParentNode(); node != null && node.getScriptObject() != offsetParent; node = node.getParentNode()) {
            if (!(node.getScriptObject() instanceof HTMLElement)) continue;
            element = (HTMLElement)node.getScriptObject();
            left += element.jsxGet_currentStyle().getLeft(true, true, true);
        }
        if (offsetParent != null) {
            left += offsetParent.jsxGet_currentStyle().getMarginLeft();
            left += offsetParent.jsxGet_currentStyle().getPaddingLeft();
        }
        return left;
    }

    public int jsxGet_offsetTop() {
        if (this instanceof HTMLBodyElement) {
            return 0;
        }
        int top = 0;
        HTMLElement offsetParent = this.getOffsetParent();
        DomNode node = this.getDomNodeOrDie();
        HTMLElement element = (HTMLElement)node.getScriptObject();
        top += element.jsxGet_currentStyle().getTop(true, false, false);
        String position = element.jsxGet_currentStyle().jsxGet_position();
        if ("absolute".equals(position)) {
            return top;
        }
        for (node = node.getParentNode(); node != null && node.getScriptObject() != offsetParent; node = node.getParentNode()) {
            if (!(node.getScriptObject() instanceof HTMLElement)) continue;
            element = (HTMLElement)node.getScriptObject();
            top += element.jsxGet_currentStyle().getTop(false, true, true);
        }
        if (offsetParent != null) {
            top += offsetParent.jsxGet_currentStyle().getPaddingTop();
        }
        return top;
    }

    public Object jsxGet_offsetParent() {
        boolean useTables;
        DomNode currentElement;
        Object offsetParent = Context.getUndefinedValue();
        HTMLElement htmlElement = (HTMLElement)currentElement.getScriptObject();
        ComputedCSSStyleDeclaration style = htmlElement.jsxGet_currentStyle();
        String position = style.jsxGet_position();
        boolean ie = this.getBrowserVersion().isIE();
        boolean staticPos = "static".equals(position);
        boolean fixedPos = "fixed".equals(position);
        boolean bl = useTables = ie && (staticPos || fixedPos) || !ie && staticPos;
        for (currentElement = this.getHtmlElementOrDie(); currentElement != null; currentElement = currentElement.getParentNode()) {
            DomNode parentNode = currentElement.getParentNode();
            if (parentNode instanceof HtmlBody || useTables && parentNode instanceof HtmlTableDataCell || useTables && parentNode instanceof HtmlTable) {
                offsetParent = parentNode.getScriptObject();
                break;
            }
            if (parentNode == null || !(parentNode.getScriptObject() instanceof HTMLElement)) continue;
            HTMLElement parentElement = (HTMLElement)parentNode.getScriptObject();
            ComputedCSSStyleDeclaration parentStyle = parentElement.jsxGet_currentStyle();
            String parentPosition = parentStyle.jsxGet_position();
            boolean parentIsStatic = "static".equals(parentPosition);
            boolean parentIsFixed = "fixed".equals(parentPosition);
            if ((!ie || parentIsStatic || parentIsFixed) && (ie || parentIsStatic)) continue;
            offsetParent = parentNode.getScriptObject();
            break;
        }
        return offsetParent;
    }

    public String toString() {
        return "HTMLElement for " + this.getHtmlElementOrNull();
    }

    public int jsxGet_scrollTop() {
        return this.scrollTop_;
    }

    public void jsxSet_scrollTop(int scroll) {
        this.scrollTop_ = scroll;
    }

    public int jsxGet_scrollLeft() {
        return this.scrollLeft_;
    }

    public void jsxSet_scrollLeft(int scroll) {
        this.scrollLeft_ = scroll;
    }

    public int jsxGet_scrollHeight() {
        return 10;
    }

    public int jsxGet_scrollWidth() {
        return 10;
    }

    public Object jsxGet_parentElement() {
        if ("html".equalsIgnoreCase(this.getDomNodeOrDie().getNodeName())) {
            return null;
        }
        return this.jsxGet_parentNode();
    }

    public HTMLElement getParentHTMLElement() {
        Node parent;
        for (parent = (Node)((Object)this.jsxGet_parentNode()); parent != null && !(parent instanceof HTMLElement); parent = (Node)((Object)parent.jsxGet_parentNode())) {
        }
        return (HTMLElement)parent;
    }

    public void jsxFunction_scrollIntoView() {
    }

    public TextRectangle jsxFunction_getBoundingClientRect() {
        TextRectangle textRectangle = new TextRectangle(0, this.getPosX() + this.jsxGet_clientLeft(), 0, this.getPosY() + this.jsxGet_clientTop());
        textRectangle.setParentScope(this.getWindow());
        textRectangle.setPrototype(this.getPrototype(((Object)((Object)textRectangle)).getClass()));
        return textRectangle;
    }

    public Object jsxFunction_getClientRects() {
        return new NativeArray(0L);
    }

    public void jsxFunction_setExpression(String propertyName, String expression, String language) {
    }

    public boolean jsxFunction_removeExpression(String propertyName) {
        return true;
    }

    public String jsxGet_uniqueID() {
        if (this.uniqueID_ == null) {
            this.uniqueID_ = "ms__id" + UniqueID_Counter_++;
        }
        return this.uniqueID_;
    }

    public boolean jsxFunction_dispatchEvent(Event event) {
        event.setTarget(this);
        HtmlElement element = this.getHtmlElementOrDie();
        if (event instanceof MouseEvent && element instanceof ClickableElement) {
            if (event.jsxGet_type().equals("click")) {
                try {
                    ((ClickableElement)element).click(event);
                }
                catch (IOException e) {
                    throw Context.reportRuntimeError((String)("Error calling click(): " + e.getMessage()));
                }
            } else if (event.jsxGet_type().equals("dblclick")) {
                try {
                    ((ClickableElement)element).dblClick(event.jsxGet_shiftKey(), event.jsxGet_ctrlKey(), event.jsxGet_altKey());
                }
                catch (IOException e) {
                    throw Context.reportRuntimeError((String)("Error calling dblClick(): " + e.getMessage()));
                }
            } else {
                this.fireEvent(event);
            }
        } else {
            this.fireEvent(event);
        }
        return !event.isPreventDefault();
    }

    public final HtmlElement getHtmlElementOrDie() throws IllegalStateException {
        return (HtmlElement)this.getDomNodeOrDie();
    }

    public HtmlElement getHtmlElementOrNull() {
        return (HtmlElement)this.getDomNodeOrNull();
    }

    public void jsxFunction_blur() {
        HtmlElement element = (HtmlElement)this.getDomNodeOrDie();
        element.blur();
    }

    public Object jsxFunction_createTextRange() {
        TextRange range = new TextRange();
        range.setParentScope(this.getParentScope());
        range.setPrototype(this.getPrototype(((Object)((Object)range)).getClass()));
        return range;
    }

    public boolean jsxFunction_contains(HTMLElement element) {
        for (HTMLElement parent = element; parent != null; parent = (HTMLElement)parent.jsxGet_parentElement()) {
            if (this != parent) continue;
            return true;
        }
        return false;
    }

    public void jsxFunction_focus() {
        HtmlElement element = (HtmlElement)this.getDomNodeOrDie();
        element.focus();
    }

    public void jsxFunction_setActive() {
        Window window = this.getWindow();
        HTMLDocument document = window.jsxGet_document();
        document.setActiveElement(this);
        if (window.getWebWindow() == window.getWebWindow().getWebClient().getCurrentWindow()) {
            HtmlElement element = (HtmlElement)this.getDomNodeOrDie();
            ((HtmlPage)element.getPage()).setFocusedElement(element);
        }
    }

    public String jsxGet_nodeName() {
        DomNode domNode = this.getDomNodeOrDie();
        String nodeName = domNode.getNodeName();
        if (domNode.getPage() instanceof HtmlPage) {
            nodeName = nodeName.toUpperCase();
        }
        return nodeName;
    }

    public Object jsxGet_prefix() {
        if (this.getBrowserVersion().isIE()) {
            return super.jsxGet_prefix();
        }
        return null;
    }

    public Object jsxGet_filters() {
        return this;
    }

    private final class DownloadBehaviorDownloader
    extends Thread {
        private final URL url_;
        private final Function callback_;

        private DownloadBehaviorDownloader(URL url, Function callback) {
            super("Downloader for behavior #default#download '" + url + "'");
            this.url_ = url;
            this.callback_ = callback;
        }

        public void run() {
            WebClient client = HTMLElement.this.getWindow().getWebWindow().getWebClient();
            final Scriptable scope = this.callback_.getParentScope();
            WebRequestSettings settings = new WebRequestSettings(this.url_);
            try {
                WebResponse webResponse = client.loadWebResponse(settings);
                String content = webResponse.getContentAsString();
                HTMLElement.this.getLog().debug((Object)("Downloaded content: " + StringUtils.abbreviate((String)content, (int)512)));
                final Object[] args = new Object[]{content};
                ContextAction action = new ContextAction(){

                    public Object run(Context cx) {
                        DownloadBehaviorDownloader.this.callback_.call(cx, scope, scope, args);
                        return null;
                    }
                };
                HtmlUnitContextFactory cf = client.getJavaScriptEngine().getContextFactory();
                cf.call(action);
            }
            catch (IOException e) {
                HTMLElement.this.getLog().error((Object)("Behavior #default#download: Cannot download " + this.url_), (Throwable)e);
            }
        }
    }

    public static class ProxyDomNode
    extends HtmlDivision {
        private static final long serialVersionUID = -7816775277187498538L;
        private final DomNode target_;
        private boolean append_;

        public ProxyDomNode(SgmlPage page, DomNode target, boolean append) {
            super(null, "div", page, null);
            this.target_ = target;
            this.append_ = append;
        }

        public DomNode appendChild(org.w3c.dom.Node node) {
            DomNode domNode = (DomNode)node;
            if (this.append_) {
                return this.target_.appendChild(domNode);
            }
            this.target_.insertBefore(domNode);
            return domNode;
        }

        public DomNode getDomNode() {
            return this.target_;
        }

        public boolean isAppend() {
            return this.append_;
        }
    }
}

