// $ANTLR 3.4 cz/vutbr/web/csskit/antlr/CSS.g 2013-10-11 18:40:21

package cz.vutbr.web.csskit.antlr;

import org.fit.net.DataURLHandler;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

import java.io.IOException;
import java.net.MalformedURLException;
import java.net.URL;
import java.nio.charset.Charset;
import java.nio.charset.IllegalCharsetNameException;

import cz.vutbr.web.css.StyleSheet;
import cz.vutbr.web.css.CSSException;
import cz.vutbr.web.css.CSSFactory;
import cz.vutbr.web.css.SupportedCSS; 



import org.antlr.runtime.*;
import java.util.Stack;
import java.util.List;
import java.util.ArrayList;

@SuppressWarnings({"all", "warnings", "unchecked"})
public class CSSLexer extends Lexer {
    public static final int EOF=-1;
    public static final int T__99=99;
    public static final int T__100=100;
    public static final int T__101=101;
    public static final int ADJACENT=4;
    public static final int APOS=5;
    public static final int ASTERISK=6;
    public static final int ATBLOCK=7;
    public static final int ATKEYWORD=8;
    public static final int ATTRIBUTE=9;
    public static final int BRACEBLOCK=10;
    public static final int CDC=11;
    public static final int CDO=12;
    public static final int CHARSET=13;
    public static final int CHILD=14;
    public static final int CLASSKEYWORD=15;
    public static final int COLON=16;
    public static final int COMMA=17;
    public static final int COMMENT=18;
    public static final int CONTAINS=19;
    public static final int CURLYBLOCK=20;
    public static final int DASHMATCH=21;
    public static final int DECLARATION=22;
    public static final int DESCENDANT=23;
    public static final int DIMENSION=24;
    public static final int ELEMENT=25;
    public static final int ENDSWITH=26;
    public static final int EQUALS=27;
    public static final int ESCAPE_CHAR=28;
    public static final int EXCLAMATION=29;
    public static final int EXPRESSION=30;
    public static final int FONTFACE=31;
    public static final int FUNCTION=32;
    public static final int GREATER=33;
    public static final int HASH=34;
    public static final int IDENT=35;
    public static final int IDENT_MACR=36;
    public static final int IMPORT=37;
    public static final int IMPORTANT=38;
    public static final int IMPORT_END=39;
    public static final int INCLUDES=40;
    public static final int INDEX=41;
    public static final int INLINESTYLE=42;
    public static final int INTEGER_MACR=43;
    public static final int INVALID_DECLARATION=44;
    public static final int INVALID_DIRECTIVE=45;
    public static final int INVALID_IMPORT=46;
    public static final int INVALID_SELECTOR=47;
    public static final int INVALID_SELPART=48;
    public static final int INVALID_STATEMENT=49;
    public static final int INVALID_STRING=50;
    public static final int INVALID_TOKEN=51;
    public static final int LBRACE=52;
    public static final int LCURLY=53;
    public static final int LESS=54;
    public static final int LPAREN=55;
    public static final int MARGIN_AREA=56;
    public static final int MEDIA=57;
    public static final int MINUS=58;
    public static final int NAME_CHAR=59;
    public static final int NAME_MACR=60;
    public static final int NAME_START=61;
    public static final int NL_CHAR=62;
    public static final int NON_ASCII=63;
    public static final int NUMBER=64;
    public static final int NUMBER_MACR=65;
    public static final int PAGE=66;
    public static final int PARENBLOCK=67;
    public static final int PERCENT=68;
    public static final int PERCENTAGE=69;
    public static final int PLUS=70;
    public static final int PRECEDING=71;
    public static final int PSEUDO=72;
    public static final int QUESTION=73;
    public static final int QUOT=74;
    public static final int RBRACE=75;
    public static final int RCURLY=76;
    public static final int RPAREN=77;
    public static final int RULE=78;
    public static final int S=79;
    public static final int SELECTOR=80;
    public static final int SEMICOLON=81;
    public static final int SET=82;
    public static final int SLASH=83;
    public static final int SL_COMMENT=84;
    public static final int STARTSWITH=85;
    public static final int STRING=86;
    public static final int STRING_CHAR=87;
    public static final int STRING_MACR=88;
    public static final int STYLESHEET=89;
    public static final int TILDE=90;
    public static final int UNIRANGE=91;
    public static final int URI=92;
    public static final int URI_CHAR=93;
    public static final int URI_MACR=94;
    public static final int VALUE=95;
    public static final int VIEWPORT=96;
    public static final int W_CHAR=97;
    public static final int W_MACR=98;

        

        private static Logger log = LoggerFactory.getLogger(CSSLexer.class);
        
        private static SupportedCSS css = CSSFactory.getSupportedCSS();
        
        public static class LexerState {
            
            public enum RecoveryMode {
                BALANCED,
                FUNCTION, 
                RULE,
                DECL
            } 
        
            public short curlyNest;
            public short parenNest;
            public boolean quotOpen;
            public boolean aposOpen;
            
            public LexerState() {
            	this.curlyNest = 0;
            	this.parenNest = 0;
            	this.quotOpen = false;
            	this.aposOpen = false;
            }
            
            public LexerState(LexerState clone) {
            	this();
                this.curlyNest = clone.curlyNest;
                this.parenNest = clone.parenNest;
                this.quotOpen = clone.quotOpen;
                this.aposOpen = clone.aposOpen;
            }
            
            @Override
            public boolean equals(Object o)
            {
                return (this.curlyNest == ((LexerState) o).curlyNest &&
                        this.parenNest == ((LexerState) o).parenNest &&
                        this.quotOpen == ((LexerState) o).quotOpen &&
                        this.aposOpen == ((LexerState) o).aposOpen);
            }
            
            /**
             * Checks whether all pair characters (single and double quotatation marks,
             * curly braces) are balanced
    		     */ 
            public boolean isBalanced() {
            	return aposOpen==false && quotOpen==false && curlyNest==0 && parenNest==0;
            }
            
            /**
             * Checks whether some pair characters are balanced. Modes are:
             * <ul>
             * <li>BALANCED - everything must be balanced: single and double quotatation marks, curly braces, parentheses 
             * <li>FUNCTION - within the function arguments: parentheses must be balanced 
             * <li>RULE - within the CSS rule: all but curly braces
             * <li>DECL - within declaration: all, keep curly braces at desired state
             * </ul> 
             */ 
            public boolean isBalanced(RecoveryMode mode, LexerState state)
            {
                if (mode == RecoveryMode.BALANCED)
                    return aposOpen==false && quotOpen==false && curlyNest==0 && parenNest==0;
                else if (mode == RecoveryMode.FUNCTION)
                    return parenNest==0;
                else if (mode == RecoveryMode.RULE)
                    return aposOpen==false && quotOpen==false && parenNest==0;
                else if (mode == RecoveryMode.DECL)
                    return aposOpen==false && quotOpen==false && parenNest==0 && curlyNest==state.curlyNest;
                else
                    return false;
            }
            
            /**
             * Recovers from unexpected EOF by preparing 
             * new token
             */ 
            public CSSToken generateEOFRecover() {
            	
            	CSSToken t = null;
            
            	if(aposOpen) {
            		this.aposOpen=false;
            		t = new CSSToken(CSSLexer.APOS, this);
            		t.setText("'");
            	}
            	else if(quotOpen) {
            		this.quotOpen=false;
            		t = new CSSToken(CSSLexer.QUOT, this);
            		t.setText("\"");
            	}
            	else if(parenNest!=0) {
            		this.parenNest--;
            		t = new CSSToken(CSSLexer.RPAREN, this);
            		t.setText(")");
            	}
            	else if(curlyNest!=0) {
            		this.curlyNest--;
            		t = new CSSToken(CSSLexer.RCURLY, this);
            		t.setText("}");
            	}
            	
            	log.debug("Recovering from EOF by {}", t);
            	return t;
            }
            
            @Override
            public String toString() {
            	StringBuilder sb = new StringBuilder();
            	sb.append("{=").append(curlyNest)
            	  .append(", (=").append(parenNest)
            	  .append(", '=").append(aposOpen ? "1" : "0")
            	  .append(", \"=").append(quotOpen ? "1" :"0");
            	 
            	return sb.toString();  
            }
        }
        
        private static class LexerStream {
        
        	public CharStream input;
        	public int mark;
        	public LexerState ls;
        	
        	public LexerStream(CharStream input, LexerState ls) {
        	    this.input = input;
        	    this.mark = input.mark();
        	    this.ls = new LexerState(ls);
        	}
        }
        
        // number of already processed tokens (for checking the beginning of the style sheet)
        private int tokencnt = 0;
        
        // lexer states for imported files
        private Stack<LexerStream> imports;
        
        // current lexer state
        private LexerState ls;
        
        // this is for orthogonality
        @SuppressWarnings("unused")
        private StyleSheet stylesheet;
        
        // token recovery
        private Stack<Integer> expectedToken;
        
        /**
         * This function must be called to initialize lexer's state.
         * Because we can't change directly generated constructors.
         * @param stylesheet CSS StyleSheet instance  
         */
        public CSSLexer init(StyleSheet stylesheet) {
    	    this.imports = new Stack<LexerStream>();
    	    this.expectedToken = new Stack<Integer>();
    		this.ls = new LexerState();
    		this.stylesheet = stylesheet;
    		return this;
        }
        
        @Override
        public void reset() {
        	super.reset();
        	this.ls = new LexerState();
        }
        
        /**
         * Overrides next token to match includes and to 
         * recover from EOF
         */
    	@Override 
        public Token nextToken(){
           Token token = nextTokenRecover();

           //count non-empty tokens for eventual checking of the style sheet start
           if (token.getType() == S) {
               tokencnt++;
           }

           // recover from unexpected EOF
           if(token==Token.EOF_TOKEN && !ls.isBalanced()) {
               CSSToken t = ls.generateEOFRecover(); 
               return (Token) t;
           }

           // push back import stream
           // We've got EOF and have non empty stack
           if(token==Token.EOF_TOKEN && !imports.empty()){

           	 // prepare end token 	
           	 CSSToken t = new CSSToken(IMPORT_END, ls);
           	 t.setText("IMPORT_END");
           
             // We've got EOF and have non empty stack.
             LexerStream stream = imports.pop();
             setCharStream(stream.input);
             input.rewind(stream.mark);
             this.ls = stream.ls;
             
             // send created token
             return (Token) t;
             //token = nextTokenRecover();
           }       

           // Skip first token after switching on another input.
           if(((CommonToken)token).getStartIndex() < 0)
             token = nextToken();
            
           return token;
        }

        /**
    	 * Adds contextual information about n      {
    	 esting into token.
    	 */
        @Override
    	public Token emit() {
    		CSSToken t = new CSSToken(input, state.type, state.channel,
                            state.tokenStartCharIndex, getCharIndex()-1);
            t.setLine(state.tokenStartLine);
            t.setText(state.text);
            t.setCharPositionInLine(state.tokenStartCharPositionInLine);
            t.setBase(((CSSInputStream) input).getBase());
            
            // clone lexer state
            t.setLexerState(new LexerState(ls));
            emit(t);
            return t;
    	}

    	@Override
        public void emitErrorMessage(String msg) {
        	log.info("ANTLR: {}", msg);
        }
        
        /**
         * Does special token recovery for some cases
         */ 
        @Override
        public void recover(RecognitionException re) {
        	// there is no special recovery
        	if(expectedToken.isEmpty())
        		super.recover(re);
        	else {
        		switch(expectedToken.pop().intValue()) {
        		
        		case IMPORT:  // IMPORT share recovery rules with CHARSET
        		case CHARSET:
        			final BitSet charsetFollow = BitSet.of((int) '}', (int) ';');
        			consumeUntilBalanced(charsetFollow);
        			break;
        		case STRING:
        			// eat character which should be newline but not EOF
        			if(consumeAnyButEOF()) {
        				// set back to uninitialized state
        				ls.quotOpen = false;
        				ls.aposOpen = false;
        				// create invalid string token
        				state.token = (Token) new CSSToken(INVALID_STRING, ls);
            			state.token.setText("INVALID_STRING");
        			}
        			// we can't just let parser generate missing 
        		    // single/double quot token
        			// because we have not emitted content of string yet!
        			// we will fake string token
        			else {
        				char enclosing = (ls.quotOpen) ? '"' : '\'';
        				ls.quotOpen = false;
        				ls.aposOpen = false;
        				state.token = (Token) new CSSToken(STRING, ls, 
        					state.tokenStartCharIndex, getCharIndex() -1);
            			state.token.setText(
            				input.substring(state.tokenStartCharIndex, getCharIndex() -1)
            				+ enclosing);	
        			}
        			break;
        		default:
        			super.recover(re);
        		}
        	}	
        }
        
        /**
         * Implements Lexer's next token with extra token passing from
         * recovery function 
         */
        private Token nextTokenRecover() {
        	while (true) {
    			state.token = null;
    			state.channel = Token.DEFAULT_CHANNEL;
    			state.tokenStartCharIndex = input.index();
    			state.tokenStartCharPositionInLine = input.getCharPositionInLine();
    			state.tokenStartLine = input.getLine();
    			state.text = null;
    			if ( input.LA(1)==CharStream.EOF ) {
    				return CSSToken.EOF_TOKEN;
    			}
    			try {
    				mTokens();
    				if ( state.token==null ) {
    					emit();
    				}
    				else if ( state.token==Token.SKIP_TOKEN ) {
    					continue;
    				}
    				return state.token;
    			}
    			catch (RecognitionException re) {
    				reportError(re);
    				if ( re instanceof NoViableAltException ) {
    					recover(re); 
    				}

    				// there can be token returned from recovery
                    if(state.token!=null) {
                        state.token.setChannel(Token.INVALID_TOKEN_TYPE);
                      	state.token.setInputStream(input);
                       	state.token.setLine(state.tokenStartLine);
                		state.token.setCharPositionInLine(state.tokenStartCharPositionInLine);
                		emit(state.token);
                		return state.token;
                    }
    			}
    		}
    	}
        
        /**
         * Eats characters until on from follow is found and Lexer state 
         * is balanced at the moment
         */ 
        private void consumeUntilBalanced(BitSet follow) {

        	log.debug("Lexer entered consumeUntilBalanced with {} and follow {}", 
        		ls, follow);
        
        	int c;
    		do {
        		c = input.LA(1);
        		// change apostrophe state
        		if(c=='\'' && ls.quotOpen==false) {
        			ls.aposOpen = !ls.aposOpen;
        		}
        		// change quot state
        		else if (c=='"' && ls.aposOpen==false) {
        			ls.quotOpen = !ls.quotOpen;
        		}
        		else if(c=='(') {
        			ls.parenNest++;
        		}
        		else if(c==')' && ls.parenNest>0) {
        			ls.parenNest--;
        		}
        		else if(c=='{') {
        			ls.curlyNest++;
        		}
        		else if(c=='}' && ls.curlyNest>0) {
        			ls.curlyNest--;
        		}
        		// handle end of line in string
        		else if(c=='\n') {
        			if(ls.quotOpen) ls.quotOpen=false;
        			else if(ls.aposOpen) ls.aposOpen=false;
        		} 
        		else if(c==EOF) {
        			log.info("Unexpected EOF during consumeUntilBalanced, EOF not consumed");
        			return;
        		}
        	
        		input.consume();
        		// log result
        		if(log.isTraceEnabled())
        			log.trace("Lexer consumes '{}'({}) until balanced ({}).", 
        				new Object[] {
        					Character.toString((char) c),
        					Integer.toString(c),
        					ls});
        			
        	}while(!(ls.isBalanced() && follow.member(c)));
        }
        
        /**
         * Consumes arbitrary character but EOF
         * @return <code>false</code> if EOF was matched,
         *         <code>true</code> otherwise and that character was consumed
         */
        private boolean consumeAnyButEOF() {
        
        	int c = input.LA(1);
        	
        	if(c==CharStream.EOF)
        		return false;
        		
        	if(log.isTraceEnabled())
        		log.trace("Lexer consumes '{}' while consumeButEOF", 
        					Character.toString((char)c));
        	
        	// consume character				
        	input.consume();
        	return true;
        }
        
        /**
         * Reads all the contents of an expression. Parenthesis are matched but not in strings.
         */ 
        private String readExpressionContents() 
        {
          log.debug("readExpressionContents"); 
        
          StringBuffer ret = new StringBuffer(); 
          int parenN = 1; /* one already open */
          boolean inApos = false;
          boolean inQuot = false;
          boolean esc = false;
          boolean finished = false;
          int c;
    	    while (!finished)
    	    {
    	        c = input.LA(1);
    	        if(c=='\'' && !inQuot && !(inApos && esc)) {
    	            inApos = !inApos;
    	        }
    	        else if (c=='"' && !inApos && !(inQuot && esc)) {
    	            inQuot = !inQuot;
    	        }
    	        else if(c=='(' && !inApos && !inQuot) {
    	            parenN++;
    	        }
    	        else if(c==')' && parenN>0  && !inApos && !inQuot) {
    	            parenN--;
    	            if (parenN == 0) finished = true;
    	        }
    	        // handle end of line in string
    	        else if (c=='\n') {
    	           inQuot = false;
    	           inApos = false;
    	        } 
    	        else if(c==EOF) {
    	          log.info("Unexpected EOF during consumeUntilBalanced, EOF not consumed");
    	          return ret.toString();
    	        }
    	        
    	        esc = (c == '\\') && !esc;
    	        
    	        if (!finished) ret.append((char) c);
    	        
    	        input.consume();
    	          
    	    }
    	    
    	    log.debug("Expr: " + ret.toString());
          return ret.toString();
        }
        


    // delegates
    // delegators
    public Lexer[] getDelegates() {
        return new Lexer[] {};
    }

    public CSSLexer() {} 
    public CSSLexer(CharStream input) {
        this(input, new RecognizerSharedState());
    }
    public CSSLexer(CharStream input, RecognizerSharedState state) {
        super(input,state);
    }
    public String getGrammarFileName() { return "cz/vutbr/web/csskit/antlr/CSS.g"; }

    // $ANTLR start "T__99"
    public final void mT__99() throws RecognitionException {
        try {
            int _type = T__99;
            int _channel = DEFAULT_TOKEN_CHANNEL;
            // cz/vutbr/web/csskit/antlr/CSS.g:479:7: ( '#' )
            // cz/vutbr/web/csskit/antlr/CSS.g:479:9: '#'
            {
            match('#'); 

            }

            state.type = _type;
            state.channel = _channel;
        }
        finally {
        	// do for sure before leaving
        }
    }
    // $ANTLR end "T__99"

    // $ANTLR start "T__100"
    public final void mT__100() throws RecognitionException {
        try {
            int _type = T__100;
            int _channel = DEFAULT_TOKEN_CHANNEL;
            // cz/vutbr/web/csskit/antlr/CSS.g:480:8: ( '^' )
            // cz/vutbr/web/csskit/antlr/CSS.g:480:10: '^'
            {
            match('^'); 

            }

            state.type = _type;
            state.channel = _channel;
        }
        finally {
        	// do for sure before leaving
        }
    }
    // $ANTLR end "T__100"

    // $ANTLR start "T__101"
    public final void mT__101() throws RecognitionException {
        try {
            int _type = T__101;
            int _channel = DEFAULT_TOKEN_CHANNEL;
            // cz/vutbr/web/csskit/antlr/CSS.g:481:8: ( 'important' )
            // cz/vutbr/web/csskit/antlr/CSS.g:481:10: 'important'
            {
            match("important"); 



            }

            state.type = _type;
            state.channel = _channel;
        }
        finally {
        	// do for sure before leaving
        }
    }
    // $ANTLR end "T__101"

    // $ANTLR start "IDENT"
    public final void mIDENT() throws RecognitionException {
        try {
            int _type = IDENT;
            int _channel = DEFAULT_TOKEN_CHANNEL;
            // cz/vutbr/web/csskit/antlr/CSS.g:1078:2: ( IDENT_MACR )
            // cz/vutbr/web/csskit/antlr/CSS.g:1078:4: IDENT_MACR
            {
            mIDENT_MACR(); 


            }

            state.type = _type;
            state.channel = _channel;
        }
        finally {
        	// do for sure before leaving
        }
    }
    // $ANTLR end "IDENT"

    // $ANTLR start "CHARSET"
    public final void mCHARSET() throws RecognitionException {
        try {
            int _type = CHARSET;
            int _channel = DEFAULT_TOKEN_CHANNEL;
            CommonToken s=null;


            	expectedToken.push(new Integer(CHARSET));

            // cz/vutbr/web/csskit/antlr/CSS.g:1088:2: ( '@charset' ( S )* s= STRING_MACR ( S )* SEMICOLON )
            // cz/vutbr/web/csskit/antlr/CSS.g:1088:4: '@charset' ( S )* s= STRING_MACR ( S )* SEMICOLON
            {
            match("@charset"); 



            // cz/vutbr/web/csskit/antlr/CSS.g:1088:15: ( S )*
            loop1:
            do {
                int alt1=2;
                switch ( input.LA(1) ) {
                case '\t':
                case '\n':
                case '\f':
                case '\r':
                case ' ':
                    {
                    alt1=1;
                    }
                    break;

                }

                switch (alt1) {
            	case 1 :
            	    // cz/vutbr/web/csskit/antlr/CSS.g:1088:15: S
            	    {
            	    mS(); 


            	    }
            	    break;

            	default :
            	    break loop1;
                }
            } while (true);


            int sStart81 = getCharIndex();
            int sStartLine81 = getLine();
            int sStartCharPos81 = getCharPositionInLine();
            mSTRING_MACR(); 
            s = new CommonToken(input, Token.INVALID_TOKEN_TYPE, Token.DEFAULT_CHANNEL, sStart81, getCharIndex()-1);
            s.setLine(sStartLine81);
            s.setCharPositionInLine(sStartCharPos81);


            // cz/vutbr/web/csskit/antlr/CSS.g:1088:32: ( S )*
            loop2:
            do {
                int alt2=2;
                switch ( input.LA(1) ) {
                case '\t':
                case '\n':
                case '\f':
                case '\r':
                case ' ':
                    {
                    alt2=1;
                    }
                    break;

                }

                switch (alt2) {
            	case 1 :
            	    // cz/vutbr/web/csskit/antlr/CSS.g:1088:32: S
            	    {
            	    mS(); 


            	    }
            	    break;

            	default :
            	    break loop2;
                }
            } while (true);


            mSEMICOLON(); 



            	    // we have to trim manually
            	    String enc = CSSToken.extractSTRING(s.getText());
            	    //System.err.println("CHARSET"+tokencnt);
            	    if (tokencnt <= 1) //we are at the beginning of the style sheet
            	    {
            			    try {
            			           log.warn("Changing charset to {}", enc);
            			          ((CSSInputStream) input).setEncoding(enc);
            			          //input = setCharStream(new ANTLFileStream(input.getSourceName(), enc));
            			        }
            			        catch(IllegalCharsetNameException icne) {
            			        	log.warn("Could not change to unsupported charset!", icne);
            			        	throw new RuntimeException(new CSSException("Unsupported charset: " + enc));
            			        }
            			        catch (IOException e) {
                            log.warn("Could not change to unsupported charset!", e);
            			        }
            			 }
            			 else
            			      log.warn("Ignoring @charset rule not at the beginning of the style sheet");
            	  

            }

            state.type = _type;
            state.channel = _channel;

            	expectedToken.pop();

        }
        finally {
        	// do for sure before leaving
        }
    }
    // $ANTLR end "CHARSET"

    // $ANTLR start "IMPORT"
    public final void mIMPORT() throws RecognitionException {
        try {
            int _type = IMPORT;
            int _channel = DEFAULT_TOKEN_CHANNEL;
            CommonToken s=null;
            CommonToken m=null;


            	expectedToken.push(new Integer(IMPORT));
            	StringBuilder media = new StringBuilder();
            	String mText = null;

            // cz/vutbr/web/csskit/antlr/CSS.g:1122:2: ( '@import' ( S )* (s= STRING_MACR |s= URI ) ( S )* (m= IDENT_MACR ( S )* ( ',' ( S )* m= IDENT_MACR ( S )* )* )? SEMICOLON )
            // cz/vutbr/web/csskit/antlr/CSS.g:1122:4: '@import' ( S )* (s= STRING_MACR |s= URI ) ( S )* (m= IDENT_MACR ( S )* ( ',' ( S )* m= IDENT_MACR ( S )* )* )? SEMICOLON
            {
            match("@import"); 



            // cz/vutbr/web/csskit/antlr/CSS.g:1122:14: ( S )*
            loop3:
            do {
                int alt3=2;
                switch ( input.LA(1) ) {
                case '\t':
                case '\n':
                case '\f':
                case '\r':
                case ' ':
                    {
                    alt3=1;
                    }
                    break;

                }

                switch (alt3) {
            	case 1 :
            	    // cz/vutbr/web/csskit/antlr/CSS.g:1122:14: S
            	    {
            	    mS(); 


            	    }
            	    break;

            	default :
            	    break loop3;
                }
            } while (true);


            // cz/vutbr/web/csskit/antlr/CSS.g:1123:4: (s= STRING_MACR |s= URI )
            int alt4=2;
            switch ( input.LA(1) ) {
            case '\"':
            case '\'':
                {
                alt4=1;
                }
                break;
            case 'u':
                {
                alt4=2;
                }
                break;
            default:
                NoViableAltException nvae =
                    new NoViableAltException("", 4, 0, input);

                throw nvae;

            }

            switch (alt4) {
                case 1 :
                    // cz/vutbr/web/csskit/antlr/CSS.g:1123:5: s= STRING_MACR
                    {
                    int sStart124 = getCharIndex();
                    int sStartLine124 = getLine();
                    int sStartCharPos124 = getCharPositionInLine();
                    mSTRING_MACR(); 
                    s = new CommonToken(input, Token.INVALID_TOKEN_TYPE, Token.DEFAULT_CHANNEL, sStart124, getCharIndex()-1);
                    s.setLine(sStartLine124);
                    s.setCharPositionInLine(sStartCharPos124);


                     s.setType(STRING);

                    }
                    break;
                case 2 :
                    // cz/vutbr/web/csskit/antlr/CSS.g:1124:7: s= URI
                    {
                    int sStart137 = getCharIndex();
                    int sStartLine137 = getLine();
                    int sStartCharPos137 = getCharPositionInLine();
                    mURI(); 
                    s = new CommonToken(input, Token.INVALID_TOKEN_TYPE, Token.DEFAULT_CHANNEL, sStart137, getCharIndex()-1);
                    s.setLine(sStartLine137);
                    s.setCharPositionInLine(sStartCharPos137);


                    s.setType(URI);

                    }
                    break;

            }


            // cz/vutbr/web/csskit/antlr/CSS.g:1124:33: ( S )*
            loop5:
            do {
                int alt5=2;
                switch ( input.LA(1) ) {
                case '\t':
                case '\n':
                case '\f':
                case '\r':
                case ' ':
                    {
                    alt5=1;
                    }
                    break;

                }

                switch (alt5) {
            	case 1 :
            	    // cz/vutbr/web/csskit/antlr/CSS.g:1124:33: S
            	    {
            	    mS(); 


            	    }
            	    break;

            	default :
            	    break loop5;
                }
            } while (true);


            // cz/vutbr/web/csskit/antlr/CSS.g:1125:6: (m= IDENT_MACR ( S )* ( ',' ( S )* m= IDENT_MACR ( S )* )* )?
            int alt10=2;
            int LA10_0 = input.LA(1);

            if ( ((LA10_0 >= 'A' && LA10_0 <= 'Z')||LA10_0=='\\'||LA10_0=='_'||(LA10_0 >= 'a' && LA10_0 <= 'z')||(LA10_0 >= '\u0080' && LA10_0 <= '\uD7FF')||(LA10_0 >= '\uE000' && LA10_0 <= '\uFFFD')) ) {
                alt10=1;
            }
            switch (alt10) {
                case 1 :
                    // cz/vutbr/web/csskit/antlr/CSS.g:1125:7: m= IDENT_MACR ( S )* ( ',' ( S )* m= IDENT_MACR ( S )* )*
                    {
                    int mStart153 = getCharIndex();
                    int mStartLine153 = getLine();
                    int mStartCharPos153 = getCharPositionInLine();
                    mIDENT_MACR(); 
                    m = new CommonToken(input, Token.INVALID_TOKEN_TYPE, Token.DEFAULT_CHANNEL, mStart153, getCharIndex()-1);
                    m.setLine(mStartLine153);
                    m.setCharPositionInLine(mStartCharPos153);


                     
                    	        mText = m.getText();
                    	    	if(css.isSupportedMedia(mText)) 
                    	    		media.append(mText); 
                    	    	else
                    	    	    log.debug("Invalid import media \"{}\"", mText);
                    	     

                    // cz/vutbr/web/csskit/antlr/CSS.g:1132:7: ( S )*
                    loop6:
                    do {
                        int alt6=2;
                        switch ( input.LA(1) ) {
                        case '\t':
                        case '\n':
                        case '\f':
                        case '\r':
                        case ' ':
                            {
                            alt6=1;
                            }
                            break;

                        }

                        switch (alt6) {
                    	case 1 :
                    	    // cz/vutbr/web/csskit/antlr/CSS.g:1132:7: S
                    	    {
                    	    mS(); 


                    	    }
                    	    break;

                    	default :
                    	    break loop6;
                        }
                    } while (true);


                    // cz/vutbr/web/csskit/antlr/CSS.g:1133:9: ( ',' ( S )* m= IDENT_MACR ( S )* )*
                    loop9:
                    do {
                        int alt9=2;
                        switch ( input.LA(1) ) {
                        case ',':
                            {
                            alt9=1;
                            }
                            break;

                        }

                        switch (alt9) {
                    	case 1 :
                    	    // cz/vutbr/web/csskit/antlr/CSS.g:1133:10: ',' ( S )* m= IDENT_MACR ( S )*
                    	    {
                    	    match(','); 

                    	    // cz/vutbr/web/csskit/antlr/CSS.g:1133:14: ( S )*
                    	    loop7:
                    	    do {
                    	        int alt7=2;
                    	        switch ( input.LA(1) ) {
                    	        case '\t':
                    	        case '\n':
                    	        case '\f':
                    	        case '\r':
                    	        case ' ':
                    	            {
                    	            alt7=1;
                    	            }
                    	            break;

                    	        }

                    	        switch (alt7) {
                    	    	case 1 :
                    	    	    // cz/vutbr/web/csskit/antlr/CSS.g:1133:14: S
                    	    	    {
                    	    	    mS(); 


                    	    	    }
                    	    	    break;

                    	    	default :
                    	    	    break loop7;
                    	        }
                    	    } while (true);


                    	    int mStart184 = getCharIndex();
                    	    int mStartLine184 = getLine();
                    	    int mStartCharPos184 = getCharPositionInLine();
                    	    mIDENT_MACR(); 
                    	    m = new CommonToken(input, Token.INVALID_TOKEN_TYPE, Token.DEFAULT_CHANNEL, mStart184, getCharIndex()-1);
                    	    m.setLine(mStartLine184);
                    	    m.setCharPositionInLine(mStartCharPos184);


                    	     
                    	    	         mText = m.getText();
                    	    	       	 if(css.isSupportedMedia(mText)) 
                    	    	       	 		media.append(",").append(mText);
                    	    	       	 else
                    	    	    	    log.debug("Invalid import media \"{}\"", mText);		
                    	    	       	

                    	    // cz/vutbr/web/csskit/antlr/CSS.g:1140:9: ( S )*
                    	    loop8:
                    	    do {
                    	        int alt8=2;
                    	        switch ( input.LA(1) ) {
                    	        case '\t':
                    	        case '\n':
                    	        case '\f':
                    	        case '\r':
                    	        case ' ':
                    	            {
                    	            alt8=1;
                    	            }
                    	            break;

                    	        }

                    	        switch (alt8) {
                    	    	case 1 :
                    	    	    // cz/vutbr/web/csskit/antlr/CSS.g:1140:9: S
                    	    	    {
                    	    	    mS(); 


                    	    	    }
                    	    	    break;

                    	    	default :
                    	    	    break loop8;
                    	        }
                    	    } while (true);


                    	    }
                    	    break;

                    	default :
                    	    break loop9;
                        }
                    } while (true);


                    }
                    break;

            }


            mSEMICOLON(); 



            		    // do some funny work with file name to be imported
                    String fileName = s.getText();
                    log.debug("FILE: " + fileName);
                        	  	
                    if(s.getType()==STRING) 
                    	fileName = CSSToken.extractSTRING(fileName);
                    else
                    	fileName = CSSToken.extractURI(fileName);
                        	  	
                    log.info("Will import file \"{}\" with media: {}", 
                      		fileName, media.toString());           	  	
                        	  	
                    // import file
                    URL url = null;
                    try {
                    		    // construct URL
                    		    log.debug("BASE: " + ((CSSInputStream) input).getBase());
                    		    URL base = ((CSSInputStream) input).getBase();
                    		    if (base != null)
                          	    url = DataURLHandler.createURL(base, fileName);
                          	else
                          	{
                          	    log.warn("Base URL is unknown");
                                url = DataURLHandler.createURL(base, fileName);
                          	}
                          	               			
                          	log.debug("Actually, will try to import file \"{}\"", url.toString());	
                          			
                            // save current lexer's stream
                            LexerStream stream = new LexerStream(input, ls);
                            imports.push(stream);
                                	
                            CSSToken t = new CSSToken(IMPORT, ls);
                            t.setText(media.toString());
                                	
                            // switch on new stream
                            String enc = ((CSSInputStream) input).getEncoding();
                            setCharStream(CSSInputStream.urlStream(url, enc));
                            reset();
                                	
                            log.info("File \"{}\" was imported.", url.toString());
                            emit(t);
                     }
                     catch(MalformedURLException mue) {
                     		log.warn("Unable to construct URL for fileName", fileName); 
                          	// set type to invalid import
                            _type = INVALID_IMPORT;
                            setText("INVALID_IMPORT");
                     }              		 
                     catch(IOException fnf) {
                     		log.warn("Cannot read \"{}\" to import: {}", fileName, fnf.getMessage());
                            // restore state
                            imports.pop();
                            // set type to invalid import
                            _type = INVALID_IMPORT;
                            setText("INVALID_IMPORT");
                      }
            	

            }

            state.type = _type;
            state.channel = _channel;

            	expectedToken.pop();

        }
        finally {
        	// do for sure before leaving
        }
    }
    // $ANTLR end "IMPORT"

    // $ANTLR start "MEDIA"
    public final void mMEDIA() throws RecognitionException {
        try {
            int _type = MEDIA;
            int _channel = DEFAULT_TOKEN_CHANNEL;
            // cz/vutbr/web/csskit/antlr/CSS.g:1205:2: ( '@media' )
            // cz/vutbr/web/csskit/antlr/CSS.g:1205:4: '@media'
            {
            match("@media"); 



            }

            state.type = _type;
            state.channel = _channel;
        }
        finally {
        	// do for sure before leaving
        }
    }
    // $ANTLR end "MEDIA"

    // $ANTLR start "PAGE"
    public final void mPAGE() throws RecognitionException {
        try {
            int _type = PAGE;
            int _channel = DEFAULT_TOKEN_CHANNEL;
            // cz/vutbr/web/csskit/antlr/CSS.g:1209:2: ( '@page' )
            // cz/vutbr/web/csskit/antlr/CSS.g:1209:4: '@page'
            {
            match("@page"); 



            }

            state.type = _type;
            state.channel = _channel;
        }
        finally {
        	// do for sure before leaving
        }
    }
    // $ANTLR end "PAGE"

    // $ANTLR start "MARGIN_AREA"
    public final void mMARGIN_AREA() throws RecognitionException {
        try {
            int _type = MARGIN_AREA;
            int _channel = DEFAULT_TOKEN_CHANNEL;
            // cz/vutbr/web/csskit/antlr/CSS.g:1213:3: ( '@top-left-corner' | '@top-left' | '@top-center' | '@top-right' | '@top-right-corner' | '@bottom-left-corner' | '@bottom-left' | '@bottom-center' | '@bottom-right' | '@bottom-right-corner' | '@left-top' | '@left-middle' | '@left-bottom' | '@right-top' | '@right-middle' | '@right-bottom' )
            int alt11=16;
            switch ( input.LA(1) ) {
            case '@':
                {
                switch ( input.LA(2) ) {
                case 't':
                    {
                    switch ( input.LA(3) ) {
                    case 'o':
                        {
                        switch ( input.LA(4) ) {
                        case 'p':
                            {
                            switch ( input.LA(5) ) {
                            case '-':
                                {
                                switch ( input.LA(6) ) {
                                case 'l':
                                    {
                                    switch ( input.LA(7) ) {
                                    case 'e':
                                        {
                                        switch ( input.LA(8) ) {
                                        case 'f':
                                            {
                                            switch ( input.LA(9) ) {
                                            case 't':
                                                {
                                                switch ( input.LA(10) ) {
                                                case '-':
                                                    {
                                                    alt11=1;
                                                    }
                                                    break;
                                                default:
                                                    alt11=2;
                                                }

                                                }
                                                break;
                                            default:
                                                NoViableAltException nvae =
                                                    new NoViableAltException("", 11, 31, input);

                                                throw nvae;

                                            }

                                            }
                                            break;
                                        default:
                                            NoViableAltException nvae =
                                                new NoViableAltException("", 11, 24, input);

                                            throw nvae;

                                        }

                                        }
                                        break;
                                    default:
                                        NoViableAltException nvae =
                                            new NoViableAltException("", 11, 18, input);

                                        throw nvae;

                                    }

                                    }
                                    break;
                                case 'c':
                                    {
                                    alt11=3;
                                    }
                                    break;
                                case 'r':
                                    {
                                    switch ( input.LA(7) ) {
                                    case 'i':
                                        {
                                        switch ( input.LA(8) ) {
                                        case 'g':
                                            {
                                            switch ( input.LA(9) ) {
                                            case 'h':
                                                {
                                                switch ( input.LA(10) ) {
                                                case 't':
                                                    {
                                                    switch ( input.LA(11) ) {
                                                    case '-':
                                                        {
                                                        alt11=5;
                                                        }
                                                        break;
                                                    default:
                                                        alt11=4;
                                                    }

                                                    }
                                                    break;
                                                default:
                                                    NoViableAltException nvae =
                                                        new NoViableAltException("", 11, 38, input);

                                                    throw nvae;

                                                }

                                                }
                                                break;
                                            default:
                                                NoViableAltException nvae =
                                                    new NoViableAltException("", 11, 32, input);

                                                throw nvae;

                                            }

                                            }
                                            break;
                                        default:
                                            NoViableAltException nvae =
                                                new NoViableAltException("", 11, 25, input);

                                            throw nvae;

                                        }

                                        }
                                        break;
                                    default:
                                        NoViableAltException nvae =
                                            new NoViableAltException("", 11, 20, input);

                                        throw nvae;

                                    }

                                    }
                                    break;
                                default:
                                    NoViableAltException nvae =
                                        new NoViableAltException("", 11, 14, input);

                                    throw nvae;

                                }

                                }
                                break;
                            default:
                                NoViableAltException nvae =
                                    new NoViableAltException("", 11, 10, input);

                                throw nvae;

                            }

                            }
                            break;
                        default:
                            NoViableAltException nvae =
                                new NoViableAltException("", 11, 6, input);

                            throw nvae;

                        }

                        }
                        break;
                    default:
                        NoViableAltException nvae =
                            new NoViableAltException("", 11, 2, input);

                        throw nvae;

                    }

                    }
                    break;
                case 'b':
                    {
                    switch ( input.LA(3) ) {
                    case 'o':
                        {
                        switch ( input.LA(4) ) {
                        case 't':
                            {
                            switch ( input.LA(5) ) {
                            case 't':
                                {
                                switch ( input.LA(6) ) {
                                case 'o':
                                    {
                                    switch ( input.LA(7) ) {
                                    case 'm':
                                        {
                                        switch ( input.LA(8) ) {
                                        case '-':
                                            {
                                            switch ( input.LA(9) ) {
                                            case 'l':
                                                {
                                                switch ( input.LA(10) ) {
                                                case 'e':
                                                    {
                                                    switch ( input.LA(11) ) {
                                                    case 'f':
                                                        {
                                                        switch ( input.LA(12) ) {
                                                        case 't':
                                                            {
                                                            switch ( input.LA(13) ) {
                                                            case '-':
                                                                {
                                                                alt11=6;
                                                                }
                                                                break;
                                                            default:
                                                                alt11=7;
                                                            }

                                                            }
                                                            break;
                                                        default:
                                                            NoViableAltException nvae =
                                                                new NoViableAltException("", 11, 49, input);

                                                            throw nvae;

                                                        }

                                                        }
                                                        break;
                                                    default:
                                                        NoViableAltException nvae =
                                                            new NoViableAltException("", 11, 45, input);

                                                        throw nvae;

                                                    }

                                                    }
                                                    break;
                                                default:
                                                    NoViableAltException nvae =
                                                        new NoViableAltException("", 11, 39, input);

                                                    throw nvae;

                                                }

                                                }
                                                break;
                                            case 'c':
                                                {
                                                alt11=8;
                                                }
                                                break;
                                            case 'r':
                                                {
                                                switch ( input.LA(10) ) {
                                                case 'i':
                                                    {
                                                    switch ( input.LA(11) ) {
                                                    case 'g':
                                                        {
                                                        switch ( input.LA(12) ) {
                                                        case 'h':
                                                            {
                                                            switch ( input.LA(13) ) {
                                                            case 't':
                                                                {
                                                                switch ( input.LA(14) ) {
                                                                case '-':
                                                                    {
                                                                    alt11=10;
                                                                    }
                                                                    break;
                                                                default:
                                                                    alt11=9;
                                                                }

                                                                }
                                                                break;
                                                            default:
                                                                NoViableAltException nvae =
                                                                    new NoViableAltException("", 11, 52, input);

                                                                throw nvae;

                                                            }

                                                            }
                                                            break;
                                                        default:
                                                            NoViableAltException nvae =
                                                                new NoViableAltException("", 11, 50, input);

                                                            throw nvae;

                                                        }

                                                        }
                                                        break;
                                                    default:
                                                        NoViableAltException nvae =
                                                            new NoViableAltException("", 11, 46, input);

                                                        throw nvae;

                                                    }

                                                    }
                                                    break;
                                                default:
                                                    NoViableAltException nvae =
                                                        new NoViableAltException("", 11, 41, input);

                                                    throw nvae;

                                                }

                                                }
                                                break;
                                            default:
                                                NoViableAltException nvae =
                                                    new NoViableAltException("", 11, 33, input);

                                                throw nvae;

                                            }

                                            }
                                            break;
                                        default:
                                            NoViableAltException nvae =
                                                new NoViableAltException("", 11, 26, input);

                                            throw nvae;

                                        }

                                        }
                                        break;
                                    default:
                                        NoViableAltException nvae =
                                            new NoViableAltException("", 11, 21, input);

                                        throw nvae;

                                    }

                                    }
                                    break;
                                default:
                                    NoViableAltException nvae =
                                        new NoViableAltException("", 11, 15, input);

                                    throw nvae;

                                }

                                }
                                break;
                            default:
                                NoViableAltException nvae =
                                    new NoViableAltException("", 11, 11, input);

                                throw nvae;

                            }

                            }
                            break;
                        default:
                            NoViableAltException nvae =
                                new NoViableAltException("", 11, 7, input);

                            throw nvae;

                        }

                        }
                        break;
                    default:
                        NoViableAltException nvae =
                            new NoViableAltException("", 11, 3, input);

                        throw nvae;

                    }

                    }
                    break;
                case 'l':
                    {
                    switch ( input.LA(3) ) {
                    case 'e':
                        {
                        switch ( input.LA(4) ) {
                        case 'f':
                            {
                            switch ( input.LA(5) ) {
                            case 't':
                                {
                                switch ( input.LA(6) ) {
                                case '-':
                                    {
                                    switch ( input.LA(7) ) {
                                    case 't':
                                        {
                                        alt11=11;
                                        }
                                        break;
                                    case 'm':
                                        {
                                        alt11=12;
                                        }
                                        break;
                                    case 'b':
                                        {
                                        alt11=13;
                                        }
                                        break;
                                    default:
                                        NoViableAltException nvae =
                                            new NoViableAltException("", 11, 22, input);

                                        throw nvae;

                                    }

                                    }
                                    break;
                                default:
                                    NoViableAltException nvae =
                                        new NoViableAltException("", 11, 16, input);

                                    throw nvae;

                                }

                                }
                                break;
                            default:
                                NoViableAltException nvae =
                                    new NoViableAltException("", 11, 12, input);

                                throw nvae;

                            }

                            }
                            break;
                        default:
                            NoViableAltException nvae =
                                new NoViableAltException("", 11, 8, input);

                            throw nvae;

                        }

                        }
                        break;
                    default:
                        NoViableAltException nvae =
                            new NoViableAltException("", 11, 4, input);

                        throw nvae;

                    }

                    }
                    break;
                case 'r':
                    {
                    switch ( input.LA(3) ) {
                    case 'i':
                        {
                        switch ( input.LA(4) ) {
                        case 'g':
                            {
                            switch ( input.LA(5) ) {
                            case 'h':
                                {
                                switch ( input.LA(6) ) {
                                case 't':
                                    {
                                    switch ( input.LA(7) ) {
                                    case '-':
                                        {
                                        switch ( input.LA(8) ) {
                                        case 't':
                                            {
                                            alt11=14;
                                            }
                                            break;
                                        case 'm':
                                            {
                                            alt11=15;
                                            }
                                            break;
                                        case 'b':
                                            {
                                            alt11=16;
                                            }
                                            break;
                                        default:
                                            NoViableAltException nvae =
                                                new NoViableAltException("", 11, 30, input);

                                            throw nvae;

                                        }

                                        }
                                        break;
                                    default:
                                        NoViableAltException nvae =
                                            new NoViableAltException("", 11, 23, input);

                                        throw nvae;

                                    }

                                    }
                                    break;
                                default:
                                    NoViableAltException nvae =
                                        new NoViableAltException("", 11, 17, input);

                                    throw nvae;

                                }

                                }
                                break;
                            default:
                                NoViableAltException nvae =
                                    new NoViableAltException("", 11, 13, input);

                                throw nvae;

                            }

                            }
                            break;
                        default:
                            NoViableAltException nvae =
                                new NoViableAltException("", 11, 9, input);

                            throw nvae;

                        }

                        }
                        break;
                    default:
                        NoViableAltException nvae =
                            new NoViableAltException("", 11, 5, input);

                        throw nvae;

                    }

                    }
                    break;
                default:
                    NoViableAltException nvae =
                        new NoViableAltException("", 11, 1, input);

                    throw nvae;

                }

                }
                break;
            default:
                NoViableAltException nvae =
                    new NoViableAltException("", 11, 0, input);

                throw nvae;

            }

            switch (alt11) {
                case 1 :
                    // cz/vutbr/web/csskit/antlr/CSS.g:1213:5: '@top-left-corner'
                    {
                    match("@top-left-corner"); 



                    }
                    break;
                case 2 :
                    // cz/vutbr/web/csskit/antlr/CSS.g:1214:5: '@top-left'
                    {
                    match("@top-left"); 



                    }
                    break;
                case 3 :
                    // cz/vutbr/web/csskit/antlr/CSS.g:1215:5: '@top-center'
                    {
                    match("@top-center"); 



                    }
                    break;
                case 4 :
                    // cz/vutbr/web/csskit/antlr/CSS.g:1216:5: '@top-right'
                    {
                    match("@top-right"); 



                    }
                    break;
                case 5 :
                    // cz/vutbr/web/csskit/antlr/CSS.g:1217:5: '@top-right-corner'
                    {
                    match("@top-right-corner"); 



                    }
                    break;
                case 6 :
                    // cz/vutbr/web/csskit/antlr/CSS.g:1218:5: '@bottom-left-corner'
                    {
                    match("@bottom-left-corner"); 



                    }
                    break;
                case 7 :
                    // cz/vutbr/web/csskit/antlr/CSS.g:1219:5: '@bottom-left'
                    {
                    match("@bottom-left"); 



                    }
                    break;
                case 8 :
                    // cz/vutbr/web/csskit/antlr/CSS.g:1220:5: '@bottom-center'
                    {
                    match("@bottom-center"); 



                    }
                    break;
                case 9 :
                    // cz/vutbr/web/csskit/antlr/CSS.g:1221:5: '@bottom-right'
                    {
                    match("@bottom-right"); 



                    }
                    break;
                case 10 :
                    // cz/vutbr/web/csskit/antlr/CSS.g:1222:5: '@bottom-right-corner'
                    {
                    match("@bottom-right-corner"); 



                    }
                    break;
                case 11 :
                    // cz/vutbr/web/csskit/antlr/CSS.g:1223:5: '@left-top'
                    {
                    match("@left-top"); 



                    }
                    break;
                case 12 :
                    // cz/vutbr/web/csskit/antlr/CSS.g:1224:5: '@left-middle'
                    {
                    match("@left-middle"); 



                    }
                    break;
                case 13 :
                    // cz/vutbr/web/csskit/antlr/CSS.g:1225:5: '@left-bottom'
                    {
                    match("@left-bottom"); 



                    }
                    break;
                case 14 :
                    // cz/vutbr/web/csskit/antlr/CSS.g:1226:5: '@right-top'
                    {
                    match("@right-top"); 



                    }
                    break;
                case 15 :
                    // cz/vutbr/web/csskit/antlr/CSS.g:1227:5: '@right-middle'
                    {
                    match("@right-middle"); 



                    }
                    break;
                case 16 :
                    // cz/vutbr/web/csskit/antlr/CSS.g:1228:5: '@right-bottom'
                    {
                    match("@right-bottom"); 



                    }
                    break;

            }
            state.type = _type;
            state.channel = _channel;
        }
        finally {
        	// do for sure before leaving
        }
    }
    // $ANTLR end "MARGIN_AREA"

    // $ANTLR start "VIEWPORT"
    public final void mVIEWPORT() throws RecognitionException {
        try {
            int _type = VIEWPORT;
            int _channel = DEFAULT_TOKEN_CHANNEL;
            // cz/vutbr/web/csskit/antlr/CSS.g:1232:3: ( '@viewport' )
            // cz/vutbr/web/csskit/antlr/CSS.g:1232:5: '@viewport'
            {
            match("@viewport"); 



            }

            state.type = _type;
            state.channel = _channel;
        }
        finally {
        	// do for sure before leaving
        }
    }
    // $ANTLR end "VIEWPORT"

    // $ANTLR start "FONTFACE"
    public final void mFONTFACE() throws RecognitionException {
        try {
            int _type = FONTFACE;
            int _channel = DEFAULT_TOKEN_CHANNEL;
            // cz/vutbr/web/csskit/antlr/CSS.g:1236:3: ( '@font-face' )
            // cz/vutbr/web/csskit/antlr/CSS.g:1236:5: '@font-face'
            {
            match("@font-face"); 



            }

            state.type = _type;
            state.channel = _channel;
        }
        finally {
        	// do for sure before leaving
        }
    }
    // $ANTLR end "FONTFACE"

    // $ANTLR start "ATKEYWORD"
    public final void mATKEYWORD() throws RecognitionException {
        try {
            int _type = ATKEYWORD;
            int _channel = DEFAULT_TOKEN_CHANNEL;
            // cz/vutbr/web/csskit/antlr/CSS.g:1242:2: ( '@' ( MINUS )? IDENT_MACR )
            // cz/vutbr/web/csskit/antlr/CSS.g:1242:4: '@' ( MINUS )? IDENT_MACR
            {
            match('@'); 

            // cz/vutbr/web/csskit/antlr/CSS.g:1242:8: ( MINUS )?
            int alt12=2;
            switch ( input.LA(1) ) {
                case '-':
                    {
                    alt12=1;
                    }
                    break;
            }

            switch (alt12) {
                case 1 :
                    // cz/vutbr/web/csskit/antlr/CSS.g:
                    {
                    if ( input.LA(1)=='-' ) {
                        input.consume();
                    }
                    else {
                        MismatchedSetException mse = new MismatchedSetException(null,input);
                        recover(mse);
                        throw mse;
                    }


                    }
                    break;

            }


            mIDENT_MACR(); 


            }

            state.type = _type;
            state.channel = _channel;
        }
        finally {
        	// do for sure before leaving
        }
    }
    // $ANTLR end "ATKEYWORD"

    // $ANTLR start "CLASSKEYWORD"
    public final void mCLASSKEYWORD() throws RecognitionException {
        try {
            int _type = CLASSKEYWORD;
            int _channel = DEFAULT_TOKEN_CHANNEL;
            // cz/vutbr/web/csskit/antlr/CSS.g:1245:5: ( '.' IDENT_MACR )
            // cz/vutbr/web/csskit/antlr/CSS.g:1245:7: '.' IDENT_MACR
            {
            match('.'); 

            mIDENT_MACR(); 


            }

            state.type = _type;
            state.channel = _channel;
        }
        finally {
        	// do for sure before leaving
        }
    }
    // $ANTLR end "CLASSKEYWORD"

    // $ANTLR start "STRING"
    public final void mSTRING() throws RecognitionException {
        try {
            int _type = STRING;
            int _channel = DEFAULT_TOKEN_CHANNEL;

            	expectedToken.push(new Integer(STRING));

            // cz/vutbr/web/csskit/antlr/CSS.g:1257:2: ( STRING_MACR )
            // cz/vutbr/web/csskit/antlr/CSS.g:1257:4: STRING_MACR
            {
            mSTRING_MACR(); 


            }

            state.type = _type;
            state.channel = _channel;

            	expectedToken.pop();

        }
        finally {
        	// do for sure before leaving
        }
    }
    // $ANTLR end "STRING"

    // $ANTLR start "HASH"
    public final void mHASH() throws RecognitionException {
        try {
            int _type = HASH;
            int _channel = DEFAULT_TOKEN_CHANNEL;
            // cz/vutbr/web/csskit/antlr/CSS.g:1262:2: ( '#' NAME_MACR )
            // cz/vutbr/web/csskit/antlr/CSS.g:1262:4: '#' NAME_MACR
            {
            match('#'); 

            mNAME_MACR(); 


            }

            state.type = _type;
            state.channel = _channel;
        }
        finally {
        	// do for sure before leaving
        }
    }
    // $ANTLR end "HASH"

    // $ANTLR start "INDEX"
    public final void mINDEX() throws RecognitionException {
        try {
            int _type = INDEX;
            int _channel = DEFAULT_TOKEN_CHANNEL;
            // cz/vutbr/web/csskit/antlr/CSS.g:1267:3: ( ( INTEGER_MACR )? ( 'N' | 'n' ) ( ( S )* ( PLUS | MINUS ) ( S )* INTEGER_MACR )? )
            // cz/vutbr/web/csskit/antlr/CSS.g:1267:5: ( INTEGER_MACR )? ( 'N' | 'n' ) ( ( S )* ( PLUS | MINUS ) ( S )* INTEGER_MACR )?
            {
            // cz/vutbr/web/csskit/antlr/CSS.g:1267:5: ( INTEGER_MACR )?
            int alt13=2;
            switch ( input.LA(1) ) {
                case '0':
                case '1':
                case '2':
                case '3':
                case '4':
                case '5':
                case '6':
                case '7':
                case '8':
                case '9':
                    {
                    alt13=1;
                    }
                    break;
            }

            switch (alt13) {
                case 1 :
                    // cz/vutbr/web/csskit/antlr/CSS.g:1267:5: INTEGER_MACR
                    {
                    mINTEGER_MACR(); 


                    }
                    break;

            }


            if ( input.LA(1)=='N'||input.LA(1)=='n' ) {
                input.consume();
            }
            else {
                MismatchedSetException mse = new MismatchedSetException(null,input);
                recover(mse);
                throw mse;
            }


            // cz/vutbr/web/csskit/antlr/CSS.g:1267:31: ( ( S )* ( PLUS | MINUS ) ( S )* INTEGER_MACR )?
            int alt16=2;
            switch ( input.LA(1) ) {
                case '\t':
                case '\n':
                case '\f':
                case '\r':
                case ' ':
                case '+':
                case '-':
                    {
                    alt16=1;
                    }
                    break;
            }

            switch (alt16) {
                case 1 :
                    // cz/vutbr/web/csskit/antlr/CSS.g:1267:32: ( S )* ( PLUS | MINUS ) ( S )* INTEGER_MACR
                    {
                    // cz/vutbr/web/csskit/antlr/CSS.g:1267:32: ( S )*
                    loop14:
                    do {
                        int alt14=2;
                        switch ( input.LA(1) ) {
                        case '\t':
                        case '\n':
                        case '\f':
                        case '\r':
                        case ' ':
                            {
                            alt14=1;
                            }
                            break;

                        }

                        switch (alt14) {
                    	case 1 :
                    	    // cz/vutbr/web/csskit/antlr/CSS.g:1267:32: S
                    	    {
                    	    mS(); 


                    	    }
                    	    break;

                    	default :
                    	    break loop14;
                        }
                    } while (true);


                    if ( input.LA(1)=='+'||input.LA(1)=='-' ) {
                        input.consume();
                    }
                    else {
                        MismatchedSetException mse = new MismatchedSetException(null,input);
                        recover(mse);
                        throw mse;
                    }


                    // cz/vutbr/web/csskit/antlr/CSS.g:1267:50: ( S )*
                    loop15:
                    do {
                        int alt15=2;
                        switch ( input.LA(1) ) {
                        case '\t':
                        case '\n':
                        case '\f':
                        case '\r':
                        case ' ':
                            {
                            alt15=1;
                            }
                            break;

                        }

                        switch (alt15) {
                    	case 1 :
                    	    // cz/vutbr/web/csskit/antlr/CSS.g:1267:50: S
                    	    {
                    	    mS(); 


                    	    }
                    	    break;

                    	default :
                    	    break loop15;
                        }
                    } while (true);


                    mINTEGER_MACR(); 


                    }
                    break;

            }


            }

            state.type = _type;
            state.channel = _channel;
        }
        finally {
        	// do for sure before leaving
        }
    }
    // $ANTLR end "INDEX"

    // $ANTLR start "NUMBER"
    public final void mNUMBER() throws RecognitionException {
        try {
            int _type = NUMBER;
            int _channel = DEFAULT_TOKEN_CHANNEL;
            // cz/vutbr/web/csskit/antlr/CSS.g:1272:2: ( NUMBER_MACR )
            // cz/vutbr/web/csskit/antlr/CSS.g:1272:4: NUMBER_MACR
            {
            mNUMBER_MACR(); 


            }

            state.type = _type;
            state.channel = _channel;
        }
        finally {
        	// do for sure before leaving
        }
    }
    // $ANTLR end "NUMBER"

    // $ANTLR start "PERCENTAGE"
    public final void mPERCENTAGE() throws RecognitionException {
        try {
            int _type = PERCENTAGE;
            int _channel = DEFAULT_TOKEN_CHANNEL;
            // cz/vutbr/web/csskit/antlr/CSS.g:1277:2: ( NUMBER_MACR '%' )
            // cz/vutbr/web/csskit/antlr/CSS.g:1277:4: NUMBER_MACR '%'
            {
            mNUMBER_MACR(); 


            match('%'); 

            }

            state.type = _type;
            state.channel = _channel;
        }
        finally {
        	// do for sure before leaving
        }
    }
    // $ANTLR end "PERCENTAGE"

    // $ANTLR start "DIMENSION"
    public final void mDIMENSION() throws RecognitionException {
        try {
            int _type = DIMENSION;
            int _channel = DEFAULT_TOKEN_CHANNEL;
            // cz/vutbr/web/csskit/antlr/CSS.g:1282:2: ( NUMBER_MACR IDENT_MACR )
            // cz/vutbr/web/csskit/antlr/CSS.g:1282:4: NUMBER_MACR IDENT_MACR
            {
            mNUMBER_MACR(); 


            mIDENT_MACR(); 


            }

            state.type = _type;
            state.channel = _channel;
        }
        finally {
        	// do for sure before leaving
        }
    }
    // $ANTLR end "DIMENSION"

    // $ANTLR start "URI"
    public final void mURI() throws RecognitionException {
        try {
            int _type = URI;
            int _channel = DEFAULT_TOKEN_CHANNEL;
            // cz/vutbr/web/csskit/antlr/CSS.g:1287:2: ( 'url(' W_MACR ( STRING_MACR | URI_MACR ) W_MACR ')' )
            // cz/vutbr/web/csskit/antlr/CSS.g:1287:4: 'url(' W_MACR ( STRING_MACR | URI_MACR ) W_MACR ')'
            {
            match("url("); 



            mW_MACR(); 


            // cz/vutbr/web/csskit/antlr/CSS.g:1287:18: ( STRING_MACR | URI_MACR )
            int alt17=2;
            int LA17_0 = input.LA(1);

            if ( (LA17_0=='\"'||LA17_0=='\'') ) {
                alt17=1;
            }
            else if ( ((LA17_0 >= '\t' && LA17_0 <= '\n')||(LA17_0 >= '\f' && LA17_0 <= '\r')||(LA17_0 >= ' ' && LA17_0 <= '!')||(LA17_0 >= '#' && LA17_0 <= '&')||(LA17_0 >= ')' && LA17_0 <= '~')||(LA17_0 >= '\u0080' && LA17_0 <= '\uD7FF')||(LA17_0 >= '\uE000' && LA17_0 <= '\uFFFD')) ) {
                alt17=2;
            }
            else {
                NoViableAltException nvae =
                    new NoViableAltException("", 17, 0, input);

                throw nvae;

            }
            switch (alt17) {
                case 1 :
                    // cz/vutbr/web/csskit/antlr/CSS.g:1287:19: STRING_MACR
                    {
                    mSTRING_MACR(); 


                    }
                    break;
                case 2 :
                    // cz/vutbr/web/csskit/antlr/CSS.g:1287:33: URI_MACR
                    {
                    mURI_MACR(); 


                    }
                    break;

            }


            mW_MACR(); 


            match(')'); 

            }

            state.type = _type;
            state.channel = _channel;
        }
        finally {
        	// do for sure before leaving
        }
    }
    // $ANTLR end "URI"

    // $ANTLR start "UNIRANGE"
    public final void mUNIRANGE() throws RecognitionException {
        try {
            int _type = UNIRANGE;
            int _channel = DEFAULT_TOKEN_CHANNEL;
            // cz/vutbr/web/csskit/antlr/CSS.g:1291:9: ( 'U+' ( '0' .. '9' | 'a' .. 'f' | 'A' .. 'F' | '?' ) ( '0' .. '9' | 'a' .. 'f' | 'A' .. 'F' | '?' ) ( '0' .. '9' | 'a' .. 'f' | 'A' .. 'F' | '?' ) ( '0' .. '9' | 'a' .. 'f' | 'A' .. 'F' | '?' ) ( ( '0' .. '9' | 'a' .. 'f' | 'A' .. 'F' | '?' ) ( '0' .. '9' | 'a' .. 'f' | 'A' .. 'F' | '?' ) )? ( '-' ( '0' .. '9' | 'a' .. 'f' | 'A' .. 'F' ) ( '0' .. '9' | 'a' .. 'f' | 'A' .. 'F' ) ( '0' .. '9' | 'a' .. 'f' | 'A' .. 'F' ) ( '0' .. '9' | 'a' .. 'f' | 'A' .. 'F' ) ( ( '0' .. '9' | 'a' .. 'f' | 'A' .. 'F' ) ( '0' .. '9' | 'a' .. 'f' | 'A' .. 'F' ) )? )? )
            // cz/vutbr/web/csskit/antlr/CSS.g:1292:2: 'U+' ( '0' .. '9' | 'a' .. 'f' | 'A' .. 'F' | '?' ) ( '0' .. '9' | 'a' .. 'f' | 'A' .. 'F' | '?' ) ( '0' .. '9' | 'a' .. 'f' | 'A' .. 'F' | '?' ) ( '0' .. '9' | 'a' .. 'f' | 'A' .. 'F' | '?' ) ( ( '0' .. '9' | 'a' .. 'f' | 'A' .. 'F' | '?' ) ( '0' .. '9' | 'a' .. 'f' | 'A' .. 'F' | '?' ) )? ( '-' ( '0' .. '9' | 'a' .. 'f' | 'A' .. 'F' ) ( '0' .. '9' | 'a' .. 'f' | 'A' .. 'F' ) ( '0' .. '9' | 'a' .. 'f' | 'A' .. 'F' ) ( '0' .. '9' | 'a' .. 'f' | 'A' .. 'F' ) ( ( '0' .. '9' | 'a' .. 'f' | 'A' .. 'F' ) ( '0' .. '9' | 'a' .. 'f' | 'A' .. 'F' ) )? )?
            {
            match("U+"); 



            if ( (input.LA(1) >= '0' && input.LA(1) <= '9')||input.LA(1)=='?'||(input.LA(1) >= 'A' && input.LA(1) <= 'F')||(input.LA(1) >= 'a' && input.LA(1) <= 'f') ) {
                input.consume();
            }
            else {
                MismatchedSetException mse = new MismatchedSetException(null,input);
                recover(mse);
                throw mse;
            }


            if ( (input.LA(1) >= '0' && input.LA(1) <= '9')||input.LA(1)=='?'||(input.LA(1) >= 'A' && input.LA(1) <= 'F')||(input.LA(1) >= 'a' && input.LA(1) <= 'f') ) {
                input.consume();
            }
            else {
                MismatchedSetException mse = new MismatchedSetException(null,input);
                recover(mse);
                throw mse;
            }


            if ( (input.LA(1) >= '0' && input.LA(1) <= '9')||input.LA(1)=='?'||(input.LA(1) >= 'A' && input.LA(1) <= 'F')||(input.LA(1) >= 'a' && input.LA(1) <= 'f') ) {
                input.consume();
            }
            else {
                MismatchedSetException mse = new MismatchedSetException(null,input);
                recover(mse);
                throw mse;
            }


            if ( (input.LA(1) >= '0' && input.LA(1) <= '9')||input.LA(1)=='?'||(input.LA(1) >= 'A' && input.LA(1) <= 'F')||(input.LA(1) >= 'a' && input.LA(1) <= 'f') ) {
                input.consume();
            }
            else {
                MismatchedSetException mse = new MismatchedSetException(null,input);
                recover(mse);
                throw mse;
            }


            // cz/vutbr/web/csskit/antlr/CSS.g:1296:7: ( ( '0' .. '9' | 'a' .. 'f' | 'A' .. 'F' | '?' ) ( '0' .. '9' | 'a' .. 'f' | 'A' .. 'F' | '?' ) )?
            int alt18=2;
            switch ( input.LA(1) ) {
                case '0':
                case '1':
                case '2':
                case '3':
                case '4':
                case '5':
                case '6':
                case '7':
                case '8':
                case '9':
                case '?':
                case 'A':
                case 'B':
                case 'C':
                case 'D':
                case 'E':
                case 'F':
                case 'a':
                case 'b':
                case 'c':
                case 'd':
                case 'e':
                case 'f':
                    {
                    alt18=1;
                    }
                    break;
            }

            switch (alt18) {
                case 1 :
                    // cz/vutbr/web/csskit/antlr/CSS.g:1296:8: ( '0' .. '9' | 'a' .. 'f' | 'A' .. 'F' | '?' ) ( '0' .. '9' | 'a' .. 'f' | 'A' .. 'F' | '?' )
                    {
                    if ( (input.LA(1) >= '0' && input.LA(1) <= '9')||input.LA(1)=='?'||(input.LA(1) >= 'A' && input.LA(1) <= 'F')||(input.LA(1) >= 'a' && input.LA(1) <= 'f') ) {
                        input.consume();
                    }
                    else {
                        MismatchedSetException mse = new MismatchedSetException(null,input);
                        recover(mse);
                        throw mse;
                    }


                    if ( (input.LA(1) >= '0' && input.LA(1) <= '9')||input.LA(1)=='?'||(input.LA(1) >= 'A' && input.LA(1) <= 'F')||(input.LA(1) >= 'a' && input.LA(1) <= 'f') ) {
                        input.consume();
                    }
                    else {
                        MismatchedSetException mse = new MismatchedSetException(null,input);
                        recover(mse);
                        throw mse;
                    }


                    }
                    break;

            }


            // cz/vutbr/web/csskit/antlr/CSS.g:1297:2: ( '-' ( '0' .. '9' | 'a' .. 'f' | 'A' .. 'F' ) ( '0' .. '9' | 'a' .. 'f' | 'A' .. 'F' ) ( '0' .. '9' | 'a' .. 'f' | 'A' .. 'F' ) ( '0' .. '9' | 'a' .. 'f' | 'A' .. 'F' ) ( ( '0' .. '9' | 'a' .. 'f' | 'A' .. 'F' ) ( '0' .. '9' | 'a' .. 'f' | 'A' .. 'F' ) )? )?
            int alt20=2;
            switch ( input.LA(1) ) {
                case '-':
                    {
                    alt20=1;
                    }
                    break;
            }

            switch (alt20) {
                case 1 :
                    // cz/vutbr/web/csskit/antlr/CSS.g:1297:3: '-' ( '0' .. '9' | 'a' .. 'f' | 'A' .. 'F' ) ( '0' .. '9' | 'a' .. 'f' | 'A' .. 'F' ) ( '0' .. '9' | 'a' .. 'f' | 'A' .. 'F' ) ( '0' .. '9' | 'a' .. 'f' | 'A' .. 'F' ) ( ( '0' .. '9' | 'a' .. 'f' | 'A' .. 'F' ) ( '0' .. '9' | 'a' .. 'f' | 'A' .. 'F' ) )?
                    {
                    match('-'); 

                    if ( (input.LA(1) >= '0' && input.LA(1) <= '9')||(input.LA(1) >= 'A' && input.LA(1) <= 'F')||(input.LA(1) >= 'a' && input.LA(1) <= 'f') ) {
                        input.consume();
                    }
                    else {
                        MismatchedSetException mse = new MismatchedSetException(null,input);
                        recover(mse);
                        throw mse;
                    }


                    if ( (input.LA(1) >= '0' && input.LA(1) <= '9')||(input.LA(1) >= 'A' && input.LA(1) <= 'F')||(input.LA(1) >= 'a' && input.LA(1) <= 'f') ) {
                        input.consume();
                    }
                    else {
                        MismatchedSetException mse = new MismatchedSetException(null,input);
                        recover(mse);
                        throw mse;
                    }


                    if ( (input.LA(1) >= '0' && input.LA(1) <= '9')||(input.LA(1) >= 'A' && input.LA(1) <= 'F')||(input.LA(1) >= 'a' && input.LA(1) <= 'f') ) {
                        input.consume();
                    }
                    else {
                        MismatchedSetException mse = new MismatchedSetException(null,input);
                        recover(mse);
                        throw mse;
                    }


                    if ( (input.LA(1) >= '0' && input.LA(1) <= '9')||(input.LA(1) >= 'A' && input.LA(1) <= 'F')||(input.LA(1) >= 'a' && input.LA(1) <= 'f') ) {
                        input.consume();
                    }
                    else {
                        MismatchedSetException mse = new MismatchedSetException(null,input);
                        recover(mse);
                        throw mse;
                    }


                    // cz/vutbr/web/csskit/antlr/CSS.g:1302:14: ( ( '0' .. '9' | 'a' .. 'f' | 'A' .. 'F' ) ( '0' .. '9' | 'a' .. 'f' | 'A' .. 'F' ) )?
                    int alt19=2;
                    switch ( input.LA(1) ) {
                        case '0':
                        case '1':
                        case '2':
                        case '3':
                        case '4':
                        case '5':
                        case '6':
                        case '7':
                        case '8':
                        case '9':
                        case 'A':
                        case 'B':
                        case 'C':
                        case 'D':
                        case 'E':
                        case 'F':
                        case 'a':
                        case 'b':
                        case 'c':
                        case 'd':
                        case 'e':
                        case 'f':
                            {
                            alt19=1;
                            }
                            break;
                    }

                    switch (alt19) {
                        case 1 :
                            // cz/vutbr/web/csskit/antlr/CSS.g:1302:15: ( '0' .. '9' | 'a' .. 'f' | 'A' .. 'F' ) ( '0' .. '9' | 'a' .. 'f' | 'A' .. 'F' )
                            {
                            if ( (input.LA(1) >= '0' && input.LA(1) <= '9')||(input.LA(1) >= 'A' && input.LA(1) <= 'F')||(input.LA(1) >= 'a' && input.LA(1) <= 'f') ) {
                                input.consume();
                            }
                            else {
                                MismatchedSetException mse = new MismatchedSetException(null,input);
                                recover(mse);
                                throw mse;
                            }


                            if ( (input.LA(1) >= '0' && input.LA(1) <= '9')||(input.LA(1) >= 'A' && input.LA(1) <= 'F')||(input.LA(1) >= 'a' && input.LA(1) <= 'f') ) {
                                input.consume();
                            }
                            else {
                                MismatchedSetException mse = new MismatchedSetException(null,input);
                                recover(mse);
                                throw mse;
                            }


                            }
                            break;

                    }


                    }
                    break;

            }


            }

            state.type = _type;
            state.channel = _channel;
        }
        finally {
        	// do for sure before leaving
        }
    }
    // $ANTLR end "UNIRANGE"

    // $ANTLR start "CDO"
    public final void mCDO() throws RecognitionException {
        try {
            int _type = CDO;
            int _channel = DEFAULT_TOKEN_CHANNEL;
            // cz/vutbr/web/csskit/antlr/CSS.g:1308:2: ( '<!--' )
            // cz/vutbr/web/csskit/antlr/CSS.g:1308:4: '<!--'
            {
            match("<!--"); 



            }

            state.type = _type;
            state.channel = _channel;
        }
        finally {
        	// do for sure before leaving
        }
    }
    // $ANTLR end "CDO"

    // $ANTLR start "CDC"
    public final void mCDC() throws RecognitionException {
        try {
            int _type = CDC;
            int _channel = DEFAULT_TOKEN_CHANNEL;
            // cz/vutbr/web/csskit/antlr/CSS.g:1313:2: ( '-->' )
            // cz/vutbr/web/csskit/antlr/CSS.g:1313:4: '-->'
            {
            match("-->"); 



            }

            state.type = _type;
            state.channel = _channel;
        }
        finally {
        	// do for sure before leaving
        }
    }
    // $ANTLR end "CDC"

    // $ANTLR start "SEMICOLON"
    public final void mSEMICOLON() throws RecognitionException {
        try {
            int _type = SEMICOLON;
            int _channel = DEFAULT_TOKEN_CHANNEL;
            // cz/vutbr/web/csskit/antlr/CSS.g:1316:2: ( ';' )
            // cz/vutbr/web/csskit/antlr/CSS.g:1316:4: ';'
            {
            match(';'); 

            }

            state.type = _type;
            state.channel = _channel;
        }
        finally {
        	// do for sure before leaving
        }
    }
    // $ANTLR end "SEMICOLON"

    // $ANTLR start "COLON"
    public final void mCOLON() throws RecognitionException {
        try {
            int _type = COLON;
            int _channel = DEFAULT_TOKEN_CHANNEL;
            // cz/vutbr/web/csskit/antlr/CSS.g:1320:2: ( ':' )
            // cz/vutbr/web/csskit/antlr/CSS.g:1320:4: ':'
            {
            match(':'); 

            }

            state.type = _type;
            state.channel = _channel;
        }
        finally {
        	// do for sure before leaving
        }
    }
    // $ANTLR end "COLON"

    // $ANTLR start "COMMA"
    public final void mCOMMA() throws RecognitionException {
        try {
            int _type = COMMA;
            int _channel = DEFAULT_TOKEN_CHANNEL;
            // cz/vutbr/web/csskit/antlr/CSS.g:1324:5: ( ',' )
            // cz/vutbr/web/csskit/antlr/CSS.g:1324:7: ','
            {
            match(','); 

            }

            state.type = _type;
            state.channel = _channel;
        }
        finally {
        	// do for sure before leaving
        }
    }
    // $ANTLR end "COMMA"

    // $ANTLR start "QUESTION"
    public final void mQUESTION() throws RecognitionException {
        try {
            int _type = QUESTION;
            int _channel = DEFAULT_TOKEN_CHANNEL;
            // cz/vutbr/web/csskit/antlr/CSS.g:1328:2: ( '?' )
            // cz/vutbr/web/csskit/antlr/CSS.g:1328:4: '?'
            {
            match('?'); 

            }

            state.type = _type;
            state.channel = _channel;
        }
        finally {
        	// do for sure before leaving
        }
    }
    // $ANTLR end "QUESTION"

    // $ANTLR start "PERCENT"
    public final void mPERCENT() throws RecognitionException {
        try {
            int _type = PERCENT;
            int _channel = DEFAULT_TOKEN_CHANNEL;
            // cz/vutbr/web/csskit/antlr/CSS.g:1332:2: ( '%' )
            // cz/vutbr/web/csskit/antlr/CSS.g:1332:4: '%'
            {
            match('%'); 

            }

            state.type = _type;
            state.channel = _channel;
        }
        finally {
        	// do for sure before leaving
        }
    }
    // $ANTLR end "PERCENT"

    // $ANTLR start "EQUALS"
    public final void mEQUALS() throws RecognitionException {
        try {
            int _type = EQUALS;
            int _channel = DEFAULT_TOKEN_CHANNEL;
            // cz/vutbr/web/csskit/antlr/CSS.g:1336:5: ( '=' )
            // cz/vutbr/web/csskit/antlr/CSS.g:1336:7: '='
            {
            match('='); 

            }

            state.type = _type;
            state.channel = _channel;
        }
        finally {
        	// do for sure before leaving
        }
    }
    // $ANTLR end "EQUALS"

    // $ANTLR start "SLASH"
    public final void mSLASH() throws RecognitionException {
        try {
            int _type = SLASH;
            int _channel = DEFAULT_TOKEN_CHANNEL;
            // cz/vutbr/web/csskit/antlr/CSS.g:1340:5: ( '/' )
            // cz/vutbr/web/csskit/antlr/CSS.g:1340:7: '/'
            {
            match('/'); 

            }

            state.type = _type;
            state.channel = _channel;
        }
        finally {
        	// do for sure before leaving
        }
    }
    // $ANTLR end "SLASH"

    // $ANTLR start "GREATER"
    public final void mGREATER() throws RecognitionException {
        try {
            int _type = GREATER;
            int _channel = DEFAULT_TOKEN_CHANNEL;
            // cz/vutbr/web/csskit/antlr/CSS.g:1344:5: ( '>' )
            // cz/vutbr/web/csskit/antlr/CSS.g:1344:7: '>'
            {
            match('>'); 

            }

            state.type = _type;
            state.channel = _channel;
        }
        finally {
        	// do for sure before leaving
        }
    }
    // $ANTLR end "GREATER"

    // $ANTLR start "LESS"
    public final void mLESS() throws RecognitionException {
        try {
            int _type = LESS;
            int _channel = DEFAULT_TOKEN_CHANNEL;
            // cz/vutbr/web/csskit/antlr/CSS.g:1348:5: ( '<' )
            // cz/vutbr/web/csskit/antlr/CSS.g:1348:7: '<'
            {
            match('<'); 

            }

            state.type = _type;
            state.channel = _channel;
        }
        finally {
        	// do for sure before leaving
        }
    }
    // $ANTLR end "LESS"

    // $ANTLR start "LCURLY"
    public final void mLCURLY() throws RecognitionException {
        try {
            int _type = LCURLY;
            int _channel = DEFAULT_TOKEN_CHANNEL;
            // cz/vutbr/web/csskit/antlr/CSS.g:1352:2: ( '{' )
            // cz/vutbr/web/csskit/antlr/CSS.g:1352:4: '{'
            {
            match('{'); 

            ls.curlyNest++;

            }

            state.type = _type;
            state.channel = _channel;
        }
        finally {
        	// do for sure before leaving
        }
    }
    // $ANTLR end "LCURLY"

    // $ANTLR start "RCURLY"
    public final void mRCURLY() throws RecognitionException {
        try {
            int _type = RCURLY;
            int _channel = DEFAULT_TOKEN_CHANNEL;
            // cz/vutbr/web/csskit/antlr/CSS.g:1356:2: ( '}' )
            // cz/vutbr/web/csskit/antlr/CSS.g:1356:4: '}'
            {
            match('}'); 

             if(ls.curlyNest>0) ls.curlyNest--;

            }

            state.type = _type;
            state.channel = _channel;
        }
        finally {
        	// do for sure before leaving
        }
    }
    // $ANTLR end "RCURLY"

    // $ANTLR start "APOS"
    public final void mAPOS() throws RecognitionException {
        try {
            int _type = APOS;
            int _channel = DEFAULT_TOKEN_CHANNEL;
            // cz/vutbr/web/csskit/antlr/CSS.g:1360:2: ( '\\'' )
            // cz/vutbr/web/csskit/antlr/CSS.g:1360:4: '\\''
            {
            match('\''); 

             ls.aposOpen=!ls.aposOpen; 

            }

            state.type = _type;
            state.channel = _channel;
        }
        finally {
        	// do for sure before leaving
        }
    }
    // $ANTLR end "APOS"

    // $ANTLR start "QUOT"
    public final void mQUOT() throws RecognitionException {
        try {
            int _type = QUOT;
            int _channel = DEFAULT_TOKEN_CHANNEL;
            // cz/vutbr/web/csskit/antlr/CSS.g:1364:2: ( '\"' )
            // cz/vutbr/web/csskit/antlr/CSS.g:1364:4: '\"'
            {
            match('\"'); 

             ls.quotOpen=!ls.quotOpen; 

            }

            state.type = _type;
            state.channel = _channel;
        }
        finally {
        	// do for sure before leaving
        }
    }
    // $ANTLR end "QUOT"

    // $ANTLR start "LPAREN"
    public final void mLPAREN() throws RecognitionException {
        try {
            int _type = LPAREN;
            int _channel = DEFAULT_TOKEN_CHANNEL;
            // cz/vutbr/web/csskit/antlr/CSS.g:1368:2: ( '(' )
            // cz/vutbr/web/csskit/antlr/CSS.g:1368:4: '('
            {
            match('('); 

            ls.parenNest++; 

            }

            state.type = _type;
            state.channel = _channel;
        }
        finally {
        	// do for sure before leaving
        }
    }
    // $ANTLR end "LPAREN"

    // $ANTLR start "RPAREN"
    public final void mRPAREN() throws RecognitionException {
        try {
            int _type = RPAREN;
            int _channel = DEFAULT_TOKEN_CHANNEL;
            // cz/vutbr/web/csskit/antlr/CSS.g:1372:2: ( ')' )
            // cz/vutbr/web/csskit/antlr/CSS.g:1372:4: ')'
            {
            match(')'); 

             if(ls.parenNest>0) ls.parenNest--; 

            }

            state.type = _type;
            state.channel = _channel;
        }
        finally {
        	// do for sure before leaving
        }
    }
    // $ANTLR end "RPAREN"

    // $ANTLR start "LBRACE"
    public final void mLBRACE() throws RecognitionException {
        try {
            int _type = LBRACE;
            int _channel = DEFAULT_TOKEN_CHANNEL;
            // cz/vutbr/web/csskit/antlr/CSS.g:1376:2: ( '[' )
            // cz/vutbr/web/csskit/antlr/CSS.g:1376:4: '['
            {
            match('['); 

            }

            state.type = _type;
            state.channel = _channel;
        }
        finally {
        	// do for sure before leaving
        }
    }
    // $ANTLR end "LBRACE"

    // $ANTLR start "RBRACE"
    public final void mRBRACE() throws RecognitionException {
        try {
            int _type = RBRACE;
            int _channel = DEFAULT_TOKEN_CHANNEL;
            // cz/vutbr/web/csskit/antlr/CSS.g:1380:2: ( ']' )
            // cz/vutbr/web/csskit/antlr/CSS.g:1380:4: ']'
            {
            match(']'); 

            }

            state.type = _type;
            state.channel = _channel;
        }
        finally {
        	// do for sure before leaving
        }
    }
    // $ANTLR end "RBRACE"

    // $ANTLR start "EXCLAMATION"
    public final void mEXCLAMATION() throws RecognitionException {
        try {
            int _type = EXCLAMATION;
            int _channel = DEFAULT_TOKEN_CHANNEL;
            // cz/vutbr/web/csskit/antlr/CSS.g:1384:5: ( '!' )
            // cz/vutbr/web/csskit/antlr/CSS.g:1384:7: '!'
            {
            match('!'); 

            }

            state.type = _type;
            state.channel = _channel;
        }
        finally {
        	// do for sure before leaving
        }
    }
    // $ANTLR end "EXCLAMATION"

    // $ANTLR start "TILDE"
    public final void mTILDE() throws RecognitionException {
        try {
            int _type = TILDE;
            int _channel = DEFAULT_TOKEN_CHANNEL;
            // cz/vutbr/web/csskit/antlr/CSS.g:1388:3: ( '~' )
            // cz/vutbr/web/csskit/antlr/CSS.g:1388:5: '~'
            {
            match('~'); 

            }

            state.type = _type;
            state.channel = _channel;
        }
        finally {
        	// do for sure before leaving
        }
    }
    // $ANTLR end "TILDE"

    // $ANTLR start "MINUS"
    public final void mMINUS() throws RecognitionException {
        try {
            int _type = MINUS;
            int _channel = DEFAULT_TOKEN_CHANNEL;
            // cz/vutbr/web/csskit/antlr/CSS.g:1392:2: ( '-' )
            // cz/vutbr/web/csskit/antlr/CSS.g:1392:4: '-'
            {
            match('-'); 

            }

            state.type = _type;
            state.channel = _channel;
        }
        finally {
        	// do for sure before leaving
        }
    }
    // $ANTLR end "MINUS"

    // $ANTLR start "PLUS"
    public final void mPLUS() throws RecognitionException {
        try {
            int _type = PLUS;
            int _channel = DEFAULT_TOKEN_CHANNEL;
            // cz/vutbr/web/csskit/antlr/CSS.g:1396:2: ( '+' )
            // cz/vutbr/web/csskit/antlr/CSS.g:1396:4: '+'
            {
            match('+'); 

            }

            state.type = _type;
            state.channel = _channel;
        }
        finally {
        	// do for sure before leaving
        }
    }
    // $ANTLR end "PLUS"

    // $ANTLR start "ASTERISK"
    public final void mASTERISK() throws RecognitionException {
        try {
            int _type = ASTERISK;
            int _channel = DEFAULT_TOKEN_CHANNEL;
            // cz/vutbr/web/csskit/antlr/CSS.g:1400:2: ( '*' )
            // cz/vutbr/web/csskit/antlr/CSS.g:1400:4: '*'
            {
            match('*'); 

            }

            state.type = _type;
            state.channel = _channel;
        }
        finally {
        	// do for sure before leaving
        }
    }
    // $ANTLR end "ASTERISK"

    // $ANTLR start "S"
    public final void mS() throws RecognitionException {
        try {
            int _type = S;
            int _channel = DEFAULT_TOKEN_CHANNEL;
            // cz/vutbr/web/csskit/antlr/CSS.g:1406:2: ( ( W_CHAR )+ )
            // cz/vutbr/web/csskit/antlr/CSS.g:1406:4: ( W_CHAR )+
            {
            // cz/vutbr/web/csskit/antlr/CSS.g:1406:4: ( W_CHAR )+
            int cnt21=0;
            loop21:
            do {
                int alt21=2;
                switch ( input.LA(1) ) {
                case '\t':
                case '\n':
                case '\f':
                case '\r':
                case ' ':
                    {
                    alt21=1;
                    }
                    break;

                }

                switch (alt21) {
            	case 1 :
            	    // cz/vutbr/web/csskit/antlr/CSS.g:
            	    {
            	    if ( (input.LA(1) >= '\t' && input.LA(1) <= '\n')||(input.LA(1) >= '\f' && input.LA(1) <= '\r')||input.LA(1)==' ' ) {
            	        input.consume();
            	    }
            	    else {
            	        MismatchedSetException mse = new MismatchedSetException(null,input);
            	        recover(mse);
            	        throw mse;
            	    }


            	    }
            	    break;

            	default :
            	    if ( cnt21 >= 1 ) break loop21;
                        EarlyExitException eee =
                            new EarlyExitException(21, input);
                        throw eee;
                }
                cnt21++;
            } while (true);


            }

            state.type = _type;
            state.channel = _channel;
        }
        finally {
        	// do for sure before leaving
        }
    }
    // $ANTLR end "S"

    // $ANTLR start "COMMENT"
    public final void mCOMMENT() throws RecognitionException {
        try {
            int _type = COMMENT;
            int _channel = DEFAULT_TOKEN_CHANNEL;
            // cz/vutbr/web/csskit/antlr/CSS.g:1409:2: ( '/*' ( options {greedy=false; } : . )* '*/' )
            // cz/vutbr/web/csskit/antlr/CSS.g:1409:4: '/*' ( options {greedy=false; } : . )* '*/'
            {
            match("/*"); 



            // cz/vutbr/web/csskit/antlr/CSS.g:1409:9: ( options {greedy=false; } : . )*
            loop22:
            do {
                int alt22=2;
                int LA22_0 = input.LA(1);

                if ( (LA22_0=='*') ) {
                    int LA22_1 = input.LA(2);

                    if ( (LA22_1=='/') ) {
                        alt22=2;
                    }
                    else if ( ((LA22_1 >= '\u0000' && LA22_1 <= '.')||(LA22_1 >= '0' && LA22_1 <= '\uFFFF')) ) {
                        alt22=1;
                    }


                }
                else if ( ((LA22_0 >= '\u0000' && LA22_0 <= ')')||(LA22_0 >= '+' && LA22_0 <= '\uFFFF')) ) {
                    alt22=1;
                }


                switch (alt22) {
            	case 1 :
            	    // cz/vutbr/web/csskit/antlr/CSS.g:1409:37: .
            	    {
            	    matchAny(); 

            	    }
            	    break;

            	default :
            	    break loop22;
                }
            } while (true);


            match("*/"); 



             _channel = HIDDEN; 

            }

            state.type = _type;
            state.channel = _channel;
        }
        finally {
        	// do for sure before leaving
        }
    }
    // $ANTLR end "COMMENT"

    // $ANTLR start "SL_COMMENT"
    public final void mSL_COMMENT() throws RecognitionException {
        try {
            int _type = SL_COMMENT;
            int _channel = DEFAULT_TOKEN_CHANNEL;
            // cz/vutbr/web/csskit/antlr/CSS.g:1413:2: ( '//' ( options {greedy=false; } : . )* ( '\\n' | '\\r' ) )
            // cz/vutbr/web/csskit/antlr/CSS.g:1413:4: '//' ( options {greedy=false; } : . )* ( '\\n' | '\\r' )
            {
            match("//"); 



            // cz/vutbr/web/csskit/antlr/CSS.g:1413:9: ( options {greedy=false; } : . )*
            loop23:
            do {
                int alt23=2;
                int LA23_0 = input.LA(1);

                if ( (LA23_0=='\n'||LA23_0=='\r') ) {
                    alt23=2;
                }
                else if ( ((LA23_0 >= '\u0000' && LA23_0 <= '\t')||(LA23_0 >= '\u000B' && LA23_0 <= '\f')||(LA23_0 >= '\u000E' && LA23_0 <= '\uFFFF')) ) {
                    alt23=1;
                }


                switch (alt23) {
            	case 1 :
            	    // cz/vutbr/web/csskit/antlr/CSS.g:1413:37: .
            	    {
            	    matchAny(); 

            	    }
            	    break;

            	default :
            	    break loop23;
                }
            } while (true);


            if ( input.LA(1)=='\n'||input.LA(1)=='\r' ) {
                input.consume();
            }
            else {
                MismatchedSetException mse = new MismatchedSetException(null,input);
                recover(mse);
                throw mse;
            }


             _channel=HIDDEN; 

            }

            state.type = _type;
            state.channel = _channel;
        }
        finally {
        	// do for sure before leaving
        }
    }
    // $ANTLR end "SL_COMMENT"

    // $ANTLR start "EXPRESSION"
    public final void mEXPRESSION() throws RecognitionException {
        try {
            int _type = EXPRESSION;
            int _channel = DEFAULT_TOKEN_CHANNEL;
            // cz/vutbr/web/csskit/antlr/CSS.g:1419:3: ( 'expression(' )
            // cz/vutbr/web/csskit/antlr/CSS.g:1419:5: 'expression('
            {
            match("expression("); 



             readExpressionContents(); 

            }

            state.type = _type;
            state.channel = _channel;
        }
        finally {
        	// do for sure before leaving
        }
    }
    // $ANTLR end "EXPRESSION"

    // $ANTLR start "FUNCTION"
    public final void mFUNCTION() throws RecognitionException {
        try {
            int _type = FUNCTION;
            int _channel = DEFAULT_TOKEN_CHANNEL;
            // cz/vutbr/web/csskit/antlr/CSS.g:1424:2: ( IDENT_MACR '(' )
            // cz/vutbr/web/csskit/antlr/CSS.g:1424:4: IDENT_MACR '('
            {
            mIDENT_MACR(); 


            match('('); 

            }

            state.type = _type;
            state.channel = _channel;
        }
        finally {
        	// do for sure before leaving
        }
    }
    // $ANTLR end "FUNCTION"

    // $ANTLR start "INCLUDES"
    public final void mINCLUDES() throws RecognitionException {
        try {
            int _type = INCLUDES;
            int _channel = DEFAULT_TOKEN_CHANNEL;
            // cz/vutbr/web/csskit/antlr/CSS.g:1427:2: ( '~=' )
            // cz/vutbr/web/csskit/antlr/CSS.g:1427:4: '~='
            {
            match("~="); 



            }

            state.type = _type;
            state.channel = _channel;
        }
        finally {
        	// do for sure before leaving
        }
    }
    // $ANTLR end "INCLUDES"

    // $ANTLR start "DASHMATCH"
    public final void mDASHMATCH() throws RecognitionException {
        try {
            int _type = DASHMATCH;
            int _channel = DEFAULT_TOKEN_CHANNEL;
            // cz/vutbr/web/csskit/antlr/CSS.g:1431:2: ( '|=' )
            // cz/vutbr/web/csskit/antlr/CSS.g:1431:4: '|='
            {
            match("|="); 



            }

            state.type = _type;
            state.channel = _channel;
        }
        finally {
        	// do for sure before leaving
        }
    }
    // $ANTLR end "DASHMATCH"

    // $ANTLR start "STARTSWITH"
    public final void mSTARTSWITH() throws RecognitionException {
        try {
            int _type = STARTSWITH;
            int _channel = DEFAULT_TOKEN_CHANNEL;
            // cz/vutbr/web/csskit/antlr/CSS.g:1435:3: ( '^=' )
            // cz/vutbr/web/csskit/antlr/CSS.g:1435:5: '^='
            {
            match("^="); 



            }

            state.type = _type;
            state.channel = _channel;
        }
        finally {
        	// do for sure before leaving
        }
    }
    // $ANTLR end "STARTSWITH"

    // $ANTLR start "ENDSWITH"
    public final void mENDSWITH() throws RecognitionException {
        try {
            int _type = ENDSWITH;
            int _channel = DEFAULT_TOKEN_CHANNEL;
            // cz/vutbr/web/csskit/antlr/CSS.g:1439:3: ( '$=' )
            // cz/vutbr/web/csskit/antlr/CSS.g:1439:5: '$='
            {
            match("$="); 



            }

            state.type = _type;
            state.channel = _channel;
        }
        finally {
        	// do for sure before leaving
        }
    }
    // $ANTLR end "ENDSWITH"

    // $ANTLR start "CONTAINS"
    public final void mCONTAINS() throws RecognitionException {
        try {
            int _type = CONTAINS;
            int _channel = DEFAULT_TOKEN_CHANNEL;
            // cz/vutbr/web/csskit/antlr/CSS.g:1443:3: ( '*=' )
            // cz/vutbr/web/csskit/antlr/CSS.g:1443:5: '*='
            {
            match("*="); 



            }

            state.type = _type;
            state.channel = _channel;
        }
        finally {
        	// do for sure before leaving
        }
    }
    // $ANTLR end "CONTAINS"

    // $ANTLR start "INVALID_TOKEN"
    public final void mINVALID_TOKEN() throws RecognitionException {
        try {
            int _type = INVALID_TOKEN;
            int _channel = DEFAULT_TOKEN_CHANNEL;
            // cz/vutbr/web/csskit/antlr/CSS.g:1447:2: ( . )
            // cz/vutbr/web/csskit/antlr/CSS.g:1447:4: .
            {
            matchAny(); 

            }

            state.type = _type;
            state.channel = _channel;
        }
        finally {
        	// do for sure before leaving
        }
    }
    // $ANTLR end "INVALID_TOKEN"

    // $ANTLR start "IDENT_MACR"
    public final void mIDENT_MACR() throws RecognitionException {
        try {
            // cz/vutbr/web/csskit/antlr/CSS.g:1461:4: ( NAME_START ( NAME_CHAR )* )
            // cz/vutbr/web/csskit/antlr/CSS.g:1461:6: NAME_START ( NAME_CHAR )*
            {
            mNAME_START(); 


            // cz/vutbr/web/csskit/antlr/CSS.g:1461:17: ( NAME_CHAR )*
            loop24:
            do {
                int alt24=2;
                int LA24_0 = input.LA(1);

                if ( (LA24_0=='-'||(LA24_0 >= '0' && LA24_0 <= '9')||(LA24_0 >= 'A' && LA24_0 <= 'Z')||LA24_0=='\\'||LA24_0=='_'||(LA24_0 >= 'a' && LA24_0 <= 'z')||(LA24_0 >= '\u0080' && LA24_0 <= '\uD7FF')||(LA24_0 >= '\uE000' && LA24_0 <= '\uFFFD')) ) {
                    alt24=1;
                }


                switch (alt24) {
            	case 1 :
            	    // cz/vutbr/web/csskit/antlr/CSS.g:1461:17: NAME_CHAR
            	    {
            	    mNAME_CHAR(); 


            	    }
            	    break;

            	default :
            	    break loop24;
                }
            } while (true);


            }


        }
        finally {
        	// do for sure before leaving
        }
    }
    // $ANTLR end "IDENT_MACR"

    // $ANTLR start "NAME_MACR"
    public final void mNAME_MACR() throws RecognitionException {
        try {
            // cz/vutbr/web/csskit/antlr/CSS.g:1462:3: ( ( NAME_CHAR )+ )
            // cz/vutbr/web/csskit/antlr/CSS.g:1462:5: ( NAME_CHAR )+
            {
            // cz/vutbr/web/csskit/antlr/CSS.g:1462:5: ( NAME_CHAR )+
            int cnt25=0;
            loop25:
            do {
                int alt25=2;
                int LA25_0 = input.LA(1);

                if ( (LA25_0=='-'||(LA25_0 >= '0' && LA25_0 <= '9')||(LA25_0 >= 'A' && LA25_0 <= 'Z')||LA25_0=='\\'||LA25_0=='_'||(LA25_0 >= 'a' && LA25_0 <= 'z')||(LA25_0 >= '\u0080' && LA25_0 <= '\uD7FF')||(LA25_0 >= '\uE000' && LA25_0 <= '\uFFFD')) ) {
                    alt25=1;
                }


                switch (alt25) {
            	case 1 :
            	    // cz/vutbr/web/csskit/antlr/CSS.g:1462:5: NAME_CHAR
            	    {
            	    mNAME_CHAR(); 


            	    }
            	    break;

            	default :
            	    if ( cnt25 >= 1 ) break loop25;
                        EarlyExitException eee =
                            new EarlyExitException(25, input);
                        throw eee;
                }
                cnt25++;
            } while (true);


            }


        }
        finally {
        	// do for sure before leaving
        }
    }
    // $ANTLR end "NAME_MACR"

    // $ANTLR start "NAME_START"
    public final void mNAME_START() throws RecognitionException {
        try {
            // cz/vutbr/web/csskit/antlr/CSS.g:1467:4: ( ( 'a' .. 'z' | 'A' .. 'Z' | '_' | NON_ASCII | ESCAPE_CHAR ) )
            // cz/vutbr/web/csskit/antlr/CSS.g:1467:6: ( 'a' .. 'z' | 'A' .. 'Z' | '_' | NON_ASCII | ESCAPE_CHAR )
            {
            // cz/vutbr/web/csskit/antlr/CSS.g:1467:6: ( 'a' .. 'z' | 'A' .. 'Z' | '_' | NON_ASCII | ESCAPE_CHAR )
            int alt26=5;
            int LA26_0 = input.LA(1);

            if ( ((LA26_0 >= 'a' && LA26_0 <= 'z')) ) {
                alt26=1;
            }
            else if ( ((LA26_0 >= 'A' && LA26_0 <= 'Z')) ) {
                alt26=2;
            }
            else if ( (LA26_0=='_') ) {
                alt26=3;
            }
            else if ( ((LA26_0 >= '\u0080' && LA26_0 <= '\uD7FF')||(LA26_0 >= '\uE000' && LA26_0 <= '\uFFFD')) ) {
                alt26=4;
            }
            else if ( (LA26_0=='\\') ) {
                alt26=5;
            }
            else {
                NoViableAltException nvae =
                    new NoViableAltException("", 26, 0, input);

                throw nvae;

            }
            switch (alt26) {
                case 1 :
                    // cz/vutbr/web/csskit/antlr/CSS.g:1467:7: 'a' .. 'z'
                    {
                    matchRange('a','z'); 

                    }
                    break;
                case 2 :
                    // cz/vutbr/web/csskit/antlr/CSS.g:1467:18: 'A' .. 'Z'
                    {
                    matchRange('A','Z'); 

                    }
                    break;
                case 3 :
                    // cz/vutbr/web/csskit/antlr/CSS.g:1467:29: '_'
                    {
                    match('_'); 

                    }
                    break;
                case 4 :
                    // cz/vutbr/web/csskit/antlr/CSS.g:1467:35: NON_ASCII
                    {
                    mNON_ASCII(); 


                    }
                    break;
                case 5 :
                    // cz/vutbr/web/csskit/antlr/CSS.g:1467:47: ESCAPE_CHAR
                    {
                    mESCAPE_CHAR(); 


                    }
                    break;

            }


            }


        }
        finally {
        	// do for sure before leaving
        }
    }
    // $ANTLR end "NAME_START"

    // $ANTLR start "NON_ASCII"
    public final void mNON_ASCII() throws RecognitionException {
        try {
            // cz/vutbr/web/csskit/antlr/CSS.g:1472:4: ( ( '\\u0080' .. '\\uD7FF' | '\\uE000' .. '\\uFFFD' ) )
            // cz/vutbr/web/csskit/antlr/CSS.g:
            {
            if ( (input.LA(1) >= '\u0080' && input.LA(1) <= '\uD7FF')||(input.LA(1) >= '\uE000' && input.LA(1) <= '\uFFFD') ) {
                input.consume();
            }
            else {
                MismatchedSetException mse = new MismatchedSetException(null,input);
                recover(mse);
                throw mse;
            }


            }


        }
        finally {
        	// do for sure before leaving
        }
    }
    // $ANTLR end "NON_ASCII"

    // $ANTLR start "ESCAPE_CHAR"
    public final void mESCAPE_CHAR() throws RecognitionException {
        try {
            // cz/vutbr/web/csskit/antlr/CSS.g:1477:3: ( ( '\\\\' ) ( ( ( '0' .. '9' | 'a' .. 'f' | 'A' .. 'F' ) ( '0' .. '9' | 'a' .. 'f' | 'A' .. 'F' ) ( '0' .. '9' | 'a' .. 'f' | 'A' .. 'F' ) ( '0' .. '9' | 'a' .. 'f' | 'A' .. 'F' ) ( ( '0' .. '9' | 'a' .. 'f' | 'A' .. 'F' ) ( '0' .. '9' | 'a' .. 'f' | 'A' .. 'F' ) )? ) | ( '\\u0020' .. '\\u007E' | '\\u0080' .. '\\uD7FF' | '\\uE000' .. '\\uFFFD' ) ) )
            // cz/vutbr/web/csskit/antlr/CSS.g:1477:5: ( '\\\\' ) ( ( ( '0' .. '9' | 'a' .. 'f' | 'A' .. 'F' ) ( '0' .. '9' | 'a' .. 'f' | 'A' .. 'F' ) ( '0' .. '9' | 'a' .. 'f' | 'A' .. 'F' ) ( '0' .. '9' | 'a' .. 'f' | 'A' .. 'F' ) ( ( '0' .. '9' | 'a' .. 'f' | 'A' .. 'F' ) ( '0' .. '9' | 'a' .. 'f' | 'A' .. 'F' ) )? ) | ( '\\u0020' .. '\\u007E' | '\\u0080' .. '\\uD7FF' | '\\uE000' .. '\\uFFFD' ) )
            {
            // cz/vutbr/web/csskit/antlr/CSS.g:1477:5: ( '\\\\' )
            // cz/vutbr/web/csskit/antlr/CSS.g:1477:6: '\\\\'
            {
            match('\\'); 

            }


            // cz/vutbr/web/csskit/antlr/CSS.g:1478:5: ( ( ( '0' .. '9' | 'a' .. 'f' | 'A' .. 'F' ) ( '0' .. '9' | 'a' .. 'f' | 'A' .. 'F' ) ( '0' .. '9' | 'a' .. 'f' | 'A' .. 'F' ) ( '0' .. '9' | 'a' .. 'f' | 'A' .. 'F' ) ( ( '0' .. '9' | 'a' .. 'f' | 'A' .. 'F' ) ( '0' .. '9' | 'a' .. 'f' | 'A' .. 'F' ) )? ) | ( '\\u0020' .. '\\u007E' | '\\u0080' .. '\\uD7FF' | '\\uE000' .. '\\uFFFD' ) )
            int alt28=2;
            int LA28_0 = input.LA(1);

            if ( ((LA28_0 >= '0' && LA28_0 <= '9')||(LA28_0 >= 'A' && LA28_0 <= 'F')||(LA28_0 >= 'a' && LA28_0 <= 'f')) ) {
                switch ( input.LA(2) ) {
                case '0':
                case '1':
                case '2':
                case '3':
                case '4':
                case '5':
                case '6':
                case '7':
                case '8':
                case '9':
                case 'A':
                case 'B':
                case 'C':
                case 'D':
                case 'E':
                case 'F':
                case 'a':
                case 'b':
                case 'c':
                case 'd':
                case 'e':
                case 'f':
                    {
                    alt28=1;
                    }
                    break;
                default:
                    alt28=2;
                }

            }
            else if ( ((LA28_0 >= ' ' && LA28_0 <= '/')||(LA28_0 >= ':' && LA28_0 <= '@')||(LA28_0 >= 'G' && LA28_0 <= '`')||(LA28_0 >= 'g' && LA28_0 <= '~')||(LA28_0 >= '\u0080' && LA28_0 <= '\uD7FF')||(LA28_0 >= '\uE000' && LA28_0 <= '\uFFFD')) ) {
                alt28=2;
            }
            else {
                NoViableAltException nvae =
                    new NoViableAltException("", 28, 0, input);

                throw nvae;

            }
            switch (alt28) {
                case 1 :
                    // cz/vutbr/web/csskit/antlr/CSS.g:1479:7: ( ( '0' .. '9' | 'a' .. 'f' | 'A' .. 'F' ) ( '0' .. '9' | 'a' .. 'f' | 'A' .. 'F' ) ( '0' .. '9' | 'a' .. 'f' | 'A' .. 'F' ) ( '0' .. '9' | 'a' .. 'f' | 'A' .. 'F' ) ( ( '0' .. '9' | 'a' .. 'f' | 'A' .. 'F' ) ( '0' .. '9' | 'a' .. 'f' | 'A' .. 'F' ) )? )
                    {
                    // cz/vutbr/web/csskit/antlr/CSS.g:1479:7: ( ( '0' .. '9' | 'a' .. 'f' | 'A' .. 'F' ) ( '0' .. '9' | 'a' .. 'f' | 'A' .. 'F' ) ( '0' .. '9' | 'a' .. 'f' | 'A' .. 'F' ) ( '0' .. '9' | 'a' .. 'f' | 'A' .. 'F' ) ( ( '0' .. '9' | 'a' .. 'f' | 'A' .. 'F' ) ( '0' .. '9' | 'a' .. 'f' | 'A' .. 'F' ) )? )
                    // cz/vutbr/web/csskit/antlr/CSS.g:1479:8: ( '0' .. '9' | 'a' .. 'f' | 'A' .. 'F' ) ( '0' .. '9' | 'a' .. 'f' | 'A' .. 'F' ) ( '0' .. '9' | 'a' .. 'f' | 'A' .. 'F' ) ( '0' .. '9' | 'a' .. 'f' | 'A' .. 'F' ) ( ( '0' .. '9' | 'a' .. 'f' | 'A' .. 'F' ) ( '0' .. '9' | 'a' .. 'f' | 'A' .. 'F' ) )?
                    {
                    if ( (input.LA(1) >= '0' && input.LA(1) <= '9')||(input.LA(1) >= 'A' && input.LA(1) <= 'F')||(input.LA(1) >= 'a' && input.LA(1) <= 'f') ) {
                        input.consume();
                    }
                    else {
                        MismatchedSetException mse = new MismatchedSetException(null,input);
                        recover(mse);
                        throw mse;
                    }


                    if ( (input.LA(1) >= '0' && input.LA(1) <= '9')||(input.LA(1) >= 'A' && input.LA(1) <= 'F')||(input.LA(1) >= 'a' && input.LA(1) <= 'f') ) {
                        input.consume();
                    }
                    else {
                        MismatchedSetException mse = new MismatchedSetException(null,input);
                        recover(mse);
                        throw mse;
                    }


                    if ( (input.LA(1) >= '0' && input.LA(1) <= '9')||(input.LA(1) >= 'A' && input.LA(1) <= 'F')||(input.LA(1) >= 'a' && input.LA(1) <= 'f') ) {
                        input.consume();
                    }
                    else {
                        MismatchedSetException mse = new MismatchedSetException(null,input);
                        recover(mse);
                        throw mse;
                    }


                    if ( (input.LA(1) >= '0' && input.LA(1) <= '9')||(input.LA(1) >= 'A' && input.LA(1) <= 'F')||(input.LA(1) >= 'a' && input.LA(1) <= 'f') ) {
                        input.consume();
                    }
                    else {
                        MismatchedSetException mse = new MismatchedSetException(null,input);
                        recover(mse);
                        throw mse;
                    }


                    // cz/vutbr/web/csskit/antlr/CSS.g:1483:8: ( ( '0' .. '9' | 'a' .. 'f' | 'A' .. 'F' ) ( '0' .. '9' | 'a' .. 'f' | 'A' .. 'F' ) )?
                    int alt27=2;
                    switch ( input.LA(1) ) {
                        case '0':
                        case '1':
                        case '2':
                        case '3':
                        case '4':
                        case '5':
                        case '6':
                        case '7':
                        case '8':
                        case '9':
                        case 'A':
                        case 'B':
                        case 'C':
                        case 'D':
                        case 'E':
                        case 'F':
                        case 'a':
                        case 'b':
                        case 'c':
                        case 'd':
                        case 'e':
                        case 'f':
                            {
                            alt27=1;
                            }
                            break;
                    }

                    switch (alt27) {
                        case 1 :
                            // cz/vutbr/web/csskit/antlr/CSS.g:1483:9: ( '0' .. '9' | 'a' .. 'f' | 'A' .. 'F' ) ( '0' .. '9' | 'a' .. 'f' | 'A' .. 'F' )
                            {
                            if ( (input.LA(1) >= '0' && input.LA(1) <= '9')||(input.LA(1) >= 'A' && input.LA(1) <= 'F')||(input.LA(1) >= 'a' && input.LA(1) <= 'f') ) {
                                input.consume();
                            }
                            else {
                                MismatchedSetException mse = new MismatchedSetException(null,input);
                                recover(mse);
                                throw mse;
                            }


                            if ( (input.LA(1) >= '0' && input.LA(1) <= '9')||(input.LA(1) >= 'A' && input.LA(1) <= 'F')||(input.LA(1) >= 'a' && input.LA(1) <= 'f') ) {
                                input.consume();
                            }
                            else {
                                MismatchedSetException mse = new MismatchedSetException(null,input);
                                recover(mse);
                                throw mse;
                            }


                            }
                            break;

                    }


                    }


                    }
                    break;
                case 2 :
                    // cz/vutbr/web/csskit/antlr/CSS.g:1486:7: ( '\\u0020' .. '\\u007E' | '\\u0080' .. '\\uD7FF' | '\\uE000' .. '\\uFFFD' )
                    {
                    if ( (input.LA(1) >= ' ' && input.LA(1) <= '~')||(input.LA(1) >= '\u0080' && input.LA(1) <= '\uD7FF')||(input.LA(1) >= '\uE000' && input.LA(1) <= '\uFFFD') ) {
                        input.consume();
                    }
                    else {
                        MismatchedSetException mse = new MismatchedSetException(null,input);
                        recover(mse);
                        throw mse;
                    }


                    }
                    break;

            }


            }


        }
        finally {
        	// do for sure before leaving
        }
    }
    // $ANTLR end "ESCAPE_CHAR"

    // $ANTLR start "NAME_CHAR"
    public final void mNAME_CHAR() throws RecognitionException {
        try {
            // cz/vutbr/web/csskit/antlr/CSS.g:1492:4: ( ( 'a' .. 'z' | 'A' .. 'Z' | '0' .. '9' | '-' | '_' | NON_ASCII | ESCAPE_CHAR ) )
            // cz/vutbr/web/csskit/antlr/CSS.g:1492:6: ( 'a' .. 'z' | 'A' .. 'Z' | '0' .. '9' | '-' | '_' | NON_ASCII | ESCAPE_CHAR )
            {
            // cz/vutbr/web/csskit/antlr/CSS.g:1492:6: ( 'a' .. 'z' | 'A' .. 'Z' | '0' .. '9' | '-' | '_' | NON_ASCII | ESCAPE_CHAR )
            int alt29=7;
            int LA29_0 = input.LA(1);

            if ( ((LA29_0 >= 'a' && LA29_0 <= 'z')) ) {
                alt29=1;
            }
            else if ( ((LA29_0 >= 'A' && LA29_0 <= 'Z')) ) {
                alt29=2;
            }
            else if ( ((LA29_0 >= '0' && LA29_0 <= '9')) ) {
                alt29=3;
            }
            else if ( (LA29_0=='-') ) {
                alt29=4;
            }
            else if ( (LA29_0=='_') ) {
                alt29=5;
            }
            else if ( ((LA29_0 >= '\u0080' && LA29_0 <= '\uD7FF')||(LA29_0 >= '\uE000' && LA29_0 <= '\uFFFD')) ) {
                alt29=6;
            }
            else if ( (LA29_0=='\\') ) {
                alt29=7;
            }
            else {
                NoViableAltException nvae =
                    new NoViableAltException("", 29, 0, input);

                throw nvae;

            }
            switch (alt29) {
                case 1 :
                    // cz/vutbr/web/csskit/antlr/CSS.g:1492:7: 'a' .. 'z'
                    {
                    matchRange('a','z'); 

                    }
                    break;
                case 2 :
                    // cz/vutbr/web/csskit/antlr/CSS.g:1492:18: 'A' .. 'Z'
                    {
                    matchRange('A','Z'); 

                    }
                    break;
                case 3 :
                    // cz/vutbr/web/csskit/antlr/CSS.g:1492:29: '0' .. '9'
                    {
                    matchRange('0','9'); 

                    }
                    break;
                case 4 :
                    // cz/vutbr/web/csskit/antlr/CSS.g:1492:40: '-'
                    {
                    match('-'); 

                    }
                    break;
                case 5 :
                    // cz/vutbr/web/csskit/antlr/CSS.g:1492:46: '_'
                    {
                    match('_'); 

                    }
                    break;
                case 6 :
                    // cz/vutbr/web/csskit/antlr/CSS.g:1492:52: NON_ASCII
                    {
                    mNON_ASCII(); 


                    }
                    break;
                case 7 :
                    // cz/vutbr/web/csskit/antlr/CSS.g:1492:64: ESCAPE_CHAR
                    {
                    mESCAPE_CHAR(); 


                    }
                    break;

            }


            }


        }
        finally {
        	// do for sure before leaving
        }
    }
    // $ANTLR end "NAME_CHAR"

    // $ANTLR start "INTEGER_MACR"
    public final void mINTEGER_MACR() throws RecognitionException {
        try {
            // cz/vutbr/web/csskit/antlr/CSS.g:1497:5: ( ( '0' .. '9' )+ )
            // cz/vutbr/web/csskit/antlr/CSS.g:1497:7: ( '0' .. '9' )+
            {
            // cz/vutbr/web/csskit/antlr/CSS.g:1497:7: ( '0' .. '9' )+
            int cnt30=0;
            loop30:
            do {
                int alt30=2;
                switch ( input.LA(1) ) {
                case '0':
                case '1':
                case '2':
                case '3':
                case '4':
                case '5':
                case '6':
                case '7':
                case '8':
                case '9':
                    {
                    alt30=1;
                    }
                    break;

                }

                switch (alt30) {
            	case 1 :
            	    // cz/vutbr/web/csskit/antlr/CSS.g:
            	    {
            	    if ( (input.LA(1) >= '0' && input.LA(1) <= '9') ) {
            	        input.consume();
            	    }
            	    else {
            	        MismatchedSetException mse = new MismatchedSetException(null,input);
            	        recover(mse);
            	        throw mse;
            	    }


            	    }
            	    break;

            	default :
            	    if ( cnt30 >= 1 ) break loop30;
                        EarlyExitException eee =
                            new EarlyExitException(30, input);
                        throw eee;
                }
                cnt30++;
            } while (true);


            }


        }
        finally {
        	// do for sure before leaving
        }
    }
    // $ANTLR end "INTEGER_MACR"

    // $ANTLR start "NUMBER_MACR"
    public final void mNUMBER_MACR() throws RecognitionException {
        try {
            // cz/vutbr/web/csskit/antlr/CSS.g:1502:4: ( ( '0' .. '9' )+ | ( ( '0' .. '9' )* '.' ( '0' .. '9' )+ ) )
            int alt34=2;
            alt34 = dfa34.predict(input);
            switch (alt34) {
                case 1 :
                    // cz/vutbr/web/csskit/antlr/CSS.g:1502:6: ( '0' .. '9' )+
                    {
                    // cz/vutbr/web/csskit/antlr/CSS.g:1502:6: ( '0' .. '9' )+
                    int cnt31=0;
                    loop31:
                    do {
                        int alt31=2;
                        switch ( input.LA(1) ) {
                        case '0':
                        case '1':
                        case '2':
                        case '3':
                        case '4':
                        case '5':
                        case '6':
                        case '7':
                        case '8':
                        case '9':
                            {
                            alt31=1;
                            }
                            break;

                        }

                        switch (alt31) {
                    	case 1 :
                    	    // cz/vutbr/web/csskit/antlr/CSS.g:
                    	    {
                    	    if ( (input.LA(1) >= '0' && input.LA(1) <= '9') ) {
                    	        input.consume();
                    	    }
                    	    else {
                    	        MismatchedSetException mse = new MismatchedSetException(null,input);
                    	        recover(mse);
                    	        throw mse;
                    	    }


                    	    }
                    	    break;

                    	default :
                    	    if ( cnt31 >= 1 ) break loop31;
                                EarlyExitException eee =
                                    new EarlyExitException(31, input);
                                throw eee;
                        }
                        cnt31++;
                    } while (true);


                    }
                    break;
                case 2 :
                    // cz/vutbr/web/csskit/antlr/CSS.g:1502:20: ( ( '0' .. '9' )* '.' ( '0' .. '9' )+ )
                    {
                    // cz/vutbr/web/csskit/antlr/CSS.g:1502:20: ( ( '0' .. '9' )* '.' ( '0' .. '9' )+ )
                    // cz/vutbr/web/csskit/antlr/CSS.g:1502:21: ( '0' .. '9' )* '.' ( '0' .. '9' )+
                    {
                    // cz/vutbr/web/csskit/antlr/CSS.g:1502:21: ( '0' .. '9' )*
                    loop32:
                    do {
                        int alt32=2;
                        switch ( input.LA(1) ) {
                        case '0':
                        case '1':
                        case '2':
                        case '3':
                        case '4':
                        case '5':
                        case '6':
                        case '7':
                        case '8':
                        case '9':
                            {
                            alt32=1;
                            }
                            break;

                        }

                        switch (alt32) {
                    	case 1 :
                    	    // cz/vutbr/web/csskit/antlr/CSS.g:
                    	    {
                    	    if ( (input.LA(1) >= '0' && input.LA(1) <= '9') ) {
                    	        input.consume();
                    	    }
                    	    else {
                    	        MismatchedSetException mse = new MismatchedSetException(null,input);
                    	        recover(mse);
                    	        throw mse;
                    	    }


                    	    }
                    	    break;

                    	default :
                    	    break loop32;
                        }
                    } while (true);


                    match('.'); 

                    // cz/vutbr/web/csskit/antlr/CSS.g:1502:37: ( '0' .. '9' )+
                    int cnt33=0;
                    loop33:
                    do {
                        int alt33=2;
                        switch ( input.LA(1) ) {
                        case '0':
                        case '1':
                        case '2':
                        case '3':
                        case '4':
                        case '5':
                        case '6':
                        case '7':
                        case '8':
                        case '9':
                            {
                            alt33=1;
                            }
                            break;

                        }

                        switch (alt33) {
                    	case 1 :
                    	    // cz/vutbr/web/csskit/antlr/CSS.g:
                    	    {
                    	    if ( (input.LA(1) >= '0' && input.LA(1) <= '9') ) {
                    	        input.consume();
                    	    }
                    	    else {
                    	        MismatchedSetException mse = new MismatchedSetException(null,input);
                    	        recover(mse);
                    	        throw mse;
                    	    }


                    	    }
                    	    break;

                    	default :
                    	    if ( cnt33 >= 1 ) break loop33;
                                EarlyExitException eee =
                                    new EarlyExitException(33, input);
                                throw eee;
                        }
                        cnt33++;
                    } while (true);


                    }


                    }
                    break;

            }

        }
        finally {
        	// do for sure before leaving
        }
    }
    // $ANTLR end "NUMBER_MACR"

    // $ANTLR start "STRING_MACR"
    public final void mSTRING_MACR() throws RecognitionException {
        try {
            // cz/vutbr/web/csskit/antlr/CSS.g:1507:2: ( QUOT ( STRING_CHAR | APOS )* QUOT | APOS ( STRING_CHAR | QUOT )* APOS )
            int alt37=2;
            switch ( input.LA(1) ) {
            case '\"':
                {
                alt37=1;
                }
                break;
            case '\'':
                {
                alt37=2;
                }
                break;
            default:
                NoViableAltException nvae =
                    new NoViableAltException("", 37, 0, input);

                throw nvae;

            }

            switch (alt37) {
                case 1 :
                    // cz/vutbr/web/csskit/antlr/CSS.g:1507:4: QUOT ( STRING_CHAR | APOS )* QUOT
                    {
                    mQUOT(); 


                    // cz/vutbr/web/csskit/antlr/CSS.g:1507:9: ( STRING_CHAR | APOS )*
                    loop35:
                    do {
                        int alt35=3;
                        int LA35_0 = input.LA(1);

                        if ( (LA35_0=='\t'||(LA35_0 >= ' ' && LA35_0 <= '!')||(LA35_0 >= '#' && LA35_0 <= '&')||(LA35_0 >= '(' && LA35_0 <= '~')||(LA35_0 >= '\u0080' && LA35_0 <= '\uD7FF')||(LA35_0 >= '\uE000' && LA35_0 <= '\uFFFD')) ) {
                            alt35=1;
                        }
                        else if ( (LA35_0=='\'') ) {
                            alt35=2;
                        }


                        switch (alt35) {
                    	case 1 :
                    	    // cz/vutbr/web/csskit/antlr/CSS.g:1507:10: STRING_CHAR
                    	    {
                    	    mSTRING_CHAR(); 


                    	    }
                    	    break;
                    	case 2 :
                    	    // cz/vutbr/web/csskit/antlr/CSS.g:1507:24: APOS
                    	    {
                    	    mAPOS(); 


                    	    ls.aposOpen=false;

                    	    }
                    	    break;

                    	default :
                    	    break loop35;
                        }
                    } while (true);


                    mQUOT(); 


                    }
                    break;
                case 2 :
                    // cz/vutbr/web/csskit/antlr/CSS.g:1508:4: APOS ( STRING_CHAR | QUOT )* APOS
                    {
                    mAPOS(); 


                    // cz/vutbr/web/csskit/antlr/CSS.g:1508:9: ( STRING_CHAR | QUOT )*
                    loop36:
                    do {
                        int alt36=3;
                        int LA36_0 = input.LA(1);

                        if ( (LA36_0=='\t'||(LA36_0 >= ' ' && LA36_0 <= '!')||(LA36_0 >= '#' && LA36_0 <= '&')||(LA36_0 >= '(' && LA36_0 <= '~')||(LA36_0 >= '\u0080' && LA36_0 <= '\uD7FF')||(LA36_0 >= '\uE000' && LA36_0 <= '\uFFFD')) ) {
                            alt36=1;
                        }
                        else if ( (LA36_0=='\"') ) {
                            alt36=2;
                        }


                        switch (alt36) {
                    	case 1 :
                    	    // cz/vutbr/web/csskit/antlr/CSS.g:1508:10: STRING_CHAR
                    	    {
                    	    mSTRING_CHAR(); 


                    	    }
                    	    break;
                    	case 2 :
                    	    // cz/vutbr/web/csskit/antlr/CSS.g:1508:24: QUOT
                    	    {
                    	    mQUOT(); 


                    	    ls.quotOpen=false;

                    	    }
                    	    break;

                    	default :
                    	    break loop36;
                        }
                    } while (true);


                    mAPOS(); 


                    }
                    break;

            }

        }
        finally {
        	// do for sure before leaving
        }
    }
    // $ANTLR end "STRING_MACR"

    // $ANTLR start "STRING_CHAR"
    public final void mSTRING_CHAR() throws RecognitionException {
        try {
            // cz/vutbr/web/csskit/antlr/CSS.g:1513:2: ( ( URI_CHAR | ' ' | '(' | ')' | ( '\\\\' NL_CHAR ) ) )
            // cz/vutbr/web/csskit/antlr/CSS.g:1513:5: ( URI_CHAR | ' ' | '(' | ')' | ( '\\\\' NL_CHAR ) )
            {
            // cz/vutbr/web/csskit/antlr/CSS.g:1513:5: ( URI_CHAR | ' ' | '(' | ')' | ( '\\\\' NL_CHAR ) )
            int alt38=5;
            int LA38_0 = input.LA(1);

            if ( (LA38_0=='\\') ) {
                switch ( input.LA(2) ) {
                case '\n':
                case '\f':
                case '\r':
                    {
                    alt38=5;
                    }
                    break;
                default:
                    alt38=1;
                }

            }
            else if ( (LA38_0=='\t'||LA38_0=='!'||(LA38_0 >= '#' && LA38_0 <= '&')||(LA38_0 >= '*' && LA38_0 <= '[')||(LA38_0 >= ']' && LA38_0 <= '~')||(LA38_0 >= '\u0080' && LA38_0 <= '\uD7FF')||(LA38_0 >= '\uE000' && LA38_0 <= '\uFFFD')) ) {
                alt38=1;
            }
            else if ( (LA38_0==' ') ) {
                alt38=2;
            }
            else if ( (LA38_0=='(') ) {
                alt38=3;
            }
            else if ( (LA38_0==')') ) {
                alt38=4;
            }
            else {
                NoViableAltException nvae =
                    new NoViableAltException("", 38, 0, input);

                throw nvae;

            }
            switch (alt38) {
                case 1 :
                    // cz/vutbr/web/csskit/antlr/CSS.g:1513:6: URI_CHAR
                    {
                    mURI_CHAR(); 


                    }
                    break;
                case 2 :
                    // cz/vutbr/web/csskit/antlr/CSS.g:1513:17: ' '
                    {
                    match(' '); 

                    }
                    break;
                case 3 :
                    // cz/vutbr/web/csskit/antlr/CSS.g:1513:23: '('
                    {
                    match('('); 

                    }
                    break;
                case 4 :
                    // cz/vutbr/web/csskit/antlr/CSS.g:1513:29: ')'
                    {
                    match(')'); 

                    }
                    break;
                case 5 :
                    // cz/vutbr/web/csskit/antlr/CSS.g:1513:35: ( '\\\\' NL_CHAR )
                    {
                    // cz/vutbr/web/csskit/antlr/CSS.g:1513:35: ( '\\\\' NL_CHAR )
                    // cz/vutbr/web/csskit/antlr/CSS.g:1513:36: '\\\\' NL_CHAR
                    {
                    match('\\'); 

                    mNL_CHAR(); 


                    }


                    }
                    break;

            }


            }


        }
        finally {
        	// do for sure before leaving
        }
    }
    // $ANTLR end "STRING_CHAR"

    // $ANTLR start "URI_MACR"
    public final void mURI_MACR() throws RecognitionException {
        try {
            // cz/vutbr/web/csskit/antlr/CSS.g:1518:2: ( ( URI_CHAR )* )
            // cz/vutbr/web/csskit/antlr/CSS.g:1518:4: ( URI_CHAR )*
            {
            // cz/vutbr/web/csskit/antlr/CSS.g:1518:4: ( URI_CHAR )*
            loop39:
            do {
                int alt39=2;
                int LA39_0 = input.LA(1);

                if ( (LA39_0=='\t'||LA39_0=='!'||(LA39_0 >= '#' && LA39_0 <= '&')||(LA39_0 >= '*' && LA39_0 <= '~')||(LA39_0 >= '\u0080' && LA39_0 <= '\uD7FF')||(LA39_0 >= '\uE000' && LA39_0 <= '\uFFFD')) ) {
                    alt39=1;
                }


                switch (alt39) {
            	case 1 :
            	    // cz/vutbr/web/csskit/antlr/CSS.g:1518:4: URI_CHAR
            	    {
            	    mURI_CHAR(); 


            	    }
            	    break;

            	default :
            	    break loop39;
                }
            } while (true);


            }


        }
        finally {
        	// do for sure before leaving
        }
    }
    // $ANTLR end "URI_MACR"

    // $ANTLR start "URI_CHAR"
    public final void mURI_CHAR() throws RecognitionException {
        try {
            // cz/vutbr/web/csskit/antlr/CSS.g:1523:2: ( ( '\\u0009' | '\\u0021' | '\\u0023' .. '\\u0026' | '\\u002A' .. '\\u007E' ) | NON_ASCII | ESCAPE_CHAR )
            int alt40=3;
            int LA40_0 = input.LA(1);

            if ( (LA40_0=='\\') ) {
                int LA40_1 = input.LA(2);

                if ( ((LA40_1 >= ' ' && LA40_1 <= '~')||(LA40_1 >= '\u0080' && LA40_1 <= '\uD7FF')||(LA40_1 >= '\uE000' && LA40_1 <= '\uFFFD')) ) {
                    alt40=3;
                }
                else {
                    alt40=1;
                }
            }
            else if ( ((LA40_0 >= '\u0080' && LA40_0 <= '\uD7FF')||(LA40_0 >= '\uE000' && LA40_0 <= '\uFFFD')) ) {
                alt40=2;
            }
            else if ( (LA40_0=='\t'||LA40_0=='!'||(LA40_0 >= '#' && LA40_0 <= '&')||(LA40_0 >= '*' && LA40_0 <= '[')||(LA40_0 >= ']' && LA40_0 <= '~')) ) {
                alt40=1;
            }
            else {
                NoViableAltException nvae =
                    new NoViableAltException("", 40, 0, input);

                throw nvae;

            }
            switch (alt40) {
                case 1 :
                    // cz/vutbr/web/csskit/antlr/CSS.g:1523:4: ( '\\u0009' | '\\u0021' | '\\u0023' .. '\\u0026' | '\\u002A' .. '\\u007E' )
                    {
                    if ( input.LA(1)=='\t'||input.LA(1)=='!'||(input.LA(1) >= '#' && input.LA(1) <= '&')||(input.LA(1) >= '*' && input.LA(1) <= '~') ) {
                        input.consume();
                    }
                    else {
                        MismatchedSetException mse = new MismatchedSetException(null,input);
                        recover(mse);
                        throw mse;
                    }


                    }
                    break;
                case 2 :
                    // cz/vutbr/web/csskit/antlr/CSS.g:1524:6: NON_ASCII
                    {
                    mNON_ASCII(); 


                    }
                    break;
                case 3 :
                    // cz/vutbr/web/csskit/antlr/CSS.g:1524:18: ESCAPE_CHAR
                    {
                    mESCAPE_CHAR(); 


                    }
                    break;

            }

        }
        finally {
        	// do for sure before leaving
        }
    }
    // $ANTLR end "URI_CHAR"

    // $ANTLR start "NL_CHAR"
    public final void mNL_CHAR() throws RecognitionException {
        try {
            // cz/vutbr/web/csskit/antlr/CSS.g:1529:4: ( '\\u000A' | '\\u000D' '\\u000A' | '\\u000D' | '\\u000C' )
            int alt41=4;
            switch ( input.LA(1) ) {
            case '\n':
                {
                alt41=1;
                }
                break;
            case '\r':
                {
                switch ( input.LA(2) ) {
                case '\n':
                    {
                    alt41=2;
                    }
                    break;
                default:
                    alt41=3;
                }

                }
                break;
            case '\f':
                {
                alt41=4;
                }
                break;
            default:
                NoViableAltException nvae =
                    new NoViableAltException("", 41, 0, input);

                throw nvae;

            }

            switch (alt41) {
                case 1 :
                    // cz/vutbr/web/csskit/antlr/CSS.g:1529:6: '\\u000A'
                    {
                    match('\n'); 

                    }
                    break;
                case 2 :
                    // cz/vutbr/web/csskit/antlr/CSS.g:1529:17: '\\u000D' '\\u000A'
                    {
                    match('\r'); 

                    match('\n'); 

                    }
                    break;
                case 3 :
                    // cz/vutbr/web/csskit/antlr/CSS.g:1529:37: '\\u000D'
                    {
                    match('\r'); 

                    }
                    break;
                case 4 :
                    // cz/vutbr/web/csskit/antlr/CSS.g:1529:48: '\\u000C'
                    {
                    match('\f'); 

                    }
                    break;

            }

        }
        finally {
        	// do for sure before leaving
        }
    }
    // $ANTLR end "NL_CHAR"

    // $ANTLR start "W_MACR"
    public final void mW_MACR() throws RecognitionException {
        try {
            // cz/vutbr/web/csskit/antlr/CSS.g:1534:2: ( ( W_CHAR )* )
            // cz/vutbr/web/csskit/antlr/CSS.g:1534:4: ( W_CHAR )*
            {
            // cz/vutbr/web/csskit/antlr/CSS.g:1534:4: ( W_CHAR )*
            loop42:
            do {
                int alt42=2;
                switch ( input.LA(1) ) {
                case '\t':
                case '\n':
                case '\f':
                case '\r':
                case ' ':
                    {
                    alt42=1;
                    }
                    break;

                }

                switch (alt42) {
            	case 1 :
            	    // cz/vutbr/web/csskit/antlr/CSS.g:
            	    {
            	    if ( (input.LA(1) >= '\t' && input.LA(1) <= '\n')||(input.LA(1) >= '\f' && input.LA(1) <= '\r')||input.LA(1)==' ' ) {
            	        input.consume();
            	    }
            	    else {
            	        MismatchedSetException mse = new MismatchedSetException(null,input);
            	        recover(mse);
            	        throw mse;
            	    }


            	    }
            	    break;

            	default :
            	    break loop42;
                }
            } while (true);


            }


        }
        finally {
        	// do for sure before leaving
        }
    }
    // $ANTLR end "W_MACR"

    // $ANTLR start "W_CHAR"
    public final void mW_CHAR() throws RecognitionException {
        try {
            // cz/vutbr/web/csskit/antlr/CSS.g:1539:4: ( '\\u0009' | '\\u000A' | '\\u000C' | '\\u000D' | '\\u0020' )
            // cz/vutbr/web/csskit/antlr/CSS.g:
            {
            if ( (input.LA(1) >= '\t' && input.LA(1) <= '\n')||(input.LA(1) >= '\f' && input.LA(1) <= '\r')||input.LA(1)==' ' ) {
                input.consume();
            }
            else {
                MismatchedSetException mse = new MismatchedSetException(null,input);
                recover(mse);
                throw mse;
            }


            }


        }
        finally {
        	// do for sure before leaving
        }
    }
    // $ANTLR end "W_CHAR"

    public void mTokens() throws RecognitionException {
        // cz/vutbr/web/csskit/antlr/CSS.g:1:8: ( T__99 | T__100 | T__101 | IDENT | CHARSET | IMPORT | MEDIA | PAGE | MARGIN_AREA | VIEWPORT | FONTFACE | ATKEYWORD | CLASSKEYWORD | STRING | HASH | INDEX | NUMBER | PERCENTAGE | DIMENSION | URI | UNIRANGE | CDO | CDC | SEMICOLON | COLON | COMMA | QUESTION | PERCENT | EQUALS | SLASH | GREATER | LESS | LCURLY | RCURLY | APOS | QUOT | LPAREN | RPAREN | LBRACE | RBRACE | EXCLAMATION | TILDE | MINUS | PLUS | ASTERISK | S | COMMENT | SL_COMMENT | EXPRESSION | FUNCTION | INCLUDES | DASHMATCH | STARTSWITH | ENDSWITH | CONTAINS | INVALID_TOKEN )
        int alt43=56;
        alt43 = dfa43.predict(input);
        switch (alt43) {
            case 1 :
                // cz/vutbr/web/csskit/antlr/CSS.g:1:10: T__99
                {
                mT__99(); 


                }
                break;
            case 2 :
                // cz/vutbr/web/csskit/antlr/CSS.g:1:16: T__100
                {
                mT__100(); 


                }
                break;
            case 3 :
                // cz/vutbr/web/csskit/antlr/CSS.g:1:23: T__101
                {
                mT__101(); 


                }
                break;
            case 4 :
                // cz/vutbr/web/csskit/antlr/CSS.g:1:30: IDENT
                {
                mIDENT(); 


                }
                break;
            case 5 :
                // cz/vutbr/web/csskit/antlr/CSS.g:1:36: CHARSET
                {
                mCHARSET(); 


                }
                break;
            case 6 :
                // cz/vutbr/web/csskit/antlr/CSS.g:1:44: IMPORT
                {
                mIMPORT(); 


                }
                break;
            case 7 :
                // cz/vutbr/web/csskit/antlr/CSS.g:1:51: MEDIA
                {
                mMEDIA(); 


                }
                break;
            case 8 :
                // cz/vutbr/web/csskit/antlr/CSS.g:1:57: PAGE
                {
                mPAGE(); 


                }
                break;
            case 9 :
                // cz/vutbr/web/csskit/antlr/CSS.g:1:62: MARGIN_AREA
                {
                mMARGIN_AREA(); 


                }
                break;
            case 10 :
                // cz/vutbr/web/csskit/antlr/CSS.g:1:74: VIEWPORT
                {
                mVIEWPORT(); 


                }
                break;
            case 11 :
                // cz/vutbr/web/csskit/antlr/CSS.g:1:83: FONTFACE
                {
                mFONTFACE(); 


                }
                break;
            case 12 :
                // cz/vutbr/web/csskit/antlr/CSS.g:1:92: ATKEYWORD
                {
                mATKEYWORD(); 


                }
                break;
            case 13 :
                // cz/vutbr/web/csskit/antlr/CSS.g:1:102: CLASSKEYWORD
                {
                mCLASSKEYWORD(); 


                }
                break;
            case 14 :
                // cz/vutbr/web/csskit/antlr/CSS.g:1:115: STRING
                {
                mSTRING(); 


                }
                break;
            case 15 :
                // cz/vutbr/web/csskit/antlr/CSS.g:1:122: HASH
                {
                mHASH(); 


                }
                break;
            case 16 :
                // cz/vutbr/web/csskit/antlr/CSS.g:1:127: INDEX
                {
                mINDEX(); 


                }
                break;
            case 17 :
                // cz/vutbr/web/csskit/antlr/CSS.g:1:133: NUMBER
                {
                mNUMBER(); 


                }
                break;
            case 18 :
                // cz/vutbr/web/csskit/antlr/CSS.g:1:140: PERCENTAGE
                {
                mPERCENTAGE(); 


                }
                break;
            case 19 :
                // cz/vutbr/web/csskit/antlr/CSS.g:1:151: DIMENSION
                {
                mDIMENSION(); 


                }
                break;
            case 20 :
                // cz/vutbr/web/csskit/antlr/CSS.g:1:161: URI
                {
                mURI(); 


                }
                break;
            case 21 :
                // cz/vutbr/web/csskit/antlr/CSS.g:1:165: UNIRANGE
                {
                mUNIRANGE(); 


                }
                break;
            case 22 :
                // cz/vutbr/web/csskit/antlr/CSS.g:1:174: CDO
                {
                mCDO(); 


                }
                break;
            case 23 :
                // cz/vutbr/web/csskit/antlr/CSS.g:1:178: CDC
                {
                mCDC(); 


                }
                break;
            case 24 :
                // cz/vutbr/web/csskit/antlr/CSS.g:1:182: SEMICOLON
                {
                mSEMICOLON(); 


                }
                break;
            case 25 :
                // cz/vutbr/web/csskit/antlr/CSS.g:1:192: COLON
                {
                mCOLON(); 


                }
                break;
            case 26 :
                // cz/vutbr/web/csskit/antlr/CSS.g:1:198: COMMA
                {
                mCOMMA(); 


                }
                break;
            case 27 :
                // cz/vutbr/web/csskit/antlr/CSS.g:1:204: QUESTION
                {
                mQUESTION(); 


                }
                break;
            case 28 :
                // cz/vutbr/web/csskit/antlr/CSS.g:1:213: PERCENT
                {
                mPERCENT(); 


                }
                break;
            case 29 :
                // cz/vutbr/web/csskit/antlr/CSS.g:1:221: EQUALS
                {
                mEQUALS(); 


                }
                break;
            case 30 :
                // cz/vutbr/web/csskit/antlr/CSS.g:1:228: SLASH
                {
                mSLASH(); 


                }
                break;
            case 31 :
                // cz/vutbr/web/csskit/antlr/CSS.g:1:234: GREATER
                {
                mGREATER(); 


                }
                break;
            case 32 :
                // cz/vutbr/web/csskit/antlr/CSS.g:1:242: LESS
                {
                mLESS(); 


                }
                break;
            case 33 :
                // cz/vutbr/web/csskit/antlr/CSS.g:1:247: LCURLY
                {
                mLCURLY(); 


                }
                break;
            case 34 :
                // cz/vutbr/web/csskit/antlr/CSS.g:1:254: RCURLY
                {
                mRCURLY(); 


                }
                break;
            case 35 :
                // cz/vutbr/web/csskit/antlr/CSS.g:1:261: APOS
                {
                mAPOS(); 


                }
                break;
            case 36 :
                // cz/vutbr/web/csskit/antlr/CSS.g:1:266: QUOT
                {
                mQUOT(); 


                }
                break;
            case 37 :
                // cz/vutbr/web/csskit/antlr/CSS.g:1:271: LPAREN
                {
                mLPAREN(); 


                }
                break;
            case 38 :
                // cz/vutbr/web/csskit/antlr/CSS.g:1:278: RPAREN
                {
                mRPAREN(); 


                }
                break;
            case 39 :
                // cz/vutbr/web/csskit/antlr/CSS.g:1:285: LBRACE
                {
                mLBRACE(); 


                }
                break;
            case 40 :
                // cz/vutbr/web/csskit/antlr/CSS.g:1:292: RBRACE
                {
                mRBRACE(); 


                }
                break;
            case 41 :
                // cz/vutbr/web/csskit/antlr/CSS.g:1:299: EXCLAMATION
                {
                mEXCLAMATION(); 


                }
                break;
            case 42 :
                // cz/vutbr/web/csskit/antlr/CSS.g:1:311: TILDE
                {
                mTILDE(); 


                }
                break;
            case 43 :
                // cz/vutbr/web/csskit/antlr/CSS.g:1:317: MINUS
                {
                mMINUS(); 


                }
                break;
            case 44 :
                // cz/vutbr/web/csskit/antlr/CSS.g:1:323: PLUS
                {
                mPLUS(); 


                }
                break;
            case 45 :
                // cz/vutbr/web/csskit/antlr/CSS.g:1:328: ASTERISK
                {
                mASTERISK(); 


                }
                break;
            case 46 :
                // cz/vutbr/web/csskit/antlr/CSS.g:1:337: S
                {
                mS(); 


                }
                break;
            case 47 :
                // cz/vutbr/web/csskit/antlr/CSS.g:1:339: COMMENT
                {
                mCOMMENT(); 


                }
                break;
            case 48 :
                // cz/vutbr/web/csskit/antlr/CSS.g:1:347: SL_COMMENT
                {
                mSL_COMMENT(); 


                }
                break;
            case 49 :
                // cz/vutbr/web/csskit/antlr/CSS.g:1:358: EXPRESSION
                {
                mEXPRESSION(); 


                }
                break;
            case 50 :
                // cz/vutbr/web/csskit/antlr/CSS.g:1:369: FUNCTION
                {
                mFUNCTION(); 


                }
                break;
            case 51 :
                // cz/vutbr/web/csskit/antlr/CSS.g:1:378: INCLUDES
                {
                mINCLUDES(); 


                }
                break;
            case 52 :
                // cz/vutbr/web/csskit/antlr/CSS.g:1:387: DASHMATCH
                {
                mDASHMATCH(); 


                }
                break;
            case 53 :
                // cz/vutbr/web/csskit/antlr/CSS.g:1:397: STARTSWITH
                {
                mSTARTSWITH(); 


                }
                break;
            case 54 :
                // cz/vutbr/web/csskit/antlr/CSS.g:1:408: ENDSWITH
                {
                mENDSWITH(); 


                }
                break;
            case 55 :
                // cz/vutbr/web/csskit/antlr/CSS.g:1:417: CONTAINS
                {
                mCONTAINS(); 


                }
                break;
            case 56 :
                // cz/vutbr/web/csskit/antlr/CSS.g:1:426: INVALID_TOKEN
                {
                mINVALID_TOKEN(); 


                }
                break;

        }

    }


    protected DFA34 dfa34 = new DFA34(this);
    protected DFA43 dfa43 = new DFA43(this);
    static final String DFA34_eotS =
        "\1\uffff\1\3\2\uffff";
    static final String DFA34_eofS =
        "\4\uffff";
    static final String DFA34_minS =
        "\2\56\2\uffff";
    static final String DFA34_maxS =
        "\2\71\2\uffff";
    static final String DFA34_acceptS =
        "\2\uffff\1\2\1\1";
    static final String DFA34_specialS =
        "\4\uffff}>";
    static final String[] DFA34_transitionS = {
            "\1\2\1\uffff\12\1",
            "\1\2\1\uffff\12\1",
            "",
            ""
    };

    static final short[] DFA34_eot = DFA.unpackEncodedString(DFA34_eotS);
    static final short[] DFA34_eof = DFA.unpackEncodedString(DFA34_eofS);
    static final char[] DFA34_min = DFA.unpackEncodedStringToUnsignedChars(DFA34_minS);
    static final char[] DFA34_max = DFA.unpackEncodedStringToUnsignedChars(DFA34_maxS);
    static final short[] DFA34_accept = DFA.unpackEncodedString(DFA34_acceptS);
    static final short[] DFA34_special = DFA.unpackEncodedString(DFA34_specialS);

    static short[][] DFA34_transition() {
        int numStates = DFA34_transitionS.length;
        short[][] DFA34_transition = new short[numStates][];
        for (int i=0; i<numStates; i++) {
            DFA34_transition[i] = DFA.unpackEncodedString(DFA34_transitionS[i]);
        }

        return DFA34_transition;
    }

    class DFA34 extends DFA {

        public DFA34(BaseRecognizer recognizer) {
            this.recognizer = recognizer;
            this.decisionNumber = 34;
            this.eot = DFA34_eot;
            this.eof = DFA34_eof;
            this.min = DFA34_min;
            this.max = DFA34_max;
            this.accept = DFA34_accept;
            this.special = DFA34_special;
            this.transition = DFA34_transition();
        }
        public String getDescription() {
            return "1501:1: fragment NUMBER_MACR : ( ( '0' .. '9' )+ | ( ( '0' .. '9' )* '.' ( '0' .. '9' )+ ) );";
        }
    }
    static final String DFA43_eotS =
        "\1\uffff\1\53\1\56\5\60\3\52\1\112\1\114\1\115\4\60\1\130\1\132"+
        "\6\uffff\1\143\10\uffff\1\155\1\uffff\1\160\1\uffff\1\60\2\52\5"+
        "\uffff\1\60\1\uffff\6\60\2\uffff\1\60\1\uffff\2\60\12\107\2\uffff"+
        "\1\115\4\uffff\1\72\1\115\2\uffff\1\72\1\uffff\1\60\1\uffff\1\60"+
        "\35\uffff\7\60\12\107\1\123\11\60\12\107\1\72\1\70\10\60\3\107\1"+
        "\u00b9\6\107\1\uffff\10\60\2\107\1\u00cc\1\uffff\10\107\10\60\2"+
        "\107\1\uffff\12\107\5\60\1\107\1\uffff\15\107\1\60\1\u00fe\1\uffff"+
        "\1\107\1\u0101\5\107\1\u0101\5\107\1\u010c\1\107\1\60\1\uffff\2"+
        "\107\1\uffff\1\107\1\u0101\5\107\1\u0101\2\107\1\uffff\1\u0119\1"+
        "\60\1\107\1\u0101\10\107\2\uffff\2\107\1\u0101\2\107\2\u0101\2\107"+
        "\1\uffff\4\107\3\u0101\3\107\1\u0101\5\107\1\u0101\3\107\1\u0101"+
        "\4\107\1\u0101\1\107\1\u0101";
    static final String DFA43_eofS =
        "\u0141\uffff";
    static final String DFA43_minS =
        "\1\0\1\55\1\75\1\50\2\11\2\50\1\40\1\55\1\60\2\11\1\45\4\50\1\41"+
        "\1\55\6\uffff\1\52\10\uffff\1\75\1\uffff\1\75\1\uffff\1\50\2\75"+
        "\5\uffff\1\50\1\uffff\6\50\1\40\1\uffff\1\11\1\uffff\2\50\1\150"+
        "\1\155\1\145\1\141\2\157\1\145\2\151\1\157\2\uffff\1\45\4\uffff"+
        "\1\55\1\45\1\60\1\uffff\1\55\1\uffff\1\50\1\uffff\1\50\35\uffff"+
        "\7\50\1\141\1\160\1\144\1\147\1\160\1\164\1\146\1\147\1\145\1\156"+
        "\1\11\11\50\1\162\1\157\1\151\1\145\1\55\2\164\1\150\1\167\1\164"+
        "\1\55\1\11\10\50\1\163\1\162\1\141\1\55\1\143\1\157\1\55\1\164\1"+
        "\160\1\55\1\uffff\10\50\1\145\1\164\1\55\1\uffff\2\145\1\151\1\155"+
        "\1\142\1\55\1\157\1\146\10\50\1\164\1\11\1\uffff\1\146\1\156\1\147"+
        "\1\55\1\157\1\151\1\157\1\142\1\162\1\141\5\50\1\11\1\uffff\1\162"+
        "\2\164\1\150\1\143\1\160\1\144\1\164\1\157\1\151\1\157\1\164\1\143"+
        "\2\50\1\uffff\1\154\1\55\1\145\1\164\2\145\1\151\1\55\1\144\1\164"+
        "\1\160\1\144\1\164\1\55\1\145\1\50\1\uffff\1\50\1\143\1\uffff\1"+
        "\162\1\55\1\146\1\156\1\147\1\154\1\157\1\55\1\144\1\164\1\uffff"+
        "\1\55\1\50\1\157\1\55\1\143\2\164\1\150\1\145\1\155\1\154\1\157"+
        "\2\uffff\1\162\1\157\1\55\1\145\1\164\2\55\1\145\1\155\1\uffff\1"+
        "\156\1\162\1\143\1\162\3\55\1\145\1\156\1\157\1\55\1\143\1\162\1"+
        "\145\1\162\1\157\1\55\1\162\1\156\1\162\1\55\1\145\1\156\1\162\1"+
        "\145\1\55\1\162\1\55";
    static final String DFA43_maxS =
        "\1\uffff\1\ufffd\1\75\17\ufffd\1\41\1\55\6\uffff\1\57\10\uffff\1"+
        "\75\1\uffff\1\75\1\uffff\1\ufffd\2\75\5\uffff\1\ufffd\1\uffff\7"+
        "\ufffd\1\uffff\1\ufffd\1\uffff\2\ufffd\1\150\1\155\1\145\1\141\2"+
        "\157\1\145\2\151\1\157\2\uffff\1\ufffd\4\uffff\2\ufffd\1\71\1\uffff"+
        "\1\ufffd\1\uffff\1\ufffd\1\uffff\1\ufffd\35\uffff\7\ufffd\1\141"+
        "\1\160\1\144\1\147\1\160\1\164\1\146\1\147\1\145\1\156\1\71\11\ufffd"+
        "\1\162\1\157\1\151\1\145\1\55\2\164\1\150\1\167\1\164\12\ufffd\1"+
        "\163\1\162\1\141\1\ufffd\1\162\1\157\1\55\1\164\1\160\1\55\1\uffff"+
        "\10\ufffd\1\145\1\164\1\ufffd\1\uffff\2\145\1\151\1\155\1\164\1"+
        "\55\1\157\1\146\10\ufffd\1\164\1\165\1\uffff\1\146\1\156\1\147\1"+
        "\55\1\157\1\151\1\157\1\164\1\162\1\141\5\ufffd\1\47\1\uffff\1\162"+
        "\2\164\1\150\1\162\1\160\1\144\1\164\1\157\1\151\1\157\1\164\1\143"+
        "\2\ufffd\1\uffff\1\154\1\ufffd\1\145\1\164\2\145\1\151\1\ufffd\1"+
        "\144\1\164\1\160\1\144\1\164\1\ufffd\1\145\1\ufffd\1\uffff\1\50"+
        "\1\143\1\uffff\1\162\1\ufffd\1\146\1\156\1\147\1\154\1\157\1\ufffd"+
        "\1\144\1\164\1\uffff\2\ufffd\1\157\1\ufffd\1\143\2\164\1\150\1\145"+
        "\1\155\1\154\1\157\2\uffff\1\162\1\157\1\ufffd\1\145\1\164\2\ufffd"+
        "\1\145\1\155\1\uffff\1\156\1\162\1\143\1\162\3\ufffd\1\145\1\156"+
        "\1\157\1\ufffd\1\143\1\162\1\145\1\162\1\157\1\ufffd\1\162\1\156"+
        "\1\162\1\ufffd\1\145\1\156\1\162\1\145\1\ufffd\1\162\1\ufffd";
    static final String DFA43_acceptS =
        "\24\uffff\1\30\1\31\1\32\1\33\1\34\1\35\1\uffff\1\37\1\41\1\42\1"+
        "\45\1\46\1\47\1\50\1\51\1\uffff\1\54\1\uffff\1\56\3\uffff\1\70\1"+
        "\1\1\17\1\65\1\2\1\uffff\1\4\7\uffff\1\62\1\uffff\1\20\14\uffff"+
        "\1\14\1\15\1\uffff\1\44\1\16\1\43\1\21\3\uffff\1\22\1\uffff\1\23"+
        "\1\uffff\1\25\1\uffff\1\26\1\40\1\27\1\53\1\30\1\31\1\32\1\33\1"+
        "\34\1\35\1\57\1\60\1\36\1\37\1\41\1\42\1\45\1\46\1\47\1\50\1\51"+
        "\1\63\1\52\1\54\1\67\1\55\1\56\1\64\1\66\71\uffff\1\24\13\uffff"+
        "\1\10\22\uffff\1\7\20\uffff\1\6\17\uffff\1\5\20\uffff\1\3\2\uffff"+
        "\1\11\12\uffff\1\12\14\uffff\1\13\1\61\11\uffff\1\61\34\uffff";
    static final String DFA43_specialS =
        "\1\0\u0140\uffff}>";
    static final String[] DFA43_transitionS = {
            "\11\52\2\46\1\52\2\46\22\52\1\46\1\42\1\13\1\1\1\51\1\30\1\52"+
            "\1\14\1\36\1\37\1\45\1\44\1\26\1\23\1\12\1\32\12\15\1\25\1\24"+
            "\1\22\1\31\1\33\1\27\1\11\15\21\1\5\6\21\1\17\5\21\1\40\1\10"+
            "\1\41\1\2\1\6\1\52\4\47\1\20\3\47\1\3\4\47\1\4\6\47\1\16\5\47"+
            "\1\34\1\50\1\35\1\43\1\52\ud780\7\u0800\52\u1ffe\7\2\52",
            "\1\54\2\uffff\12\54\7\uffff\32\54\1\uffff\1\54\2\uffff\1\54"+
            "\1\uffff\32\54\5\uffff\ud780\54\u0800\uffff\u1ffe\54",
            "\1\55",
            "\1\70\4\uffff\1\64\2\uffff\12\63\7\uffff\32\62\1\uffff\1\67"+
            "\2\uffff\1\65\1\uffff\14\61\1\57\15\61\5\uffff\ud780\66\u0800"+
            "\uffff\u1ffe\66",
            "\2\72\1\uffff\2\72\22\uffff\1\72\7\uffff\1\70\2\uffff\1\72"+
            "\1\uffff\1\71\2\uffff\12\63\7\uffff\32\62\1\uffff\1\67\2\uffff"+
            "\1\65\1\uffff\32\61\5\uffff\ud780\66\u0800\uffff\u1ffe\66",
            "\2\72\1\uffff\2\72\22\uffff\1\72\7\uffff\1\70\2\uffff\1\72"+
            "\1\uffff\1\71\2\uffff\12\63\7\uffff\32\62\1\uffff\1\67\2\uffff"+
            "\1\65\1\uffff\32\61\5\uffff\ud780\66\u0800\uffff\u1ffe\66",
            "\1\70\4\uffff\1\64\2\uffff\12\63\7\uffff\32\62\1\uffff\1\67"+
            "\2\uffff\1\65\1\uffff\32\61\5\uffff\ud780\66\u0800\uffff\u1ffe"+
            "\66",
            "\1\70\4\uffff\1\64\2\uffff\12\63\7\uffff\32\62\1\uffff\1\67"+
            "\2\uffff\1\65\1\uffff\32\61\5\uffff\ud780\66\u0800\uffff\u1ffe"+
            "\66",
            "\20\74\12\73\7\74\6\73\32\74\6\73\30\74\1\uffff\ud780\74\u0800"+
            "\uffff\u1ffe\74",
            "\1\107\23\uffff\32\107\1\uffff\1\107\2\uffff\1\107\1\uffff"+
            "\1\107\1\102\1\75\2\107\1\106\2\107\1\76\2\107\1\103\1\77\2"+
            "\107\1\100\1\107\1\104\1\107\1\101\1\107\1\105\4\107\5\uffff"+
            "\ud780\107\u0800\uffff\u1ffe\107",
            "\12\111\7\uffff\32\110\1\uffff\1\110\2\uffff\1\110\1\uffff"+
            "\32\110\5\uffff\ud780\110\u0800\uffff\u1ffe\110",
            "\1\113\26\uffff\137\113\1\uffff\ud780\113\u0800\uffff\u1ffe"+
            "\113",
            "\1\113\26\uffff\137\113\1\uffff\ud780\113\u0800\uffff\u1ffe"+
            "\113",
            "\1\121\10\uffff\1\120\1\uffff\12\117\7\uffff\15\123\1\122\14"+
            "\123\1\uffff\1\123\2\uffff\1\123\1\uffff\15\123\1\116\14\123"+
            "\5\uffff\ud780\123\u0800\uffff\u1ffe\123",
            "\1\70\4\uffff\1\64\2\uffff\12\63\7\uffff\32\62\1\uffff\1\67"+
            "\2\uffff\1\65\1\uffff\21\61\1\124\10\61\5\uffff\ud780\66\u0800"+
            "\uffff\u1ffe\66",
            "\1\70\2\uffff\1\125\1\uffff\1\64\2\uffff\12\63\7\uffff\32\62"+
            "\1\uffff\1\67\2\uffff\1\65\1\uffff\32\61\5\uffff\ud780\66\u0800"+
            "\uffff\u1ffe\66",
            "\1\70\4\uffff\1\64\2\uffff\12\63\7\uffff\32\62\1\uffff\1\67"+
            "\2\uffff\1\65\1\uffff\27\61\1\126\2\61\5\uffff\ud780\66\u0800"+
            "\uffff\u1ffe\66",
            "\1\70\4\uffff\1\64\2\uffff\12\63\7\uffff\32\62\1\uffff\1\67"+
            "\2\uffff\1\65\1\uffff\32\61\5\uffff\ud780\66\u0800\uffff\u1ffe"+
            "\66",
            "\1\127",
            "\1\131",
            "",
            "",
            "",
            "",
            "",
            "",
            "\1\141\4\uffff\1\142",
            "",
            "",
            "",
            "",
            "",
            "",
            "",
            "",
            "\1\154",
            "",
            "\1\157",
            "",
            "\1\70\4\uffff\1\64\2\uffff\12\63\7\uffff\32\62\1\uffff\1\67"+
            "\2\uffff\1\65\1\uffff\32\61\5\uffff\ud780\66\u0800\uffff\u1ffe"+
            "\66",
            "\1\162",
            "\1\163",
            "",
            "",
            "",
            "",
            "",
            "\1\70\4\uffff\1\64\2\uffff\12\63\7\uffff\32\62\1\uffff\1\67"+
            "\2\uffff\1\65\1\uffff\17\61\1\164\12\61\5\uffff\ud780\66\u0800"+
            "\uffff\u1ffe\66",
            "",
            "\1\70\4\uffff\1\64\2\uffff\12\63\7\uffff\32\62\1\uffff\1\67"+
            "\2\uffff\1\65\1\uffff\32\61\5\uffff\ud780\66\u0800\uffff\u1ffe"+
            "\66",
            "\1\70\4\uffff\1\64\2\uffff\12\63\7\uffff\32\62\1\uffff\1\67"+
            "\2\uffff\1\65\1\uffff\32\61\5\uffff\ud780\66\u0800\uffff\u1ffe"+
            "\66",
            "\1\70\4\uffff\1\64\2\uffff\12\63\7\uffff\32\62\1\uffff\1\67"+
            "\2\uffff\1\65\1\uffff\32\61\5\uffff\ud780\66\u0800\uffff\u1ffe"+
            "\66",
            "\1\70\4\uffff\1\64\2\uffff\12\63\7\uffff\32\62\1\uffff\1\67"+
            "\2\uffff\1\65\1\uffff\32\61\5\uffff\ud780\66\u0800\uffff\u1ffe"+
            "\66",
            "\1\70\4\uffff\1\64\2\uffff\12\63\7\uffff\32\62\1\uffff\1\67"+
            "\2\uffff\1\65\1\uffff\32\61\5\uffff\ud780\66\u0800\uffff\u1ffe"+
            "\66",
            "\1\70\4\uffff\1\64\2\uffff\12\63\7\uffff\32\62\1\uffff\1\67"+
            "\2\uffff\1\65\1\uffff\32\61\5\uffff\ud780\66\u0800\uffff\u1ffe"+
            "\66",
            "\20\166\12\165\7\166\6\165\32\166\6\165\30\166\1\uffff\ud780"+
            "\166\u0800\uffff\u1ffe\166",
            "",
            "\2\72\1\uffff\2\72\22\uffff\1\72\7\uffff\1\70\4\uffff\1\64"+
            "\2\uffff\12\167\7\uffff\32\62\1\uffff\1\67\2\uffff\1\65\1\uffff"+
            "\32\61\5\uffff\ud780\66\u0800\uffff\u1ffe\66",
            "",
            "\1\70\4\uffff\1\64\2\uffff\12\172\7\uffff\6\171\24\62\1\uffff"+
            "\1\67\2\uffff\1\65\1\uffff\6\170\24\61\5\uffff\ud780\66\u0800"+
            "\uffff\u1ffe\66",
            "\1\70\4\uffff\1\64\2\uffff\12\63\7\uffff\32\62\1\uffff\1\67"+
            "\2\uffff\1\65\1\uffff\32\61\5\uffff\ud780\66\u0800\uffff\u1ffe"+
            "\66",
            "\1\173",
            "\1\174",
            "\1\175",
            "\1\176",
            "\1\177",
            "\1\u0080",
            "\1\u0081",
            "\1\u0082",
            "\1\u0083",
            "\1\u0084",
            "",
            "",
            "\1\121\12\uffff\12\111\7\uffff\32\123\1\uffff\1\123\2\uffff"+
            "\1\123\1\uffff\32\123\5\uffff\ud780\123\u0800\uffff\u1ffe\123",
            "",
            "",
            "",
            "",
            "\1\u0085\2\uffff\12\123\7\uffff\32\123\1\uffff\1\123\2\uffff"+
            "\1\123\1\uffff\32\123\5\uffff\ud780\123\u0800\uffff\u1ffe\123",
            "\1\121\10\uffff\1\120\1\uffff\12\117\7\uffff\15\123\1\122\14"+
            "\123\1\uffff\1\123\2\uffff\1\123\1\uffff\15\123\1\116\14\123"+
            "\5\uffff\ud780\123\u0800\uffff\u1ffe\123",
            "\12\111",
            "",
            "\1\u0085\2\uffff\12\123\7\uffff\32\123\1\uffff\1\123\2\uffff"+
            "\1\123\1\uffff\32\123\5\uffff\ud780\123\u0800\uffff\u1ffe\123",
            "",
            "\1\70\4\uffff\1\64\2\uffff\12\63\7\uffff\32\62\1\uffff\1\67"+
            "\2\uffff\1\65\1\uffff\13\61\1\u0086\16\61\5\uffff\ud780\66\u0800"+
            "\uffff\u1ffe\66",
            "",
            "\1\70\4\uffff\1\64\2\uffff\12\63\7\uffff\32\62\1\uffff\1\67"+
            "\2\uffff\1\65\1\uffff\17\61\1\u0087\12\61\5\uffff\ud780\66\u0800"+
            "\uffff\u1ffe\66",
            "",
            "",
            "",
            "",
            "",
            "",
            "",
            "",
            "",
            "",
            "",
            "",
            "",
            "",
            "",
            "",
            "",
            "",
            "",
            "",
            "",
            "",
            "",
            "",
            "",
            "",
            "",
            "",
            "",
            "\1\70\4\uffff\1\64\2\uffff\12\63\7\uffff\32\62\1\uffff\1\67"+
            "\2\uffff\1\65\1\uffff\16\61\1\u0088\13\61\5\uffff\ud780\66\u0800"+
            "\uffff\u1ffe\66",
            "\1\70\4\uffff\1\64\2\uffff\12\u008b\7\uffff\6\u008a\24\62\1"+
            "\uffff\1\67\2\uffff\1\65\1\uffff\6\u0089\24\61\5\uffff\ud780"+
            "\66\u0800\uffff\u1ffe\66",
            "\1\70\4\uffff\1\64\2\uffff\12\63\7\uffff\32\62\1\uffff\1\67"+
            "\2\uffff\1\65\1\uffff\32\61\5\uffff\ud780\66\u0800\uffff\u1ffe"+
            "\66",
            "\1\70\4\uffff\1\64\2\uffff\12\167\7\uffff\32\62\1\uffff\1\67"+
            "\2\uffff\1\65\1\uffff\32\61\5\uffff\ud780\66\u0800\uffff\u1ffe"+
            "\66",
            "\1\70\4\uffff\1\64\2\uffff\12\u008e\7\uffff\6\u008d\24\62\1"+
            "\uffff\1\67\2\uffff\1\65\1\uffff\6\u008c\24\61\5\uffff\ud780"+
            "\66\u0800\uffff\u1ffe\66",
            "\1\70\4\uffff\1\64\2\uffff\12\u008e\7\uffff\6\u008d\24\62\1"+
            "\uffff\1\67\2\uffff\1\65\1\uffff\6\u008c\24\61\5\uffff\ud780"+
            "\66\u0800\uffff\u1ffe\66",
            "\1\70\4\uffff\1\64\2\uffff\12\u008e\7\uffff\6\u008d\24\62\1"+
            "\uffff\1\67\2\uffff\1\65\1\uffff\6\u008c\24\61\5\uffff\ud780"+
            "\66\u0800\uffff\u1ffe\66",
            "\1\u008f",
            "\1\u0090",
            "\1\u0091",
            "\1\u0092",
            "\1\u0093",
            "\1\u0094",
            "\1\u0095",
            "\1\u0096",
            "\1\u0097",
            "\1\u0098",
            "\2\72\1\uffff\2\72\22\uffff\1\72\17\uffff\12\u0099",
            "\1\u009a\4\uffff\1\64\2\uffff\12\63\7\uffff\32\62\1\uffff\1"+
            "\67\2\uffff\1\65\1\uffff\32\61\5\uffff\ud780\66\u0800\uffff"+
            "\u1ffe\66",
            "\1\70\4\uffff\1\64\2\uffff\12\63\7\uffff\32\62\1\uffff\1\67"+
            "\2\uffff\1\65\1\uffff\21\61\1\u009b\10\61\5\uffff\ud780\66\u0800"+
            "\uffff\u1ffe\66",
            "\1\70\4\uffff\1\64\2\uffff\12\63\7\uffff\32\62\1\uffff\1\67"+
            "\2\uffff\1\65\1\uffff\21\61\1\u009c\10\61\5\uffff\ud780\66\u0800"+
            "\uffff\u1ffe\66",
            "\1\70\4\uffff\1\64\2\uffff\12\u009f\7\uffff\6\u009e\24\62\1"+
            "\uffff\1\67\2\uffff\1\65\1\uffff\6\u009d\24\61\5\uffff\ud780"+
            "\66\u0800\uffff\u1ffe\66",
            "\1\70\4\uffff\1\64\2\uffff\12\u009f\7\uffff\6\u009e\24\62\1"+
            "\uffff\1\67\2\uffff\1\65\1\uffff\6\u009d\24\61\5\uffff\ud780"+
            "\66\u0800\uffff\u1ffe\66",
            "\1\70\4\uffff\1\64\2\uffff\12\u009f\7\uffff\6\u009e\24\62\1"+
            "\uffff\1\67\2\uffff\1\65\1\uffff\6\u009d\24\61\5\uffff\ud780"+
            "\66\u0800\uffff\u1ffe\66",
            "\1\70\4\uffff\1\64\2\uffff\12\u00a2\7\uffff\6\u00a1\24\62\1"+
            "\uffff\1\67\2\uffff\1\65\1\uffff\6\u00a0\24\61\5\uffff\ud780"+
            "\66\u0800\uffff\u1ffe\66",
            "\1\70\4\uffff\1\64\2\uffff\12\u00a2\7\uffff\6\u00a1\24\62\1"+
            "\uffff\1\67\2\uffff\1\65\1\uffff\6\u00a0\24\61\5\uffff\ud780"+
            "\66\u0800\uffff\u1ffe\66",
            "\1\70\4\uffff\1\64\2\uffff\12\u00a2\7\uffff\6\u00a1\24\62\1"+
            "\uffff\1\67\2\uffff\1\65\1\uffff\6\u00a0\24\61\5\uffff\ud780"+
            "\66\u0800\uffff\u1ffe\66",
            "\1\u00a3",
            "\1\u00a4",
            "\1\u00a5",
            "\1\u00a6",
            "\1\u00a7",
            "\1\u00a8",
            "\1\u00a9",
            "\1\u00aa",
            "\1\u00ab",
            "\1\u00ac",
            "\1\123\2\uffff\12\u0099\7\uffff\32\123\1\uffff\1\123\2\uffff"+
            "\1\123\1\uffff\32\123\5\uffff\ud780\123\u0800\uffff\u1ffe\123",
            "\2\u00ad\1\uffff\2\u00ad\22\uffff\10\u00ad\1\uffff\126\u00ad"+
            "\1\uffff\ud780\u00ad\u0800\uffff\u1ffe\u00ad",
            "\1\70\4\uffff\1\64\2\uffff\12\63\7\uffff\32\62\1\uffff\1\67"+
            "\2\uffff\1\65\1\uffff\4\61\1\u00ae\25\61\5\uffff\ud780\66\u0800"+
            "\uffff\u1ffe\66",
            "\1\70\4\uffff\1\64\2\uffff\12\63\7\uffff\32\62\1\uffff\1\67"+
            "\2\uffff\1\65\1\uffff\23\61\1\u00af\6\61\5\uffff\ud780\66\u0800"+
            "\uffff\u1ffe\66",
            "\1\70\4\uffff\1\64\2\uffff\12\u00b2\7\uffff\6\u00b1\24\62\1"+
            "\uffff\1\67\2\uffff\1\65\1\uffff\6\u00b0\24\61\5\uffff\ud780"+
            "\66\u0800\uffff\u1ffe\66",
            "\1\70\4\uffff\1\64\2\uffff\12\u00b2\7\uffff\6\u00b1\24\62\1"+
            "\uffff\1\67\2\uffff\1\65\1\uffff\6\u00b0\24\61\5\uffff\ud780"+
            "\66\u0800\uffff\u1ffe\66",
            "\1\70\4\uffff\1\64\2\uffff\12\u00b2\7\uffff\6\u00b1\24\62\1"+
            "\uffff\1\67\2\uffff\1\65\1\uffff\6\u00b0\24\61\5\uffff\ud780"+
            "\66\u0800\uffff\u1ffe\66",
            "\1\70\4\uffff\1\64\2\uffff\12\u00b5\7\uffff\6\u00b4\24\62\1"+
            "\uffff\1\67\2\uffff\1\65\1\uffff\6\u00b3\24\61\5\uffff\ud780"+
            "\66\u0800\uffff\u1ffe\66",
            "\1\70\4\uffff\1\64\2\uffff\12\u00b5\7\uffff\6\u00b4\24\62\1"+
            "\uffff\1\67\2\uffff\1\65\1\uffff\6\u00b3\24\61\5\uffff\ud780"+
            "\66\u0800\uffff\u1ffe\66",
            "\1\70\4\uffff\1\64\2\uffff\12\u00b5\7\uffff\6\u00b4\24\62\1"+
            "\uffff\1\67\2\uffff\1\65\1\uffff\6\u00b3\24\61\5\uffff\ud780"+
            "\66\u0800\uffff\u1ffe\66",
            "\1\u00b6",
            "\1\u00b7",
            "\1\u00b8",
            "\1\107\2\uffff\12\107\7\uffff\32\107\1\uffff\1\107\2\uffff"+
            "\1\107\1\uffff\32\107\5\uffff\ud780\107\u0800\uffff\u1ffe\107",
            "\1\u00bb\10\uffff\1\u00ba\5\uffff\1\u00bc",
            "\1\u00bd",
            "\1\u00be",
            "\1\u00bf",
            "\1\u00c0",
            "\1\u00c1",
            "",
            "\1\70\4\uffff\1\64\2\uffff\12\63\7\uffff\32\62\1\uffff\1\67"+
            "\2\uffff\1\65\1\uffff\22\61\1\u00c2\7\61\5\uffff\ud780\66\u0800"+
            "\uffff\u1ffe\66",
            "\1\70\4\uffff\1\64\2\uffff\12\63\7\uffff\32\62\1\uffff\1\67"+
            "\2\uffff\1\65\1\uffff\1\u00c3\31\61\5\uffff\ud780\66\u0800\uffff"+
            "\u1ffe\66",
            "\1\70\4\uffff\1\64\2\uffff\12\u00c6\7\uffff\6\u00c5\24\62\1"+
            "\uffff\1\67\2\uffff\1\65\1\uffff\6\u00c4\24\61\5\uffff\ud780"+
            "\66\u0800\uffff\u1ffe\66",
            "\1\70\4\uffff\1\64\2\uffff\12\u00c6\7\uffff\6\u00c5\24\62\1"+
            "\uffff\1\67\2\uffff\1\65\1\uffff\6\u00c4\24\61\5\uffff\ud780"+
            "\66\u0800\uffff\u1ffe\66",
            "\1\70\4\uffff\1\64\2\uffff\12\u00c6\7\uffff\6\u00c5\24\62\1"+
            "\uffff\1\67\2\uffff\1\65\1\uffff\6\u00c4\24\61\5\uffff\ud780"+
            "\66\u0800\uffff\u1ffe\66",
            "\1\70\4\uffff\1\64\2\uffff\12\u00c9\7\uffff\6\u00c8\24\62\1"+
            "\uffff\1\67\2\uffff\1\65\1\uffff\6\u00c7\24\61\5\uffff\ud780"+
            "\66\u0800\uffff\u1ffe\66",
            "\1\70\4\uffff\1\64\2\uffff\12\u00c9\7\uffff\6\u00c8\24\62\1"+
            "\uffff\1\67\2\uffff\1\65\1\uffff\6\u00c7\24\61\5\uffff\ud780"+
            "\66\u0800\uffff\u1ffe\66",
            "\1\70\4\uffff\1\64\2\uffff\12\u00c9\7\uffff\6\u00c8\24\62\1"+
            "\uffff\1\67\2\uffff\1\65\1\uffff\6\u00c7\24\61\5\uffff\ud780"+
            "\66\u0800\uffff\u1ffe\66",
            "\1\u00ca",
            "\1\u00cb",
            "\1\107\2\uffff\12\107\7\uffff\32\107\1\uffff\1\107\2\uffff"+
            "\1\107\1\uffff\32\107\5\uffff\ud780\107\u0800\uffff\u1ffe\107",
            "",
            "\1\u00cd",
            "\1\u00ce",
            "\1\u00cf",
            "\1\u00d0",
            "\1\u00d3\12\uffff\1\u00d2\6\uffff\1\u00d1",
            "\1\u00d4",
            "\1\u00d5",
            "\1\u00d6",
            "\1\70\4\uffff\1\64\2\uffff\12\63\7\uffff\32\62\1\uffff\1\67"+
            "\2\uffff\1\65\1\uffff\22\61\1\u00d7\7\61\5\uffff\ud780\66\u0800"+
            "\uffff\u1ffe\66",
            "\1\70\4\uffff\1\64\2\uffff\12\63\7\uffff\32\62\1\uffff\1\67"+
            "\2\uffff\1\65\1\uffff\15\61\1\u00d8\14\61\5\uffff\ud780\66\u0800"+
            "\uffff\u1ffe\66",
            "\1\70\4\uffff\1\64\2\uffff\12\u00db\7\uffff\6\u00da\24\62\1"+
            "\uffff\1\67\2\uffff\1\65\1\uffff\6\u00d9\24\61\5\uffff\ud780"+
            "\66\u0800\uffff\u1ffe\66",
            "\1\70\4\uffff\1\64\2\uffff\12\u00db\7\uffff\6\u00da\24\62\1"+
            "\uffff\1\67\2\uffff\1\65\1\uffff\6\u00d9\24\61\5\uffff\ud780"+
            "\66\u0800\uffff\u1ffe\66",
            "\1\70\4\uffff\1\64\2\uffff\12\u00db\7\uffff\6\u00da\24\62\1"+
            "\uffff\1\67\2\uffff\1\65\1\uffff\6\u00d9\24\61\5\uffff\ud780"+
            "\66\u0800\uffff\u1ffe\66",
            "\1\70\4\uffff\1\64\2\uffff\12\63\7\uffff\32\62\1\uffff\1\67"+
            "\2\uffff\1\65\1\uffff\32\61\5\uffff\ud780\66\u0800\uffff\u1ffe"+
            "\66",
            "\1\70\4\uffff\1\64\2\uffff\12\63\7\uffff\32\62\1\uffff\1\67"+
            "\2\uffff\1\65\1\uffff\32\61\5\uffff\ud780\66\u0800\uffff\u1ffe"+
            "\66",
            "\1\70\4\uffff\1\64\2\uffff\12\63\7\uffff\32\62\1\uffff\1\67"+
            "\2\uffff\1\65\1\uffff\32\61\5\uffff\ud780\66\u0800\uffff\u1ffe"+
            "\66",
            "\1\u00dc",
            "\2\u00dd\1\uffff\2\u00dd\22\uffff\1\u00dd\1\uffff\1\u00dd\4"+
            "\uffff\1\u00dd\115\uffff\1\u00de",
            "",
            "\1\u00df",
            "\1\u00e0",
            "\1\u00e1",
            "\1\u00e2",
            "\1\u00e3",
            "\1\u00e4",
            "\1\u00e5",
            "\1\u00e8\12\uffff\1\u00e7\6\uffff\1\u00e6",
            "\1\u00e9",
            "\1\u00ea",
            "\1\70\4\uffff\1\64\2\uffff\12\63\7\uffff\32\62\1\uffff\1\67"+
            "\2\uffff\1\65\1\uffff\10\61\1\u00eb\21\61\5\uffff\ud780\66\u0800"+
            "\uffff\u1ffe\66",
            "\1\70\4\uffff\1\64\2\uffff\12\63\7\uffff\32\62\1\uffff\1\67"+
            "\2\uffff\1\65\1\uffff\23\61\1\u00ec\6\61\5\uffff\ud780\66\u0800"+
            "\uffff\u1ffe\66",
            "\1\70\4\uffff\1\64\2\uffff\12\63\7\uffff\32\62\1\uffff\1\67"+
            "\2\uffff\1\65\1\uffff\32\61\5\uffff\ud780\66\u0800\uffff\u1ffe"+
            "\66",
            "\1\70\4\uffff\1\64\2\uffff\12\63\7\uffff\32\62\1\uffff\1\67"+
            "\2\uffff\1\65\1\uffff\32\61\5\uffff\ud780\66\u0800\uffff\u1ffe"+
            "\66",
            "\1\70\4\uffff\1\64\2\uffff\12\63\7\uffff\32\62\1\uffff\1\67"+
            "\2\uffff\1\65\1\uffff\32\61\5\uffff\ud780\66\u0800\uffff\u1ffe"+
            "\66",
            "\2\u00ed\1\uffff\2\u00ed\22\uffff\1\u00ed\1\uffff\1\u00ed\4"+
            "\uffff\1\u00ed",
            "",
            "\1\u00ee",
            "\1\u00ef",
            "\1\u00f0",
            "\1\u00f1",
            "\1\u00f3\10\uffff\1\u00f2\5\uffff\1\u00f4",
            "\1\u00f5",
            "\1\u00f6",
            "\1\u00f7",
            "\1\u00f8",
            "\1\u00f9",
            "\1\u00fa",
            "\1\u00fb",
            "\1\u00fc",
            "\1\70\4\uffff\1\64\2\uffff\12\63\7\uffff\32\62\1\uffff\1\67"+
            "\2\uffff\1\65\1\uffff\16\61\1\u00fd\13\61\5\uffff\ud780\66\u0800"+
            "\uffff\u1ffe\66",
            "\1\70\4\uffff\1\64\2\uffff\12\63\7\uffff\32\62\1\uffff\1\67"+
            "\2\uffff\1\65\1\uffff\32\61\5\uffff\ud780\66\u0800\uffff\u1ffe"+
            "\66",
            "",
            "\1\u00ff",
            "\1\u0100\2\uffff\12\107\7\uffff\32\107\1\uffff\1\107\2\uffff"+
            "\1\107\1\uffff\32\107\5\uffff\ud780\107\u0800\uffff\u1ffe\107",
            "\1\u0102",
            "\1\u0103",
            "\1\u0104",
            "\1\u0105",
            "\1\u0106",
            "\1\107\2\uffff\12\107\7\uffff\32\107\1\uffff\1\107\2\uffff"+
            "\1\107\1\uffff\32\107\5\uffff\ud780\107\u0800\uffff\u1ffe\107",
            "\1\u0107",
            "\1\u0108",
            "\1\u0109",
            "\1\u010a",
            "\1\u010b",
            "\1\107\2\uffff\12\107\7\uffff\32\107\1\uffff\1\107\2\uffff"+
            "\1\107\1\uffff\32\107\5\uffff\ud780\107\u0800\uffff\u1ffe\107",
            "\1\u010d",
            "\1\70\4\uffff\1\64\2\uffff\12\63\7\uffff\32\62\1\uffff\1\67"+
            "\2\uffff\1\65\1\uffff\15\61\1\u010e\14\61\5\uffff\ud780\66\u0800"+
            "\uffff\u1ffe\66",
            "",
            "\1\u00dd",
            "\1\u010f",
            "",
            "\1\u0110",
            "\1\u0111\2\uffff\12\107\7\uffff\32\107\1\uffff\1\107\2\uffff"+
            "\1\107\1\uffff\32\107\5\uffff\ud780\107\u0800\uffff\u1ffe\107",
            "\1\u0112",
            "\1\u0113",
            "\1\u0114",
            "\1\u0115",
            "\1\u0116",
            "\1\107\2\uffff\12\107\7\uffff\32\107\1\uffff\1\107\2\uffff"+
            "\1\107\1\uffff\32\107\5\uffff\ud780\107\u0800\uffff\u1ffe\107",
            "\1\u0117",
            "\1\u0118",
            "",
            "\1\107\2\uffff\12\107\7\uffff\32\107\1\uffff\1\107\2\uffff"+
            "\1\107\1\uffff\32\107\5\uffff\ud780\107\u0800\uffff\u1ffe\107",
            "\1\u011a\4\uffff\1\64\2\uffff\12\63\7\uffff\32\62\1\uffff\1"+
            "\67\2\uffff\1\65\1\uffff\32\61\5\uffff\ud780\66\u0800\uffff"+
            "\u1ffe\66",
            "\1\u011b",
            "\1\107\2\uffff\12\107\7\uffff\32\107\1\uffff\1\107\2\uffff"+
            "\1\107\1\uffff\32\107\5\uffff\ud780\107\u0800\uffff\u1ffe\107",
            "\1\u011c",
            "\1\u011d",
            "\1\u011e",
            "\1\u011f",
            "\1\u0120",
            "\1\u0121",
            "\1\u0122",
            "\1\u0123",
            "",
            "",
            "\1\u0125",
            "\1\u0126",
            "\1\u0127\2\uffff\12\107\7\uffff\32\107\1\uffff\1\107\2\uffff"+
            "\1\107\1\uffff\32\107\5\uffff\ud780\107\u0800\uffff\u1ffe\107",
            "\1\u0128",
            "\1\u0129",
            "\1\107\2\uffff\12\107\7\uffff\32\107\1\uffff\1\107\2\uffff"+
            "\1\107\1\uffff\32\107\5\uffff\ud780\107\u0800\uffff\u1ffe\107",
            "\1\107\2\uffff\12\107\7\uffff\32\107\1\uffff\1\107\2\uffff"+
            "\1\107\1\uffff\32\107\5\uffff\ud780\107\u0800\uffff\u1ffe\107",
            "\1\u012a",
            "\1\u012b",
            "",
            "\1\u012c",
            "\1\u012d",
            "\1\u012e",
            "\1\u012f",
            "\1\u0130\2\uffff\12\107\7\uffff\32\107\1\uffff\1\107\2\uffff"+
            "\1\107\1\uffff\32\107\5\uffff\ud780\107\u0800\uffff\u1ffe\107",
            "\1\107\2\uffff\12\107\7\uffff\32\107\1\uffff\1\107\2\uffff"+
            "\1\107\1\uffff\32\107\5\uffff\ud780\107\u0800\uffff\u1ffe\107",
            "\1\107\2\uffff\12\107\7\uffff\32\107\1\uffff\1\107\2\uffff"+
            "\1\107\1\uffff\32\107\5\uffff\ud780\107\u0800\uffff\u1ffe\107",
            "\1\u0131",
            "\1\u0132",
            "\1\u0133",
            "\1\107\2\uffff\12\107\7\uffff\32\107\1\uffff\1\107\2\uffff"+
            "\1\107\1\uffff\32\107\5\uffff\ud780\107\u0800\uffff\u1ffe\107",
            "\1\u0134",
            "\1\u0135",
            "\1\u0136",
            "\1\u0137",
            "\1\u0138",
            "\1\107\2\uffff\12\107\7\uffff\32\107\1\uffff\1\107\2\uffff"+
            "\1\107\1\uffff\32\107\5\uffff\ud780\107\u0800\uffff\u1ffe\107",
            "\1\u0139",
            "\1\u013a",
            "\1\u013b",
            "\1\107\2\uffff\12\107\7\uffff\32\107\1\uffff\1\107\2\uffff"+
            "\1\107\1\uffff\32\107\5\uffff\ud780\107\u0800\uffff\u1ffe\107",
            "\1\u013c",
            "\1\u013d",
            "\1\u013e",
            "\1\u013f",
            "\1\107\2\uffff\12\107\7\uffff\32\107\1\uffff\1\107\2\uffff"+
            "\1\107\1\uffff\32\107\5\uffff\ud780\107\u0800\uffff\u1ffe\107",
            "\1\u0140",
            "\1\107\2\uffff\12\107\7\uffff\32\107\1\uffff\1\107\2\uffff"+
            "\1\107\1\uffff\32\107\5\uffff\ud780\107\u0800\uffff\u1ffe\107"
    };

    static final short[] DFA43_eot = DFA.unpackEncodedString(DFA43_eotS);
    static final short[] DFA43_eof = DFA.unpackEncodedString(DFA43_eofS);
    static final char[] DFA43_min = DFA.unpackEncodedStringToUnsignedChars(DFA43_minS);
    static final char[] DFA43_max = DFA.unpackEncodedStringToUnsignedChars(DFA43_maxS);
    static final short[] DFA43_accept = DFA.unpackEncodedString(DFA43_acceptS);
    static final short[] DFA43_special = DFA.unpackEncodedString(DFA43_specialS);

    static short[][] DFA43_transition() {
        int numStates = DFA43_transitionS.length;
        short[][] DFA43_transition = new short[numStates][];
        for (int i=0; i<numStates; i++) {
            DFA43_transition[i] = DFA.unpackEncodedString(DFA43_transitionS[i]);
        }
        return DFA43_transition;
    }

    class DFA43 extends DFA {

        public DFA43(BaseRecognizer recognizer) {
            this.recognizer = recognizer;
            this.decisionNumber = 43;
            this.eot = DFA43_eot;
            this.eof = DFA43_eof;
            this.min = DFA43_min;
            this.max = DFA43_max;
            this.accept = DFA43_accept;
            this.special = DFA43_special;
            this.transition = DFA43_transition();
        }
        public String getDescription() {
            return "1:1: Tokens : ( T__99 | T__100 | T__101 | IDENT | CHARSET | IMPORT | MEDIA | PAGE | MARGIN_AREA | VIEWPORT | FONTFACE | ATKEYWORD | CLASSKEYWORD | STRING | HASH | INDEX | NUMBER | PERCENTAGE | DIMENSION | URI | UNIRANGE | CDO | CDC | SEMICOLON | COLON | COMMA | QUESTION | PERCENT | EQUALS | SLASH | GREATER | LESS | LCURLY | RCURLY | APOS | QUOT | LPAREN | RPAREN | LBRACE | RBRACE | EXCLAMATION | TILDE | MINUS | PLUS | ASTERISK | S | COMMENT | SL_COMMENT | EXPRESSION | FUNCTION | INCLUDES | DASHMATCH | STARTSWITH | ENDSWITH | CONTAINS | INVALID_TOKEN );";
        }
        public int specialStateTransition(int s, IntStream _input) throws NoViableAltException {
            IntStream input = _input;
        	int _s = s;
            switch ( s ) {
                    case 0 : 
                        int LA43_0 = input.LA(1);

                        s = -1;
                        if ( (LA43_0=='#') ) {s = 1;}

                        else if ( (LA43_0=='^') ) {s = 2;}

                        else if ( (LA43_0=='i') ) {s = 3;}

                        else if ( (LA43_0=='n') ) {s = 4;}

                        else if ( (LA43_0=='N') ) {s = 5;}

                        else if ( (LA43_0=='_') ) {s = 6;}

                        else if ( ((LA43_0 >= '\u0080' && LA43_0 <= '\uD7FF')||(LA43_0 >= '\uE000' && LA43_0 <= '\uFFFD')) ) {s = 7;}

                        else if ( (LA43_0=='\\') ) {s = 8;}

                        else if ( (LA43_0=='@') ) {s = 9;}

                        else if ( (LA43_0=='.') ) {s = 10;}

                        else if ( (LA43_0=='\"') ) {s = 11;}

                        else if ( (LA43_0=='\'') ) {s = 12;}

                        else if ( ((LA43_0 >= '0' && LA43_0 <= '9')) ) {s = 13;}

                        else if ( (LA43_0=='u') ) {s = 14;}

                        else if ( (LA43_0=='U') ) {s = 15;}

                        else if ( (LA43_0=='e') ) {s = 16;}

                        else if ( ((LA43_0 >= 'A' && LA43_0 <= 'M')||(LA43_0 >= 'O' && LA43_0 <= 'T')||(LA43_0 >= 'V' && LA43_0 <= 'Z')) ) {s = 17;}

                        else if ( (LA43_0=='<') ) {s = 18;}

                        else if ( (LA43_0=='-') ) {s = 19;}

                        else if ( (LA43_0==';') ) {s = 20;}

                        else if ( (LA43_0==':') ) {s = 21;}

                        else if ( (LA43_0==',') ) {s = 22;}

                        else if ( (LA43_0=='?') ) {s = 23;}

                        else if ( (LA43_0=='%') ) {s = 24;}

                        else if ( (LA43_0=='=') ) {s = 25;}

                        else if ( (LA43_0=='/') ) {s = 26;}

                        else if ( (LA43_0=='>') ) {s = 27;}

                        else if ( (LA43_0=='{') ) {s = 28;}

                        else if ( (LA43_0=='}') ) {s = 29;}

                        else if ( (LA43_0=='(') ) {s = 30;}

                        else if ( (LA43_0==')') ) {s = 31;}

                        else if ( (LA43_0=='[') ) {s = 32;}

                        else if ( (LA43_0==']') ) {s = 33;}

                        else if ( (LA43_0=='!') ) {s = 34;}

                        else if ( (LA43_0=='~') ) {s = 35;}

                        else if ( (LA43_0=='+') ) {s = 36;}

                        else if ( (LA43_0=='*') ) {s = 37;}

                        else if ( ((LA43_0 >= '\t' && LA43_0 <= '\n')||(LA43_0 >= '\f' && LA43_0 <= '\r')||LA43_0==' ') ) {s = 38;}

                        else if ( ((LA43_0 >= 'a' && LA43_0 <= 'd')||(LA43_0 >= 'f' && LA43_0 <= 'h')||(LA43_0 >= 'j' && LA43_0 <= 'm')||(LA43_0 >= 'o' && LA43_0 <= 't')||(LA43_0 >= 'v' && LA43_0 <= 'z')) ) {s = 39;}

                        else if ( (LA43_0=='|') ) {s = 40;}

                        else if ( (LA43_0=='$') ) {s = 41;}

                        else if ( ((LA43_0 >= '\u0000' && LA43_0 <= '\b')||LA43_0=='\u000B'||(LA43_0 >= '\u000E' && LA43_0 <= '\u001F')||LA43_0=='&'||LA43_0=='`'||LA43_0=='\u007F'||(LA43_0 >= '\uD800' && LA43_0 <= '\uDFFF')||(LA43_0 >= '\uFFFE' && LA43_0 <= '\uFFFF')) ) {s = 42;}

                        if ( s>=0 ) return s;
                        break;
            }
            NoViableAltException nvae =
                new NoViableAltException(getDescription(), 43, _s, input);
            error(nvae);
            throw nvae;
        }

    }
 

}
