/*
 * Decompiled with CFR 0.152.
 */
package cz.vutbr.web.csskit;

import cz.vutbr.web.css.Selector;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import org.w3c.dom.Attr;
import org.w3c.dom.Element;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class ElementUtil {
    public static final String CLASS_DELIM = " ";
    public static final String CLASS_ATTR = "class";
    public static final String ID_ATTR = "id";

    public static Collection<String> elementClasses(Element e) {
        if (e.hasAttribute(CLASS_ATTR)) {
            String classNames = e.getAttribute(CLASS_ATTR);
            ArrayList<String> list = new ArrayList<String>();
            for (String cname : classNames.toLowerCase().split(CLASS_DELIM)) {
                if ((cname = cname.trim()).length() <= 0) continue;
                list.add(cname);
            }
            return list;
        }
        return Collections.emptyList();
    }

    public static boolean matchesClass(Element e, String className) {
        if (e.hasAttribute(CLASS_ATTR)) {
            String classNames = e.getAttribute(CLASS_ATTR).toLowerCase();
            int len = className.length();
            int start = classNames.indexOf(className.toLowerCase());
            if (start == -1) {
                return false;
            }
            return !(start != 0 && !Character.isWhitespace(classNames.charAt(start - 1)) || start + len != classNames.length() && !Character.isWhitespace(classNames.charAt(start + len)));
        }
        return false;
    }

    public static String elementID(Element e) {
        String id = e.getAttribute(ID_ATTR);
        return id;
    }

    public static boolean matchesID(Element e, String id) {
        return id.equalsIgnoreCase(ElementUtil.elementID(e));
    }

    public static String elementName(Element e) {
        String name = e.getNodeName();
        return name;
    }

    public static boolean matchesName(Element e, String name) {
        if (name == null) {
            return false;
        }
        return name.equalsIgnoreCase(ElementUtil.elementName(e));
    }

    public static boolean matchesAttribute(Element e, String name, String value, Selector.Operator o) {
        Attr attributeNode = e.getAttributeNode(name);
        if (attributeNode != null && o != null) {
            String attributeValue = attributeNode.getNodeValue();
            switch (o) {
                case EQUALS: {
                    return attributeValue.equals(value);
                }
                case INCLUDES: {
                    attributeValue = CLASS_DELIM + attributeValue + CLASS_DELIM;
                    return attributeValue.matches(".* " + value + " .*");
                }
                case DASHMATCH: {
                    return attributeValue.matches("^" + value + "(-.*|$)");
                }
                case CONTAINS: {
                    return attributeValue.matches(".*" + value + ".*");
                }
                case STARTSWITH: {
                    return attributeValue.matches("^" + value + ".*");
                }
                case ENDSWITH: {
                    return attributeValue.matches(".*" + value + "$");
                }
            }
            return true;
        }
        return false;
    }
}

