/*
 * Decompiled with CFR 0.152.
 */
package net.snowflake.client.jdbc.internal.org.bouncycastle.jcajce.provider;

import java.lang.reflect.Constructor;
import java.lang.reflect.Method;
import java.security.AccessController;
import java.security.PrivilegedAction;
import java.security.spec.AlgorithmParameterSpec;
import java.security.spec.InvalidParameterSpecException;
import javax.crypto.spec.IvParameterSpec;
import net.snowflake.client.jdbc.internal.org.bouncycastle.asn1.ASN1Primitive;
import net.snowflake.client.jdbc.internal.org.bouncycastle.asn1.cms.GCMParameters;
import net.snowflake.client.jdbc.internal.org.bouncycastle.jcajce.spec.AEADParameterSpec;
import net.snowflake.client.jdbc.internal.org.bouncycastle.util.Integers;

class GcmSpecUtil {
    static final Class gcmSpecClass = GcmSpecUtil.lookup("javax.crypto.spec.GCMParameterSpec");

    GcmSpecUtil() {
    }

    static boolean gcmSpecExists() {
        return gcmSpecClass != null;
    }

    static boolean isGcmSpec(AlgorithmParameterSpec algorithmParameterSpec) {
        return gcmSpecClass != null && gcmSpecClass.isInstance(algorithmParameterSpec);
    }

    static boolean isGcmSpec(Class clazz) {
        return gcmSpecClass == clazz;
    }

    static Class[] getCipherSpecClasses() {
        if (GcmSpecUtil.gcmSpecExists()) {
            return new Class[]{gcmSpecClass, IvParameterSpec.class};
        }
        return new Class[]{AEADParameterSpec.class, IvParameterSpec.class};
    }

    static AlgorithmParameterSpec extractGcmSpec(final ASN1Primitive aSN1Primitive) throws InvalidParameterSpecException {
        Object object = AccessController.doPrivileged(new PrivilegedAction<Object>(){

            @Override
            public Object run() {
                try {
                    GCMParameters gCMParameters = GCMParameters.getInstance(aSN1Primitive);
                    Constructor constructor = gcmSpecClass.getConstructor(Integer.TYPE, byte[].class);
                    return constructor.newInstance(Integers.valueOf(gCMParameters.getIcvLen() * 8), gCMParameters.getNonce());
                }
                catch (NoSuchMethodException noSuchMethodException) {
                    return new InvalidParameterSpecException("no constructor found!");
                }
                catch (Exception exception) {
                    return new InvalidParameterSpecException("construction failed: " + exception.getMessage());
                }
            }
        });
        if (object instanceof AlgorithmParameterSpec) {
            return (AlgorithmParameterSpec)object;
        }
        throw (InvalidParameterSpecException)object;
    }

    static GCMParameters extractGcmParameters(final AlgorithmParameterSpec algorithmParameterSpec) throws InvalidParameterSpecException {
        Object object = AccessController.doPrivileged(new PrivilegedAction<Object>(){

            @Override
            public Object run() {
                try {
                    Method method = gcmSpecClass.getDeclaredMethod("getTLen", new Class[0]);
                    Method method2 = gcmSpecClass.getDeclaredMethod("getIV", new Class[0]);
                    return new GCMParameters((byte[])method2.invoke((Object)algorithmParameterSpec, new Object[0]), (Integer)method.invoke((Object)algorithmParameterSpec, new Object[0]) / 8);
                }
                catch (Exception exception) {
                    return new InvalidParameterSpecException("cannot process GCMParameterSpec: " + exception.getMessage());
                }
            }
        });
        if (object instanceof GCMParameters) {
            return (GCMParameters)object;
        }
        throw (InvalidParameterSpecException)object;
    }

    private static Class lookup(String string) {
        try {
            return GcmSpecUtil.class.getClassLoader().loadClass(string);
        }
        catch (Exception exception) {
            return null;
        }
    }
}

