/*
 * Decompiled with CFR 0.152.
 */
package net.snowflake.client.jdbc.internal.org.bouncycastle.jcajce.provider;

import java.security.MessageDigest;
import net.snowflake.client.jdbc.internal.org.bouncycastle.crypto.OutputDigestCalculator;
import net.snowflake.client.jdbc.internal.org.bouncycastle.crypto.Parameters;
import net.snowflake.client.jdbc.internal.org.bouncycastle.crypto.UpdateOutputStream;
import net.snowflake.client.jdbc.internal.org.bouncycastle.crypto.fips.FipsDigestOperatorFactory;
import net.snowflake.client.jdbc.internal.org.bouncycastle.crypto.fips.FipsSHS;

final class BaseMessageDigest
extends MessageDigest
implements Cloneable {
    private static FipsDigestOperatorFactory<FipsSHS.Parameters> fipsFactory = new FipsSHS.OperatorFactory<FipsSHS.Parameters>();
    protected final OutputDigestCalculator digestCalculator;
    private final UpdateOutputStream digestStream;

    protected BaseMessageDigest(FipsSHS.Parameters parameters) {
        this(fipsFactory.createOutputDigestCalculator(parameters));
    }

    BaseMessageDigest(OutputDigestCalculator outputDigestCalculator) {
        super(((Parameters)outputDigestCalculator.getParameters()).getAlgorithm().getName());
        this.digestCalculator = outputDigestCalculator;
        this.digestStream = outputDigestCalculator.getDigestStream();
    }

    protected void engineReset() {
        this.digestCalculator.reset();
    }

    protected void engineUpdate(byte by) {
        this.digestStream.update(by);
    }

    protected void engineUpdate(byte[] byArray, int n, int n2) {
        this.digestStream.update(byArray, n, n2);
    }

    protected byte[] engineDigest() {
        byte[] byArray = this.digestCalculator.getDigest();
        this.engineReset();
        return byArray;
    }

    protected int engineGetDigestLength() {
        return this.digestCalculator.getDigestSize();
    }

    public Object clone() throws CloneNotSupportedException {
        return new BaseMessageDigest(this.digestCalculator.clone());
    }
}

