/*
 * Decompiled with CFR 0.152.
 */
package net.snowflake.client.jdbc.internal.org.bouncycastle.crypto.internal.macs;

import net.snowflake.client.jdbc.internal.org.bouncycastle.crypto.internal.CipherParameters;
import net.snowflake.client.jdbc.internal.org.bouncycastle.crypto.internal.DataLengthException;
import net.snowflake.client.jdbc.internal.org.bouncycastle.crypto.internal.InvalidCipherTextException;
import net.snowflake.client.jdbc.internal.org.bouncycastle.crypto.internal.Mac;
import net.snowflake.client.jdbc.internal.org.bouncycastle.crypto.internal.modes.AEADBlockCipher;
import net.snowflake.client.jdbc.internal.org.bouncycastle.crypto.internal.params.AEADParameters;
import net.snowflake.client.jdbc.internal.org.bouncycastle.crypto.internal.params.KeyParameter;
import net.snowflake.client.jdbc.internal.org.bouncycastle.crypto.internal.params.ParametersWithIV;

public class AEADCipherMac
implements Mac {
    private final AEADBlockCipher aeadCipher;
    private final int macLenInBits;

    public AEADCipherMac(AEADBlockCipher aEADBlockCipher, int n) {
        this.aeadCipher = aEADBlockCipher;
        this.macLenInBits = n;
    }

    public void init(CipherParameters cipherParameters) throws IllegalArgumentException {
        if (!(cipherParameters instanceof ParametersWithIV)) {
            throw new IllegalArgumentException("AEAD cipher based MAC needs nonce/IV");
        }
        ParametersWithIV parametersWithIV = (ParametersWithIV)cipherParameters;
        this.aeadCipher.init(true, new AEADParameters((KeyParameter)parametersWithIV.getParameters(), this.macLenInBits, parametersWithIV.getIV()));
    }

    public String getAlgorithmName() {
        return this.aeadCipher.getAlgorithmName() + "MAC";
    }

    public int getMacSize() {
        return (this.macLenInBits + 7) / 8;
    }

    public void update(byte by) throws IllegalStateException {
        this.aeadCipher.processAADByte(by);
    }

    public void update(byte[] byArray, int n, int n2) throws DataLengthException, IllegalStateException {
        this.aeadCipher.processAADBytes(byArray, n, n2);
    }

    public int doFinal(byte[] byArray, int n) throws DataLengthException, IllegalStateException {
        try {
            return this.aeadCipher.doFinal(byArray, n);
        }
        catch (InvalidCipherTextException invalidCipherTextException) {
            throw new IllegalStateException("Unable to create MAC tag:" + invalidCipherTextException.getMessage(), invalidCipherTextException);
        }
    }

    public void reset() {
        this.aeadCipher.reset();
    }
}

