/*
 * Decompiled with CFR 0.152.
 */
package net.snowflake.client.jdbc.internal.org.bouncycastle.crypto.general;

import java.security.SecureRandom;
import net.snowflake.client.jdbc.internal.org.bouncycastle.crypto.Algorithm;
import net.snowflake.client.jdbc.internal.org.bouncycastle.crypto.CryptoServicesRegistrar;
import net.snowflake.client.jdbc.internal.org.bouncycastle.crypto.IllegalKeyException;
import net.snowflake.client.jdbc.internal.org.bouncycastle.crypto.fips.FipsUnapprovedOperationError;
import net.snowflake.client.jdbc.internal.org.bouncycastle.crypto.internal.ValidatedSymmetricKey;
import net.snowflake.client.jdbc.internal.org.bouncycastle.crypto.internal.params.KeyParameter;
import net.snowflake.client.jdbc.internal.org.bouncycastle.crypto.internal.params.KeyParameterImpl;

class Utils {
    static final SecureRandom testRandom = new SecureRandom();

    Utils() {
    }

    static void approveModeCheck(Algorithm algorithm) {
        if (CryptoServicesRegistrar.isInApprovedOnlyMode()) {
            throw new FipsUnapprovedOperationError("Attempt to use unapproved algorithm in approved only mode", algorithm);
        }
    }

    static KeyParameter getKeyParameter(ValidatedSymmetricKey validatedSymmetricKey) {
        return new KeyParameterImpl(validatedSymmetricKey.getKeyBytes());
    }

    static void checkKeyAlgorithm(ValidatedSymmetricKey validatedSymmetricKey, Algorithm algorithm, Algorithm algorithm2) {
        Algorithm algorithm3 = validatedSymmetricKey.getAlgorithm();
        if (!algorithm3.equals(algorithm) && !algorithm3.equals(algorithm2)) {
            throw new IllegalKeyException("Key not for appropriate algorithm");
        }
    }

    static int bitsToBytes(int n) {
        return (n + 7) / 8;
    }

    static int getDefaultMacSize(Algorithm algorithm, int n) {
        if (algorithm.getName().endsWith("GMAC") || algorithm.getName().endsWith("/CMAC") || algorithm.getName().endsWith("GCM") || algorithm.getName().endsWith("OCB") || algorithm.getName().endsWith("ISO979ALG3")) {
            return n;
        }
        return n / 2;
    }
}

