/*
 * Decompiled with CFR 0.152.
 */
package net.snowflake.client.jdbc.internal.org.bouncycastle.crypto.general;

import java.math.BigInteger;
import java.security.AccessController;
import java.security.PrivilegedAction;
import java.security.SecureRandom;
import net.snowflake.client.jdbc.internal.org.bouncycastle.crypto.Algorithm;
import net.snowflake.client.jdbc.internal.org.bouncycastle.crypto.AsymmetricPrivateKey;
import net.snowflake.client.jdbc.internal.org.bouncycastle.crypto.AsymmetricPublicKey;
import net.snowflake.client.jdbc.internal.org.bouncycastle.crypto.DigestAlgorithm;
import net.snowflake.client.jdbc.internal.org.bouncycastle.crypto.OutputSignerUsingSecureRandom;
import net.snowflake.client.jdbc.internal.org.bouncycastle.crypto.OutputVerifier;
import net.snowflake.client.jdbc.internal.org.bouncycastle.crypto.asymmetric.AsymmetricECGOST3410PrivateKey;
import net.snowflake.client.jdbc.internal.org.bouncycastle.crypto.asymmetric.AsymmetricECGOST3410PublicKey;
import net.snowflake.client.jdbc.internal.org.bouncycastle.crypto.asymmetric.AsymmetricKeyPair;
import net.snowflake.client.jdbc.internal.org.bouncycastle.crypto.asymmetric.ECDomainParameters;
import net.snowflake.client.jdbc.internal.org.bouncycastle.crypto.asymmetric.GOST3410Parameters;
import net.snowflake.client.jdbc.internal.org.bouncycastle.crypto.asymmetric.NamedECDomainParameters;
import net.snowflake.client.jdbc.internal.org.bouncycastle.crypto.general.DSAOutputSigner;
import net.snowflake.client.jdbc.internal.org.bouncycastle.crypto.general.DSAOutputVerifier;
import net.snowflake.client.jdbc.internal.org.bouncycastle.crypto.general.EcGost3410Signer;
import net.snowflake.client.jdbc.internal.org.bouncycastle.crypto.general.EcKeyGenerationParameters;
import net.snowflake.client.jdbc.internal.org.bouncycastle.crypto.general.EcKeyPairGenerator;
import net.snowflake.client.jdbc.internal.org.bouncycastle.crypto.general.GeneralAlgorithm;
import net.snowflake.client.jdbc.internal.org.bouncycastle.crypto.general.GeneralParameters;
import net.snowflake.client.jdbc.internal.org.bouncycastle.crypto.general.GuardedAsymmetricKeyPairGenerator;
import net.snowflake.client.jdbc.internal.org.bouncycastle.crypto.general.GuardedSignatureOperatorFactory;
import net.snowflake.client.jdbc.internal.org.bouncycastle.crypto.general.Register;
import net.snowflake.client.jdbc.internal.org.bouncycastle.crypto.general.SecureHash;
import net.snowflake.client.jdbc.internal.org.bouncycastle.crypto.general.SelfTestExecutor;
import net.snowflake.client.jdbc.internal.org.bouncycastle.crypto.general.Utils;
import net.snowflake.client.jdbc.internal.org.bouncycastle.crypto.internal.AsymmetricCipherKeyPair;
import net.snowflake.client.jdbc.internal.org.bouncycastle.crypto.internal.DSA;
import net.snowflake.client.jdbc.internal.org.bouncycastle.crypto.internal.Digest;
import net.snowflake.client.jdbc.internal.org.bouncycastle.crypto.internal.params.EcDomainParameters;
import net.snowflake.client.jdbc.internal.org.bouncycastle.crypto.internal.params.EcNamedDomainParameters;
import net.snowflake.client.jdbc.internal.org.bouncycastle.crypto.internal.params.EcPrivateKeyParameters;
import net.snowflake.client.jdbc.internal.org.bouncycastle.crypto.internal.params.EcPublicKeyParameters;
import net.snowflake.client.jdbc.internal.org.bouncycastle.crypto.internal.params.ParametersWithRandom;
import net.snowflake.client.jdbc.internal.org.bouncycastle.crypto.internal.test.ConsistencyTest;
import net.snowflake.client.jdbc.internal.org.bouncycastle.util.encoders.Hex;

public final class ECGOST3410 {
    public static final GeneralAlgorithm ALGORITHM = new GeneralAlgorithm("ECGOST3410", (Enum)Variations.ECGOST3410);
    public static final SignatureParameters GOST3410 = new SignatureParameters();

    private ECGOST3410() {
    }

    private static EcDomainParameters getDomainParams(ECDomainParameters eCDomainParameters) {
        if (eCDomainParameters instanceof NamedECDomainParameters) {
            return new EcNamedDomainParameters(((NamedECDomainParameters)eCDomainParameters).getID(), eCDomainParameters.getCurve(), eCDomainParameters.getG(), eCDomainParameters.getN(), eCDomainParameters.getH(), eCDomainParameters.getSeed());
        }
        return new EcDomainParameters(eCDomainParameters.getCurve(), eCDomainParameters.getG(), eCDomainParameters.getN(), eCDomainParameters.getH(), eCDomainParameters.getSeed());
    }

    private static EcPrivateKeyParameters getLwKey(final AsymmetricECGOST3410PrivateKey asymmetricECGOST3410PrivateKey) {
        return AccessController.doPrivileged(new PrivilegedAction<EcPrivateKeyParameters>(){

            @Override
            public EcPrivateKeyParameters run() {
                return new EcPrivateKeyParameters(asymmetricECGOST3410PrivateKey.getS(), ECGOST3410.getDomainParams((ECDomainParameters)asymmetricECGOST3410PrivateKey.getParameters().getDomainParameters()));
            }
        });
    }

    private static void validateKeyPair(AsymmetricCipherKeyPair asymmetricCipherKeyPair) {
        SelfTestExecutor.validate((Algorithm)ALGORITHM, asymmetricCipherKeyPair, new ConsistencyTest<AsymmetricCipherKeyPair>(){

            @Override
            public boolean hasTestPassed(AsymmetricCipherKeyPair asymmetricCipherKeyPair) {
                byte[] byArray = Hex.decode("576a1f885e3420128c8a656097ba7d8bb4c6f1b1853348cf2ba976971dbdbefc");
                EcGost3410Signer ecGost3410Signer = new EcGost3410Signer();
                ecGost3410Signer.init(true, new ParametersWithRandom(asymmetricCipherKeyPair.getPrivate(), Utils.testRandom));
                BigInteger[] bigIntegerArray = ecGost3410Signer.generateSignature(byArray);
                ecGost3410Signer.init(false, asymmetricCipherKeyPair.getPublic());
                ecGost3410Signer.verifySignature(byArray, bigIntegerArray[0], bigIntegerArray[1]);
                return ecGost3410Signer.verifySignature(byArray, bigIntegerArray[0], bigIntegerArray[1]);
            }
        });
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    public static final class KeyGenParameters
    extends GeneralParameters {
        private final GOST3410Parameters<ECDomainParameters> domainParameters;

        public KeyGenParameters(GOST3410Parameters<ECDomainParameters> gOST3410Parameters) {
            super(ALGORITHM);
            this.domainParameters = gOST3410Parameters;
        }

        public GOST3410Parameters<ECDomainParameters> getDomainParameters() {
            return this.domainParameters;
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    public static final class KeyPairGenerator
    extends GuardedAsymmetricKeyPairGenerator<KeyGenParameters, AsymmetricECGOST3410PublicKey, AsymmetricECGOST3410PrivateKey> {
        private final EcKeyPairGenerator engine = new EcKeyPairGenerator();
        private final GOST3410Parameters<ECDomainParameters> parameters;
        private final EcKeyGenerationParameters param;

        public KeyPairGenerator(KeyGenParameters keyGenParameters, SecureRandom secureRandom) {
            super(keyGenParameters);
            this.parameters = keyGenParameters.getDomainParameters();
            this.param = new EcKeyGenerationParameters(ECGOST3410.getDomainParams(this.parameters.getDomainParameters()), secureRandom);
            this.engine.init(this.param);
        }

        @Override
        protected AsymmetricKeyPair<AsymmetricECGOST3410PublicKey, AsymmetricECGOST3410PrivateKey> doGenerateKeyPair() {
            AsymmetricCipherKeyPair asymmetricCipherKeyPair = this.engine.generateKeyPair();
            ECGOST3410.validateKeyPair(asymmetricCipherKeyPair);
            EcPublicKeyParameters ecPublicKeyParameters = (EcPublicKeyParameters)asymmetricCipherKeyPair.getPublic();
            EcPrivateKeyParameters ecPrivateKeyParameters = (EcPrivateKeyParameters)asymmetricCipherKeyPair.getPrivate();
            Object t = ((KeyGenParameters)this.getParameters()).getAlgorithm();
            return new AsymmetricKeyPair<AsymmetricECGOST3410PublicKey, AsymmetricECGOST3410PrivateKey>(new AsymmetricECGOST3410PublicKey((Algorithm)t, this.parameters, ecPublicKeyParameters.getQ()), new AsymmetricECGOST3410PrivateKey((Algorithm)t, this.parameters, ecPrivateKeyParameters.getD()));
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    public static final class SignatureOperatorFactory
    extends GuardedSignatureOperatorFactory<SignatureParameters> {
        @Override
        public OutputSignerUsingSecureRandom<SignatureParameters> doCreateSigner(AsymmetricPrivateKey asymmetricPrivateKey, SignatureParameters signatureParameters) {
            EcGost3410Signer ecGost3410Signer = new EcGost3410Signer();
            Digest digest = Register.createDigest(signatureParameters.getDigestAlgorithm());
            AsymmetricECGOST3410PrivateKey asymmetricECGOST3410PrivateKey = (AsymmetricECGOST3410PrivateKey)asymmetricPrivateKey;
            final EcPrivateKeyParameters ecPrivateKeyParameters = ECGOST3410.getLwKey(asymmetricECGOST3410PrivateKey);
            return new DSAOutputSigner<SignatureParameters>(ecGost3410Signer, digest, signatureParameters, new DSAOutputSigner.Initializer(){

                public void initialize(DSA dSA, SecureRandom secureRandom) {
                    dSA.init(true, new ParametersWithRandom(ecPrivateKeyParameters, secureRandom));
                }
            });
        }

        @Override
        public OutputVerifier<SignatureParameters> doCreateVerifier(AsymmetricPublicKey asymmetricPublicKey, SignatureParameters signatureParameters) {
            EcGost3410Signer ecGost3410Signer = new EcGost3410Signer();
            Digest digest = Register.createDigest(signatureParameters.getDigestAlgorithm());
            AsymmetricECGOST3410PublicKey asymmetricECGOST3410PublicKey = (AsymmetricECGOST3410PublicKey)asymmetricPublicKey;
            EcPublicKeyParameters ecPublicKeyParameters = new EcPublicKeyParameters(asymmetricECGOST3410PublicKey.getW(), ECGOST3410.getDomainParams((ECDomainParameters)asymmetricECGOST3410PublicKey.getParameters().getDomainParameters()));
            ecGost3410Signer.init(false, ecPublicKeyParameters);
            return new DSAOutputVerifier<SignatureParameters>(ecGost3410Signer, digest, signatureParameters);
        }
    }

    public static final class SignatureParameters
    extends GeneralParameters {
        private final DigestAlgorithm digestAlgorithm;

        SignatureParameters() {
            this(SecureHash.Algorithm.GOST3411);
        }

        private SignatureParameters(DigestAlgorithm digestAlgorithm) {
            super(ALGORITHM);
            this.digestAlgorithm = digestAlgorithm;
        }

        public DigestAlgorithm getDigestAlgorithm() {
            return this.digestAlgorithm;
        }

        public SignatureParameters withDigestAlgorithm(DigestAlgorithm digestAlgorithm) {
            return new SignatureParameters(digestAlgorithm);
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    private static enum Variations {
        ECGOST3410;

    }
}

